/*
 * Decompiled with CFR 0.152.
 */
package com.tage.crimson_warfare;

import com.tage.crimson_warfare.blocks.BlockRegistry;
import com.tage.crimson_warfare.proxies.IProxy;
import com.tage.crimson_warfare.research.ResearchTab;
import com.tage.crimson_warfare.world.CrimsonWorldGenerator;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;

@Mod(modid="crimsonwarfare", name="Crimson Warfare", version="1.5", dependencies="required-after:thaumcraft", acceptedMinecraftVersions="[1.12.2]")
public class CrimsonWarfare {
    public static final String MODID = "crimsonwarfare";
    public static final String NAME = "Crimson Warfare";
    public static final String VERSION = "1.5";
    @Mod.Instance(value="crimsonwarfare")
    public static CrimsonWarfare instance;
    @SidedProxy(serverSide="com.tage.crimson_warfare.proxies.ServerProxy", clientSide="com.tage.crimson_warfare.proxies.ClientProxy")
    public static IProxy proxy;
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new CrimsonWorldGenerator(), (int)3);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ResearchTab.addResearch();
        MinecraftForge.EVENT_BUS.register((Object)new ResearchEventClass());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new CrimsonWorldGenerator());
    }

    @Mod.EventBusSubscriber
    public static class ResearchEventClass {
        @SubscribeEvent
        public void researchEvent(LivingEvent.LivingUpdateEvent event) {
            if (event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                if (ThaumcraftApi.internalMethods.doesPlayerHaveRequisites(player, "FAKEFLUXRIFT") && ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{"FLUXRIFT"})) {
                    ThaumcraftApi.internalMethods.completeResearch(player, "FAKEFLUXRIFT");
                }
                if (ThaumcraftApi.internalMethods.doesPlayerHaveRequisites(player, "FAKEBASEELDRITCH") && ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, (String[])new String[]{"BASEELDRITCH"})) {
                    ThaumcraftApi.internalMethods.completeResearch(player, "FAKEBASEELDRITCH");
                }
            }
        }
    }

    @Mod.EventBusSubscriber
    public static class RegistryHandler {
        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            BlockRegistry.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            BlockRegistry.register((IForgeRegistry<Block>)event.getRegistry());
        }

        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            BlockRegistry.registerModels();
        }
    }
}

