/*
 * Decompiled with CFR 0.152.
 */
package c4.cherishedworlds.event;

import c4.cherishedworlds.CherishedWorlds;
import c4.cherishedworlds.core.FavoriteWorldsList;
import c4.cherishedworlds.core.OTGIntegration;
import c4.cherishedworlds.core.ReflectionAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.AnvilConverterException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiListWorldSelection;
import net.minecraft.client.gui.GuiListWorldSelectionEntry;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldSummary;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerClient {
    public static final ResourceLocation STAR_ICON = new ResourceLocation("cherishedworlds", "textures/gui/staricon.png");

    @SubscribeEvent
    public void onGuiDrawScreen(GuiScreenEvent.DrawScreenEvent.Post evt) {
        GuiScreen gui = evt.getGui();
        if (CherishedWorlds.isOtgLoaded) {
            OTGIntegration.drawOtg(evt);
        } else if (gui instanceof GuiWorldSelection) {
            GuiListWorldSelection selectionList;
            GuiWorldSelection worldSelect = (GuiWorldSelection)gui;
            if (FavoriteWorldsList.hasFavorite() && (selectionList = ReflectionAccessor.getSelectionList(worldSelect)) != null) {
                int size = ReflectionAccessor.getSize(selectionList);
                for (int i = 0; i < size; ++i) {
                    WorldSummary summary;
                    GuiListWorldSelectionEntry entry = selectionList.func_148180_b(i);
                    if (entry == null || (summary = ReflectionAccessor.getWorldSummary(entry)) == null || !FavoriteWorldsList.isFavorite(summary.func_75786_a())) continue;
                    int top = selectionList.field_148153_b + 15 + selectionList.field_148149_f * i - selectionList.func_148148_g();
                    int x = evt.getGui().field_146294_l / 2 - 148;
                    if (top >= selectionList.field_148154_c - 8 || top <= selectionList.field_148153_b) continue;
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(STAR_ICON);
                    Gui.func_146110_a((int)x, (int)top, (float)0.0f, (float)0.0f, (int)9, (int)9, (float)9.0f, (float)9.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void onGuiButtonClick(GuiScreenEvent.ActionPerformedEvent evt) {
        GuiScreen gui = evt.getGui();
        if (CherishedWorlds.isOtgLoaded) {
            OTGIntegration.buttonClickOtg(evt);
        } else if (gui instanceof GuiWorldSelection) {
            WorldSummary summary;
            GuiListWorldSelectionEntry entry;
            GuiListWorldSelection selectionList;
            GuiWorldSelection worldSelect = (GuiWorldSelection)gui;
            if (evt.getButton().field_146127_k == 6) {
                WorldSummary summary2;
                GuiListWorldSelectionEntry entry2;
                GuiListWorldSelection selectionList2 = ReflectionAccessor.getSelectionList(worldSelect);
                if (selectionList2 != null && (entry2 = selectionList2.func_186794_f()) != null && (summary2 = ReflectionAccessor.getWorldSummary(entry2)) != null) {
                    FavoriteWorldsList.addFavorite(summary2.func_75786_a());
                    FavoriteWorldsList.saveFavoritesList();
                }
            } else if (evt.getButton().field_146127_k == 7 && (selectionList = ReflectionAccessor.getSelectionList(worldSelect)) != null && (entry = selectionList.func_186794_f()) != null && (summary = ReflectionAccessor.getWorldSummary(entry)) != null) {
                FavoriteWorldsList.removeFavorite(summary.func_75786_a());
                FavoriteWorldsList.saveFavoritesList();
            }
        }
    }

    @SubscribeEvent
    public void onGuiMouseClick(GuiScreenEvent.MouseInputEvent.Post evt) {
        GuiListWorldSelectionEntry entry;
        GuiWorldSelection worldSelect;
        GuiListWorldSelection selectionList;
        GuiScreen gui = evt.getGui();
        if (CherishedWorlds.isOtgLoaded) {
            OTGIntegration.mouseClickOtg(evt);
        } else if (gui instanceof GuiWorldSelection && (selectionList = ReflectionAccessor.getSelectionList(worldSelect = (GuiWorldSelection)gui)) != null && (entry = selectionList.func_186794_f()) != null) {
            boolean isFavored;
            List<GuiButton> buttonList = ReflectionAccessor.getButtonList(gui);
            WorldSummary summary = ReflectionAccessor.getWorldSummary(entry);
            boolean bl = isFavored = summary != null && FavoriteWorldsList.isFavorite(summary.func_75786_a());
            if (buttonList != null && !buttonList.isEmpty() && buttonList.size() >= 7) {
                for (GuiButton button : buttonList) {
                    if (button.field_146126_j.equals("Pin")) {
                        button.field_146124_l = !isFavored;
                        continue;
                    }
                    if (!button.field_146126_j.equals("Unpin")) continue;
                    button.field_146124_l = isFavored;
                }
                GuiButton deleteButton = (GuiButton)ObfuscationReflectionHelper.getPrivateValue(GuiWorldSelection.class, (Object)worldSelect, (String[])new String[]{"deleteButton", "field_146642_y"});
                deleteButton.field_146124_l = !isFavored;
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post evt) {
        GuiScreen gui = evt.getGui();
        if (CherishedWorlds.isOtgLoaded) {
            OTGIntegration.initOtg(evt);
        } else if (gui instanceof GuiWorldSelection) {
            GuiWorldSelection worldSelect = (GuiWorldSelection)gui;
            List buttonList = evt.getButtonList();
            int width = worldSelect.field_146294_l;
            GuiButton bookmark = new GuiButton(6, width / 2 + 48, 8, 50, 20, "Pin");
            GuiButton bookmark2 = new GuiButton(7, width / 2 + 104, 8, 50, 20, "Unpin");
            bookmark.field_146124_l = false;
            bookmark2.field_146124_l = false;
            buttonList.add(bookmark);
            buttonList.add(bookmark2);
            GuiListWorldSelection selectionList = ReflectionAccessor.getSelectionList(worldSelect);
            if (selectionList != null) {
                FavoriteWorldsList.loadFavoritesList();
                EventHandlerClient.refreshList(selectionList);
            }
        }
    }

    private static void refreshList(GuiListWorldSelection listWorldSelection) {
        List list;
        Minecraft mc = Minecraft.func_71410_x();
        ISaveFormat isaveformat = mc.func_71359_d();
        try {
            list = isaveformat.func_75799_b();
        }
        catch (AnvilConverterException anvilconverterexception) {
            CherishedWorlds.logger.error("Couldn't load level list", (Throwable)anvilconverterexception);
            mc.func_147108_a((GuiScreen)new GuiErrorScreen(I18n.func_135052_a((String)"selectWorld.unable_to_load", (Object[])new Object[0]), anvilconverterexception.getMessage()));
            return;
        }
        List<GuiListWorldSelectionEntry> entries = ReflectionAccessor.getWorldSelectionEntries(listWorldSelection);
        if (entries != null) {
            entries.clear();
            ListIterator iter = list.listIterator();
            ArrayList favorites = Lists.newArrayList();
            while (iter.hasNext()) {
                WorldSummary summ = (WorldSummary)iter.next();
                if (!FavoriteWorldsList.isFavorite(summ.func_75786_a())) continue;
                favorites.add(summ);
                iter.remove();
            }
            Collections.sort(favorites);
            Collections.sort(list);
            for (WorldSummary worldsummary : favorites) {
                entries.add(new GuiListWorldSelectionEntry(listWorldSelection, worldsummary, mc.func_71359_d()));
            }
            for (WorldSummary worldsummary : list) {
                entries.add(new GuiListWorldSelectionEntry(listWorldSelection, worldsummary, mc.func_71359_d()));
            }
        }
    }
}

