/*
 * Decompiled with CFR 0.152.
 */
package c4.champions.common;

import c4.champions.common.capability.CapabilityChampionship;
import c4.champions.common.capability.IChampionship;
import c4.champions.common.config.ConfigHandler;
import c4.champions.common.init.ChampionsRegistry;
import c4.champions.common.util.ChampionHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerCommon {
    private static final ResourceLocation CHAMPION_LOOT = new ResourceLocation("champions", "champion_loot");

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent evt) {
        EntityLivingBase entityLivingBase = evt.getEntityLiving();
        boolean flag = entityLivingBase.field_70170_p.func_82736_K().func_82766_b("showDeathMessages");
        Entity source = evt.getSource().func_76346_g();
        if (!(source instanceof EntityPlayer)) {
            return;
        }
        if (flag && !entityLivingBase.field_70170_p.field_72995_K && ChampionHelper.isValidChampion((Entity)entityLivingBase)) {
            IChampionship chp = CapabilityChampionship.getChampionship((EntityLiving)entityLivingBase);
            int messageTier = ConfigHandler.deathMessageTier;
            if (messageTier > 0 && chp != null && ChampionHelper.isElite(chp.getRank()) && chp.getRank().getTier() >= messageTier) {
                entityLivingBase.func_184102_h().func_184103_al().func_148539_a(new TextComponentTranslation("champions.identifier", new Object[0]).func_150257_a((ITextComponent)new TextComponentString(" ")).func_150257_a(entityLivingBase.func_110142_aN().func_151521_b()));
            }
        }
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent evt) {
        IChampionship chp;
        EntityLivingBase entity = evt.getEntityLiving();
        if (!entity.field_70170_p.func_82736_K().func_82766_b("doMobLoot") || !ConfigHandler.lootFake && evt.getSource().func_76346_g() instanceof FakePlayer) {
            return;
        }
        if (ChampionHelper.isValidChampion((Entity)entity) && (chp = CapabilityChampionship.getChampionship((EntityLiving)entity)) != null && ChampionHelper.isElite(chp.getRank()) && entity.field_70170_p instanceof WorldServer) {
            List<ItemStack> loot;
            if (ConfigHandler.lootSource != ConfigHandler.LootSource.CONFIG) {
                WorldServer world = (WorldServer)entity.field_70170_p;
                LootTable table = world.func_184146_ak().func_186521_a(CHAMPION_LOOT);
                DamageSource source = evt.getSource();
                LootContext.Builder builder = new LootContext.Builder(world).func_186473_a(evt.getSource()).func_186472_a((Entity)entity);
                if (source.func_76346_g() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)source.func_76346_g();
                    builder.func_186470_a(player).func_186469_a(player.func_184817_da());
                }
                LootContext ctx = builder.func_186471_a();
                List stacks = table.func_186462_a(world.field_73012_v, ctx);
                for (ItemStack stack : stacks) {
                    EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
                    entityitem.func_174869_p();
                    evt.getDrops().add(entityitem);
                }
            }
            if (ConfigHandler.lootSource != ConfigHandler.LootSource.LOOT_TABLE && !(loot = ChampionHelper.getLootDrops(chp.getRank().getTier())).isEmpty()) {
                loot.forEach(lootStack -> {
                    if (!lootStack.func_190926_b()) {
                        EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, lootStack);
                        entityitem.func_174869_p();
                        evt.getDrops().add(entityitem);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void livingXP(LivingExperienceDropEvent evt) {
        IChampionship chp;
        EntityLivingBase entity = evt.getEntityLiving();
        if (ChampionHelper.isValidChampion((Entity)entity) && (chp = CapabilityChampionship.getChampionship((EntityLiving)entity)) != null && ChampionHelper.isElite(chp.getRank())) {
            evt.setDroppedExperience((int)((double)chp.getRank().getGrowthFactor() * ConfigHandler.growth.exp * (double)evt.getOriginalExperience()));
        }
    }

    @SubscribeEvent
    public void livingDamage(LivingHurtEvent evt) {
        IChampionship chp;
        EntityLiving entity;
        if (evt.getSource().func_76346_g() instanceof EntityLiving && (entity = (EntityLiving)evt.getSource().func_76346_g()).func_110148_a(SharedMonsterAttributes.field_111264_e) == null && ChampionHelper.isValidChampion((Entity)entity) && (chp = CapabilityChampionship.getChampionship(entity)) != null && ChampionHelper.isElite(chp.getRank())) {
            evt.setAmount(evt.getAmount() * (float)(1.0 + ConfigHandler.growth.attackDamage * (double)chp.getRank().getTier()));
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start evt) {
        IChampionship chp;
        Explosion explosion = evt.getExplosion();
        EntityLivingBase entityLivingBase = explosion.func_94613_c();
        if (entityLivingBase instanceof EntityCreeper && !entityLivingBase.field_70170_p.field_72995_K && (chp = CapabilityChampionship.getChampionship((EntityLiving)((EntityCreeper)entityLivingBase))) != null && ChampionHelper.isElite(chp.getRank())) {
            explosion.field_77280_f += (float)(ConfigHandler.growth.creeperStrength * chp.getRank().getTier());
        }
    }

    @SubscribeEvent
    public void injuredPotionHealHandler(LivingHealEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        if (entity.func_70644_a(ChampionsRegistry.injured)) {
            evt.setAmount(evt.getAmount() * 0.6f);
        }
    }

    @SubscribeEvent
    public void injuredPotionHurtHandler(LivingDamageEvent evt) {
        if (evt.getEntityLiving().func_70644_a(ChampionsRegistry.injured)) {
            evt.setAmount(evt.getAmount() * 1.4f);
        }
    }
}

