/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.recipes;

import com.mojang.authlib.GameProfile;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.bees.CareerBeeEntry;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerSpawnHandler {
    private final String name;
    private final UUID DireID;
    private final CareerBeeEntry beeSpecies;

    public static void registerBeeSpawn(String name, UUID direID, CareerBeeEntry beeSpecies) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerSpawnHandler(name, direID, beeSpecies));
    }

    public PlayerSpawnHandler(String name, UUID direID, CareerBeeEntry beeSpecies) {
        this.name = name;
        this.DireID = direID;
        this.beeSpecies = beeSpecies;
    }

    @SubscribeEvent
    public void onSpawn(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        GameProfile gameProfile = player.func_146103_bH();
        if (BeeMod.deobf || this.DireID.equals(gameProfile.getId())) {
            NBTTagCompound tag = event.player.getEntityData();
            if (!tag.func_74764_b("PlayerPersisted")) {
                tag.func_74782_a("PlayerPersisted", (NBTBase)new NBTTagCompound());
            }
            if (tag.func_74775_l("PlayerPersisted").func_74767_n("spawn_" + this.name)) {
                return;
            }
            tag.func_74775_l("PlayerPersisted").func_74757_a("spawn_" + this.name, true);
            IAllele[] template = BeeManager.beeRoot.getTemplate((IAlleleSpecies)this.beeSpecies.species);
            IBeeGenome iBeeGenome = BeeManager.beeRoot.templateAsGenome(template, template);
            IBee bee = BeeManager.beeRoot.getBee(iBeeGenome);
            player.field_71071_by.func_70441_a(BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.PRINCESS));
            for (int i = 0; i < 3; ++i) {
                player.field_71071_by.func_70441_a(BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE));
            }
        }
    }
}

