/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.rwtema.careerbees.helpers.INBTSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializer<T>
implements INBTSerializer<T> {
    private static final HashMap<Class<?>, NBTSerializer<?>> clazzMap = new HashMap();
    @Nonnull
    public final List<NBTSerializerEntry<? super T>> serializers;
    @Nonnull
    public final Iterable<NBTSerializerEntry<? super T>> iterable;

    public NBTSerializer(@Nullable NBTSerializer<? super T> parent) {
        this.serializers = new ArrayList<NBTSerializerEntry<? super T>>();
        this.iterable = parent != null ? Iterables.concat(parent.iterable, this.serializers) : this.serializers;
    }

    public NBTSerializer(@Nonnull List<NBTSerializerEntry<? super T>> serializers, @Nonnull Iterable<NBTSerializerEntry<? super T>> iterable) {
        this.serializers = serializers;
        this.iterable = iterable;
    }

    @Nonnull
    public static <T, K extends NBTBase> BiConsumer<T, NBTBase> convertSetterSerializable(@Nonnull Function<T, INBTSerializable<K>> nbtSerializable) {
        return (t, nbtBase) -> ((INBTSerializable)nbtSerializable.apply(t)).deserializeNBT(nbtBase);
    }

    @Nonnull
    public static <T, K extends NBTBase> Function<T, NBTBase> convertGetterSerializable(@Nonnull Function<T, INBTSerializable<K>> nbtSerializable) {
        return t -> ((INBTSerializable)nbtSerializable.apply(t)).serializeNBT();
    }

    public static <T extends TileEntity> NBTSerializer<T> getTileEntitySeializer(Class<T> clazz) {
        return NBTSerializer.getClassSerializer(clazz, TileEntity.class);
    }

    public static <T extends Entity> NBTSerializer<T> getEntitySeializer(Class<T> clazz) {
        return NBTSerializer.getClassSerializer(clazz, Entity.class);
    }

    @Nonnull
    public static <T> NBTSerializer<T> getClassSerializer(@Nonnull Class<T> clazz, Class<?> baseParentClass) {
        NBTSerializer<Object> nbtSerializer = clazzMap.get(clazz);
        if (nbtSerializer == null) {
            nbtSerializer = clazz == baseParentClass ? new NBTSerializer<T>(null) : new NBTSerializer<T>(NBTSerializer.getClassSerializer(clazz.getSuperclass(), baseParentClass));
            clazzMap.put(clazz, nbtSerializer);
        }
        return nbtSerializer;
    }

    public NBTSerializer<T> getPartial(String ... keys) {
        ImmutableSet set = ImmutableSet.copyOf((Object[])keys);
        return new NBTSerializer<T>(ImmutableList.of(), Iterables.filter(this.iterable, arg_0 -> NBTSerializer.lambda$getPartial$2((Set)set, arg_0)));
    }

    public <K> NBTSerializer<T> addDataManagerKey(String key, DataParameter<K> dataParameter, NBTSerializerInterface<T, K> addType) {
        Function<Entity, Object> entityKFunction = e -> e.func_184212_Q().func_187225_a(dataParameter);
        BiConsumer<Entity, Object> entityKBiConsumer = (e, t) -> {
            e.func_184212_Q().func_187227_b(dataParameter, t);
            e.func_184212_Q().func_187217_b(dataParameter);
        };
        return addType.invoke(this, key, entityKFunction, entityKBiConsumer);
    }

    @Override
    public void readFromNBT(@Nonnull T t, @Nonnull NBTTagCompound tag) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            if (!(nBTSerializerEntry.expectedType == -1 ? tag.func_74764_b(nBTSerializerEntry.key) : tag.func_150297_b(nBTSerializerEntry.key, nBTSerializerEntry.expectedType))) continue;
            NBTBase base = tag.func_74781_a(nBTSerializerEntry.key);
            nBTSerializerEntry.setter.accept(t, base);
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull T t, @Nonnull NBTTagCompound tag) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            NBTBase apply = nBTSerializerEntry.getter.apply(t);
            if (apply == null) continue;
            tag.func_74782_a(nBTSerializerEntry.key, apply);
        }
        return tag;
    }

    @Nonnull
    private NBTSerializer<T> addEntry(@Nonnull NBTSerializerEntry<T> entry) {
        for (NBTSerializerEntry<? super T> nBTSerializerEntry : this.iterable) {
            if (!nBTSerializerEntry.key.equals(entry.key)) continue;
            throw new IllegalStateException("Duplicate key: " + nBTSerializerEntry.key);
        }
        this.serializers.add(entry);
        return this;
    }

    @Nonnull
    public <K extends NBTBase> NBTSerializer<T> addNBTSerializable(String key, @Nonnull Function<T, INBTSerializable<K>> nbtSerializable) {
        return this.addEntry(new NBTSerializerEntry(key, NBTSerializer.convertGetterSerializable(nbtSerializable), NBTSerializer.convertSetterSerializable(nbtSerializable), -1));
    }

    @Nonnull
    public NBTSerializer<T> addByte(String key, @Nonnull Function<T, Byte> getter, @Nonnull BiConsumer<T, Byte> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagByte(((Byte)getter.apply(obj)).byteValue()), (t, nbtBase) -> setter.accept(t, ((NBTTagByte)nbtBase).func_150290_f()), 1));
    }

    @Nonnull
    public NBTSerializer<T> addShort(String key, @Nonnull Function<T, Short> getter, @Nonnull BiConsumer<T, Short> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagShort(((Short)getter.apply(obj)).shortValue()), (t, nbtBase) -> setter.accept(t, ((NBTTagShort)nbtBase).func_150289_e()), 2));
    }

    @Nonnull
    public NBTSerializer<T> addInt(String key, @Nonnull ToIntFunction<T> getter, @Nonnull ObjIntConsumer<T> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagInt(getter.applyAsInt(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagInt)nbtBase).func_150287_d()), 3));
    }

    public NBTSerializer<T> addInteger(String key, Function<T, Integer> getter, BiConsumer<T, Integer> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagInt(((Integer)getter.apply(obj)).intValue()), (t, nbtBase) -> setter.accept(t, ((NBTTagInt)nbtBase).func_150287_d()), 3));
    }

    @Nonnull
    public NBTSerializer<T> addFloat(String key, @Nonnull Function<T, Float> getter, @Nonnull BiConsumer<T, Float> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagFloat(((Float)getter.apply(obj)).floatValue()), (t, nbtBase) -> setter.accept(t, Float.valueOf(((NBTTagFloat)nbtBase).func_150288_h())), 5));
    }

    @Nonnull
    public NBTSerializer<T> addLong(String key, @Nonnull Function<T, Long> getter, @Nonnull BiConsumer<T, Long> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagLong(((Long)getter.apply(obj)).longValue()), (t, nbtBase) -> setter.accept(t, ((NBTTagLong)nbtBase).func_150291_c()), 4));
    }

    @Nonnull
    public NBTSerializer<T> addDouble(String key, @Nonnull Function<T, Double> getter, @Nonnull BiConsumer<T, Double> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagDouble(((Double)getter.apply(obj)).doubleValue()), (t, nbtBase) -> setter.accept(t, ((NBTTagDouble)nbtBase).func_150286_g()), 6));
    }

    @Nonnull
    public NBTSerializer<T> addByteArray(String key, @Nonnull Function<T, byte[]> getter, @Nonnull BiConsumer<T, byte[]> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagByteArray((byte[])getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagByteArray)nbtBase).func_150292_c()), 7));
    }

    @Nonnull
    public NBTSerializer<T> addIntArray(String key, @Nonnull Function<T, int[]> getter, @Nonnull BiConsumer<T, int[]> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagIntArray((int[])getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagIntArray)nbtBase).func_150302_c()), 11));
    }

    @Nonnull
    public NBTSerializer<T> addString(String key, @Nonnull Function<T, String> getter, @Nonnull BiConsumer<T, String> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> new NBTTagString((String)getter.apply(obj)), (t, nbtBase) -> setter.accept(t, ((NBTTagString)nbtBase).func_150285_a_()), 8));
    }

    @Nonnull
    public NBTSerializer<T> addNBTTagCompound(String key, @Nonnull Function<T, NBTTagCompound> getter, @Nonnull BiConsumer<T, NBTTagCompound> setter) {
        return this.addEntry(new NBTSerializerEntry(key, getter::apply, (t, nbtBase) -> setter.accept(t, (NBTTagCompound)nbtBase), 10));
    }

    @Nonnull
    public NBTSerializer<T> addBlockPos(String key, @Nonnull Function<T, BlockPos> getter, @Nonnull BiConsumer<T, BlockPos> setter) {
        return this.addLong(key, value -> ((BlockPos)getter.apply(value)).func_177986_g(), (t, value) -> setter.accept(t, BlockPos.func_177969_a((long)value)));
    }

    @Nonnull
    public NBTSerializer<T> addOptionalBlockPos(String key, @Nonnull Function<T, Optional<BlockPos>> getter, @Nonnull BiConsumer<T, Optional<BlockPos>> setter) {
        return this.addEntry(new NBTSerializerEntry(key, obj -> (NBTTagLong)((Optional)getter.apply(obj)).transform(BlockPos::func_177986_g).transform(NBTTagLong::new).orNull(), (t1, nbtBase) -> setter.accept(t1, Optional.of((Object)BlockPos.func_177969_a((long)((NBTPrimitive)nbtBase).func_150291_c()))), 4));
    }

    @Nonnull
    public NBTSerializer<T> addItemStack(String key, @Nonnull Function<T, ItemStack> getter, @Nonnull BiConsumer<T, ItemStack> setter) {
        return this.addNBTTagCompound(key, t -> ((ItemStack)getter.apply(t)).func_77955_b(new NBTTagCompound()), (t, nbtTagCompound) -> setter.accept(t, new ItemStack(nbtTagCompound)));
    }

    public NBTSerializer<T> addBoolean(String key, Function<T, Boolean> getter, BiConsumer<T, Boolean> setter) {
        return this.addByte(key, t -> (byte)((Boolean)getter.apply(t) != false ? 1 : 0), (t, s) -> setter.accept(t, s != 0));
    }

    @Nonnull
    public <E, K extends NBTBase> NBTSerializer<T> addCollection(String key, @Nonnull Function<T, Collection<E>> getter, @Nonnull Function<E, K> writer, @Nonnull Function<K, E> reader, int expectedID) {
        return this.addEntry(new NBTSerializerEntry(key, t -> {
            Collection collection = (Collection)getter.apply(t);
            NBTTagList list = new NBTTagList();
            for (Object e : collection) {
                list.func_74742_a((NBTBase)writer.apply(e));
            }
            return list;
        }, (t, nbtBase) -> {
            Collection collection = (Collection)getter.apply(t);
            collection.clear();
            NBTTagList list = (NBTTagList)nbtBase;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTBase base = list.func_179238_g(i);
                Object e = reader.apply(base);
                collection.add(e);
            }
        }, 9));
    }

    private static /* synthetic */ boolean lambda$getPartial$2(Set set, NBTSerializerEntry s) {
        return set.contains(s != null ? s.key : Boolean.valueOf(false));
    }

    private static class NBTSerializerEntry<T> {
        public final Function<? super T, NBTBase> getter;
        public final BiConsumer<? super T, NBTBase> setter;
        public final int expectedType;
        public final String key;

        private NBTSerializerEntry(String key, Function<T, NBTBase> getter, BiConsumer<T, NBTBase> setter, int expectedType) {
            this.key = key;
            this.getter = getter;
            this.setter = setter;
            this.expectedType = expectedType;
        }

        private NBTSerializerEntry(@Nonnull NBTSerializerEntry<? super T> toCopy) {
            this.key = toCopy.key;
            this.getter = toCopy.getter;
            this.setter = toCopy.setter;
            this.expectedType = toCopy.expectedType;
        }
    }

    public static interface NBTSerializerInterface<T, Z> {
        public NBTSerializer<T> invoke(NBTSerializer<T> var1, String var2, Function<T, Z> var3, BiConsumer<T, Z> var4);
    }
}

