/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.handlers;

import com.mojang.authlib.GameProfile;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.climate.IClimateState;
import forestry.api.core.BiomeHelper;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IErrorLogic;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;

public abstract class FakeHousing
implements IBeeHousing {
    public static final IBeekeepingLogic beekeepingLogic = new IBeekeepingLogic(){

        public boolean canWork() {
            return true;
        }

        public void doWork() {
        }

        public void clearCachedValues() {
        }

        public void syncToClient() {
        }

        public void syncToClient(@Nonnull EntityPlayerMP player) {
        }

        public int getBeeProgressPercent() {
            return 0;
        }

        public boolean canDoBeeFX() {
            return false;
        }

        public void doBeeFX() {
        }

        public List<BlockPos> getFlowerPositions() {
            return Collections.emptyList();
        }

        public void readFromNBT(@Nonnull NBTTagCompound nbt) {
        }

        @Nonnull
        public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
            return nbt;
        }
    };
    final IErrorLogic logic = ForestryAPI.errorStateRegistry.createErrorLogic();

    @Nonnull
    public Iterable<IBeeModifier> getBeeModifiers() {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.emptyList();
    }

    @Nonnull
    public IBeeHousingInventory getBeeInventory() {
        return new IBeeHousingInventory(){

            @Nonnull
            public ItemStack getQueen() {
                return FakeHousing.this.getQueen();
            }

            @Nonnull
            public ItemStack getDrone() {
                return FakeHousing.this.getDrone();
            }

            public void setQueen(@Nonnull ItemStack itemstack) {
            }

            public void setDrone(@Nonnull ItemStack itemstack) {
            }

            public boolean addProduct(@Nonnull ItemStack product, boolean all) {
                return FakeHousing.this.addProduct(product.func_77946_l(), all);
            }
        };
    }

    protected abstract boolean addProduct(ItemStack var1, boolean var2);

    protected ItemStack getDrone() {
        return ItemStack.field_190927_a;
    }

    protected abstract ItemStack getQueen();

    @Nonnull
    public IBeekeepingLogic getBeekeepingLogic() {
        return beekeepingLogic;
    }

    public int getBlockLightValue() {
        return this.getWorldObj().func_72935_r() ? 15 : 0;
    }

    public boolean canBlockSeeTheSky() {
        return this.getWorldObj().func_175710_j(this.getCoordinates());
    }

    public boolean isRaining() {
        return this.getWorldObj().func_72896_J();
    }

    @Nullable
    public GameProfile getOwner() {
        return null;
    }

    @Nonnull
    public Vec3d getBeeFXCoordinates() {
        BlockPos pos = this.getCoordinates();
        return new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
    }

    @Nonnull
    public Biome getBiome() {
        return this.getWorldObj().func_180494_b(this.getCoordinates());
    }

    @Nonnull
    public EnumTemperature getTemperature() {
        if (BiomeHelper.isBiomeHellish((Biome)this.getBiome())) {
            return EnumTemperature.HELLISH;
        }
        IClimateState state = ForestryAPI.climateManager.getClimateState(this.getWorldObj(), this.getCoordinates());
        float temperature = state.getTemperature();
        return EnumTemperature.getFromValue((float)temperature);
    }

    @Nonnull
    public EnumHumidity getHumidity() {
        IClimateState state = ForestryAPI.climateManager.getClimateState(this.getWorldObj(), this.getCoordinates());
        float humidity = state.getHumidity();
        return EnumHumidity.getFromValue((float)humidity);
    }

    @Nonnull
    public IErrorLogic getErrorLogic() {
        return this.logic;
    }
}

