/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects.settings;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

public abstract class Setting<V, NBT extends NBTBase> {
    static final ImmutableBiMap<Class<? extends NBTBase>, Integer> classIds = ImmutableBiMap.builder().put(NBTTagByte.class, (Object)1).put(NBTTagShort.class, (Object)2).put(NBTTagInt.class, (Object)3).put(NBTTagLong.class, (Object)4).put(NBTTagFloat.class, (Object)5).put(NBTTagDouble.class, (Object)6).put(NBTTagByteArray.class, (Object)7).put(NBTTagString.class, (Object)8).put(NBTTagList.class, (Object)9).put(NBTTagCompound.class, (Object)10).put(NBTTagIntArray.class, (Object)11).put(NBTTagLongArray.class, (Object)12).build();
    final V _default;
    final String keyname;
    final int expectedType;

    public Setting(@Nonnull EffectBase parent, String keyname, V _default, Class<NBT> clazz) {
        this._default = _default;
        this.keyname = keyname;
        this.expectedType = (Integer)classIds.get(clazz);
        parent.addSetting(this);
    }

    public String getKeyname() {
        return this.keyname;
    }

    public int getExpectedType() {
        return this.expectedType;
    }

    public V getDefault() {
        return this._default;
    }

    public V getValue(@Nonnull IBeeHousing housing) {
        for (IBeeModifier iBeeModifier : housing.getBeeModifiers()) {
            if (!(iBeeModifier instanceof IEffectSettingsHolder)) continue;
            return this.getValue((IEffectSettingsHolder)iBeeModifier);
        }
        return this._default;
    }

    public V getValue(@Nonnull IEffectSettingsHolder settingsHolder) {
        return settingsHolder.getValue(this);
    }

    public boolean shouldBeVisible(IEffectSettingsHolder settingsHolder) {
        return true;
    }

    public boolean shouldBeEnabled(IEffectSettingsHolder settingsHolder) {
        return true;
    }

    public abstract NBT toNBT(V var1);

    public abstract V fromNBT(NBT var1);

    public String format(V value) {
        return String.valueOf(value);
    }

    public boolean isAcceptable(V value) {
        return true;
    }

    @Nullable
    public List<V> getEntries() {
        if (this.getType() != Entry_Type.BUTTON) {
            return ImmutableList.of();
        }
        throw new UnsupportedOperationException();
    }

    public V nextEntry(V input) {
        List<V> entries = this.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            V v = entries.get(i);
            if (!Objects.equals(input, v)) continue;
            return entries.get((i + 1) % entries.size());
        }
        return entries.get(0);
    }

    @Nonnull
    public abstract Entry_Type getType();

    public V overrideInput(V input) {
        return input;
    }

    public V onClickWithItemStack(V currentValue, ItemStack stack, IEffectSettingsHolder holder) {
        return currentValue;
    }

    public int priority() {
        return 0;
    }

    @Nullable
    public List<String> getTooltip(V value) {
        return null;
    }

    public static class OreDicText
    extends TextRestricted {
        @Nullable
        ArrayList<String> ores = null;

        public OreDicText(@Nonnull EffectBase parent, String keyname) {
            super(parent, keyname);
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        @Override
        @Nullable
        public ArrayList<String> getEntries() {
            ArrayList ores = this.ores;
            if (ores == null) {
                this.ores = ores = Lists.newArrayList((Object[])OreDictionary.getOreNames());
            }
            return ores;
        }

        @SubscribeEvent
        public void onOreRegister(OreDictionary.OreRegisterEvent event) {
            this.ores = null;
        }

        @Override
        public String onClickWithItemStack(String currentValue, @Nonnull ItemStack stack, IEffectSettingsHolder holder) {
            int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
            if (oreIDs.length == 0) {
                return currentValue;
            }
            for (int i = 0; i < oreIDs.length - 1; ++i) {
                String oreName = OreDictionary.getOreName((int)i);
                if (!oreName.equals(currentValue)) continue;
                return OreDictionary.getOreName((int)(i + 1));
            }
            return OreDictionary.getOreName((int)oreIDs[0]);
        }
    }

    public static abstract class TextRestricted
    extends Text {
        public TextRestricted(@Nonnull EffectBase parent, String keyname) {
            super(parent, keyname);
        }

        @Override
        public boolean isAcceptable(@Nonnull String value) {
            return value.isEmpty() || this.getEntries().parallelStream().map(s -> s.toLowerCase(Locale.ENGLISH)).anyMatch(s -> s.startsWith(value));
        }

        @Override
        @Nullable
        public abstract ArrayList<String> getEntries();

        @Override
        public String overrideInput(@Nonnull String input) {
            if (input.isEmpty()) {
                return input;
            }
            String toLowerCase = input.toLowerCase(Locale.ENGLISH);
            return this.getEntries().parallelStream().map(s -> s.toLowerCase(Locale.ENGLISH)).filter(s -> s.startsWith(toLowerCase)).map(s -> s.substring(0, toLowerCase.length())).findAny().map(s -> s + toLowerCase.substring(s.length())).orElse(input);
        }
    }

    public static class Text
    extends SettingFunc<String, NBTTagString> {
        public Text(@Nonnull EffectBase parent, String keyname) {
            super(parent, keyname, "", NBTTagString::new, NBTTagString::func_150285_a_, NBTTagString.class);
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.TEXT;
        }
    }

    public static class Slider
    extends SettingFunc<Float, NBTTagFloat>
    implements IScrollBar {
        private final float minValue;
        private final float maxValue;

        public Slider(@Nonnull EffectBase parent, String keyname, float _default, float minValue, float maxValue) {
            super(parent, keyname, Float.valueOf(_default), NBTTagFloat::new, NBTTagFloat::func_150288_h, NBTTagFloat.class);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.SCROLL_BAR;
        }

        @Override
        public float getMinValue() {
            return this.minValue;
        }

        @Override
        public float getMaxValue() {
            return this.maxValue;
        }

        @Override
        public Float overrideInput(Float input) {
            return Float.valueOf(MathHelper.func_76131_a((float)input.floatValue(), (float)this.minValue, (float)this.maxValue));
        }
    }

    public static class YesNo
    extends SettingFunc<Boolean, NBTTagByte> {
        public YesNo(@Nonnull EffectBase parent, String keyname, boolean _default) {
            super(parent, keyname, _default, t -> new NBTTagByte(t != false ? (byte)1 : (byte)0), t -> t.func_150287_d() != 0, NBTTagByte.class);
        }

        @Override
        public List<Boolean> getEntries() {
            return ImmutableList.of((Object)Boolean.TRUE, (Object)Boolean.FALSE);
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.BUTTON;
        }
    }

    public static class Stack
    extends SettingFunc<ItemStack, NBTTagCompound> {
        final Predicate<ItemStack> isValid;

        public Stack(@Nonnull EffectBase parent, String keyname) {
            this(parent, keyname, ItemStack.field_190927_a);
        }

        public Stack(@Nonnull EffectBase parent, String keyname, ItemStack _default) {
            this(parent, keyname, _default, (ItemStack t) -> true);
        }

        public Stack(@Nonnull EffectBase parent, String keyname, ItemStack _default, Predicate<ItemStack> isValid) {
            super(parent, keyname, _default, t -> t.func_77955_b(new NBTTagCompound()), ItemStack::new, NBTTagCompound.class);
            this.isValid = isValid;
        }

        @Override
        @Nonnull
        public ItemStack onClickWithItemStack(ItemStack currentValue, @Nonnull ItemStack stack, IEffectSettingsHolder holder) {
            return stack.func_77946_l();
        }

        @Override
        @Nonnull
        public String format(@Nonnull ItemStack value) {
            if (value.func_190926_b()) {
                return "";
            }
            return value.func_82833_r();
        }

        @Override
        public boolean isAcceptable(ItemStack value) {
            return this.isValid.test(value);
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.ITEMSTACK;
        }
    }

    public static class Choice<E extends Enum<E>>
    extends SettingFunc<E, NBTTagByte> {
        public Choice(@Nonnull EffectBase parent, String keyname, @Nonnull E _default) {
            super(parent, keyname, _default, t -> new NBTTagByte((byte)t.ordinal()), t -> ((Enum[])_default.getDeclaringClass().getEnumConstants())[t.func_150287_d()], NBTTagByte.class);
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.BUTTON;
        }

        @Override
        public List<E> getEntries() {
            return ImmutableList.copyOf((Object[])((Enum)this._default).getDeclaringClass().getEnumConstants());
        }
    }

    public static class ChoiceOptional<E extends Enum<E>>
    extends SettingFunc<E, NBTTagByte> {
        @Nonnull
        private final Class<E> clazz;

        public ChoiceOptional(@Nonnull EffectBase parent, String keyname, @Nonnull Class<E> clazz) {
            super(parent, keyname, null, t -> new NBTTagByte(t == null ? (byte)-1 : (byte)t.ordinal()), t -> t.func_150290_f() == -1 ? null : ((Enum[])clazz.getEnumConstants())[t.func_150287_d()], NBTTagByte.class);
            this.clazz = clazz;
        }

        @Override
        @Nonnull
        public Entry_Type getType() {
            return Entry_Type.BUTTON;
        }

        @Override
        @Nonnull
        public List<E> getEntries() {
            ArrayList list = Lists.newArrayList((Object[])new Enum[]{null});
            Collections.addAll(list, this.clazz.getEnumConstants());
            return list;
        }
    }

    public static abstract class SettingFunc<V, NBT extends NBTBase>
    extends Setting<V, NBT> {
        final Function<V, NBT> toNBT;
        final Function<NBT, V> fromNBT;

        public SettingFunc(@Nonnull EffectBase parent, String keyname, V _default, Function<V, NBT> toNBT, Function<NBT, V> fromNBT, Class<NBT> clazz) {
            super(parent, keyname, _default, clazz);
            this.toNBT = toNBT;
            this.fromNBT = fromNBT;
        }

        @Override
        public NBT toNBT(V value) {
            return (NBT)((NBTBase)this.toNBT.apply(value));
        }

        @Override
        public V fromNBT(NBT value) {
            return this.fromNBT.apply(value);
        }
    }

    static interface IScrollBar {
        public float getMinValue();

        public float getMaxValue();
    }

    public static enum Entry_Type {
        TEXT(1),
        BUTTON(2),
        ITEMSTACK(2),
        SCROLL_BAR(1);

        public final int height;

        private Entry_Type(int height) {
            this.height = height;
        }
    }
}

