/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class EffectExplosion
extends EffectBaseThrottled
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectExplosion INSTANCE = new EffectExplosion("exploding", 20, 0.05f);

    public EffectExplosion(String name, int baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, @Nonnull World world, @Nonnull BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        this.tryCreateSplosion(random, world, pos);
    }

    public void tryCreateSplosion(@Nonnull Random random, @Nonnull World world, @Nonnull BlockPos pos) {
        Explosion explosion = new Explosion(world, null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2.0f + random.nextFloat() * 2.0f, false, true);
        if (ForgeEventFactory.onExplosionStart((World)world, (Explosion)explosion)) {
            return;
        }
        explosion.func_77278_a();
        List affectedBlockPositions = explosion.func_180343_e();
        if (affectedBlockPositions.isEmpty()) {
            return;
        }
        List collect = affectedBlockPositions.stream().filter(p -> !world.func_175623_d(p) && world.func_175625_s(p) == null).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        affectedBlockPositions.clear();
        affectedBlockPositions.addAll(collect);
        explosion.func_77279_a(true);
        ((WorldServer)world).func_175739_a(EnumParticleTypes.EXPLOSION_HUGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1, 1.0, 0.0, 0.0, 0.0, new int[0]);
        for (int i = 0; i < 4; ++i) {
            ((WorldServer)world).func_175739_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)pos.func_177958_n() + 0.5 + random.nextGaussian() * 2.0, (double)pos.func_177956_o() + 0.5 + random.nextGaussian() * 2.0, (double)pos.func_177952_p() + 0.5 + random.nextGaussian() * 2.0, 1, 1.0, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        return world.func_175625_s(pos) == null;
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        this.tryCreateSplosion(world.field_73012_v, world, pos);
        return true;
    }
}

