/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.bees.CareerBeeEntry;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectItemModification;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class EffectEffection
extends EffectItemModification {
    public static final EffectEffection INSTANCE = new EffectEffection("effect.restore", 16.0f);

    public EffectEffection(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    @Override
    @Nullable
    public ItemStack modifyStack(IBeeGenome genome, @Nonnull ItemStack stack, IBeeHousing housing) {
        return this.modifyStack(stack);
    }

    private ItemStack modifyStack(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        EnumBeeType type = BeeManager.beeRoot.getType(stack);
        if (type != EnumBeeType.DRONE && type != EnumBeeType.PRINCESS) {
            return null;
        }
        IBee bee = BeeManager.beeRoot.getMember(stack);
        if (bee == null) {
            return null;
        }
        IBeeGenome targetGenome = bee.getGenome();
        IAlleleBeeSpecies species = targetGenome.getPrimary();
        IAlleleBeeEffect effect = this.getiAlleleBeeEffect(species);
        if (effect == null) {
            return null;
        }
        IChromosome[] chromosomes = targetGenome.getChromosomes();
        IAllele[] a = new IAllele[chromosomes.length];
        IAllele[] b = new IAllele[chromosomes.length];
        for (int i = 0; i < chromosomes.length; ++i) {
            a[i] = chromosomes[i].getPrimaryAllele();
            b[i] = chromosomes[i].getSecondaryAllele();
            if (i != EnumBeeChromosome.EFFECT.ordinal()) continue;
            if (a[i] == effect && b[i] == effect) {
                return null;
            }
            a[i] = effect;
            b[i] = effect;
        }
        IBeeGenome iBeeGenome = BeeManager.beeRoot.templateAsGenome(a, b);
        NBTTagCompound nbt = tagCompound.func_74737_b();
        bee.writeToNBT(nbt);
        NBTTagCompound nbtGenome = new NBTTagCompound();
        iBeeGenome.writeToNBT(nbtGenome);
        nbt.func_74782_a("Genome", (NBTBase)nbtGenome);
        ItemStack newStack = new ItemStack(stack.func_77973_b(), stack.func_190916_E(), stack.func_77952_i());
        newStack.func_77982_d(nbt);
        return newStack;
    }

    private IAlleleBeeEffect getiAlleleBeeEffect(@Nonnull IAlleleBeeSpecies species) {
        IAlleleBeeEffect iAlleleBeeEffect = CareerBeeEntry.CustomBeeFactory.SPECIES_EFFECT_MAP.get(species);
        if (iAlleleBeeEffect != null) {
            return iAlleleBeeEffect;
        }
        IAllele[] template = BeeManager.beeRoot.getTemplate((IAlleleSpecies)species);
        IAllele iAllele = template[EnumBeeChromosome.EFFECT.ordinal()];
        if (iAllele instanceof IAlleleBeeEffect) {
            return (IAlleleBeeEffect)iAllele;
        }
        return null;
    }

    @Override
    public boolean acceptItemStack(@Nonnull ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        EnumBeeType type = BeeManager.beeRoot.getType(stack);
        if (type != EnumBeeType.DRONE && type != EnumBeeType.PRINCESS) {
            return false;
        }
        IBee bee = BeeManager.beeRoot.getMember(stack);
        if (bee == null) {
            return false;
        }
        IBeeGenome targetGenome = bee.getGenome();
        IAlleleBeeSpecies species = targetGenome.getPrimary();
        IAlleleBeeEffect effect = this.getiAlleleBeeEffect(species);
        if (effect == null) {
            return false;
        }
        IChromosome[] chromosomes = targetGenome.getChromosomes();
        IChromosome chromosome = chromosomes[EnumBeeChromosome.EFFECT.ordinal()];
        return chromosome.getPrimaryAllele() != effect || chromosome.getSecondaryAllele() != effect;
    }

    @Override
    public boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, ItemStack oldStack, @Nonnull ItemStack newStack, IBeeHousing housing) {
        return true;
    }
}

