/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.ImmutableList;
import com.rwtema.careerbees.effects.EffectBaseThrottled;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.genetics.IEffectData;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.lang3.tuple.Pair;

public class EffectDire
extends EffectBaseThrottled {
    public static final int R = 9;
    public static final int HEIGHT = 6;
    public static final EffectDire INSTANCE = new EffectDire("novabynova", 2.0f);
    final ImmutableList<Insn> insnList = ImmutableList.builder().add((Object)new Floor()).addAll((Iterable)IntStream.range(0, 6).mapToObj(x$0 -> new Sides(x$0)).collect(Collectors.toList())).add((Object)new Torches()).add((Object)new Ceiling()).build();

    public EffectDire(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectDire(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    public void performEffect(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, @Nonnull Random random, World world, BlockPos pos, IBeeModifier beeHousingModifier, IBeeModifier beeModeModifier, IEffectSettingsHolder settings) {
        int n = storedData.getInteger(1);
        World worldObj = housing.getWorldObj();
        BlockPos coordinates = housing.getCoordinates();
        int attempts = 20;
        block0: while (attempts > 0) {
            int k = n;
            for (Insn insn : this.insnList) {
                if (k < insn.getSize()) {
                    Pair<BlockPos, IBlockState> result = insn.getResult(k);
                    BlockPos p = coordinates.func_177971_a((Vec3i)result.getLeft());
                    if (!worldObj.func_175701_a(p)) continue;
                    IBlockState state = worldObj.func_180495_p(p);
                    if (((IBlockState)result.getRight()).func_185904_a() != Material.field_151579_a && state.func_177230_c().func_176200_f((IBlockAccess)worldObj, p)) {
                        if (state.func_185904_a() != Material.field_151579_a && !state.func_185904_a().func_76224_d()) {
                            worldObj.func_175655_b(p, true);
                        }
                        worldObj.func_175656_a(p, (IBlockState)result.getRight());
                        break block0;
                    }
                    if (attempts <= 0) break block0;
                    n = (n + 1) % this.insnList.stream().mapToInt(Insn::getSize).sum();
                    --attempts;
                    continue block0;
                }
                k -= insn.getSize();
            }
        }
        storedData.setInteger(1, (n + 1) % this.insnList.stream().mapToInt(Insn::getSize).sum());
    }

    static {
        MinecraftForge.EVENT_BUS.register(EffectDire.class);
    }

    private class Ceiling
    extends Insn {
        private Ceiling() {
        }

        @Override
        int getSize() {
            return 81;
        }

        @Override
        @Nonnull
        Pair<BlockPos, IBlockState> getResult(int n) {
            int maxW = 4;
            int d = 0;
            int x = -maxW;
            int z = -maxW;
            block6: for (int i = 0; i < n; ++i) {
                switch (d) {
                    case 0: {
                        if (++x != maxW) continue block6;
                        d = 1;
                        continue block6;
                    }
                    case 1: {
                        if (++z != maxW) continue block6;
                        d = 2;
                        continue block6;
                    }
                    case 2: {
                        if (--x != -maxW) continue block6;
                        d = 3;
                        continue block6;
                    }
                    case 3: {
                        if (--z != -maxW + 1) continue block6;
                        d = 0;
                        --maxW;
                    }
                }
            }
            boolean flag = !(Math.abs(x) != 1 && Math.abs(x) != 2 || Math.abs(z) != 1 && Math.abs(z) != 2);
            return Pair.of((Object)new BlockPos(x, 6, z), (Object)(flag ? Blocks.field_150359_w.func_176223_P() : Blocks.field_150347_e.func_176223_P()));
        }
    }

    private class Torches
    extends Insn {
        private Torches() {
        }

        @Override
        int getSize() {
            return 4;
        }

        @Override
        @Nonnull
        Pair<BlockPos, IBlockState> getResult(int n) {
            EnumFacing dir = EnumFacing.field_176754_o[n];
            int i = 3;
            return Pair.of((Object)new BlockPos(dir.func_82601_c() * i, 3, dir.func_82599_e() * i), (Object)Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)dir.func_176734_d()));
        }
    }

    private class Sides
    extends Insn {
        final int y;

        private Sides(int y) {
            this.y = y;
        }

        @Override
        int getSize() {
            return 32;
        }

        @Override
        @Nonnull
        Pair<BlockPos, IBlockState> getResult(int n) {
            int dz;
            int dx;
            int z0;
            int x0;
            int d = n % 8;
            int dn = (n - d) / 8;
            switch (dn) {
                case 0: {
                    x0 = 0;
                    z0 = 0;
                    dx = 1;
                    dz = 0;
                    break;
                }
                case 1: {
                    x0 = 8;
                    z0 = 0;
                    dx = 0;
                    dz = 1;
                    break;
                }
                case 2: {
                    x0 = 8;
                    z0 = 8;
                    dx = -1;
                    dz = 0;
                    break;
                }
                case 3: {
                    x0 = 0;
                    z0 = 8;
                    dx = 0;
                    dz = -1;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("" + n);
                }
            }
            int x = x0 - 4 + dx * d;
            int z = z0 - 4 + dz * d;
            if (this.y <= 1 && (x == 0 || z == 0)) {
                return Pair.of((Object)new BlockPos(x, this.y, z), (Object)Blocks.field_150350_a.func_176223_P());
            }
            return Pair.of((Object)new BlockPos(x, this.y, z), (Object)Blocks.field_150347_e.func_176223_P());
        }
    }

    private class Floor
    extends Insn {
        private Floor() {
        }

        @Override
        int getSize() {
            return 81;
        }

        @Override
        @Nonnull
        Pair<BlockPos, IBlockState> getResult(int n) {
            int x = n % 9;
            int z = (n - x) / 9;
            return Pair.of((Object)new BlockPos(x - 4, -1, z - 4), (Object)Blocks.field_150347_e.func_176223_P());
        }
    }

    private static abstract class Insn {
        private Insn() {
        }

        abstract int getSize();

        @Nonnull
        abstract Pair<BlockPos, IBlockState> getResult(int var1);
    }
}

