/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EffectAcceleration
extends EffectBase
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectAcceleration INSTANCE = new EffectAcceleration();
    final WeakHashMap<World, TObjectIntHashMap<BlockPos>> posToTick = new WeakHashMap();
    boolean processing = false;

    public EffectAcceleration() {
        super("accelerate");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        return true;
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        Block block;
        TObjectIntHashMap toTickPos = this.posToTick.computeIfAbsent(world, w -> new TObjectIntHashMap());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof ITickable) {
            toTickPos.put((Object)pos, 40);
        }
        if ((block = world.func_180495_p(pos).func_177230_c()).func_149653_t()) {
            world.func_175684_a(pos, block, 1);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        if (this.processing) {
            return storedData;
        }
        World world = housing.getWorldObj();
        if (world.field_72995_K) {
            return storedData;
        }
        if (world.func_82737_E() % 20L != 0L) {
            return storedData;
        }
        BlockPos coordinates = housing.getCoordinates();
        TObjectIntHashMap toTickPos = this.posToTick.computeIfAbsent(world, w -> new TObjectIntHashMap());
        if (toTickPos.containsKey((Object)coordinates)) {
            return storedData;
        }
        toTickPos.put((Object)coordinates, 0);
        try {
            this.processing = true;
            Vec3d territory = EffectAcceleration.getTerritory(genome, housing);
            int mx = MathHelper.func_76128_c((double)territory.field_72450_a);
            int my = MathHelper.func_76128_c((double)territory.field_72448_b);
            int mz = MathHelper.func_76128_c((double)territory.field_72449_c);
            for (int dx = -mx; dx <= mx; ++dx) {
                for (int dz = -mz; dz <= mz; ++dz) {
                    for (int dy = -my; dy <= my; ++dy) {
                        BlockPos pos = new BlockPos(coordinates.func_177958_n() + dx, coordinates.func_177956_o() + dy, coordinates.func_177952_p() + dz);
                        IBlockState blockState = world.func_180495_p(pos);
                        Block block = blockState.func_177230_c();
                        if (block.isAir(blockState, (IBlockAccess)world, pos)) continue;
                        TileEntity tileEntity = world.func_175625_s(pos);
                        if (tileEntity instanceof ITickable) {
                            toTickPos.put((Object)pos.func_185334_h(), 40);
                        }
                        if (!block.func_149653_t()) continue;
                        world.func_175684_a(pos, block, 1);
                    }
                }
            }
        }
        finally {
            this.processing = false;
        }
        return storedData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void worldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (this.processing) {
            return;
        }
        TObjectIntHashMap<BlockPos> blockPosSet = this.posToTick.get(event.world);
        if (blockPosSet != null && !blockPosSet.isEmpty()) {
            try {
                this.processing = true;
                ArrayList<ITickable> toTick = new ArrayList<ITickable>(this.posToTick.size());
                TObjectIntIterator iterator = blockPosSet.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    BlockPos blockPos = (BlockPos)iterator.key();
                    TileEntity tileEntity = event.world.func_175625_s(blockPos);
                    if (tileEntity instanceof ITickable) {
                        toTick.add((ITickable)tileEntity);
                        int value = iterator.value();
                        if (value > 0) {
                            iterator.setValue(value - 1);
                            continue;
                        }
                        iterator.remove();
                        continue;
                    }
                    iterator.remove();
                }
                for (int i = 0; i < 4; ++i) {
                    toTick.forEach(ITickable::func_73660_a);
                }
            }
            finally {
                this.processing = false;
            }
        }
    }
}

