/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import forestry.api.genetics.IEffectData;
import gnu.trove.map.hash.TIntIntHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.Validate;

public abstract class BaseEffectDataMap
implements IEffectData {
    public void setBoolean(int index, boolean val) {
        this.setInteger(index, val ? 1 : 0);
    }

    public boolean getBoolean(int index) {
        return this.getInteger(index) != 0;
    }

    public void readFromNBT(@Nonnull NBTTagCompound nbt) {
    }

    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        return nbt;
    }

    public static class None
    extends BaseEffectDataMap {
        public static final None INSTANCE = new None();

        public void setInteger(int index, int val) {
        }

        public int getInteger(int index) {
            return 0;
        }
    }

    public static class IntArray
    extends BaseEffectDataMap {
        final int[] data;

        public IntArray(int[] data) {
            this.data = data;
        }

        public void setInteger(int index, int val) {
            this.data[index] = val;
        }

        public int getInteger(int index) {
            return this.data[index];
        }
    }

    public static class IntMap
    extends BaseEffectDataMap {
        @Nonnull
        final TIntIntHashMap map = new TIntIntHashMap(1, 0.5f, 0, 0);

        public void setInteger(int index, int val) {
            this.map.put(index, val);
        }

        public int getInteger(int index) {
            return this.map.get(index);
        }
    }

    public static class SingleInt
    extends BaseEffectDataMap {
        int data;

        public void setInteger(int index, int val) {
            Validate.isTrue((index == 0 ? 1 : 0) != 0);
            this.data = val;
        }

        public int getInteger(int index) {
            Validate.isTrue((index == 0 ? 1 : 0) != 0);
            return this.data;
        }
    }
}

