/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.bees;

import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleArea;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosomeType;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.math.Vec3i;

public class SpecialProperties {
    public static IAllele FERTILITY_6;
    public static IAllele FERTILITY_7;
    public static IAllele SPEED_0;
    public static IAllele ETERNAL;
    public static IAllele AGORAPHOBIC;
    public static IAllele LEGENDARY_SPEED;
    public static IAllele LEGENDARY_;
    public static IAlleleFloat ROBO_SPEED;

    public static void init() {
        SPEED_0 = SpecialProperties.createFloat("lazy", 0.001f, true, EnumBeeChromosome.SPEED);
        ROBO_SPEED = SpecialProperties.createFloat("robotic", 2.5f, true, EnumBeeChromosome.SPEED);
        FERTILITY_6 = SpecialProperties.createInteger("prolific", 6, false, EnumBeeChromosome.FERTILITY);
        FERTILITY_7 = SpecialProperties.createInteger("catholic", 7, false, EnumBeeChromosome.FERTILITY);
        ETERNAL = SpecialProperties.createInteger("immortal", 3000, true, EnumBeeChromosome.LIFESPAN);
        AGORAPHOBIC = SpecialProperties.createArea("agoraphobic", new Vec3i(0.01, 0.01, 0.01), true, EnumBeeChromosome.TERRITORY);
    }

    @Nonnull
    public static IAlleleInteger createInteger(String valName, int value, boolean isDominant, @Nonnull EnumBeeChromosome chromosome) {
        return SpecialProperties.createType((x$0, x$1, x$2, x$3, x$4, xva$5) -> AlleleManager.alleleFactory.createInteger(x$0, x$1, x$2, x$3, x$4, new IChromosomeType[]{xva$5}), valName, chromosome, value, isDominant);
    }

    @Nonnull
    public static IAlleleFloat createFloat(String valName, float value, boolean isDominant, @Nonnull EnumBeeChromosome chromosome) {
        return SpecialProperties.createType((x$0, x$1, x$2, x$3, x$4, xva$5) -> AlleleManager.alleleFactory.createFloat(x$0, x$1, x$2, x$3, x$4, new IChromosomeType[]{xva$5}), valName, chromosome, Float.valueOf(value), isDominant);
    }

    @Nonnull
    public static IAlleleBoolean createBoolean(String valName, boolean value, boolean isDominant, @Nonnull EnumBeeChromosome chromosome) {
        return SpecialProperties.createType((modId, category, valueName, value1, isDominant1, type) -> AlleleManager.alleleFactory.createBoolean(modId, category, value1.booleanValue(), isDominant1, new IChromosomeType[0]), valName, chromosome, value, isDominant);
    }

    @Nonnull
    public static IAlleleArea createArea(String valName, Vec3i value, boolean isDominant, @Nonnull EnumBeeChromosome chromosome) {
        return SpecialProperties.createType((x$0, x$1, x$2, x$3, x$4, xva$5) -> AlleleManager.alleleFactory.createArea(x$0, x$1, x$2, x$3, x$4, new IChromosomeType[]{xva$5}), valName, chromosome, value, isDominant);
    }

    @Nonnull
    public static <V, K extends IAllele> K createType(@Nonnull RegisterType<V, K> t, String valName, @Nonnull EnumBeeChromosome chromosome, V value, boolean isDominant) {
        K type = t.createType("careerbees", chromosome.name().toLowerCase(Locale.ENGLISH), valName, value, isDominant, (IChromosomeType)chromosome);
        Lang.translate(type.getUnlocalizedName(), valName);
        return type;
    }

    public static interface RegisterType<V, K extends IAllele> {
        @Nonnull
        public K createType(String var1, String var2, String var3, V var4, boolean var5, IChromosomeType var6);
    }
}

