/*
 * Decompiled with CFR 0.152.
 */
package quaternary.brokenwings.countermeasures;

import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.config.Configuration;
import quaternary.brokenwings.config.ConfigHelpers;
import quaternary.brokenwings.config.ItemList;
import quaternary.brokenwings.countermeasures.ICountermeasure;

public class GreasyArmorCountermeasure
implements ICountermeasure {
    private ItemList items;

    @Override
    public String getName() {
        return "greasyarmor";
    }

    @Override
    public String getFriendlyName() {
        return "Greasy Armor";
    }

    @Override
    public String getDescription() {
        return "Unequips armor matching a list. If it can't be unequipped (full inventory, maybe), it gets thrown on the ground.";
    }

    @Override
    public void readConfig(Configuration config) {
        String cat = "countermeasures." + this.getName();
        this.items = ConfigHelpers.getItemList(config, "items", cat, new ItemList(), "Items to automatically unequip when worn as armor.");
    }

    @Override
    public boolean isFlying(EntityPlayerMP playerMP) {
        for (ItemStack s : playerMP.field_71071_by.field_70460_b) {
            if (!this.items.contains(s, playerMP.field_71093_bK)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void stopFlying(EntityPlayerMP playerMP) {
        NonNullList armor = playerMP.field_71071_by.field_70460_b;
        for (int i = 0; i < armor.size(); ++i) {
            if (!this.items.contains((ItemStack)armor.get(i), playerMP.field_71093_bK)) continue;
            ItemStack gottem = ((ItemStack)armor.get(i)).func_77946_l();
            armor.set(i, (Object)ItemStack.field_190927_a);
            if (!playerMP.field_71071_by.func_70441_a(gottem)) continue;
            playerMP.func_71019_a(gottem, false);
        }
    }
}

