/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="biomeinfo")
public class Configuration {
    @Config.Name(value="Enable")
    @Config.Comment(value={"true if the biome info should be shown, false otherwise"})
    public static boolean enabled = true;
    @Config.Name(value="Fade Out")
    @Config.Comment(value={"true if the biome info should only show shortly when the biome is switched"})
    public static boolean fadeOut = true;
    @Config.Name(value="Display Time")
    @Config.Comment(value={"How long in ticks (20 ticks = 1 second) to display the biome info, if fadeOut = true"})
    @Config.RangeInt(min=0, max=0x7FFFFFFF)
    public static int displayTime = 30;
    @Config.Name(value="Position X")
    @Config.Comment(value={"The X position to display the biome info at"})
    public static int posX = 3;
    @Config.Name(value="Position Y")
    @Config.Comment(value={"The Y position to display the biome info at"})
    public static int posY = 3;
    @Config.Name(value="Scale")
    @Config.Comment(value={"The size of the biome info (multiplier)"})
    public static double scale = 1.0;
    @Config.Name(value="Shadow")
    @Config.Comment(value={"true if the biome info should be rendered with a shadow, false otherwise"})
    public static boolean textShadow = true;
    @Config.Name(value="Color")
    @Config.Comment(value={"The color to display the biome info in (hexadecimal)"})
    public static String sColor = "ffffff";
    @Config.Ignore
    public static int iColor = Integer.parseInt(sColor, 16);

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onOnConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("biomeinfo")) {
                ConfigManager.sync((String)"biomeinfo", (Config.Type)Config.Type.INSTANCE);
                iColor = Integer.parseInt(sColor, 16);
            }
        }
    }
}

