/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.biomeinfo;

import bl4ckscor3.mod.biomeinfo.Configuration;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod(modid="biomeinfo", name="BiomeInfo", version="v1.2.5", acceptedMinecraftVersions="[1.12]", clientSideOnly=true)
public class BiomeInfo {
    public static final String MODID = "biomeinfo";
    public static final String NAME = "BiomeInfo";
    public static final String VERSION = "v1.2.5";
    public static final String MC_VERSION = "1.12";
    public Biome previousBiome;
    public int displayTime = 0;
    public int alpha = 0;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ModMetadata meta = event.getModMetadata();
        meta.authorList = Arrays.asList("bl4ckscor3");
        meta.autogenerated = false;
        meta.description = "Adds a customizable text to the top left corner saying what biome the player is in.";
        meta.modId = MODID;
        meta.name = NAME;
        meta.version = VERSION;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Configuration.iColor = Integer.parseInt(Configuration.sColor, 16);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Configuration.fadeOut && this.alpha != 255) {
            this.alpha = 255;
        } else if (Configuration.fadeOut) {
            if (this.displayTime > 0) {
                --this.displayTime;
            } else if (this.alpha > 0) {
                this.alpha -= 10;
            }
        }
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        if (Configuration.enabled && !Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            Chunk chunk;
            Minecraft mc = Minecraft.func_71410_x();
            BlockPos pos = new BlockPos(mc.func_175606_aa().field_70165_t, mc.func_175606_aa().func_174813_aQ().field_72338_b, mc.func_175606_aa().field_70161_v);
            if (mc.field_71441_e != null && mc.field_71441_e.func_175667_e(pos) && pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !(chunk = mc.field_71441_e.func_175726_f(pos)).func_76621_g()) {
                Biome biome = chunk.func_177411_a(pos, mc.field_71441_e.func_72959_q());
                if (this.previousBiome != biome) {
                    this.previousBiome = biome;
                    this.displayTime = Configuration.displayTime;
                    this.alpha = 255;
                }
                if (this.alpha > 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179139_a((double)Configuration.scale, (double)Configuration.scale, (double)Configuration.scale);
                    mc.field_71466_p.func_175065_a(chunk.func_177411_a(pos, mc.field_71441_e.func_72959_q()).func_185359_l(), (float)Configuration.posX, (float)Configuration.posY, Configuration.iColor | this.alpha << 24, Configuration.textShadow);
                    GlStateManager.func_179121_F();
                }
            }
        }
    }
}

