/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.world;

import com.bewitchment.Bewitchment;
import com.bewitchment.api.capability.extendedworld.ExtendedWorld;
import com.bewitchment.common.network.PacketBiomeUpdate;
import com.bewitchment.common.network.PacketChangeBiome;
import com.google.common.collect.HashMultimap;
import java.util.Set;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.dimdev.jeid.INewChunk;

public class BiomeChangingUtils {
    public static void setMultiBiome(World world, Biome biome, BlockPos ... poses) {
        int id = Biome.func_185362_a((Biome)biome);
        HashMultimap changes = HashMultimap.create();
        for (BlockPos pos : poses) {
            changes.put((Object)new ChunkPos(pos), (Object)pos);
        }
        changes.keys().forEach(chunkPos -> {
            Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
            byte[] biomes = chunk.func_76605_m();
            Set changeSet = changes.get(chunkPos);
            changeSet.forEach(pos -> {
                int i = pos.func_177958_n() & 0xF;
                int j = pos.func_177952_p() & 0xF;
                int value = j << 4 | i;
                if (biomes[value] == id) {
                    changeSet.remove(pos);
                } else {
                    biomes[value] = (byte)id;
                }
            });
            chunk.func_76630_e();
        });
    }

    public static void resetRandomOverriddenBiome(World world) {
        ExtendedWorld extendedWorld = ExtendedWorld.get(world);
        BlockPos randomPos = extendedWorld.STORED_OVERRIDE_BIOMES.keySet().toArray(new BlockPos[extendedWorld.STORED_OVERRIDE_BIOMES.size()])[world.field_73012_v.nextInt(extendedWorld.STORED_OVERRIDE_BIOMES.size())];
        BiomeChangingUtils.setBiome(world, extendedWorld.STORED_OVERRIDE_BIOMES.get(randomPos), randomPos);
        extendedWorld.STORED_OVERRIDE_BIOMES.remove(randomPos);
        extendedWorld.func_76186_a(true);
    }

    public static void updateBiomeOnClient(World world, BlockPos pos, int id, int updateRadius) {
        Bewitchment.network.sendToAllAround((IMessage)new PacketBiomeUpdate(pos, id), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)updateRadius));
    }

    public static void setBiome(World world, BlockPos pos, int id) {
        Chunk chunk = world.func_175726_f(pos);
        int x = pos.func_177958_n() & 0xF;
        int z = pos.func_177952_p() & 0xF;
        int i = z << 4 | x;
        if (Bewitchment.JEID && chunk instanceof INewChunk) {
            ((INewChunk)chunk).getIntBiomeArray()[i] = id;
        } else {
            chunk.func_76605_m()[i] = (byte)id;
        }
        chunk.func_76630_e();
    }

    @Deprecated
    public static void setBiome(World world, Biome biome, BlockPos pos) {
        int chunkZ;
        int chunkX;
        PlayerChunkMap playerChunkMap;
        PlayerChunkMapEntry entry;
        Chunk chunk = world.func_175726_f(pos);
        int i = pos.func_177958_n() & 0xF;
        int j = pos.func_177952_p() & 0xF;
        byte id = (byte)Biome.func_185362_a((Biome)biome);
        byte b = chunk.func_76605_m()[j << 4 | i];
        if (b == id) {
            return;
        }
        chunk.func_76605_m()[j << 4 | i] = id;
        chunk.func_76630_e();
        if (world instanceof WorldServer && (entry = (playerChunkMap = ((WorldServer)world).func_184164_w()).func_187301_b(chunkX = pos.func_177958_n() >> 4, chunkZ = pos.func_177952_p() >> 4)) != null) {
            Bewitchment.network.sendToAll((IMessage)new PacketChangeBiome(biome, pos));
        }
    }
}

