/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.block.tile.entity;

import com.bewitchment.common.block.tile.entity.util.ModTileEntity;
import com.bewitchment.common.item.ItemSigil;
import com.bewitchment.common.item.ItemTaglock;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class TileEntitySigil
extends ModTileEntity
implements ITickable {
    public ItemSigil sigil;
    public int cooldown = 0;
    public int timer = 168000;
    public boolean whiteList;
    public Set<String> whiteListUUIDSet = new HashSet<String>();

    public void setupTileEntity(ItemSigil sigil) {
        this.sigil = sigil;
        this.cooldown = sigil.cooldown;
        this.whiteList = sigil.positive;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        this.readUpdateTag(tag);
        super.func_145839_a(tag);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        this.writeUpdateTag(tag);
        return super.func_189515_b(tag);
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeUpdateTag(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        this.writeUpdateTag(tag);
        return tag;
    }

    @Override
    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        NBTTagCompound tag = packet.func_148857_g();
        this.readUpdateTag(tag);
    }

    @Override
    public boolean activate(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing face) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemTaglock && player.func_184586_b(hand).func_77942_o()) {
            this.modifyList(player.func_184586_b(hand).func_77978_p().func_74779_i("boundId"));
            return true;
        }
        return super.activate(world, pos, player, hand, face);
    }

    private void writeUpdateTag(NBTTagCompound tag) {
        tag.func_74778_a("sigil", this.sigil == null ? "" : this.sigil.getRegistryName().toString());
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74757_a("whitelist", this.whiteList);
        NBTTagList playerList = new NBTTagList();
        for (String s : this.whiteListUUIDSet) {
            playerList.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74782_a("playerList", (NBTBase)playerList);
        tag.func_74768_a("timer", this.timer);
    }

    private void readUpdateTag(NBTTagCompound tag) {
        this.sigil = tag.func_74779_i("sigil").isEmpty() ? null : (ItemSigil)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("sigil")));
        this.cooldown = tag.func_74762_e("cooldown");
        this.whiteList = tag.func_74767_n("whitelist");
        NBTTagList playerList = tag.func_150295_c("playerList", 8);
        for (int i = 0; i < playerList.func_74745_c(); ++i) {
            this.whiteListUUIDSet.add(playerList.func_150307_f(i));
        }
        this.timer = tag.func_74762_e("timer");
    }

    private boolean isEntityOnList(EntityLivingBase player) {
        return this.whiteListUUIDSet.contains(player.func_110124_au().toString());
    }

    private void modifyList(String uuid) {
        if (this.whiteListUUIDSet.contains(uuid)) {
            this.whiteListUUIDSet.remove(uuid);
        } else {
            this.whiteListUUIDSet.add(uuid);
        }
    }

    public void func_73660_a() {
        if (this.timer > 0) {
            --this.timer;
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (this.sigil != null) {
                List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 6), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 6), (double)(this.field_174879_c.func_177958_n() + 6), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 6))).stream().filter(p -> this.isEntityOnList((EntityLivingBase)p) == this.whiteList).collect(Collectors.toList());
                for (EntityLivingBase living : entities) {
                    this.sigil.applyEffects(living);
                }
                this.cooldown = this.sigil.cooldown;
            }
        } else {
            if (!this.field_145850_b.field_72995_K) {
                ((WorldServer)this.field_145850_b).func_175739_a(EnumParticleTypes.REDSTONE, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 100, this.field_145850_b.field_73012_v.nextGaussian() / 3.0, 0.0, this.field_145850_b.field_73012_v.nextGaussian() / 3.0, 0.0, new int[0]);
            }
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }
}

