/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import java.util.Optional;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkyCollectionHelper {
    private static final int accuracy = 32;
    private static final Random sharedRand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static Optional<Float> getSkyNoiseDistributionClient(World world, BlockPos pos) {
        Optional<Long> testSeed = ConstellationSkyHandler.getInstance().getSeedIfPresent(world);
        if (!testSeed.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(Float.valueOf(SkyCollectionHelper.getDistributionInternal(testSeed.get(), pos)));
    }

    public static float getSkyNoiseDistribution(World world, BlockPos pos) {
        return SkyCollectionHelper.getDistributionInternal(new Random(world.func_72905_C()).nextLong(), pos);
    }

    private static float getDistributionInternal(long seed, BlockPos pos) {
        BlockPos lowerAnchorPoint = new BlockPos((int)Math.floor((float)pos.func_177958_n() / 32.0f) * 32, 0, (int)Math.floor((float)pos.func_177952_p() / 32.0f) * 32);
        float layer0 = SkyCollectionHelper.getNoiseDistribution(seed, lowerAnchorPoint, lowerAnchorPoint.func_177982_a(32, 0, 0), lowerAnchorPoint.func_177982_a(0, 0, 32), lowerAnchorPoint.func_177982_a(32, 0, 32), pos);
        sharedRand.setSeed(seed);
        long nextLayerSeed = sharedRand.nextLong();
        float layer1 = SkyCollectionHelper.getNoiseDistribution(nextLayerSeed, lowerAnchorPoint, lowerAnchorPoint.func_177982_a(32, 0, 0), lowerAnchorPoint.func_177982_a(0, 0, 32), lowerAnchorPoint.func_177982_a(32, 0, 32), pos);
        return layer0 * layer1;
    }

    private static float getNoiseDistribution(long seed, BlockPos lXlZ, BlockPos hXlZ, BlockPos lXhZ, BlockPos hXhZ, BlockPos exact) {
        float nll = SkyCollectionHelper.getNoise(seed, lXlZ.func_177958_n(), lXlZ.func_177952_p());
        float nhl = SkyCollectionHelper.getNoise(seed, hXlZ.func_177958_n(), hXlZ.func_177952_p());
        float nlh = SkyCollectionHelper.getNoise(seed, lXhZ.func_177958_n(), lXhZ.func_177952_p());
        float nhh = SkyCollectionHelper.getNoise(seed, hXhZ.func_177958_n(), hXhZ.func_177952_p());
        float xPart = Math.abs((float)(exact.func_177958_n() - lXlZ.func_177958_n()) / 32.0f);
        float zPart = Math.abs((float)(exact.func_177952_p() - lXlZ.func_177952_p()) / 32.0f);
        return SkyCollectionHelper.cosInterpolate(SkyCollectionHelper.cosInterpolate(nll, nhl, xPart), SkyCollectionHelper.cosInterpolate(nlh, nhh, xPart), zPart);
    }

    private static float cosInterpolate(float l, float h, float partial) {
        float t2 = (1.0f - MathHelper.func_76134_b((float)((float)((double)partial * Math.PI)))) / 2.0f;
        return l * (1.0f - t2) + h * t2;
    }

    private static float getNoise(long seed, int posX, int posZ) {
        sharedRand.setSeed(SkyCollectionHelper.simple_hash(new int[]{(int)seed, (int)(seed >> 32), posX, posZ}, 4));
        sharedRand.nextLong();
        return sharedRand.nextFloat();
    }

    private static int simple_hash(int[] is, int count) {
        int hash = 80238287;
        for (int i = 0; i < count; ++i) {
            hash = hash << 4 ^ hash >> 28 ^ is[i] * 5449 % 130651;
        }
        return hash % 75327403;
    }
}

