/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.storage;

import hellfirepvp.astralsorcery.common.util.ItemUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StoredItemStack {
    private ItemStack stack;
    private int amount;

    StoredItemStack(ItemStack stack) {
        this(stack, stack.func_190916_E());
    }

    private StoredItemStack(ItemStack stack, int amount) {
        this.stack = ItemUtils.copyStackWithSize(stack, 1);
        this.amount = amount;
    }

    public ItemStack getTemplateStack() {
        return ItemUtils.copyStackWithSize(this.stack, Math.min(this.stack.func_77976_d(), this.amount));
    }

    public boolean removeAmount(int amount) {
        if (this.amount - amount < 0) {
            return false;
        }
        this.amount -= amount;
        return true;
    }

    public boolean isEmpty() {
        return this.amount <= 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean combineIntoThis(StoredItemStack other) {
        if (other.stack.func_77973_b() != this.stack.func_77973_b()) {
            return false;
        }
        if (this.stack.func_77942_o() ^ other.stack.func_77942_o()) {
            return false;
        }
        if (this.stack.func_77942_o() && !this.stack.func_77978_p().equals((Object)other.stack.func_77978_p())) {
            return false;
        }
        if (this.stack.func_77973_b().func_77614_k() && this.stack.func_77960_j() != other.stack.func_77960_j()) {
            return false;
        }
        if (!this.stack.areCapsCompatible(other.stack)) {
            return false;
        }
        this.amount += other.amount;
        return true;
    }

    public boolean combineIntoThis(ItemStack other) {
        if (other.func_77973_b() != this.stack.func_77973_b()) {
            return false;
        }
        if (this.stack.func_77942_o() ^ other.func_77942_o()) {
            return false;
        }
        if (this.stack.func_77942_o() && !this.stack.func_77978_p().equals((Object)other.func_77978_p())) {
            return false;
        }
        if (this.stack.func_77973_b().func_77614_k() && this.stack.func_77960_j() != other.func_77960_j()) {
            return false;
        }
        if (!this.stack.areCapsCompatible(other)) {
            return false;
        }
        this.amount += other.func_190916_E();
        return true;
    }

    @Nonnull
    public NBTTagCompound serialize() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("item", (NBTBase)this.stack.serializeNBT());
        tag.func_74768_a("amount", this.amount);
        return tag;
    }

    @Nullable
    public static StoredItemStack deserialize(NBTTagCompound cmp) {
        ItemStack stack = new ItemStack(cmp.func_74775_l("item"));
        if (stack.func_190926_b()) {
            return null;
        }
        int amount = cmp.func_74762_e("amount");
        return new StoredItemStack(stack, amount);
    }
}

