/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.perk.tree;

import hellfirepvp.astralsorcery.client.gui.perk.BatchPerkContext;
import hellfirepvp.astralsorcery.client.gui.perk.PerkRender;
import hellfirepvp.astralsorcery.client.gui.perk.PerkRenderGroup;
import hellfirepvp.astralsorcery.client.gui.perk.group.PerkPointRenderGroup;
import hellfirepvp.astralsorcery.client.util.BufferBatch;
import hellfirepvp.astralsorcery.client.util.SpriteLibrary;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.constellation.perk.AbstractPerk;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PerkTreePoint<T extends AbstractPerk>
implements PerkRender {
    private Point offset;
    private final T perk;
    private int renderSize;
    private static final int spriteSize = 11;

    public PerkTreePoint(T perk, Point offset) {
        this.offset = offset;
        this.perk = perk;
        this.renderSize = 11;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addGroups(Collection<PerkRenderGroup> groups) {
        groups.add(PerkPointRenderGroup.INSTANCE);
    }

    public void setRenderSize(int renderSize) {
        this.renderSize = renderSize;
    }

    public int getRenderSize() {
        return this.renderSize;
    }

    public T getPerk() {
        return this.perk;
    }

    public Point getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Rectangle2D.Double renderPerkAtBatch(BatchPerkContext drawCtx, AllocationStatus status, long spriteOffsetTick, float pTicks, double x, double y, double scale) {
        SpriteSheetResource tex = this.getFlareSprite(status);
        BatchPerkContext.TextureObjectGroup grp = PerkPointRenderGroup.INSTANCE.getGroup(tex);
        if (grp == null) {
            return new Rectangle2D.Double();
        }
        BufferBatch buf = drawCtx.getContext(grp);
        BufferBuilder vb = buf.getBuffer();
        double size = (double)this.renderSize * scale;
        Vector3 starVec = new Vector3(x - size, y - size, 0.0);
        double uLength = tex.getULength();
        double vLength = tex.getVLength();
        Tuple<Double, Double> frameUV = tex.getUVOffset(spriteOffsetTick);
        for (int i = 0; i < 4; ++i) {
            int u = (i + 1 & 2) >> 1;
            int v = (i + 2 & 2) >> 1;
            Vector3 pos = starVec.clone().addX(size * (double)u * 2.0).addY(size * (double)v * 2.0);
            vb.func_181662_b(pos.getX(), pos.getY(), pos.getZ()).func_187315_a((Double)frameUV.key + uLength * (double)u, (Double)frameUV.value + vLength * (double)v).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        }
        return new Rectangle2D.Double(-size, -size, size * 2.0, size * 2.0);
    }

    protected SpriteSheetResource getFlareSprite(AllocationStatus status) {
        SpriteSheetResource tex;
        switch (status) {
            case ALLOCATED: {
                tex = SpriteLibrary.spritePerkActive;
                break;
            }
            case UNLOCKABLE: {
                tex = SpriteLibrary.spritePerkActivateable;
                break;
            }
            default: {
                tex = SpriteLibrary.spritePerkInactive;
            }
        }
        return tex;
    }

    protected SpriteSheetResource getHaloSprite(AllocationStatus status) {
        SpriteSheetResource tex;
        switch (status) {
            case ALLOCATED: {
                tex = SpriteLibrary.spriteHalo5;
                break;
            }
            case UNLOCKABLE: {
                tex = SpriteLibrary.spriteHalo6;
                break;
            }
            default: {
                tex = SpriteLibrary.spriteHalo4;
            }
        }
        return tex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerkTreePoint that = (PerkTreePoint)o;
        return Objects.equals(this.offset, that.offset);
    }

    public int hashCode() {
        return Objects.hash(this.offset);
    }

    public static enum AllocationStatus {
        UNALLOCATED,
        ALLOCATED,
        UNLOCKABLE;

    }
}

