/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.common.integration.aelib.integration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.input.BoundedInputStream;
import org.softc.armoryexpansion.ArmoryExpansion;
import org.softc.armoryexpansion.common.integration.aelib.config.MaterialConfigOptions;
import org.softc.armoryexpansion.common.integration.aelib.integration.AbstractIntegration;
import org.softc.armoryexpansion.common.integration.aelib.plugins.conarm.material.ArmorToolMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.conarm.material.ArmorToolRangedMaterial;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.oredictionary.BasicOreDictionary;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.oredictionary.IOreDictionary;
import org.softc.armoryexpansion.common.integration.aelib.plugins.general.traits.MaterialTraits;
import org.softc.armoryexpansion.common.integration.aelib.plugins.tconstruct.alloys.Alloy;

public class JsonIntegration
extends AbstractIntegration {
    private String json;

    protected JsonIntegration(String modId, String root, String json) {
        super(modId, root);
        this.json = json;
    }

    protected void loadMaterialsFromJson(InputStream path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        ArmorToolMaterial[] jsonMaterials = (ArmorToolRangedMaterial[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(path, (long)ArmoryExpansion.getBoundedInputStreamMaxSize()))), ArmorToolRangedMaterial[].class);
        this.loadMaterials(jsonMaterials);
    }

    @Override
    protected void loadMaterialsFromSource() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/" + this.root + "/data/" + this.json + "/" + this.json + "-materials.json");
        if (null != stream) {
            this.loadMaterialsFromJson(stream);
        }
    }

    protected void loadOreDictionaryEntriesFromJson(InputStream path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        IOreDictionary[] jsonMaterials = (IOreDictionary[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(path, (long)ArmoryExpansion.getBoundedInputStreamMaxSize()))), BasicOreDictionary[].class);
        this.loadOreDictionaryEntries(jsonMaterials);
    }

    @Override
    protected void loadOreDictionaryEntriesFromSource() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/" + this.root + "/data/" + this.json + "/" + this.json + "-oreDictEntries.json");
        if (null != stream) {
            this.loadOreDictionaryEntriesFromJson(stream);
        }
    }

    protected void loadAlloysFromJson(InputStream path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        Alloy[] jsonAlloys = new Alloy[]{};
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(path, (long)ArmoryExpansion.getBoundedInputStreamMaxSize())));
            jsonAlloys = (Alloy[])gson.fromJson((Reader)reader, Alloy[].class);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadAlloys(jsonAlloys);
    }

    @Override
    protected void loadAlloysFromSource() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/" + this.root + "/data/" + this.json + "/" + this.json + "-alloys.json");
        if (null != stream) {
            this.loadAlloysFromJson(stream);
        }
    }

    protected void loadConfigFromJson(InputStream path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        MaterialConfigOptions[] jsonConfig = (MaterialConfigOptions[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(path, (long)ArmoryExpansion.getBoundedInputStreamMaxSize()))), MaterialConfigOptions[].class);
        this.loadConfig(jsonConfig);
    }

    @Override
    protected void loadConfigFromSource() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/" + this.root + "/data/" + this.json + "/" + this.json + "-config.json");
        if (null != stream) {
            this.loadConfigFromJson(stream);
        }
    }

    protected void loadTraitsFromJson(InputStream path) {
        Gson gson = new GsonBuilder().setPrettyPrinting().setLenient().create();
        MaterialTraits[] jsonMaterials = (MaterialTraits[])gson.fromJson((Reader)new BufferedReader(new InputStreamReader((InputStream)new BoundedInputStream(path, (long)ArmoryExpansion.getBoundedInputStreamMaxSize()))), MaterialTraits[].class);
        this.loadTraits(jsonMaterials);
    }

    @Override
    protected void loadTraitsFromSource() {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream("assets/" + this.root + "/data/" + this.json + "/" + this.json + "-traits.json");
        if (null != stream) {
            this.loadTraitsFromJson(stream);
        }
    }
}

