/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecturecraft.repackage.com.elytradev.concrete.block;

import com.elytradev.architecturecraft.repackage.com.elytradev.concrete.block.ConcreteBlock;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.math.MathHelper;

@FunctionalInterface
public interface ItemDropBehaviour {
    public static final ItemDropBehaviour DROP_NONE = ItemDropBehaviour.of(0);
    public static final ItemDropBehaviour DEFAULT = ItemDropBehaviour.of(1);

    public static ItemDropBehaviour of(int quantity) {
        return random -> quantity;
    }

    public static ItemDropBehaviour of(Supplier<Item> drop) {
        return ItemDropBehaviour.of(drop, 1);
    }

    public static ItemDropBehaviour of(final Supplier<Item> drop, final int quantity) {
        return new ItemDropBehaviour(){

            @Override
            public int getQuantityDropped(Random random) {
                return quantity;
            }

            @Override
            public Optional<Supplier<Item>> getDrop() {
                return Optional.of(drop);
            }
        };
    }

    public static ItemDropBehaviour of(int minimum, int maximum) {
        return random -> MathHelper.func_76136_a((Random)random, (int)minimum, (int)maximum);
    }

    public static ItemDropBehaviour of(final Supplier<Item> drop, final int minimum, final int maximum) {
        return new ItemDropBehaviour(){

            @Override
            public int getQuantityDropped(Random random) {
                return MathHelper.func_76136_a((Random)random, (int)minimum, (int)maximum);
            }

            @Override
            public Optional<Supplier<Item>> getDrop() {
                return Optional.of(drop);
            }
        };
    }

    public int getQuantityDropped(Random var1);

    default public int getQuantityDroppedWithBonus(int fortune, Random random) {
        return this.getQuantityDropped(random);
    }

    default public Optional<Supplier<Item>> getDrop() {
        return Optional.empty();
    }

    default public int getMeta(ConcreteBlock block, IBlockState blockState) {
        return 0;
    }

    @FunctionalInterface
    public static interface Fortune
    extends ItemDropBehaviour {
        public static final Fortune DEFAULT = Fortune.of(1);

        public static Fortune of(int quantity) {
            return random -> quantity;
        }

        public static Fortune of(Supplier<Item> drop) {
            return Fortune.of(drop, 1);
        }

        public static Fortune of(final Supplier<Item> drop, final int quantity) {
            return new Fortune(){

                @Override
                public int getQuantityDropped(Random random) {
                    return quantity;
                }

                @Override
                public Optional<Supplier<Item>> getDrop() {
                    return Optional.of(drop);
                }
            };
        }

        public static Fortune of(int minimum, int maximum) {
            return random -> MathHelper.func_76136_a((Random)random, (int)minimum, (int)maximum);
        }

        public static Fortune of(final Supplier<Item> drop, final int minimum, final int maximum) {
            return new Fortune(){

                @Override
                public int getQuantityDropped(Random random) {
                    return MathHelper.func_76136_a((Random)random, (int)minimum, (int)maximum);
                }

                @Override
                public Optional<Supplier<Item>> getDrop() {
                    return Optional.of(drop);
                }
            };
        }

        @Override
        default public int getQuantityDroppedWithBonus(int fortune, Random random) {
            if (fortune > 0) {
                int i = random.nextInt(fortune + 2) - 1;
                if (i < 0) {
                    i = 0;
                }
                return this.getQuantityDropped(random) * (i + 1);
            }
            return this.getQuantityDropped(random);
        }
    }
}

