/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import party.lemons.arcaneworld.block.tilentity.TileEntityRitualTable;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;

public class MessageServerActivateRitual
implements IMessage {
    public ResourceLocation loc;
    public BlockPos pos;
    public int activator;
    public ItemStack[] items = new ItemStack[5];

    public MessageServerActivateRitual() {
    }

    public MessageServerActivateRitual(ResourceLocation location, BlockPos pos, EntityPlayer activator, ItemStack[] items) {
        this.loc = location;
        this.pos = pos;
        this.activator = activator.func_145782_y();
        this.items = items;
    }

    public void fromBytes(ByteBuf buf) {
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.loc = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pos = new BlockPos(x, y, z);
        this.activator = buf.readInt();
        for (int i = 0; i < 5; ++i) {
            this.items[i] = ByteBufUtils.readItemStack((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.loc.toString());
        buf.writeInt(this.activator);
        for (int i = 0; i < 5; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.items[i]);
        }
    }

    public static class Handler
    implements IMessageHandler<MessageServerActivateRitual, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageServerActivateRitual message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                BlockPos cPos = message.pos;
                TileEntity te = Minecraft.func_71410_x().field_71441_e.func_175625_s(cPos);
                if (te instanceof TileEntityRitualTable) {
                    if (((TileEntityRitualTable)te).getState() != TileEntityRitualTable.RitualState.NONE) {
                        return;
                    }
                    ((TileEntityRitualTable)te).setState(TileEntityRitualTable.RitualState.START_UP);
                    ((TileEntityRitualTable)te).setRitual((Ritual)RitualRegistry.REGISTRY.getValue(message.loc));
                    ((TileEntityRitualTable)te).setActivator((EntityPlayer)Minecraft.func_71410_x().field_71441_e.func_73045_a(message.activator));
                    ((TileEntityRitualTable)te).setStacks(message.items);
                }
            });
            return null;
        }
    }
}

