/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.handler.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import party.lemons.arcaneworld.item.ArcaneWorldItems;
import party.lemons.arcaneworld.item.impl.ItemBiomeCrystal;
import party.lemons.arcaneworld.item.impl.ItemPotionOrb;
import party.lemons.arcaneworld.item.impl.ItemRecaller;

@Mod.EventBusSubscriber(modid="arcaneworld", value={Side.CLIENT})
public class ArcaneWorldClientEventHandler {
    public static EntityItem entityItem = null;

    @SubscribeEvent
    public static void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityPlayerSP player = minecraft.field_71439_g;
        ArcaneWorldClientEventHandler.renderRecallerHand(minecraft, player, EnumHand.MAIN_HAND, event.getPartialTicks());
        ArcaneWorldClientEventHandler.renderRecallerHand(minecraft, player, EnumHand.OFF_HAND, event.getPartialTicks());
    }

    @SubscribeEvent
    public static void onItemColours(ColorHandlerEvent.Item event) {
        event.getItemColors().func_186730_a((is, i) -> {
            Biome biome = ((ItemBiomeCrystal)ArcaneWorldItems.BIOME_CRYSTAL).getBiome(is);
            if (biome == null) {
                return 0xFFFFFF;
            }
            return biome.func_180627_b(Minecraft.func_71410_x().field_71439_g.func_180425_c());
        }, new Item[]{ArcaneWorldItems.BIOME_CRYSTAL});
        event.getItemColors().func_186730_a((is, i) -> {
            List<PotionEffect> effects = ((ItemPotionOrb)ArcaneWorldItems.POTION_ORB).getPotionEffects(is);
            if (effects.isEmpty()) {
                return 0xFFFFFF;
            }
            return PotionUtils.func_185181_a(effects);
        }, new Item[]{ArcaneWorldItems.POTION_ORB});
    }

    public static void renderRecallerHand(Minecraft mc, EntityPlayerSP player, EnumHand hand, float partialTicks) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == ArcaneWorldItems.RECALLER && ItemRecaller.getPosition(stack) != null && ItemRecaller.getDimension(stack) != Integer.MAX_VALUE) {
            BlockPos pos = ItemRecaller.getPosition(stack);
            if (entityItem == null) {
                entityItem = new EntityItem((World)mc.field_71441_e, 0.0, 0.0, 0.0, new ItemStack(ArcaneWorldItems.RECALL_EYE));
                entityItem.func_174871_r();
                entityItem.func_174873_u();
                entityItem.func_184195_f(true);
            }
            double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GlStateManager.func_179137_b((double)(-playerX), (double)(-playerY), (double)(-playerZ));
            entityItem.func_70107_b((double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f));
            mc.func_175598_ae().func_188391_a((Entity)entityItem, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), 0.0f, partialTicks, false);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (entityItem != null) {
            entityItem.func_70071_h_();
        }
    }
}

