/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.gen.dungeon.generation;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import party.lemons.arcaneworld.gen.dungeon.generation.DungeonGenerator;
import party.lemons.lemonlib.ticker.ITicker;

public class TickerDungeon
implements ITicker {
    private World world;
    private int dimension;
    private DungeonGenerator generator;
    private int x;
    private int y;
    private int age;
    private boolean stopped = false;

    public TickerDungeon(World world) {
        this.world = world;
        this.dimension = world.field_73011_w.getDimension();
    }

    public TickerDungeon(World world, DungeonGenerator generator) {
        this(world);
        this.dimension = world.field_73011_w.getDimension();
        this.generator = generator;
        this.age = 0;
    }

    public void update(World world) {
        if (world.field_73011_w.getDimension() != this.dimension || this.stopped) {
            return;
        }
        ++this.age;
        if (this.age % 3 == 0) {
            boolean generated = false;
            while (!generated) {
                generated = this.generator.generateRoom(this.x, this.y);
                ++this.x;
                if (this.x < this.generator.getWidth()) continue;
                this.x = 0;
                ++this.y;
                if (this.y < this.generator.getHeight()) continue;
                generated = true;
                this.stopped = true;
            }
        }
    }

    public NBTTagCompound writeToNBT() {
        return new NBTTagCompound();
    }

    public void readFromNBT(NBTTagCompound tags) {
        this.dimension = tags.func_74762_e("dim");
        this.world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimension);
        this.stopped = true;
    }

    public boolean isTaskFinished(World world) {
        return this.stopped;
    }

    public int getDimension() {
        return this.world.field_73011_w.getDimension();
    }

    public boolean isUnique() {
        return false;
    }
}

