/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.crafting.ritual.impl;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import party.lemons.arcaneworld.crafting.ritual.Ritual;

public class RitualWeather
extends Ritual {
    private WeatherType type;

    public RitualWeather(WeatherType type, Ingredient ... ingredients) {
        super(ingredients);
        this.type = type;
    }

    @Override
    public void onActivate(@Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player, ItemStack ... items) {
        WorldServer ws = (WorldServer)world;
        int weatherTime = 1000 + ws.field_73012_v.nextInt(600) * 20;
        WorldInfo worldinfo = ws.func_72912_H();
        if (!this.type.raining) {
            worldinfo.func_176142_i(weatherTime);
            worldinfo.func_76080_g(0);
            worldinfo.func_76090_f(0);
            System.out.println("Clear");
        } else {
            worldinfo.func_176142_i(0);
            worldinfo.func_76080_g(weatherTime);
            worldinfo.func_76090_f(weatherTime);
        }
        worldinfo.func_76084_b(this.type.raining);
        worldinfo.func_76069_a(this.type.thundering);
    }

    public static enum WeatherType {
        CLEAR(false, false),
        RAIN(true, false),
        THUNDER(true, true);

        private boolean raining;
        private boolean thundering;

        private WeatherType(boolean raining, boolean thundering) {
            this.raining = raining;
            this.thundering = thundering;
        }
    }
}

