/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.compat.crafttweaker;

import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.entity.EntityList;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualArena;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCommand;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualCreateItem;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDragonBreath;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualDungeon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualSummon;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualTime;
import party.lemons.arcaneworld.crafting.ritual.impl.RitualWeather;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ArcaneWorld")
public class ArcaneWorldCrt {
    @ZenMethod
    public static void removeAll() {
        ((IForgeRegistryModifiable)RitualRegistry.REGISTRY).clear();
    }

    @ZenMethod
    public static void remove(String registryName) {
        ((IForgeRegistryModifiable)RitualRegistry.REGISTRY).remove(new ResourceLocation(registryName));
    }

    @ZenMethod
    public static void createRitualSummon(String name, String displayName, String entity, IIngredient ... inputs) {
        Class e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        ArcaneWorldCrt.createRitual(name, displayName, new RitualSummon(e, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualDragonBreath(String name, String displayName, IIngredient ... inputs) {
        ArcaneWorldCrt.createRitual(name, displayName, new RitualDragonBreath(ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createArenaRitual(String name, String displayName, String entity, IIngredient ... inputs) {
        Class e = EntityList.getClass((ResourceLocation)new ResourceLocation(entity));
        ArcaneWorldCrt.createRitual(name, displayName, new RitualArena(e, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualWeather(String name, String displayName, String weather, IIngredient ... inputs) {
        RitualWeather.WeatherType type = RitualWeather.WeatherType.CLEAR;
        switch (weather.toLowerCase()) {
            case "clear": {
                type = RitualWeather.WeatherType.CLEAR;
                break;
            }
            case "rain": {
                type = RitualWeather.WeatherType.RAIN;
                break;
            }
            case "thunder": {
                type = RitualWeather.WeatherType.THUNDER;
            }
        }
        ArcaneWorldCrt.createRitual(name, displayName, new RitualWeather(type, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualTime(String name, String displayName, int timeChange, IIngredient ... inputs) {
        ArcaneWorldCrt.createRitual(name, displayName, new RitualTime(timeChange, ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualCreateItem(String name, String displayName, IItemStack result, IIngredient ... inputs) {
        ArcaneWorldCrt.createRitual(name, displayName, new RitualCreateItem(CraftTweakerMC.getItemStack((IItemStack)result), ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualDungeon(String name, String displayName, IIngredient ... inputs) {
        ArcaneWorldCrt.createRitual(name, displayName, new RitualDungeon(ArcaneWorldCrt.getIngredients(inputs)));
    }

    @ZenMethod
    public static void createRitualCommand(String name, String displayName, String[] command, IIngredient ... inputs) {
        ArcaneWorldCrt.createRitual(name, displayName, new RitualCommand(command, ArcaneWorldCrt.getIngredients(inputs)));
    }

    public static Ingredient[] getIngredients(IIngredient ... inputs) {
        Ingredient[] ingreds = new Ingredient[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            ingreds[i] = CraftTweakerMC.getIngredient((IIngredient)inputs[i]);
        }
        return ingreds;
    }

    public static void createRitual(String name, String displayName, Ritual ritual) {
        ResourceLocation location = new ResourceLocation("crafttweaker", name);
        ritual.setRegistryName(location);
        ritual.setTranslationKey(displayName);
        RitualRegistry.REGISTRY.register((IForgeRegistryEntry)ritual);
    }
}

