/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.arcaneworld.block.tilentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import party.lemons.arcaneworld.ArcaneWorld;
import party.lemons.arcaneworld.block.tilentity.render.ItemActivation;
import party.lemons.arcaneworld.crafting.ritual.Ritual;
import party.lemons.arcaneworld.crafting.ritual.RitualRegistry;
import party.lemons.arcaneworld.handler.ArcaneWorldSounds;
import party.lemons.arcaneworld.network.MessageRitualCreateUpParticle;
import party.lemons.arcaneworld.network.MessageServerActivateRitual;

public class TileEntityRitualTable
extends TileEntity
implements ITickable {
    public int tickCount;
    public float pageFlip;
    public float pageFlipPrev;
    public float flipT;
    public float flipA;
    public float bookSpread;
    public float bookSpreadPrev;
    public float bookRotation;
    public float bookRotationPrev;
    public float tRot;
    private static final Random rand = new Random();
    private final ItemStackHandler inventory = new ItemStackHandler(5);
    private List<ItemActivation> itemActivations = new ArrayList<ItemActivation>();
    private Ritual currentRitual = RitualRegistry.EMPTY;
    private RitualState state;
    private float stateTime = 0.0f;
    private EntityPlayer player = null;
    private ItemStack[] itemsUsed = new ItemStack[5];

    public TileEntityRitualTable() {
        this.state = RitualState.NONE;
    }

    public void attemptActivateRitual(EntityPlayer player) {
        if (!this.canCast()) {
            return;
        }
        for (Ritual ritual : RitualRegistry.REGISTRY.getValuesCollection()) {
            int i;
            if (ritual.isEmpty()) continue;
            NonNullList stacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
            for (int i2 = 0; i2 < stacks.size(); ++i2) {
                stacks.set(i2, (Object)this.getInventory().getStackInSlot(i2));
            }
            if (!ritual.matches((NonNullList<ItemStack>)stacks)) continue;
            this.setRitual(ritual);
            this.setActivator(player);
            this.setState(RitualState.START_UP);
            ItemStack[] usedStacks = new ItemStack[5];
            for (i = 0; i < 5; ++i) {
                usedStacks[i] = this.getInventory().getStackInSlot(i).func_77946_l();
            }
            this.setStacks(usedStacks);
            for (i = 0; i < this.getInventory().getSlots(); ++i) {
                Ingredient ingredient = ritual.getRequiredItems().get(i);
                if (ingredient == Ingredient.field_193370_a) continue;
                int size = ingredient.func_193365_a()[0].func_190916_E();
                this.getInventory().getStackInSlot(i).func_190918_g(size);
            }
            ArcaneWorld.NETWORK.sendToAllTracking((IMessage)new MessageServerActivateRitual(ritual.getRegistryName(), this.func_174877_v(), player, usedStacks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
            break;
        }
    }

    public void func_73660_a() {
        float f2;
        this.bookSpreadPrev = this.bookSpread;
        this.bookRotationPrev = this.bookRotation;
        this.stateTime += 1.0f;
        switch (this.state) {
            case NONE: {
                this.moveBookNone();
                break;
            }
            case START_UP: {
                if (this.stateTime == 1.0f) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, ArcaneWorldSounds.RITUAL_CHARGE, SoundCategory.BLOCKS, 3.0f, 0.5f + rand.nextFloat() / 2.0f);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, ArcaneWorldSounds.RITUAL_START, SoundCategory.BLOCKS, 3.0f, 0.5f + rand.nextFloat() / 2.0f);
                }
                this.moveBookRotation(1.0f, 0.01f);
                this.particlesStartUp();
                if (this.stateTime == 10.0f) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, ArcaneWorldSounds.RITUAL_OUT, SoundCategory.BLOCKS, 3.0f, 0.5f + rand.nextFloat() / 2.0f);
                }
                if (!(this.stateTime > 25.0f)) break;
                this.setState(RitualState.ITEMS);
                break;
            }
            case ITEMS: {
                this.moveBookRotation(0.2f, 0.1f);
                this.particlesItems();
                if (this.stateTime == 5.0f) {
                    this.addItemOut(this.itemsUsed[0]);
                }
                if (this.stateTime == 15.0f) {
                    this.addItemOut(this.itemsUsed[1]);
                }
                if (this.stateTime == 25.0f) {
                    this.addItemOut(this.itemsUsed[2]);
                }
                if (this.stateTime == 35.0f) {
                    this.addItemOut(this.itemsUsed[3]);
                }
                if (this.stateTime == 45.0f) {
                    this.addItemOut(this.itemsUsed[4]);
                }
                if (!(this.stateTime > 60.0f)) break;
                this.setState(RitualState.FINISH);
                this.particlesActivate();
                if (this.field_145850_b.field_72995_K) break;
                this.currentRitual.onActivate(this.field_145850_b, this.field_174879_c, this.player, this.itemsUsed);
                break;
            }
            case FINISH: {
                this.moveBookRotation(1.0f, -0.1f);
                if (!(this.stateTime > 25.0f)) break;
                this.setState(RitualState.NONE);
                break;
            }
            default: {
                System.out.println((Object)this.state);
            }
        }
        while (this.bookRotation >= (float)Math.PI) {
            this.bookRotation -= (float)Math.PI * 2;
        }
        while (this.bookRotation < (float)(-Math.PI)) {
            this.bookRotation += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.bookRotation; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.bookRotation += f2 * 0.4f;
        this.bookSpread = MathHelper.func_76131_a((float)this.bookSpread, (float)0.0f, (float)1.0f);
        ++this.tickCount;
        this.pageFlipPrev = this.pageFlip;
        float f = (this.flipT - this.pageFlip) * 0.4f;
        float f3 = 0.2f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.pageFlip += this.flipA;
    }

    private void particlesActivate() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)this.field_145850_b;
        worldServer.func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 50, 0.0, -0.5, 0.0, 1.0, new int[0]);
    }

    private void addItemOut(ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        this.itemActivations.add(new ItemActivation(stack));
        this.field_145850_b.func_184133_a(null, this.field_174879_c, ArcaneWorldSounds.RITUAL_ITEM, SoundCategory.BLOCKS, 1.0f, 0.5f + rand.nextFloat() / 2.0f);
    }

    private void particlesStartUp() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)this.field_145850_b;
        worldServer.func_175739_a(EnumParticleTypes.ENCHANTMENT_TABLE, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 15, 0.0, -0.5, 0.0, 1.0, new int[0]);
    }

    private void particlesItems() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        WorldServer worldServer = (WorldServer)this.field_145850_b;
        worldServer.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.7f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 1, 0.0, -0.5, 0.0, (double)0.1f, new int[0]);
        ArcaneWorld.NETWORK.sendToAllTracking((IMessage)new MessageRitualCreateUpParticle(this.field_174879_c), new NetworkRegistry.TargetPoint(worldServer.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 32.0));
    }

    private void moveBookRotation(float rotation, float spread) {
        this.tRot += rotation;
        this.bookSpread += spread;
    }

    private void moveBookNone() {
        EntityPlayer entityplayer = this.field_145850_b.func_184137_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 3.0, false);
        if (entityplayer != null) {
            double d0 = entityplayer.field_70165_t - (double)((float)this.field_174879_c.func_177958_n() + 0.5f);
            double d1 = entityplayer.field_70161_v - (double)((float)this.field_174879_c.func_177952_p() + 0.5f);
            this.tRot = (float)MathHelper.func_181159_b((double)d1, (double)d0);
            this.bookSpread += 0.1f;
            if (this.bookSpread < 0.5f || rand.nextInt(40) == 0) {
                float f1 = this.flipT;
                do {
                    this.flipT += (float)(rand.nextInt(4) - rand.nextInt(4));
                } while (f1 == this.flipT);
            }
        } else {
            this.tRot += 0.02f;
            this.bookSpread -= 0.1f;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB bb = null;
        bb = this.getState() != RitualState.NONE ? INFINITE_EXTENT_AABB : new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        return bb;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
        super.func_145839_a(compound);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public RitualState getState() {
        return this.state;
    }

    public void setState(RitualState state) {
        this.state = state;
        this.stateTime = 0.0f;
    }

    public List<ItemActivation> getItemActivations() {
        return this.itemActivations;
    }

    public void setRitual(Ritual ritual) {
        this.currentRitual = ritual;
    }

    public void setActivator(EntityPlayer player) {
        this.player = player;
    }

    public void setStacks(ItemStack[] stacks) {
        this.itemsUsed = stacks;
    }

    public boolean canCast() {
        if (this.getState() == RitualState.NONE) {
            for (Ritual ritual : RitualRegistry.REGISTRY.getValuesCollection()) {
                if (ritual.isEmpty()) continue;
                NonNullList stacks = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < stacks.size(); ++i) {
                    stacks.set(i, (Object)this.getInventory().getStackInSlot(i));
                }
                if (!ritual.matches((NonNullList<ItemStack>)stacks)) continue;
                return true;
            }
        }
        return false;
    }

    public static enum RitualState {
        NONE,
        START_UP,
        ITEMS,
        FINISH;

    }
}

