/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.worldGen;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.worldGen.CircusWorldGen;
import com.unoriginal.ancientbeasts.worldGen.JungleVillageWorldGen;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.IWorldGenerator;

public class ModWorldGen
implements IWorldGenerator {
    public static final JungleVillageWorldGen jungle_t = new JungleVillageWorldGen();

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        int blockX = chunkX * 16;
        int blockZ = chunkZ * 16;
        if (chunkProvider.func_191062_e(chunkX, chunkZ)) {
            switch (world.field_73011_w.getDimension()) {
                case -1: {
                    this.generateNether(world, rand, blockX + 8, blockZ + 8);
                    break;
                }
                case 0: {
                    this.generateOverworld(world, rand, blockX + 8, blockZ + 8);
                    break;
                }
                case 1: {
                    this.generateEnd(world, rand, blockX + 8, blockZ + 8);
                }
            }
        }
    }

    private void generateOverworld(World world, Random rand, int blockX, int blockZ) {
        int y = ModWorldGen.getGroundFromAbove(world, blockX, blockZ);
        BlockPos pos = new BlockPos(blockX, y, blockZ);
        if (ModWorldGen.canStructureSpawn(blockX / 16, blockZ / 16, world, AncientBeastsConfig.CircusSpawnChance)) {
            CircusWorldGen structure = new CircusWorldGen();
            structure.func_180709_b(world, rand, pos);
        }
    }

    private void generateNether(World world, Random rand, int chunkX, int chunkZ) {
    }

    private void generateEnd(World world, Random rand, int chunkX, int chunkZ) {
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 31) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150433_aE || blockAt == Blocks.field_150431_aC || blockAt == Blocks.field_150391_bh;
        }
        return y;
    }

    public static boolean canSpawnHere(Template template, World world, BlockPos posAboveGround) {
        int zwidth = template.func_186259_a().func_177952_p();
        int xwidth = template.func_186259_a().func_177958_n();
        boolean corner1 = ModWorldGen.isCornerValid(world, posAboveGround);
        boolean corner2 = ModWorldGen.isCornerValid(world, posAboveGround.func_177982_a(xwidth, 0, zwidth));
        return posAboveGround.func_177956_o() > 31 && corner1 && corner2;
    }

    public static boolean canStructureSpawn(int chunkX, int chunkZ, World world, int frequency) {
        if (frequency <= 0) {
            return false;
        }
        int maxDistanceBetween = frequency + 8;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            chunkX -= maxDistanceBetween - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= maxDistanceBetween - 1;
        }
        int k = chunkX / maxDistanceBetween;
        int l = chunkZ / maxDistanceBetween;
        Random random = world.func_72843_D(k, l, 14357617);
        k *= maxDistanceBetween;
        l *= maxDistanceBetween;
        return i == (k += random.nextInt(maxDistanceBetween - 8)) && j == (l += random.nextInt(maxDistanceBetween - 8));
    }

    public static boolean isCornerValid(World world, BlockPos pos) {
        int variation = 3;
        int highestBlock = ModWorldGen.getGroundFromAbove(world, pos.func_177958_n(), pos.func_177952_p());
        return highestBlock > pos.func_177956_o() - variation && highestBlock < pos.func_177956_o() + variation;
    }
}

