/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.worldGen;

import com.unoriginal.ancientbeasts.entity.Entities.EntityHunter;
import com.unoriginal.ancientbeasts.entity.Entities.EntityPriest;
import com.unoriginal.ancientbeasts.entity.Entities.EntityTank;
import com.unoriginal.ancientbeasts.entity.Entities.EntityTribeWarrior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureComponentTemplate;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class JungleVillagePieces {
    private static final ResourceLocation LOOT_HOUSE = new ResourceLocation("ancientbeasts", "structures/j_house");
    private static final ResourceLocation LOOT_WIZARD = new ResourceLocation("ancientbeasts", "structures/j_wizard");
    private static final ResourceLocation LOOT_FARM = new ResourceLocation("ancientbeasts", "structures/j_farm");
    private TemplateManager manager;

    public static void generateVillage(TemplateManager manager, BlockPos pos, Rotation rot, List<JungleVillageTemplate> list, Random rand, World world, List<StructureComponent> components) {
        Placer placer = new Placer(manager, rand);
        placer.createTribeVillage(world, pos, rot, list, components);
    }

    public static int getGroundFromAbove(World world, int x, int z) {
        int y = 255;
        boolean foundGround = false;
        while (!foundGround && y-- >= 31) {
            Block blockAt = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = blockAt == Blocks.field_150349_c || blockAt == Blocks.field_150354_m || blockAt == Blocks.field_150433_aE || blockAt == Blocks.field_150431_aC || blockAt == Blocks.field_150391_bh;
        }
        return y;
    }

    static class Placer {
        private final TemplateManager templateManager;
        private final Random random;

        public Placer(TemplateManager p_i47361_1_, Random p_i47361_2_) {
            this.templateManager = p_i47361_1_;
            this.random = p_i47361_2_;
        }

        public void createTribeVillage(World world, BlockPos pos, Rotation rotation, List<JungleVillageTemplate> list, List<StructureComponent> components) {
            HouseCollection collection = new HouseCollection();
            String s = collection.RandHouse(this.random);
            JungleVillageTemplate t = new JungleVillageTemplate(this.templateManager, s, pos, rotation, world);
            list.add(t);
            this.placeBridge(s, this.random, list, world, pos, rotation, t, components, 0);
        }

        public boolean placeBridge(String connectedHouse, Random rand, List<JungleVillageTemplate> list, World world, BlockPos pos, Rotation rotation, JungleVillageTemplate template, List<StructureComponent> components, int houseNumber) {
            if (houseNumber < 1) {
                BridgeCollection collection = new BridgeCollection();
                Template house = this.templateManager.func_186237_a(world.func_73046_m(), new ResourceLocation("ancientbeasts:" + connectedHouse));
                Map map = house.func_186258_a(pos, template.getPlacementSettings());
                if (!world.field_72995_K) {
                    for (Map.Entry entry : map.entrySet()) {
                        String bridgefinder = (String)entry.getValue();
                        EveryHouseBridgeRotations rotations = new EveryHouseBridgeRotations();
                        String bridge_slab = collection.RandBridgeSlab(rand, false);
                        String bridge_slab_top = collection.RandBridgeSlab(rand, true);
                        String log = collection.RandBridgeLog(rand);
                        String log_h = collection.RandHalfBridgeLog(rand);
                        BlockPos position = (BlockPos)entry.getKey();
                        Rotation NEWERROT = rotations.ApplyExistantRotation(rotation, bridgefinder);
                        boolean isLog = bridgefinder.contains("log") || bridgefinder.contains("c_fl");
                        BlockPos booleanPos = ((BlockPos)entry.getKey()).func_177982_a(rotations.getIntXForRot(NEWERROT), isLog ? 1 : 0, rotations.getIntZForRot(NEWERROT));
                        if (world.func_180495_p(booleanPos).func_177230_c() != Blocks.field_185779_df) {
                            JungleVillageTemplate boolhouse;
                            if (bridgefinder.contains("c_slab")) {
                                if (!bridgefinder.contains("c_slab_r")) {
                                    boolhouse = new JungleVillageTemplate(this.templateManager, collection.RandBridgeSlab(rand, true), template.getTemplatePosition(), rotation, Mirror.NONE, world);
                                    if (!boolhouse.isCollidingExcParent(this.templateManager, template, components)) {
                                        list.add(new JungleVillageTemplate(this.templateManager, bridge_slab_top, position.func_177979_c(1), NEWERROT, world));
                                        this.placeHouse(bridge_slab_top, rand, list, world, pos, NEWERROT, template, components, ++houseNumber);
                                        return true;
                                    }
                                } else {
                                    boolhouse = new JungleVillageTemplate(this.templateManager, collection.RandBridgeSlab(rand, true), template.getTemplatePosition(), rotation, Mirror.NONE, world);
                                    if (!boolhouse.isCollidingExcParent(this.templateManager, template, components)) {
                                        list.add(new JungleVillageTemplate(this.templateManager, bridge_slab_top, position.func_177979_c(1), NEWERROT, world));
                                        this.placeHouse(bridge_slab_top, rand, list, world, pos, NEWERROT, template, components, ++houseNumber);
                                        return true;
                                    }
                                }
                            }
                            if (!bridgefinder.contains("log") && !bridgefinder.contains("c_fl") || (boolhouse = new JungleVillageTemplate(this.templateManager, collection.RandBridgeLog(rand), template.getTemplatePosition(), rotation, Mirror.NONE, world)).isCollidingExcParent(this.templateManager, template, components)) continue;
                            list.add(new JungleVillageTemplate(this.templateManager, log, position, NEWERROT, world));
                            this.placeHouse(log, rand, list, world, pos, NEWERROT, template, components, ++houseNumber);
                            return true;
                        }
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean placeHouse(String connectedBridge, Random rand, List<JungleVillageTemplate> list, World world, BlockPos pos, Rotation rotation, JungleVillageTemplate template, List<StructureComponent> components, int houseNumber) {
            HouseCollection collection = new HouseCollection();
            Template bridge = this.templateManager.func_186237_a(world.func_73046_m(), new ResourceLocation("ancientbeasts:" + connectedBridge));
            EveryHouseBridgeRotations rotations = new EveryHouseBridgeRotations();
            Map map = bridge.func_186258_a(pos, template.getPlacementSettings());
            if (!world.field_72995_K) {
                for (Map.Entry entry : map.entrySet()) {
                    String placefinder = (String)entry.getValue();
                    JungleVillageTemplate boolbridge = new JungleVillageTemplate(this.templateManager, collection.RandHouse(rand), template.getTemplatePosition(), rotation, Mirror.NONE, world);
                    if (!boolbridge.isCollidingExcParent(this.templateManager, template, components) && placefinder.contains("end")) {
                        BlockPos newPos = new BlockPos(((BlockPos)entry.getKey()).func_177958_n(), pos.func_177956_o(), ((BlockPos)entry.getKey()).func_177952_p());
                        BlockPos PosForCheck = ((BlockPos)entry.getKey()).func_177982_a(0, 0, 1).func_190942_a(rotation);
                        if (world.func_180495_p(PosForCheck).func_177230_c() == Blocks.field_185779_df) {
                            world.func_180501_a(PosForCheck, Blocks.field_150350_a.func_176223_P(), 3);
                        }
                        if (connectedBridge.contains("log")) {
                            String house = collection.RandHouseLog(rand);
                            Rotation houseRot = rotations.getAvaliableHouseLogRot(collection.houseStringtoInt(house));
                            Rotation addRot = rotations.getRealRotToADD(rotation, houseRot);
                            Rotation REALROT = houseRot.func_185830_a(addRot);
                            JungleVillageTemplate t = new JungleVillageTemplate(this.templateManager, house, newPos, REALROT, world);
                            list.add(t);
                            this.placeBridge(house, rand, list, world, newPos, REALROT, t, components, houseNumber);
                            return true;
                        }
                        if (!connectedBridge.contains("slab")) continue;
                        String house = collection.RandHouseSlab(rand);
                        Rotation houseRot = rotations.getAvaliableHouseSlabRot(collection.houseStringtoInt(house));
                        Rotation addRot = rotations.getRealRotToADD(rotation, houseRot);
                        Rotation REALROT = houseRot.func_185830_a(addRot);
                        JungleVillageTemplate t = new JungleVillageTemplate(this.templateManager, house, newPos, REALROT, world);
                        list.add(t);
                        this.placeBridge(house, rand, list, world, newPos, REALROT, t, components, houseNumber);
                        return true;
                    }
                    return false;
                }
            }
            return true;
        }
    }

    static class EveryHouseBridgeRotations {
        protected EveryHouseBridgeRotations() {
        }

        public Rotation ApplyExistantRotation(Rotation rotation, String houseN) {
            return this.getDefaultRotationForHouse(houseN).func_185830_a(rotation);
        }

        public Rotation getDefaultRotationForHouse(String houseN) {
            if (houseN.contains("_c0")) {
                return Rotation.NONE;
            }
            if (houseN.contains("_c180")) {
                return Rotation.CLOCKWISE_180;
            }
            if (houseN.contains("_cc90")) {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            if (houseN.contains("_c90")) {
                return Rotation.CLOCKWISE_90;
            }
            return Rotation.NONE;
        }

        public Rotation OppositeRot(Rotation rot) {
            Rotation result = null;
            switch (rot) {
                case NONE: {
                    result = Rotation.CLOCKWISE_180;
                    break;
                }
                case CLOCKWISE_180: {
                    result = Rotation.NONE;
                    break;
                }
                case COUNTERCLOCKWISE_90: {
                    result = Rotation.CLOCKWISE_90;
                    break;
                }
                case CLOCKWISE_90: {
                    result = Rotation.COUNTERCLOCKWISE_90;
                }
            }
            return result;
        }

        public Rotation getAvaliableHouseSlabRot(int houseN) {
            Random rand = new Random();
            Rotation result = null;
            switch (houseN) {
                case 1: {
                    result = rand.nextInt(2) == 0 ? Rotation.CLOCKWISE_180 : Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                case 2: {
                    int i = rand.nextInt(3);
                    switch (i) {
                        case 0: {
                            result = Rotation.CLOCKWISE_90;
                            break;
                        }
                        case 1: {
                            result = Rotation.CLOCKWISE_180;
                            break;
                        }
                        case 2: {
                            result = Rotation.NONE;
                        }
                    }
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 12: {
                    result = Rotation.NONE;
                    break;
                }
                case 10: {
                    result = Rotation.COUNTERCLOCKWISE_90;
                }
            }
            return result;
        }

        public Rotation getAvaliableHouseLogRot(int houseN) {
            Random rand = new Random();
            Rotation result = null;
            switch (houseN) {
                case 1: {
                    result = Rotation.COUNTERCLOCKWISE_90;
                    break;
                }
                case 5: {
                    result = rand.nextInt(2) == 0 ? Rotation.CLOCKWISE_180 : Rotation.CLOCKWISE_90;
                    break;
                }
                case 6: 
                case 9: {
                    result = Rotation.CLOCKWISE_90;
                    break;
                }
                case 7: 
                case 8: {
                    result = Rotation.NONE;
                    break;
                }
                case 10: 
                case 12: {
                    result = Rotation.CLOCKWISE_180;
                    break;
                }
                case 11: {
                    result = rand.nextInt(2) == 0 ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
                }
            }
            return result;
        }

        public Rotation getRealRotToADD(Rotation rotA, Rotation rotB) {
            switch (rotA) {
                case CLOCKWISE_180: {
                    switch (rotB) {
                        case NONE: {
                            return Rotation.NONE;
                        }
                        case CLOCKWISE_90: {
                            return Rotation.COUNTERCLOCKWISE_90;
                        }
                        case CLOCKWISE_180: {
                            return Rotation.CLOCKWISE_180;
                        }
                        case COUNTERCLOCKWISE_90: {
                            return Rotation.CLOCKWISE_90;
                        }
                    }
                }
                case COUNTERCLOCKWISE_90: {
                    switch (rotB) {
                        case NONE: {
                            return Rotation.CLOCKWISE_90;
                        }
                        case CLOCKWISE_90: {
                            return Rotation.NONE;
                        }
                        case CLOCKWISE_180: {
                            return Rotation.COUNTERCLOCKWISE_90;
                        }
                        case COUNTERCLOCKWISE_90: {
                            return Rotation.CLOCKWISE_180;
                        }
                    }
                }
                case CLOCKWISE_90: {
                    switch (rotB) {
                        case NONE: {
                            return Rotation.COUNTERCLOCKWISE_90;
                        }
                        case CLOCKWISE_90: {
                            return Rotation.CLOCKWISE_180;
                        }
                        case CLOCKWISE_180: {
                            return Rotation.CLOCKWISE_90;
                        }
                        case COUNTERCLOCKWISE_90: {
                            return Rotation.NONE;
                        }
                    }
                }
                case NONE: {
                    switch (rotB) {
                        case NONE: {
                            return Rotation.CLOCKWISE_180;
                        }
                        case CLOCKWISE_90: {
                            return Rotation.CLOCKWISE_90;
                        }
                        case CLOCKWISE_180: {
                            return Rotation.NONE;
                        }
                        case COUNTERCLOCKWISE_90: {
                            return Rotation.COUNTERCLOCKWISE_90;
                        }
                    }
                }
            }
            return rotB;
        }

        public int getIntXForRot(Rotation rotation) {
            if (rotation == Rotation.CLOCKWISE_90) {
                return -1;
            }
            if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                return 1;
            }
            return 0;
        }

        public int getIntZForRot(Rotation rotation) {
            if (rotation == Rotation.NONE) {
                return 1;
            }
            if (rotation == Rotation.CLOCKWISE_180) {
                return -1;
            }
            return 0;
        }
    }

    public static class JungleVillageTemplate
    extends StructureComponentTemplate {
        private String templateName;
        private Rotation rotation;
        private Mirror mirror;
        private World world;
        private int id;

        public JungleVillageTemplate() {
        }

        public JungleVillageTemplate(TemplateManager p_i47355_1_, String p_i47355_2_, BlockPos p_i47355_3_, Rotation p_i47355_4_, World world) {
            this(p_i47355_1_, p_i47355_2_, p_i47355_3_, p_i47355_4_, Mirror.NONE, world);
        }

        public JungleVillageTemplate(TemplateManager p_i47356_1_, String p_i47356_2_, BlockPos p_i47356_3_, Rotation p_i47356_4_, Mirror p_i47356_5_, World world) {
            super(0);
            this.templateName = p_i47356_2_;
            this.field_186178_c = p_i47356_3_;
            this.rotation = p_i47356_4_;
            this.mirror = p_i47356_5_;
            this.world = world;
            this.id = this.id++;
            this.loadTemplate(p_i47356_1_, world);
        }

        public BlockPos getTemplatePosition() {
            return this.field_186178_c;
        }

        public PlacementSettings getPlacementSettings() {
            return this.field_186177_b;
        }

        public StructureBoundingBox func_74874_b() {
            return this.field_74887_e;
        }

        private void loadTemplate(TemplateManager manager, World worldIn) {
            MinecraftServer minecraftserver = worldIn.func_73046_m();
            Template template = manager.func_186237_a(minecraftserver, new ResourceLocation("ancientbeasts:" + this.templateName));
            PlacementSettings placementsettings = new PlacementSettings().func_186222_a(true).func_186220_a(this.rotation).func_186214_a(this.mirror);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74778_a("Template", this.templateName);
            tagCompound.func_74778_a("Rot", this.field_186177_b.func_186215_c().name());
            tagCompound.func_74778_a("Mi", this.field_186177_b.func_186212_b().name());
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager p_143011_2_) {
            super.func_143011_b(tagCompound, p_143011_2_);
            this.templateName = tagCompound.func_74779_i("Template");
            this.rotation = Rotation.valueOf((String)tagCompound.func_74779_i("Rot"));
            this.mirror = Mirror.valueOf((String)tagCompound.func_74779_i("Mi"));
            this.loadTemplate(p_143011_2_, this.world);
        }

        public int getId() {
            return this.id;
        }

        protected void func_186175_a(String function, BlockPos pos, World world, Random rand, StructureBoundingBox sbb) {
            switch (function) {
                case "chest": {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    TileEntity tileentity = world.func_175625_s(pos.func_177977_b());
                    if (!(tileentity instanceof TileEntityChest)) break;
                    ((TileEntityChest)tileentity).func_189404_a(LOOT_HOUSE, rand.nextLong());
                    break;
                }
                case "chest_w": {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    TileEntity tileentity = world.func_175625_s(pos.func_177977_b());
                    if (!(tileentity instanceof TileEntityChest)) break;
                    ((TileEntityChest)tileentity).func_189404_a(LOOT_WIZARD, rand.nextLong());
                    break;
                }
                case "chest_f": {
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
                    TileEntity tileentity = world.func_175625_s(pos.func_177977_b());
                    if (!(tileentity instanceof TileEntityChest)) break;
                    ((TileEntityChest)tileentity).func_189404_a(LOOT_FARM, rand.nextLong());
                    break;
                }
                case "tribesmen": {
                    if (rand.nextInt(10) < 1) {
                        EntityTank tank = new EntityTank(world);
                        tank.func_110163_bv();
                        tank.func_174828_a(pos, 0.0f, 0.0f);
                        tank.func_180482_a(world.func_175649_E(pos), null);
                        world.func_72838_d((Entity)tank);
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                        break;
                    }
                    if (rand.nextInt(10) < 4) {
                        EntityHunter hunter = new EntityHunter(world);
                        hunter.func_110163_bv();
                        hunter.func_174828_a(pos, 0.0f, 0.0f);
                        hunter.func_180482_a(world.func_175649_E(pos), null);
                        world.func_72838_d((Entity)hunter);
                        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                        break;
                    }
                    EntityTribeWarrior warrior = new EntityTribeWarrior(world);
                    warrior.func_110163_bv();
                    warrior.func_174828_a(pos, 0.0f, 0.0f);
                    warrior.func_180482_a(world.func_175649_E(pos), null);
                    world.func_72838_d((Entity)warrior);
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                    break;
                }
                case "magicman": {
                    EntityPriest magicman = new EntityPriest(world);
                    magicman.func_110163_bv();
                    magicman.func_174828_a(pos, 0.0f, 0.0f);
                    magicman.func_180482_a(world.func_175649_E(pos), null);
                    world.func_72838_d((Entity)magicman);
                    world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                }
            }
        }

        public List<StructureComponent> findAllIntersecting(List<StructureComponent> listIn) {
            ArrayList<StructureComponent> list = new ArrayList<StructureComponent>();
            for (StructureComponent structurecomponent : listIn) {
                StructureBoundingBox intersection = new StructureBoundingBox(this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e - 1, this.field_74887_e.field_78892_f - 1);
                if (structurecomponent.func_74874_b() == null || !structurecomponent.func_74874_b().func_78884_a(intersection)) continue;
                list.add(structurecomponent);
            }
            return list;
        }

        public boolean isCollidingExcParent(TemplateManager manager, JungleVillageTemplate parent, List<StructureComponent> structures) {
            List<StructureComponent> collisions = this.findAllIntersecting(structures);
            boolean foundCollision = false;
            for (StructureComponent collision : collisions) {
                if (((JungleVillageTemplate)collision).getId() == parent.getId()) continue;
                foundCollision = true;
                break;
            }
            return foundCollision;
        }
    }

    public static class BridgeCollection {
        public String RandBridgeSlab(Random rand, boolean isTop) {
            int i = rand.nextInt(2);
            if (isTop) {
                if (i != 0) {
                    return "bridge_slab_top_s";
                }
                return "bridge_slab_top";
            }
            if (i != 0) {
                return "bridge_slab_s";
            }
            return "bridge_slab";
        }

        public String RandBridgeLog(Random rand) {
            int i = rand.nextInt(2);
            if (i == 0) {
                return "bridge_log_s";
            }
            return "bridge_log";
        }

        public String RandHalfBridgeLog(Random rand) {
            int i = rand.nextInt(2);
            if (i == 0) {
                return "bridge_h_log_s";
            }
            return "bridge_h_log";
        }
    }

    public static class HouseCollection {
        public String RandHouse(Random rand) {
            int i = rand.nextInt(13);
            if (i != 0) {
                return "house_" + i;
            }
            return "house_1";
        }

        public int houseStringtoInt(String s) {
            int i = Integer.parseInt(s.replaceAll("[\\D]", ""));
            return i;
        }

        public String RandHouseLog(Random random) {
            String s = null;
            int i = random.nextInt(8);
            switch (i) {
                case 0: {
                    s = "house_5";
                    break;
                }
                case 1: {
                    s = "house_6";
                    break;
                }
                case 2: {
                    s = "house_7";
                    break;
                }
                case 3: {
                    s = "house_8";
                    break;
                }
                case 4: {
                    s = "house_9";
                    break;
                }
                case 5: {
                    s = "house_11";
                    break;
                }
                case 6: {
                    s = "house_12";
                    break;
                }
                case 7: {
                    s = "house_10";
                }
            }
            return s;
        }

        public String RandHouseSlab(Random random) {
            String s = null;
            int i = random.nextInt(7);
            switch (i) {
                case 0: {
                    s = "house_1";
                    break;
                }
                case 1: {
                    s = "house_2";
                    break;
                }
                case 2: {
                    s = "house_3";
                    break;
                }
                case 3: {
                    s = "house_4";
                    break;
                }
                case 4: {
                    s = "house_9";
                    break;
                }
                case 5: {
                    s = "house_10";
                    break;
                }
                case 6: {
                    s = "house_12";
                }
            }
            return s;
        }

        public int houseOffset(String s) {
            int house = this.houseStringtoInt(s);
            return 1;
        }
    }
}

