/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.init.ModSounds;
import com.unoriginal.ancientbeasts.init.ModTriggers;
import com.unoriginal.ancientbeasts.network.AncientBeastsPacketHandler;
import com.unoriginal.ancientbeasts.network.MessageDismountRidingEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class EntityOwlstack
extends EntityAnimal {
    private static final DataParameter<Integer> HAPPY = EntityDataManager.func_187226_a(EntityOwlstack.class, (DataSerializer)DataSerializers.field_187192_b);
    private int happyTime;
    private int maxHappyTime;
    private UUID friendUUID;
    private EntityLivingBase friend;
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Owlstack");

    public EntityOwlstack(World worldIn) {
        super(worldIn);
        this.maxHappyTime = 20000 + this.field_70146_Z.nextInt(4000);
        this.func_70105_a(0.8f, 1.0f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151055_y, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityRabbit.class, false));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAPPY, (Object)0);
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalArmor);
    }

    public void func_70071_h_() {
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity != null && this.getHappyTime() >= 0 && entity instanceof EntityLivingBase && !this.field_70170_p.field_72995_K) {
            EntityLivingBase rider = (EntityLivingBase)this.func_184187_bx();
            if (rider != null && !(rider instanceof EntityOwlstack)) {
                if (this.getHappyTime() > this.getMaxHappyTime()) {
                    this.func_184210_p();
                    this.resetRiding();
                } else if (rider.func_184613_cA()) {
                    this.func_184210_p();
                    this.resetRiding();
                } else if (this.func_70090_H()) {
                    this.func_184210_p();
                    this.resetRiding();
                } else if (rider.func_70093_af()) {
                    this.func_184210_p();
                    this.resetRiding();
                }
            } else if ((rider == null || this.getFriend() == null) && this.func_184218_aH() && !(rider instanceof EntityOwlstack)) {
                this.func_184210_p();
                this.resetRiding();
            }
        }
        super.func_70071_h_();
    }

    public boolean canRiderInteract() {
        return true;
    }

    public void func_70636_d() {
        EntityLivingBase entity;
        EntityOwlstack owlstack;
        List list;
        super.func_70636_d();
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        if (!(this.func_184207_aI() || this.func_184218_aH() || this.field_70173_aa % 2000 != 0 || (list = this.field_70170_p.func_72872_a(EntityOwlstack.class, this.func_174813_aQ().func_186662_g(10.0))).isEmpty() || this == (owlstack = (EntityOwlstack)((Object)list.get(this.field_70170_p.field_73012_v.nextInt(list.size())))))) {
            this.func_70661_as().func_75497_a((Entity)owlstack, 1.0);
            if (this.func_70068_e((Entity)owlstack) < 4.0) {
                if (!owlstack.func_184207_aI()) {
                    this.func_184220_m((Entity)owlstack);
                } else {
                    Entity top = EntityOwlstack.getTopPassenger((Entity)owlstack);
                    if (top instanceof EntityOwlstack) {
                        this.func_184220_m(top);
                    }
                }
            }
        }
        if ((entity = this.getFriend()) != null && this.getHappyTime() >= 0 && this.isHappy()) {
            ++this.happyTime;
            int x = this.func_184188_bt().size() + 1;
            if (entity instanceof EntityPlayer && entity.func_184207_aI()) {
                EntityPlayer p = (EntityPlayer)entity;
                if (this.func_184187_bx() == p) {
                    if (!this.field_70170_p.field_72995_K) {
                        p.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, x - 1, false, false));
                    }
                    if (this.field_70170_p.field_72995_K && !p.field_71075_bZ.field_75100_b && p.field_70181_x > -3.5) {
                        p.field_70181_x = p.field_70181_x > 0.0 ? (p.field_70181_x -= 0.3 * (double)x) : (p.field_70181_x *= 1.0 * (double)x);
                    }
                }
            }
        } else if (this.getHappyTime() < 0) {
            ++this.happyTime;
        }
    }

    public void setFriend(@Nullable EntityLivingBase friend) {
        this.friend = friend;
        this.friendUUID = friend == null ? null : friend.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getFriend() {
        Entity entity;
        if (this.friend == null && this.friendUUID != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.friendUUID)) instanceof EntityLivingBase) {
            this.friend = (EntityLivingBase)entity;
        }
        return this.friend;
    }

    public int getHappyTime() {
        return this.happyTime;
    }

    public int getMaxHappyTime() {
        return this.maxHappyTime;
    }

    public void resetRiding() {
        this.setFriend(null);
        this.setHappy(0);
        this.func_184210_p();
        AncientBeastsPacketHandler.sendPacketToAllPlayers(new MessageDismountRidingEntity(null, this));
        this.happyTime = -2000;
        this.maxHappyTime = 20000 + this.field_70146_Z.nextInt(4000);
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        float tilting = MathHelper.func_76134_b((float)((float)this.field_70173_aa * 0.4f * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.01f * (float)(1 + Math.abs(-1));
        float f = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        float f1 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
        passenger.func_70107_b(this.field_70165_t + (double)(tilting * f), this.field_70163_u + (double)(this.field_70131_O - 0.2f), this.field_70161_v - (double)(tilting * f1));
    }

    public double func_70033_W() {
        if (this.func_184187_bx() != null) {
            return this.func_184187_bx().func_70093_af() ? 0.2 : 0.4;
        }
        return 0.0;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_184218_aH() || this.func_184207_aI()) {
            this.func_184210_p();
            this.func_184226_ay();
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return false;
    }

    public double func_70042_X() {
        return this.field_70131_O;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && !this.isHappy()) {
            if (itemstack.func_77973_b() == Items.field_151055_y && !this.field_70170_p.field_72995_K) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)18);
                    this.setHappy(player.func_145782_y());
                    this.happyTime = 0;
                    this.setFriend((EntityLivingBase)player);
                }
                return true;
            }
        } else if (player.func_184614_ca().func_190926_b() && this.getFriend() == player && !this.func_110167_bD() && this.isHappy() && this.getHappyTime() >= 0 && !this.field_70170_p.field_72995_K) {
            if (this.func_184187_bx() != null) {
                this.func_184210_p();
                this.func_184226_ay();
            }
            this.startRidingTopEntity((Entity)player);
            ModTriggers.OWLSTACK_INTERACT.trigger((EntityPlayerMP)player);
            player.func_184609_a(hand);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void startRidingTopEntity(Entity entity) {
        Entity top = EntityOwlstack.getTopPassenger(entity);
        if (top != null && !top.field_70128_L) {
            if (top instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)top;
                this.func_184205_a((Entity)player, true);
                this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers((Entity)player));
            } else {
                this.func_184205_a(top, true);
            }
            this.field_70699_by.func_75499_g();
        }
    }

    public static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.func_184207_aI()) {
            List list = entity.func_184188_bt();
            if (list.isEmpty()) continue;
            top = entity = (Entity)list.get(0);
        }
        return top;
    }

    public boolean isHappy() {
        return (Integer)this.field_70180_af.func_187225_a(HAPPY) != 0;
    }

    @Nullable
    public void setHappy(int id) {
        this.field_70180_af.func_187227_b(HAPPY, (Object)id);
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.field_70170_p.field_73012_v.nextInt(20);
        if (i >= 8 && i < 15) {
            Entity top = EntityOwlstack.getTopPassenger((Entity)this);
            EntityOwlstack owlstack = new EntityOwlstack(this.field_70170_p);
            owlstack.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            owlstack.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)owlstack);
            owlstack.func_184220_m(top);
        } else if (i == 15) {
            Entity top = EntityOwlstack.getTopPassenger((Entity)this);
            EntityOwlstack owlstack = new EntityOwlstack(this.field_70170_p);
            owlstack.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            owlstack.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)owlstack);
            owlstack.func_184220_m(top);
            EntityOwlstack owlstack2 = new EntityOwlstack(this.field_70170_p);
            owlstack2.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            owlstack2.func_180482_a(difficulty, null);
            this.field_70170_p.func_72838_d((Entity)owlstack2);
            owlstack2.func_184220_m(top);
        }
        return livingdata;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.friendUUID != null) {
            compound.func_186854_a("friend", this.friendUUID);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_186855_b("friend")) {
            this.friendUUID = compound.func_186857_a("friend");
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean isMobNearby() {
        List mobs = this.field_70170_p.func_72872_a(EntityMob.class, this.func_174813_aQ().func_186662_g(6.0));
        return !mobs.isEmpty();
    }

    protected SoundEvent func_184639_G() {
        return this.isMobNearby() ? ModSounds.OWLSTACK_SCREAM : ModSounds.OWLSTACK_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.OWLSTACK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.OWLSTACK_DEATH;
    }
}

