/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.google.common.base.Predicate;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityFrostWalker;
import com.unoriginal.ancientbeasts.entity.Entities.EntityFrostashFox;
import com.unoriginal.ancientbeasts.entity.Entities.ai.EntityAIRamAtTarget;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityNetherhound
extends EntityTameable {
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Netherhound");
    private int flameTicks;
    private boolean isInLava;
    private boolean isShaking;
    private float timeIsShaking;
    private float prevTimeIsShaking;

    public EntityNetherhound(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.4f);
        this.flameTicks = 200 + this.field_70146_Z.nextInt(400);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.field_70178_ae = true;
        this.func_70903_f(false);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIRamAtTarget((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFrostWalker.class, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFrostashFox.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityLivingBase.class, true, p_apply_1_ -> p_apply_1_ instanceof EntityPlayer || p_apply_1_ instanceof EntityIronGolem));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.35);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(28.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalArmor);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76361_j(), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entityIn);
            entityIn.func_70015_d(4);
            if (this.func_70051_ag()) {
                entityIn.field_70159_w += (entityIn.field_70165_t - this.field_70165_t) * 0.8;
                entityIn.field_70181_x += 0.2;
                entityIn.field_70179_y += (entityIn.field_70161_v - this.field_70161_v) * 0.8;
            }
        }
        return flag;
    }

    public void func_70636_d() {
        List entities;
        super.func_70636_d();
        if (this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) < 3.0 && this.field_70146_Z.nextInt(7) == 0 || --this.flameTicks <= 0) {
            Predicate selector = entityliving -> !(entityliving instanceof EntityNetherhound);
            List list = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(2.5), selector);
            if (!list.isEmpty() || --this.flameTicks <= 0) {
                for (EntityLivingBase l : list) {
                    if (!(this.func_184191_r((Entity)l) || this.field_70170_p.field_72995_K || l.func_70045_F())) {
                        l.func_70015_d(4);
                        l.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 3.0f * (float)AncientBeastsConfig.GlobalDamageMultiplier);
                        this.field_70170_p.func_72960_a((Entity)this, (byte)10);
                        this.func_184185_a(ModSounds.NETHERHOUND_CHARGE, 1.0f, 1.0f);
                    }
                    if (!this.field_70170_p.field_72995_K) continue;
                    for (int i = 0; i < 30; ++i) {
                        this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
                    }
                }
                this.flameTicks = 200 + this.field_70146_Z.nextInt(400);
            }
        }
        if (this.func_70051_ag() && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
            }
        }
        if (this.func_70026_G() && !this.field_70170_p.field_72995_K) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K && this.isInLava && !this.isShaking && !this.func_70781_l() && this.field_70122_E) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
            this.field_70170_p.func_72960_a((Entity)this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 150 == 0 && this.func_70909_n() && !(entities = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_186662_g(12.0))).isEmpty()) {
            for (Entity entity : entities) {
                if (!(entity instanceof EntityFrostashFox)) continue;
                this.func_70624_b((EntityLivingBase)((EntityFrostashFox)entity));
            }
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        if (this.func_70051_ag() && !this.field_70170_p.field_72995_K && !(list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(1.2))).isEmpty()) {
            for (EntityLivingBase livingBase : list) {
                if (livingBase == this) continue;
                this.func_70652_k((Entity)livingBase);
                this.field_70159_w *= 0.0;
                this.field_70181_x *= 0.0;
                this.func_70031_b(false);
            }
        }
        if (this.func_180799_ab()) {
            this.isInLava = true;
            this.isShaking = false;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
        } else if ((this.isInLava || this.isShaking) && this.isShaking) {
            if (this.timeIsShaking == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.prevTimeIsShaking = this.timeIsShaking;
            this.timeIsShaking += 0.05f;
            if (this.prevTimeIsShaking >= 2.0f) {
                this.isInLava = false;
                this.isShaking = false;
                this.prevTimeIsShaking = 0.0f;
                this.timeIsShaking = 0.0f;
            }
            if (this.timeIsShaking > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int i = (int)(MathHelper.func_76126_a((float)((this.timeIsShaking - 0.4f) * (float)Math.PI)) * 2.0f);
                for (int j = 0; j < i; ++j) {
                    float f1 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.field_70165_t + (double)f1, (double)(f + 0.8f), this.field_70161_v + (double)f2, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getShakeAngle(float p_70923_1_, float p_70923_2_) {
        float f = (this.prevTimeIsShaking + (this.timeIsShaking - this.prevTimeIsShaking) * p_70923_1_ + p_70923_2_) / 1.8f;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        return MathHelper.func_76126_a((float)(f * (float)Math.PI)) * MathHelper.func_76126_a((float)(f * (float)Math.PI * 11.0f)) * 0.15f * (float)Math.PI;
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(3.0));
            if (!list.isEmpty()) {
                for (EntityLivingBase e : list) {
                    e.func_70015_d(4);
                }
            }
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v, 1.0f, false);
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 30; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O + 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 0.5, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 0.5, new int[0]);
            }
        }
        super.func_70645_a(cause);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            ItemFood itemfood;
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFood && (itemfood = (ItemFood)itemstack.func_77973_b()).func_77845_h() && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(itemfood.func_150905_g(itemstack));
                return true;
            }
            if (this.func_152114_e((EntityLivingBase)player) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (itemstack.func_77973_b() == Items.field_151078_bh && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(this.func_110138_aP());
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151078_bh;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityNetherhound)) {
            return false;
        }
        EntityNetherhound netherhound = (EntityNetherhound)otherAnimal;
        if (!netherhound.func_70909_n()) {
            return false;
        }
        if (netherhound.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && netherhound.func_70880_s();
    }

    @Nullable
    public EntityNetherhound createChild(EntityAgeable ageable) {
        EntityNetherhound netherhound = new EntityNetherhound(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            netherhound.func_184754_b(uuid);
            netherhound.func_70903_f(true);
        }
        return netherhound;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 8) {
            this.isShaking = true;
            this.timeIsShaking = 0.0f;
            this.prevTimeIsShaking = 0.0f;
        } else if (id == 10) {
            this.func_184185_a(ModSounds.NETHERHOUND_CHARGE, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("flameTime")) {
            this.flameTicks = compound.func_74762_e("flameTime");
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("flameTime", this.flameTicks);
    }

    public boolean func_70692_ba() {
        return !this.func_70909_n();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    protected SoundEvent func_184639_G() {
        return ModSounds.NETHERHOUND_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.NETHERHOUND_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.NETHERHOUND_DEATH;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }
}

