/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.ai.EntityAIPatrol;
import com.unoriginal.ancientbeasts.entity.Entities.ai.EntityAIUseBow;
import com.unoriginal.ancientbeasts.init.ModItems;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityLilVessel
extends EntityTameable
implements IRangedAttackMob {
    private int itemDamage;
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityLilVessel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityLilVessel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PATROL = EntityDataManager.func_187226_a(EntityLilVessel.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> KILL_PLAYER = EntityDataManager.func_187226_a(EntityLilVessel.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityLilVessel(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.2f);
        this.func_70903_f(false);
    }

    public EntityLilVessel(World worldIn, EntityPlayer ownerIn, int itemDamageIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.2f);
        this.func_193101_c(ownerIn);
        this.itemDamage = itemDamageIn;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreeper.class, 8.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(4, new EntityAIUseBow<EntityLilVessel>(this, 1.0, 20, 15.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.5, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIPatrol(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIFollowOwnerPatrol(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, false));
        this.field_70715_bh.func_75776_a(5, new AIVesselTarget<EntityPlayer>(this, EntityPlayer.class));
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (!(target instanceof EntityCreeper)) {
            if (target instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)target;
                if (p == this.func_70902_q() || ((EntityPlayer)owner).func_96122_a(p)) {
                    return false;
                }
                return this.shouldKillPlayer() && p != this.func_70902_q();
            }
            return true;
        }
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0 * AncientBeastsConfig.GlobalDamageMultiplier);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_184609_a(this.func_184600_cs());
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            ItemStack stack = this.func_184582_a(this.getSlot(i));
            if (stack.func_190926_b()) continue;
            stack.func_77972_a(1, (EntityLivingBase)this);
            if (stack.func_77952_i() < stack.func_77958_k()) continue;
            this.func_70669_a(stack);
            this.func_184201_a(this.getSlot(i), ItemStack.field_190927_a);
        }
        return super.func_70097_a(source, amount);
    }

    public EntityEquipmentSlot getSlot(int slotIn) {
        switch (slotIn) {
            case 1: {
                return EntityEquipmentSlot.HEAD;
            }
            case 2: {
                return EntityEquipmentSlot.CHEST;
            }
            case 3: {
                return EntityEquipmentSlot.LEGS;
            }
            case 4: {
                return EntityEquipmentSlot.FEET;
            }
        }
        return EntityEquipmentSlot.CHEST;
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)false);
        this.field_70180_af.func_187214_a(PATROL, (Object)false);
        this.field_70180_af.func_187214_a(KILL_PLAYER, (Object)false);
    }

    public int getVariant() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(VARIANT)), (int)0, (int)1);
    }

    public void setVariant(int variantIn) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variantIn);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Patrolling", this.isPatrolling());
        compound.func_74757_a("Kill", this.shouldKillPlayer());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setPatrolling(compound.func_74767_n("Patrolling"));
        this.setKillPlayer(compound.func_74767_n("Kill"));
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() != Items.field_151057_cb && itemstack.func_77973_b() != ModItems.ECTOPLASM && !player.func_70093_af()) {
            if (!this.field_70170_p.field_72995_K && !player.func_175149_v() && player == this.func_70902_q()) {
                EntityEquipmentSlot entityequipmentslot = EntityLiving.func_184640_d((ItemStack)itemstack);
                if (itemstack.func_190926_b()) {
                    EntityEquipmentSlot entityequipmentslot1 = this.getClickedSlot(vec);
                    if (this.func_190630_a(entityequipmentslot1)) {
                        this.swapItem(player, entityequipmentslot1, itemstack, hand);
                    }
                } else {
                    this.swapItem(player, entityequipmentslot, itemstack, hand);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        if (this.func_70909_n() && player == this.func_70902_q() && player.func_70093_af()) {
            if (itemstack.func_190926_b() && !this.field_70170_p.field_72995_K) {
                if (!this.isPatrolling()) {
                    this.func_184185_a(ModSounds.LITTLE_V_ACTIVATE, 1.0f, 1.0f);
                    this.setPatrolling(true);
                } else {
                    this.func_184185_a(ModSounds.LITTLE_V_DEACTIVATE, 1.0f, 1.0f);
                    this.setPatrolling(false);
                }
                this.field_70699_by.func_75499_g();
                this.func_175449_a(this.func_180425_c(), 10);
            }
            if (itemstack.func_77973_b() == Items.field_151016_H && !this.shouldKillPlayer() && !this.field_70170_p.field_72995_K) {
                this.setKillPlayer(true);
                if (!player.field_71075_bZ.field_75098_d && AncientBeastsConfig.shouldVesselConsumeItem) {
                    itemstack.func_190918_g(1);
                }
            }
            if (this.shouldKillPlayer() && itemstack.func_77973_b() == Items.field_151102_aT && !this.field_70170_p.field_72995_K) {
                this.setKillPlayer(false);
                if (!player.field_71075_bZ.field_75098_d && AncientBeastsConfig.shouldVesselConsumeItem) {
                    itemstack.func_190918_g(1);
                }
                this.func_70624_b(null);
            }
            if (itemstack.func_77973_b() == ModItems.ECTOPLASM && this.func_110143_aJ() < 18.0f) {
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(6.0f);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    protected EntityEquipmentSlot getClickedSlot(Vec3d p_190772_1_) {
        EntityEquipmentSlot entityequipmentslot = EntityEquipmentSlot.MAINHAND;
        double d0 = p_190772_1_.field_72448_b * 2.0;
        EntityEquipmentSlot entityequipmentslot1 = EntityEquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.9 && this.func_190630_a(entityequipmentslot1)) {
            entityequipmentslot = EntityEquipmentSlot.FEET;
        } else if (d0 >= 1.2 && d0 < 1.9 && this.func_190630_a(EntityEquipmentSlot.CHEST)) {
            entityequipmentslot = EntityEquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.4 && this.func_190630_a(EntityEquipmentSlot.LEGS)) {
            entityequipmentslot = EntityEquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.func_190630_a(EntityEquipmentSlot.HEAD)) {
            entityequipmentslot = EntityEquipmentSlot.HEAD;
        }
        return entityequipmentslot;
    }

    private void swapItem(EntityPlayer player, EntityEquipmentSlot slot, ItemStack stack, EnumHand hand) {
        List<String> blacklist_items = Arrays.asList(AncientBeastsConfig.lil_v_blacklist);
        ResourceLocation item_name = stack.func_77973_b().getRegistryName();
        ItemStack itemstack = this.func_184582_a(slot);
        if (item_name != null && !blacklist_items.contains(item_name.toString())) {
            if (player.field_71075_bZ.field_75098_d && itemstack.func_190926_b() && !stack.func_190926_b()) {
                ItemStack itemstack2 = stack.func_77946_l();
                itemstack2.func_190920_e(1);
                this.func_184201_a(slot, itemstack2);
            } else if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
                if (itemstack.func_190926_b()) {
                    ItemStack itemstack1 = stack.func_77946_l();
                    itemstack1.func_190920_e(1);
                    this.func_184201_a(slot, itemstack1);
                    stack.func_190918_g(1);
                }
            } else {
                this.func_184201_a(slot, stack);
                player.func_184611_a(hand, itemstack);
            }
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70690_d(PotionEffect potioneffectIn) {
    }

    public void func_70645_a(DamageSource cause) {
        if (!this.field_70170_p.field_72995_K && this.func_70909_n()) {
            this.func_82160_b(true, 100);
            ItemStack me = new ItemStack(ModItems.VESSEL, 1, this.itemDamage + 1);
            if (this.itemDamage <= 4) {
                if (this.func_145818_k_()) {
                    me.func_151001_c(this.func_95999_t());
                }
                this.func_70099_a(me, 0.0f);
            }
        }
        super.func_70645_a(cause);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
        }
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entitytippedarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
        return entitytippedarrow;
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_70180_af.func_187225_a(PATROL);
    }

    public void setPatrolling(boolean patrol) {
        this.field_70180_af.func_187227_b(PATROL, (Object)patrol);
    }

    public boolean shouldKillPlayer() {
        return (Boolean)this.field_70180_af.func_187225_a(KILL_PLAYER);
    }

    public void setKillPlayer(boolean k) {
        this.field_70180_af.func_187227_b(KILL_PLAYER, (Object)k);
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSounds.LITTLE_VESSEL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSounds.LITTLE_VESSEL_DEATH;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public void func_98054_a(boolean child) {
        this.func_98055_j(1.0f);
    }

    class AIVesselTarget<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIVesselTarget(EntityLilVessel vessel, Class<T> classTarget) {
            super((EntityCreature)vessel, classTarget, true);
        }

        public boolean func_75250_a() {
            return EntityLilVessel.this.shouldKillPlayer() && super.func_75250_a();
        }
    }

    static class AIFollowOwnerPatrol
    extends EntityAIFollowOwner {
        private final EntityLilVessel lilVessel;

        public AIFollowOwnerPatrol(EntityLilVessel vessel, double followSpeedIn, float minDistIn, float maxDistIn) {
            super((EntityTameable)vessel, followSpeedIn, minDistIn, maxDistIn);
            this.lilVessel = vessel;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.lilVessel.isPatrolling();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !this.lilVessel.isPatrolling();
        }
    }
}

