/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityNetherhound;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityIceCrystal
extends Entity {
    private int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private boolean isAboutToVanish;
    private EntityLivingBase caster;
    private UUID casterUuid;
    public boolean isRedIce;
    private static final DataParameter<Boolean> RED = EntityDataManager.func_187226_a(EntityIceCrystal.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityIceCrystal(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.4f);
    }

    public EntityIceCrystal(World worldIn, double x, double y, double z, float p_i47276_8_, int p_i47276_9_, EntityLivingBase casterIn, boolean isRedIce) {
        this(worldIn);
        this.warmupDelayTicks = p_i47276_9_;
        this.setCaster(casterIn);
        this.field_70177_z = p_i47276_8_ * 57.295776f;
        this.func_70107_b(x, y, z);
        this.isRedIce = isRedIce;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(RED, (Object)false);
    }

    public void setCaster(@Nullable EntityLivingBase p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public EntityLivingBase getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof WorldServer && (entity = ((WorldServer)this.field_70170_p).func_175733_a(this.casterUuid)) instanceof EntityLivingBase) {
            this.caster = (EntityLivingBase)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.warmupDelayTicks = compound.func_74762_e("Warmup");
        this.casterUuid = compound.func_186857_a("OwnerUUID");
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("Warmup", this.warmupDelayTicks);
        if (this.casterUuid != null) {
            compound.func_186854_a("OwnerUUID", this.casterUuid);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isAboutToVanish) {
                --this.lifeTicks;
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                for (EntityLivingBase entitylivingbase : this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(0.2, 0.0, 0.2))) {
                    this.damage(entitylivingbase);
                }
            }
            if (!this.sentSpikeEvent) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0 && !this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
        if (this.isRedIce) {
            this.setRed(true);
        }
        if (this.func_70090_H() && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    private void damage(EntityLivingBase livingBase) {
        EntityLivingBase caster = this.getCaster();
        if (livingBase.func_70089_S() && !livingBase.func_190530_aW() && livingBase != caster) {
            if (caster == null) {
                livingBase.func_70097_a(DamageSource.field_76376_m, 4.0f * (float)AncientBeastsConfig.GlobalDamageMultiplier);
            } else {
                if (caster.func_184191_r((Entity)livingBase)) {
                    return;
                }
                livingBase.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)caster), 4.0f);
            }
            if (!(livingBase instanceof EntityNetherhound)) {
                livingBase.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 280, 8));
            }
            if (this.isRed()) {
                livingBase.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 80, 2));
            }
        }
    }

    public boolean isRed() {
        return (Boolean)this.field_70180_af.func_187225_a(RED);
    }

    public void setRed(boolean red) {
        this.field_70180_af.func_187227_b(RED, (Object)red);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 4) {
            this.isAboutToVanish = true;
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ModSounds.ICE, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getAnimationProgress(float partialTicks) {
        if (!this.isAboutToVanish) {
            return 0.0f;
        }
        int i = this.lifeTicks - 2;
        return i <= 0 ? 1.0f : 1.0f - ((float)i - partialTicks) / 20.0f;
    }
}

