/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.AbstractTribesmen;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHunter
extends AbstractTribesmen
implements IRangedAttackMob {
    private static final DataParameter<Boolean> SWINGING_ARMS = EntityDataManager.func_187226_a(EntityHunter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> CAMOUFLAGED = EntityDataManager.func_187226_a(EntityHunter.class, (DataSerializer)DataSerializers.field_187198_h);
    private final EntityAIAttackRangedBow<EntityHunter> aiArrowAttack = new EntityAIAttackRangedBow((EntityMob)this, 1.0, 20, 20.0f);
    private int camoTicks;
    private int camoCD;

    public EntityHunter(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.8f, 1.8f);
        this.setCombatTask();
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AbstractTribesmen.class, 10, true, false, p_apply_1_ -> p_apply_1_.isFiery() && !this.isFiery()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(18.0 * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0 + AncientBeastsConfig.GlobalArmor);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SWINGING_ARMS, (Object)Boolean.FALSE);
        this.field_70180_af.func_187214_a(CAMOUFLAGED, (Object)Boolean.FALSE);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (!this.isFiery()) {
            EntityArrow entityarrow = this.getArrow(distanceFactor);
            if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
            }
            double d0 = target.field_70165_t - this.field_70165_t;
            double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
            double d2 = target.field_70161_v - this.field_70161_v;
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(12 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
            this.field_70170_p.func_72838_d((Entity)entityarrow);
        } else {
            for (int i = 0; i < 4; ++i) {
                EntityArrow entityarrow = this.getArrow(distanceFactor);
                if (this.func_184614_ca().func_77973_b() instanceof ItemBow) {
                    entityarrow = ((ItemBow)this.func_184614_ca().func_77973_b()).customizeArrow(entityarrow);
                }
                double d0 = target.field_70165_t - this.field_70165_t;
                double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
                double d2 = target.field_70161_v - this.field_70161_v;
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(20 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
                this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                this.field_70170_p.func_72838_d((Entity)entityarrow);
            }
        }
    }

    protected EntityArrow getArrow(float p_190726_1_) {
        if (!this.isFiery()) {
            EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
            entityarrow.func_190547_a((EntityLivingBase)this, p_190726_1_);
            entityarrow.func_184558_a(new PotionEffect(MobEffects.field_76431_k, 200));
            return entityarrow;
        }
        EntityTippedArrow entityarrow2 = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entityarrow2.func_190547_a((EntityLivingBase)this, p_190726_1_);
        entityarrow2.func_70015_d(100);
        return entityarrow2;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSwingingArms() {
        return (Boolean)this.field_70180_af.func_187225_a(SWINGING_ARMS);
    }

    public void func_184724_a(boolean swingingArms) {
        this.field_70180_af.func_187227_b(SWINGING_ARMS, (Object)swingingArms);
    }

    public void setCombatTask() {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a(this.aiArrowAttack);
            ItemStack itemstack = this.func_184614_ca();
            if (itemstack.func_77973_b() instanceof ItemBow) {
                int i = 20;
                if (this.field_70170_p.func_175659_aa() != EnumDifficulty.HARD) {
                    i = 40;
                }
                this.aiArrowAttack.func_189428_b(i);
                this.field_70714_bg.func_75776_a(4, this.aiArrowAttack);
            }
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        super.func_180481_a(difficulty);
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
    }

    @Override
    public float avoidDistance(float distance) {
        return 3.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.isCamo() && !this.field_70170_p.field_72995_K) {
            this.setCamouflaged(false);
            this.camoCD = 800 + this.field_70146_Z.nextInt(200);
            this.camoTicks = 0;
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180481_a(difficulty);
        this.func_180483_b(difficulty);
        this.setCombatTask();
        return livingdata;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!(this.func_70638_az() == null || --this.camoCD > 0 || this.isCamo() || this.isFiery() || this.field_70170_p.field_72995_K)) {
            this.setCamouflaged(true);
            this.camoTicks = 400 + this.field_70146_Z.nextInt(400);
        }
        if (--this.camoTicks <= 0 && this.isCamo() && !this.field_70170_p.field_72995_K) {
            this.setCamouflaged(false);
            this.camoCD = 800 + this.field_70146_Z.nextInt(200);
        }
        if (!this.isCamo() || !this.field_70170_p.field_72995_K) {
            // empty if block
        }
        if (this.isFiery() && this.func_184614_ca().func_190926_b() && !this.field_70170_p.field_72995_K) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isCamo() {
        return (Boolean)this.field_70180_af.func_187225_a(CAMOUFLAGED);
    }

    public void setCamouflaged(boolean camo) {
        this.field_70180_af.func_187227_b(CAMOUFLAGED, (Object)camo);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("CamoTicks", this.camoTicks);
        compound.func_74768_a("CamoCD", this.camoCD);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("CamoTicks")) {
            this.camoTicks = compound.func_74762_e("CamoTicks");
        }
        if (compound.func_74764_b("CamoCD")) {
            this.camoCD = compound.func_74762_e("CamoCD");
        }
        if (compound.func_74764_b("CamoTrans")) {
            // empty if block
        }
        this.setCombatTask();
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, ItemStack stack) {
        super.func_184201_a(slotIn, stack);
        if (!this.field_70170_p.field_72995_K && slotIn == EntityEquipmentSlot.MAINHAND) {
            this.setCombatTask();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCamoTicks() {
        return this.camoTicks;
    }
}

