/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.entity.Entities;

import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityBoulder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveThroughVillage;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityGiant
extends EntityMob {
    protected static final IAttribute SPAWN_REINFORCEMENTS_CHANCE = new RangedAttribute(null, "zombie.spawnReinforcements", 0.0, 0.0, 1.0).func_111117_a("Spawn Reinforcements Chance");
    public static final ResourceLocation LOOT = new ResourceLocation("ancientbeasts", "entities/Giant");
    private int attackTimer;
    private int grabTicks;
    private int actionCooldown;
    private int throwTicks;
    private boolean didThrow;

    public EntityGiant(World worldIn) {
        super(worldIn);
        this.func_70105_a(2.8f, 7.2f);
        this.field_70138_W = 2.0f;
        this.field_70728_aV = 50;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIGiantMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveThroughVillage((EntityCreature)this, 1.0, false));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityZombie.class}));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityVillager.class, false));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityIronGolem.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((180.0 + AncientBeastsConfig.GiantHealthBonus) * AncientBeastsConfig.GlobalHealthMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(15.0 * AncientBeastsConfig.GlobalDamageMultiplier);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0 + AncientBeastsConfig.GlobalArmor);
        this.func_110140_aT().func_111150_b(SPAWN_REINFORCEMENTS_CHANCE).func_111128_a(0.7);
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), 2.5f, 0.5f);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.125f + 0.5f;
    }

    protected float func_70599_aP() {
        return 2.5f;
    }

    public void func_70636_d() {
        int k;
        int j;
        int i;
        IBlockState iblockstate;
        EntityLivingBase target;
        EntityLivingBase p;
        Object list;
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (this.grabTicks > 0) {
            --this.grabTicks;
        }
        if (this.actionCooldown > 0) {
            --this.actionCooldown;
        }
        if (this.throwTicks > 0) {
            --this.throwTicks;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI() && this.actionCooldown <= 0 && this.field_70146_Z.nextInt(6) == 0 && !(list = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(6.0))).isEmpty() && ((p = (EntityLivingBase)list.get(this.field_70170_p.field_73012_v.nextInt(list.size()))) instanceof EntityPlayer || p instanceof EntityVillager || p instanceof EntityIronGolem)) {
            if (p instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)p;
                if (!entityPlayer.field_71075_bZ.field_75098_d) {
                    p.func_184220_m((Entity)this);
                    this.grabTicks = 200;
                }
            } else {
                p.func_184220_m((Entity)this);
                this.grabTicks = 200;
            }
        }
        if (this.func_184207_aI()) {
            for (Entity e : this.func_184188_bt()) {
                if (!(e instanceof EntityLivingBase)) continue;
                EntityLivingBase l = (EntityLivingBase)e;
                l.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 4.0f * (float)AncientBeastsConfig.GlobalDamageMultiplier);
            }
            if (this.grabTicks <= 0 || this.field_70737_aN != 0) {
                this.func_184226_ay();
                this.actionCooldown = 800;
            }
        }
        if (this.func_70638_az() != null && !this.field_70170_p.field_72995_K && this.actionCooldown <= 0 && this.field_70146_Z.nextInt(6) == 0 && !this.func_184207_aI() && this.func_70068_e((Entity)(target = this.func_70638_az())) > 16.0 && !this.didThrow) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            this.throwBoulder(target);
            this.throwTicks = 12;
            this.actionCooldown = 400;
        }
        if (this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && (iblockstate = this.field_70170_p.func_180495_p(new BlockPos(i = MathHelper.func_76128_c((double)this.field_70165_t), j = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f)), k = MathHelper.func_76128_c((double)this.field_70161_v)))).func_185904_a() != Material.field_151579_a) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, this.func_174813_aQ().field_72338_b + 0.1, this.field_70161_v + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.field_70130_N, 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
        }
        if (this.didThrow && this.throwTicks <= 0) {
            this.didThrow = false;
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)(7 + this.field_70146_Z.nextInt(15)));
        if (flag) {
            entityIn.field_70159_w += entityIn.field_70165_t - this.field_70165_t;
            entityIn.field_70181_x += 0.6;
            entityIn.field_70179_y += entityIn.field_70161_v - this.field_70161_v;
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            EntityLivingBase entitylivingbase = this.func_70638_az();
            if (entitylivingbase == null && source.func_76346_g() instanceof EntityLivingBase) {
                entitylivingbase = (EntityLivingBase)source.func_76346_g();
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70163_u);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            if ((double)this.field_70146_Z.nextFloat() < this.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111126_e() && this.field_70170_p.func_82736_K().func_82766_b("doMobSpawning")) {
                for (int l = 0; l < 6; ++l) {
                    int k1;
                    int j1;
                    EntityZombie entityzombie = new EntityZombie(this.field_70170_p);
                    int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)20) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                    if (!this.field_70170_p.func_180495_p(new BlockPos(i1, (j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)20) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1)) - 1, k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)20) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1))).isSideSolid((IBlockAccess)this.field_70170_p, new BlockPos(i1, j1 - 1, k1), EnumFacing.UP) || this.field_70170_p.func_175671_l(new BlockPos(i1, j1, k1)) >= 10) continue;
                    entityzombie.func_70107_b((double)i1, (double)j1, (double)k1);
                    if (!this.field_70170_p.func_72917_a(entityzombie.func_174813_aQ(), (Entity)entityzombie) || !this.field_70170_p.func_184144_a((Entity)entityzombie, entityzombie.func_174813_aQ()).isEmpty() || this.field_70170_p.func_72953_d(entityzombie.func_174813_aQ())) continue;
                    this.field_70170_p.func_72838_d((Entity)entityzombie);
                    if (entitylivingbase != null) {
                        entityzombie.func_70624_b(entitylivingbase);
                    }
                    entityzombie.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)entityzombie)), null);
                    entityzombie.func_110148_a(SPAWN_REINFORCEMENTS_CHANCE).func_111121_a(new AttributeModifier("Zombie reinforcement callee charge", (double)-0.05f, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean isAttacking() {
        return this.attackTimer > 0;
    }

    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLivingBase) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)5);
            float f1 = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180) + (float)Math.PI));
            float f2 = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            entity.func_70107_b(this.field_70165_t + (double)f1 * 4.0, this.field_70163_u + 5.0, this.field_70161_v + (double)f2 * 4.0);
            if (entity.func_70093_af()) {
                entity.func_70095_a(false);
            }
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean func_184186_bw() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
        }
        if (id == 5) {
            this.grabTicks = 200;
        }
        if (id == 6) {
            this.throwTicks = 12;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    private void throwBoulder(EntityLivingBase target) {
        EntityBoulder boulder = new EntityBoulder(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - boulder.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        boulder.func_70186_c(d0, d1 + (double)f, d2, 1.3f, 0.0f);
        this.field_70170_p.func_72838_d((Entity)boulder);
        this.didThrow = true;
    }

    public int func_70641_bl() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int getThrowTicks() {
        return this.throwTicks;
    }

    public boolean isThrowing() {
        return this.throwTicks > 0;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }

    static class EntityAIGiantMelee
    extends EntityAIAttackMelee {
        public EntityAIGiantMelee(EntityCreature creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        protected void func_190102_a(EntityLivingBase enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 25;
                this.field_75441_b.func_70652_k((Entity)enemy);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    this.field_75439_d = 25;
                }
            } else {
                this.field_75439_d = 25;
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * 1.9f * this.field_75441_b.field_70130_N * 1.9f + attackTarget.field_70130_N;
        }
    }
}

