/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.blocks.tile;

import com.unoriginal.ancientbeasts.blocks.BlockMovingLight;
import com.unoriginal.ancientbeasts.init.ModItems;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityMovingLight
extends TileEntity
implements ITickable {
    public EntityLivingBase theEntityLiving;
    protected boolean shouldDie = false;
    protected int deathTimer = 20;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_73660_a() {
        if (this.shouldDie) {
            if (this.deathTimer > 0) {
                --this.deathTimer;
                return;
            }
            this.field_145850_b.func_175698_g(this.func_174877_v());
        }
        Block blockAtLocation = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        if (this.theEntityLiving == null) {
            if (blockAtLocation instanceof BlockMovingLight) {
                this.shouldDie = true;
            }
            return;
        }
        if (this.theEntityLiving.field_70128_L) {
            if (blockAtLocation instanceof BlockMovingLight) {
                this.shouldDie = true;
            }
            return;
        }
        double distanceSquared = this.func_145835_a(this.theEntityLiving.field_70165_t, this.theEntityLiving.field_70163_u, this.theEntityLiving.field_70161_v);
        if (distanceSquared > 5.0 && blockAtLocation instanceof BlockMovingLight) {
            this.shouldDie = true;
        }
        if (!this.theEntityLiving.func_70027_ad()) {
            this.theEntityLiving.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b();
            if (this.theEntityLiving.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == ModItems.MINER_HELMET && this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c() instanceof BlockMovingLight) {
                this.shouldDie = true;
            }
        }
    }

    public void setEntityLiving(EntityLivingBase parEntityLiving) {
        this.theEntityLiving = parEntityLiving;
    }

    public EntityLivingBase getEntityLiving() {
        return this.theEntityLiving;
    }

    public void func_174878_a(BlockPos posIn) {
        this.field_174879_c = posIn.func_185334_h();
        this.setEntityLiving(TileEntityMovingLight.getClosestEntityLiving(this.field_145850_b, this.field_174879_c, 2.0));
    }

    public static EntityLivingBase getClosestEntityLiving(World parWorld, BlockPos parPos, double parMaxDistance) {
        if (parMaxDistance <= 0.0) {
            return null;
        }
        EntityLivingBase closestLiving = null;
        double distanceSq = parMaxDistance * parMaxDistance;
        AxisAlignedBB aabb = new AxisAlignedBB((double)parPos.func_177958_n() - parMaxDistance, (double)parPos.func_177956_o() - parMaxDistance, (double)parPos.func_177952_p() - parMaxDistance, (double)parPos.func_177958_n() + parMaxDistance, (double)parPos.func_177956_o() + parMaxDistance, (double)parPos.func_177952_p() + parMaxDistance);
        List listEntitiesInRange = parWorld.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase next : listEntitiesInRange) {
            if (!(TileEntityMovingLight.getDistanceSq(next.func_180425_c(), parPos) < distanceSq)) continue;
            closestLiving = next;
        }
        return closestLiving;
    }

    protected static double getDistanceSq(BlockPos parPos1, BlockPos parPos2) {
        return (parPos1.func_177958_n() - parPos2.func_177958_n()) * (parPos1.func_177958_n() - parPos2.func_177958_n()) + (parPos1.func_177956_o() - parPos2.func_177956_o()) * (parPos1.func_177956_o() - parPos2.func_177956_o()) + (parPos1.func_177952_p() - parPos2.func_177952_p()) * (parPos1.func_177952_p() - parPos2.func_177952_p());
    }
}

