/*
 * Decompiled with CFR 0.152.
 */
package com.unoriginal.ancientbeasts.blocks;

import com.unoriginal.ancientbeasts.AncientBeasts;
import com.unoriginal.ancientbeasts.blocks.BlockSpike;
import com.unoriginal.ancientbeasts.init.ModBlocks;
import com.unoriginal.ancientbeasts.init.ModSounds;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSkewer
extends BlockDirectional {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.95, 0.95, 0.95);
    protected static final AxisAlignedBB AABB2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockSkewer(String name) {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(AncientBeasts.BEASTSTAB);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return AABB;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSkewerState(worldIn, pos);
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer)), 2);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.updateSkewerState(worldIn, pos);
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        iblockstate = iblockstate.func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
        return iblockstate;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public void updateSkewerState(World world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176387_N);
        int distance = 1;
        int oldDistance = 1;
        this.updateSkewerState(world, pos, facing, distance, oldDistance);
    }

    private void updateSkewerState(World world, BlockPos pos, EnumFacing direction, int newDistance, int previousDistance) {
        if (newDistance != previousDistance) {
            BlockPos oldPos = pos.func_177967_a(direction, previousDistance);
            this.removeSpike(world, oldPos);
        }
        BlockPos spikePos = pos.func_177967_a(direction, newDistance);
        AxisAlignedBB axisalignedbb = AABB2.func_186670_a(pos);
        List list = world.func_72839_b(null, axisalignedbb);
        if (!world.field_72995_K && list.isEmpty()) {
            this.removeSpike(world, spikePos);
        }
        if (world.func_180495_p(spikePos).func_177230_c() == ModBlocks.SPIKE) {
            world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, 40);
        }
    }

    public void removeSpike(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == ModBlocks.SPIKE) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)((float)pos.func_177952_p() + 0.5f), ModSounds.SPIKES_DEACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        BlockPos spikePos = pos.func_177967_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N), 1);
        this.removeSpike(worldIn, spikePos);
        super.func_180663_b(worldIn, pos, state);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        float hardness;
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)field_176387_N);
        BlockPos spikePos = pos.func_177967_a(facing, 1);
        if (!world.field_72995_K && (hardness = world.func_180495_p(spikePos).func_177230_c().func_176223_P().func_185887_b(world, spikePos)) <= 4.0f && hardness >= 0.0f) {
            if (world.func_180495_p(spikePos).func_177230_c() != ModBlocks.SPIKE) {
                world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)((float)pos.func_177952_p() + 0.5f), ModSounds.SPIKES_ACTIVATE, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            world.func_175656_a(spikePos, ModBlocks.SPIKE.func_176223_P().func_177226_a((IProperty)BlockSpike.field_176387_N, (Comparable)facing));
            this.updateSkewerState(world, pos);
            world.func_175684_a(new BlockPos((Vec3i)pos), (Block)this, 20);
        }
    }
}

