/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.handler;

import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import com.windanesz.wizardryutils.server.Attributes;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class WizardryUtilsEventHandler {
    private WizardryUtilsEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player;
        if (!event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START) {
            IAttributeInstance attribute;
            player = event.player;
            if (player.field_70173_aa % 90 == 0 && (attribute = player.func_110148_a((IAttribute)Attributes.CONDENSING)) != null && attribute.func_111126_e() != 0.0) {
                ItemStack offHand;
                ItemStack mainHand;
                double amount = attribute.func_111126_e();
                int mana = (int)amount;
                double fraction = amount - Math.floor(amount);
                if (fraction != 0.0 && (double)event.player.field_70170_p.field_73012_v.nextFloat() <= fraction) {
                    mana = amount > 0.0 ? (int)Math.ceil(amount) : (int)Math.floor(amount);
                }
                if ((mainHand = player.func_184614_ca()).func_77973_b() instanceof ISpellCastingItem && mainHand.func_77973_b() instanceof IManaStoringItem) {
                    WizardryUtilsEventHandler.handleCondensing(mainHand, mana);
                }
                if ((offHand = player.func_184592_cb()).func_77973_b() instanceof ISpellCastingItem && offHand.func_77973_b() instanceof IManaStoringItem) {
                    WizardryUtilsEventHandler.handleCondensing(offHand, mana);
                }
            }
        }
        if (event.phase == TickEvent.Phase.END) {
            player = event.player;
            if (BaublesIntegration.enabled()) {
                BaublesIntegration.tickWornArtefacts(player);
            }
        }
    }

    private static void handleCondensing(ItemStack stack, int amount) {
        if (amount > 0) {
            ((IManaStoringItem)stack.func_77973_b()).rechargeMana(stack, amount);
        } else {
            ((IManaStoringItem)stack.func_77973_b()).consumeMana(stack, -1 * amount, null);
        }
    }

    @SubscribeEvent
    public static void onEntityConstructingEvent(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            Attributes.addAttributes((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent
    public static void onSpellCastEventPre(SpellCastEvent.Pre event) {
        if (!event.getWorld().field_72995_K && event.getCaster() != null) {
            EntityLivingBase caster = event.getCaster();
            for (Map.Entry<RangedAttribute, String> entry : Attributes.getSpellModifierAttributes().entrySet()) {
                IAttributeInstance attributeInstance;
                if (entry.getKey() == Attributes.CONDENSING || (attributeInstance = caster.func_110148_a((IAttribute)entry.getKey())) == null) continue;
                String modifier = entry.getValue();
                float oldValue = event.getModifiers().get(modifier);
                float newValue = (float)((double)oldValue * (0.01 * attributeInstance.func_111126_e()));
                event.getModifiers().set(modifier, newValue, true);
            }
        }
    }
}

