/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils.capability;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class SummonedThing
implements INBTSerializable<NBTTagCompound> {
    public static final String SUMMONED_TAG = "summoned";
    public static final String CASTER_UUID_TAG = "casterUUID";
    public static final String LIFETIME_TAG = "lifetime";
    protected boolean summoned = false;
    protected int lifetime = -1;
    protected UUID casterUUID;
    protected UUID owner;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.summoned) {
            nbt.func_74757_a(SUMMONED_TAG, true);
            if (this.getOwnerId() != null) {
                NBTTagCompound casterUUID = new NBTTagCompound();
                casterUUID.func_186854_a(CASTER_UUID_TAG, this.getOwnerId());
                nbt.func_74782_a(CASTER_UUID_TAG, (NBTBase)casterUUID);
            }
            if (this.lifetime != -1) {
                nbt.func_74768_a(LIFETIME_TAG, this.getLifetime());
            }
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt != null && !nbt.func_82582_d() && nbt.func_74764_b(SUMMONED_TAG)) {
            if (nbt.func_74764_b(CASTER_UUID_TAG)) {
                this.setOwnerId(nbt.func_74775_l(CASTER_UUID_TAG).func_186857_a(CASTER_UUID_TAG));
            }
            if (nbt.func_74764_b(LIFETIME_TAG)) {
                this.setLifetime(nbt.func_74762_e(LIFETIME_TAG));
            }
        }
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
        if (!this.summoned) {
            this.summoned = true;
        }
    }

    public void setCaster(@Nullable EntityLivingBase caster) {
        this.setOwnerId(caster == null ? null : caster.func_110124_au());
        if (!this.summoned) {
            this.summoned = true;
        }
    }

    public UUID getOwnerId() {
        return this.casterUUID;
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }
}

