/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.wizardryutils;

import com.windanesz.wizardryutils.WizardryUtils;
import com.windanesz.wizardryutils.item.ItemNewArtefact;
import electroblob.wizardry.Wizardry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class ArtefactSettings {
    public static final String ADDITIONAL_ARTEFACTS_CATEGORY = "artefacts";
    private Configuration config;
    private List<String> redundantKeys = new ArrayList<String>();

    void initConfig(FMLPreInitializationEvent event) {
        this.redundantKeys.clear();
        this.config = new Configuration(new File(Wizardry.configDirectory, "wizardryutils_artefacts.cfg"));
        this.config.load();
        WizardryUtils.logger.info("Setting up main config");
        this.config.save();
    }

    void initConfigExtras() {
        WizardryUtils.logger.info("Setting up artefacts (HEAD, BELT, BODY slot) config");
        this.setupArtefactsConfig();
        this.config.save();
    }

    void saveConfigChanges() {
        this.redundantKeys.clear();
        WizardryUtils.logger.info("Saving in-game config changes");
        this.setupArtefactsConfig();
        this.config.save();
    }

    void checkForRedundantOptions(String categoryName, Collection<String> validKeys) {
        ConfigCategory category = this.config.getCategory(categoryName);
        boolean redundantKeysFound = false;
        for (String key : category.keySet()) {
            if (validKeys.contains(key)) continue;
            this.redundantKeys.add(key);
            if (!redundantKeysFound) {
                redundantKeysFound = true;
                WizardryUtils.logger.info("Config category {} contains redundant options:", (Object)categoryName);
            }
            WizardryUtils.logger.info(key);
        }
        if (redundantKeysFound) {
            WizardryUtils.logger.info("These options will have no effect (they are probably left over from an older version of Wizardy Utils or an addon which depends on it). It is recommended to either remove them manually, or delete wizardryutils_artefacts.cfg and allow a fresh config to be generated.");
        }
    }

    public boolean hasRedundantKeys() {
        return !this.redundantKeys.isEmpty();
    }

    public ConfigCategory getConfigCategory(String name) {
        return this.config.getCategory(name);
    }

    private void setupArtefactsConfig() {
        this.config.addCustomCategoryComment(ADDITIONAL_ARTEFACTS_CATEGORY, "Set an item to false to disable it. Disabled items will still appear in-game but will have no effect when worn. It is also advisable to remove disabled items from wizardry's (and addons') loot tables. Disable an item if it is causing problems, conflicts with another mod or creates an unintended exploit.");
        ArrayList<String> keys = new ArrayList<String>();
        for (Item item : Item.field_150901_e) {
            if (!(item instanceof ItemNewArtefact)) continue;
            keys.add(item.getRegistryName().toString());
            Property property = this.config.get(ADDITIONAL_ARTEFACTS_CATEGORY, item.getRegistryName().toString(), true, "Set to false to disable this item");
            property.setLanguageKey(item.func_77658_a() + ".name");
            Wizardry.proxy.setToNamedBooleanEntry(property);
            ((ItemNewArtefact)item).setEnabled(property.getBoolean());
        }
        this.checkForRedundantOptions(ADDITIONAL_ARTEFACTS_CATEGORY, keys);
    }
}

