/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.necromancersdelight.spell;

import com.windanesz.necromancersdelight.registry.NDBlocks;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GlowShroom
extends SpellRay {
    private static final String BLOCK_LIFETIME = "block_lifetime";

    public GlowShroom(String modid, String name) {
        super(modid, name, SpellActions.POINT, false);
        this.ignoreLivingEntities(true);
        this.addProperties(new String[]{BLOCK_LIFETIME});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && caster.func_70093_af() && world.func_180495_p(pos).func_177230_c() == NDBlocks.temporary_glowshroom) {
            if (!world.field_72995_K) {
                world.func_175698_g(pos);
            } else {
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
            }
            return true;
        }
        pos = pos.func_177972_a(side);
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5).scale(3.0f).clr(0.75f, 1.0f, 0.85f).spawn(world);
        }
        if (BlockUtils.canBlockBeReplaced((World)world, (BlockPos)pos)) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, NDBlocks.temporary_glowshroom.func_176223_P());
                if (world.func_175625_s(pos) instanceof TileEntityTimer) {
                    ((TileEntityTimer)world.func_175625_s(pos)).setLifetime((int)(this.getProperty(BLOCK_LIFETIME).floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }
}

