/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.necromancersdelight.handler;

import com.Fishmod.mod_LavaCow.entities.EntityBoneWorm;
import com.Fishmod.mod_LavaCow.entities.EntityForsaken;
import com.Fishmod.mod_LavaCow.entities.EntityMummy;
import com.Fishmod.mod_LavaCow.entities.tameable.EntityUnburied;
import com.Fishmod.mod_LavaCow.init.AddRecipes;
import com.Fishmod.mod_LavaCow.init.Modblocks;
import com.windanesz.necromancersdelight.entity.living.EntityManaLeechMinion;
import com.windanesz.necromancersdelight.registry.NDItems;
import com.windanesz.necromancersdelight.registry.NDPotions;
import com.windanesz.wizardryutils.capability.SummonedCreatureData;
import com.windanesz.wizardryutils.integration.baubles.BaublesIntegration;
import com.windanesz.wizardryutils.tools.WizardryUtilsTools;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.entity.living.EntitySkeletonMinion;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.passive.EntitySkeletonHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class NDEventHandler {
    @SubscribeEvent
    public static void onPotionApplicableEvent(PotionEvent.PotionApplicableEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntity();
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == NDItems.amulet_slowness_immunity) {
                    if (event.getPotionEffect().func_188419_a() != MobEffects.field_76421_d) continue;
                    event.setResult(Event.Result.DENY);
                    continue;
                }
                if (artefact != NDItems.amulet_weakness_immunity || event.getPotionEffect().func_188419_a() != MobEffects.field_76437_t) continue;
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        List stackList;
        EntityPlayer player;
        if (event.getSource().func_76346_g() instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)event.getSource().func_76346_g()), (Item)NDItems.charm_bone_bag) && (event.getEntity() instanceof AbstractSkeleton || event.getEntity() instanceof EntitySkeletonHorse) && !(stackList = BaublesIntegration.getEquippedArtefactStacks((EntityPlayer)player, (Object[])new Object[]{ItemArtefact.Type.CHARM})).isEmpty()) {
            ItemStack bag = NDEventHandler.addCharmProgress((ItemStack)stackList.get(0), 25);
            BaublesIntegration.setArtefactToSlot((EntityPlayer)player, (ItemStack)bag, (ItemArtefact.Type)ItemArtefact.Type.CHARM);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPostEvent(SpellCastEvent.Post event) {
        if (!event.getWorld().field_72995_K && event.getCaster() instanceof EntityPlayer) {
            BlockPos pos;
            ItemStack bag;
            EntityPlayer player = (EntityPlayer)event.getCaster();
            SpellModifiers modifiers = event.getModifiers();
            if (event.getSpell().getType() == SpellType.MINION && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)NDItems.charm_bone_bag) && (bag = (ItemStack)BaublesIntegration.getEquippedArtefactStacks((EntityPlayer)player, (Object[])new Object[]{ItemArtefact.Type.CHARM}).get(0)).func_77942_o() && bag.func_77978_p().func_74764_b("progress") && bag.func_77978_p().func_74762_e("progress") == 100 && (pos = BlockUtils.findNearbyFloorSpace((Entity)player, (int)5, (int)3)) != null) {
                EntityBoneWorm osVermis = new EntityBoneWorm(player.field_70170_p);
                SummonedCreatureData minionData = SummonedCreatureData.get((EntityLivingBase)osVermis);
                osVermis.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minionData.setCaster((EntityLivingBase)player);
                minionData.setLifetime((int)(800.0f * modifiers.get(WizardryItems.duration_upgrade)));
                player.field_70170_p.func_72838_d((Entity)osVermis);
                BaublesIntegration.setArtefactToSlot((EntityPlayer)player, (ItemStack)NDEventHandler.addCharmProgress(bag, 0), (ItemArtefact.Type)ItemArtefact.Type.CHARM);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onSpellCastPreEvent(SpellCastEvent.Pre event) {
        if (!event.getWorld().field_72995_K && event.getCaster() != null && event.getCaster().func_184187_bx() instanceof EntityManaLeechMinion) {
            SpellModifiers modifiers = event.getModifiers();
            modifiers.set("cost", modifiers.get("cost") * 2.0f, false);
            if (((EntityManaLeechMinion)event.getCaster().func_184187_bx()).isWeakensSpells()) {
                modifiers.set("potency", modifiers.get("potency") * 0.6f, false);
                modifiers.set(WizardryItems.blast_upgrade, modifiers.get(WizardryItems.blast_upgrade) * 0.6f, false);
                modifiers.set(WizardryItems.range_upgrade, modifiers.get(WizardryItems.range_upgrade) * 0.6f, false);
                modifiers.set(WizardryItems.duration_upgrade, modifiers.get(WizardryItems.duration_upgrade) * 0.6f, false);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawnEvent(EntityJoinWorldEvent event) {
        EntityPlayer player = null;
        if (event.getEntity() instanceof ISummonedCreature && ((ISummonedCreature)event.getEntity()).getCaster() instanceof EntityPlayer) {
            player = (EntityPlayer)((ISummonedCreature)event.getEntity()).getCaster();
        } else if (SummonedCreatureData.isSummonedEntity((Entity)event.getEntity()) && SummonedCreatureData.get((EntityLivingBase)((EntityLiving)event.getEntity())).getCaster() instanceof EntityPlayer) {
            player = (EntityPlayer)SummonedCreatureData.get((EntityLivingBase)((EntityLiving)event.getEntity())).getCaster();
        }
        if (player != null) {
            boolean mobChanged = false;
            boolean gotHelmetCharm = false;
            int unburiedRings = 0;
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)NDItems.ring_nameless)) {
                ++unburiedRings;
            }
            if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)NDItems.ring_legion)) {
                ++unburiedRings;
            }
            for (ItemArtefact artefact : ItemArtefact.getActiveArtefacts((EntityPlayer)player, (ItemArtefact.Type[])new ItemArtefact.Type[0])) {
                if (artefact == NDItems.charm_mushroom_minion && !player.func_184592_cb().func_190926_b()) {
                    EntityLiving minion = (EntityLiving)event.getEntity();
                    ItemStack offHandStack = player.func_184592_cb();
                    Item item = offHandStack.func_77973_b();
                    if (item == Item.func_150898_a((Block)Modblocks.VEIL_SHROOM)) {
                        minion.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 600));
                        offHandStack.func_190918_g(1);
                        continue;
                    }
                    if (item == Item.func_150898_a((Block)Modblocks.CORDY_SHROOM)) {
                        minion.func_70690_d(new PotionEffect(NDPotions.poisonous_spore, 600));
                        offHandStack.func_190918_g(1);
                        continue;
                    }
                    if (item == Item.func_150898_a((Block)Modblocks.BLOODTOOTH_SHROOM)) {
                        minion.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 600));
                        offHandStack.func_190918_g(1);
                        continue;
                    }
                    if (item != Item.func_150898_a((Block)Modblocks.GLOWSHROOM)) continue;
                    minion.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 600, 1));
                    minion.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 600));
                    offHandStack.func_190918_g(1);
                    continue;
                }
                if (artefact == NDItems.charm_scarab && WizardryUtilsTools.isEntityConsideredUndead((Entity)event.getEntity())) {
                    ((EntityLiving)event.getEntity()).func_70690_d(new PotionEffect(NDPotions.locusts, Integer.MAX_VALUE, 0));
                    continue;
                }
                if (artefact == NDItems.charm_mummy_minion && event.getEntity() instanceof EntityZombieMinion && !mobChanged) {
                    EntityZombieMinion zombie = (EntityZombieMinion)event.getEntity();
                    EntityMummy minion = new EntityMummy(event.getWorld());
                    SummonedCreatureData minionData = SummonedCreatureData.get((EntityLivingBase)minion);
                    minion.func_70107_b(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v);
                    minionData.setCaster((EntityLivingBase)player);
                    minionData.setLifetime(zombie.getLifetime());
                    event.getWorld().func_72838_d((Entity)minion);
                    event.setCanceled(true);
                    mobChanged = true;
                    continue;
                }
                if (artefact == WizardryItems.charm_undead_helmets) {
                    gotHelmetCharm = true;
                    continue;
                }
                if (artefact != NDItems.ring_forsaken || !(event.getEntity() instanceof EntitySkeletonMinion)) continue;
                EntitySkeletonMinion skeleton = (EntitySkeletonMinion)event.getEntity();
                World world = skeleton.field_70170_p;
                EntityForsaken forsaken = new EntityForsaken(world);
                SummonedCreatureData minionData = SummonedCreatureData.get((EntityLivingBase)forsaken);
                forsaken.func_70107_b(skeleton.field_70165_t, skeleton.field_70163_u, skeleton.field_70161_v);
                minionData.setCaster((EntityLivingBase)player);
                minionData.setLifetime(skeleton.getLifetime());
                switch (world.field_73012_v.nextInt(4)) {
                    case 0: {
                        forsaken.func_184201_a(EntityEquipmentSlot.OFFHAND, NDEventHandler.getForsakenShield());
                        forsaken.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
                        forsaken.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.4);
                        forsaken.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
                    }
                    case 1: {
                        forsaken.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                        break;
                    }
                    case 2: {
                        forsaken.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack((Item)Items.field_151031_f));
                        break;
                    }
                    case 3: {
                        forsaken.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
                        forsaken.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
                        forsaken.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
                        forsaken.func_85036_m();
                        world.func_72838_d((Entity)forsaken);
                        event.setCanceled(true);
                        EntitySkeletonHorse entityskeletonhorse = new EntitySkeletonHorse(world);
                        entityskeletonhorse.func_70107_b(forsaken.field_70165_t, forsaken.field_70163_u, forsaken.field_70161_v);
                        entityskeletonhorse.field_70172_ad = 60;
                        entityskeletonhorse.func_110234_j(true);
                        entityskeletonhorse.func_70873_a(0);
                        SummonedCreatureData entityskeletonhorseMinionData = SummonedCreatureData.get((EntityLivingBase)entityskeletonhorse);
                        entityskeletonhorse.func_70107_b(forsaken.field_70165_t, forsaken.field_70163_u, forsaken.field_70161_v);
                        entityskeletonhorseMinionData.setCaster((EntityLivingBase)player);
                        entityskeletonhorseMinionData.setLifetime(skeleton.getLifetime());
                        world.func_72838_d((Entity)entityskeletonhorse);
                        forsaken.func_184220_m((Entity)entityskeletonhorse);
                        return;
                    }
                }
                forsaken.func_85036_m();
                world.func_72838_d((Entity)forsaken);
                event.setCanceled(true);
            }
            if (unburiedRings > 0 && !mobChanged && event.getEntity() instanceof EntityZombieMinion) {
                EntityZombieMinion zombie = (EntityZombieMinion)event.getEntity();
                EntityUnburied minion = new EntityUnburied(event.getWorld());
                SummonedCreatureData minionData = SummonedCreatureData.get((EntityLivingBase)minion);
                minion.func_70107_b(zombie.field_70165_t, zombie.field_70163_u, zombie.field_70161_v);
                minionData.setCaster((EntityLivingBase)player);
                minionData.setLifetime(zombie.getLifetime());
                if (unburiedRings == 2) {
                    int i = event.getWorld().field_73012_v.nextInt(gotHelmetCharm ? 4 : 5);
                    switch (i) {
                        case 0: {
                            minion.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151051_r));
                            break;
                        }
                        case 1: {
                            minion.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(Items.field_185159_cQ));
                            break;
                        }
                        case 2: {
                            minion.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T));
                            break;
                        }
                        case 3: {
                            minion.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S));
                            break;
                        }
                        case 4: {
                            minion.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151027_R));
                            break;
                        }
                        case 5: {
                            minion.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                        }
                    }
                    if (gotHelmetCharm) {
                        minion.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
                    }
                }
                event.getWorld().func_72838_d((Entity)minion);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDamageEvent(LivingDamageEvent event) {
        if (event.getEntity() instanceof EntityPlayer && event.getSource().func_76346_g() != null && WizardryUtilsTools.isEntityConsideredUndead((Entity)event.getSource().func_76346_g()) && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)event.getEntity()), (Item)NDItems.amulet_necromantic_ward)) {
            event.setAmount(event.getAmount() * 0.85f);
        }
    }

    private static ItemStack addCharmProgress(ItemStack stack, int newProgress) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int progress = 0;
        if (newProgress != 0) {
            progress = nbt.func_74764_b("progress") ? Math.min(100, nbt.func_74762_e("progress") + newProgress) : newProgress;
        }
        nbt.func_74768_a("progress", progress);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack getForsakenShield() {
        ItemStack shield = new ItemStack(Items.field_185159_cQ);
        NBTTagList patternsList = new NBTTagList();
        shield.func_190925_c("BlockEntityTag").func_74782_a("Patterns", (NBTBase)patternsList);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("Pattern", AddRecipes.PATTERN_SKELETONKING.func_190993_b());
        tag.func_74768_a("Color", EnumDyeColor.PURPLE.func_176767_b());
        patternsList.func_74742_a((NBTBase)tag);
        shield.func_190925_c("BlockEntityTag").func_74768_a("Base", EnumDyeColor.BLACK.func_176767_b());
        return shield;
    }
}

