/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.necromancersdelight.entity.living;

import com.Fishmod.mod_LavaCow.entities.EntityParasite;
import com.Fishmod.mod_LavaCow.init.FishItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.entity.living.EntityZombieMinion;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.util.AllyDesignationSystem;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public class EntityLeechMinionBase
extends EntitySpider
implements ISummonedCreature {
    private static final DataParameter<Boolean> SPAWN_PARTICLES = EntityDataManager.func_187226_a(EntityZombieMinion.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lifetime = -1;
    private UUID casterUUID;

    public EntityLeechMinionBase(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.3f);
        this.field_70728_aV = 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SPAWN_PARTICLES, (Object)true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIParasiteAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, true, this.getTargetSelector()));
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public UUID func_184753_b() {
        return this.casterUUID;
    }

    public void setOwnerId(UUID uuid) {
        this.casterUUID = uuid;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 0;
    }

    protected boolean func_146066_aG() {
        return false;
    }

    protected Item func_146068_u() {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    public boolean func_98052_bS() {
        return false;
    }

    protected boolean func_70692_ba() {
        return this.getCaster() == null && this.func_184753_b() == null;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> entityType) {
        return !EntityFlying.class.isAssignableFrom(entityType);
    }

    public ITextComponent func_145748_c_() {
        if (this.getCaster() != null) {
            return new TextComponentTranslation("entity.ebwizardry:summonedcreature.nameplate", new Object[]{this.getCaster().func_70005_c_(), new TextComponentTranslation("entity." + this.func_70022_Q() + ".name", new Object[0])});
        }
        return super.func_145748_c_();
    }

    public boolean func_145818_k_() {
        return Wizardry.settings.summonedCreatureNames && this.getCaster() != null;
    }

    public void func_70071_h_() {
        if (this.func_184187_bx() != null) {
            this.func_70080_a(this.func_184187_bx().field_70165_t, this.func_184187_bx().field_70163_u, this.func_184187_bx().field_70161_v, this.func_184187_bx().field_70177_z, this.func_184187_bx().field_70125_A);
        }
        super.func_70071_h_();
        this.updateDelegate();
    }

    public void func_70636_d() {
        if (this.func_184187_bx() != null && this.func_184187_bx() instanceof EntityLivingBase && this.func_70613_aW()) {
            this.attachedLogic();
        }
        super.func_70636_d();
    }

    public void attachedLogic() {
        if (this.func_184187_bx() != null && this.func_184187_bx().func_70027_ad()) {
            this.func_70015_d(20);
        }
    }

    public void func_70604_c(EntityLivingBase entity) {
        if (this.shouldRevengeTarget(entity)) {
            super.func_70604_c(entity);
        }
    }

    public void onSpawn() {
        if (((Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES)).booleanValue()) {
            this.spawnParticleEffect();
        }
    }

    public void onDespawn() {
        this.spawnParticleEffect();
    }

    private void spawnParticleEffect() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 15; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * 2.0f), this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean hasParticleEffect() {
        return true;
    }

    public boolean hasAnimation() {
        return (Boolean)this.field_70180_af.func_187225_a(SPAWN_PARTICLES) != false || this.field_70173_aa > 20;
    }

    public void hideParticles() {
        this.field_70180_af.func_187227_b(SPAWN_PARTICLES, (Object)false);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return this.interactDelegate(player, hand) || super.func_184645_a(player, hand);
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(this.field_70170_p.field_72995_K || !(entityIn instanceof EntityLivingBase) || AllyDesignationSystem.isAllied((EntityLivingBase)((EntityLivingBase)entityIn), (EntityLivingBase)this) || entityIn instanceof EntityParasite || entityIn instanceof EntityLeechMinionBase)) {
            this.func_184220_m(entityIn);
            this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(entityIn));
            this.field_70703_bu = false;
            this.field_70699_by.func_75499_g();
            this.setLifetime(-1);
            this.func_70624_b((EntityLivingBase)entityIn);
        }
    }

    public float func_70047_e() {
        return 0.1f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return FishItems.ENTITY_PARASITE_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return FishItems.ENTITY_PARASITE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return FishItems.ENTITY_PARASITE_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187852_fb, 0.15f, 1.0f);
    }

    static class AIParasiteAttack
    extends EntityAIAttackMelee {
        public AIParasiteAttack(EntityLeechMinionBase leech) {
            super((EntityCreature)leech, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return attackTarget.field_70130_N + 0.1f;
        }
    }
}

