/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class PlainsStructures {
    public static ArrayList<BlueprintData> getRandomPlainsDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 1;
        return PlainsStructures.getPlainsDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getPlainsDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        IBlockState biomeLogVertState;
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), materialType, biome, disallowModSubs);
        IBlockState biomeStrippedWoodOrLogOrLogVerticState = biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), materialType, biome, disallowModSubs);
        biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedWoodState(biomeLogVertState, 0);
        if (biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150364_r || biomeStrippedWoodOrLogOrLogVerticState.func_177230_c() == Blocks.field_150363_s) {
            if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
            } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                biomeStrippedWoodOrLogOrLogVerticState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
            }
        }
        switch (decorType) {
            case 0: {
                BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 2, 0, biomeFenceState);
                BlueprintData.addPlaceBlock(blueprint, 0, 3, 0, biomeStrippedWoodOrLogOrLogVerticState);
                for (int[] lamp_uwm : new int[][]{{-1, 0, 3}, {1, 0, 1}, {0, -1, 2}, {0, 1, 0}}) {
                    BlueprintData.addPlaceBlock(blueprint, lamp_uwm[0], 3, lamp_uwm[1], Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(lamp_uwm[2])));
                }
                break;
            }
        }
        return blueprint;
    }

    public static class PlainsStreetDecor1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 6;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsStreetDecor1() {
        }

        public PlainsStreetDecor1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsStreetDecor1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)6, (EnumFacing)coordBaseMode);
            return PlainsStreetDecor1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsStreetDecor1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{-2, 1, 2, 3, 4}, new double[]{1.0, 6.0, 6.0, 4.0, 2.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l() && decorDepth >= 0) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsWeaponsmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"           ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", " FFF       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 6;
        private int averageGroundLevel = -1;

        public PlainsWeaponsmith1() {
        }

        public PlainsWeaponsmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsWeaponsmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsWeaponsmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsWeaponsmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 6 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 6)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 9, 0, 7}, {0, 1, 5, 2, 3, 6}, {3, 1, 4, 3, 3, 6}, {4, 1, 4, 4, 3, 4}, {0, 0, 7, 5, 4, 7}, {0, 4, 1, 8, 4, 6}, {1, 5, 6, 2, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150347_e.func_176203_a(0), Blocks.field_150347_e.func_176203_a(0), false);
            }
            for (int[] uvw : new int[][]{{1, 6, 6}}) {
                this.func_175811_a(world, Blocks.field_150463_bK.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 5, 1, 4, 5, 1}, {0, 5, 2, 0, 5, 6}, {0, 5, 7, 4, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150333_U.func_176203_a(0), Blocks.field_150333_U.func_176203_a(0), false);
            }
            this.func_175804_a(world, structureBB, 1, 2, 5, 2, 2, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 1, 1, 6, 2, 1, 6, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 0, 2, 5, 0, 2, 6, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 1, 2, 6, 3, 3}, {7, 1, 1, 8, 3, 1}, {7, 5, 1, 8, 6, 1}, {7, 1, 7, 8, 3, 7}, {7, 5, 7, 8, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvwo : new int[][]{{5, 2, 3, 3}, {1, 2, 8, 0}, {8, 2, 6, 2}, {3, 5, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{9, 1, 2, 9, 3, 6}, {9, 5, 2, 9, 6, 6}, {8, 1, 6, 8, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(1)), 10, 2, 4, structureBB);
            this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(3)), 8, 5, 4, structureBB);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{6, 0, 1, 6, 5, 1}, {9, 0, 1, 9, 5, 1}, {6, 0, 7, 6, 5, 7}, {9, 0, 7, 9, 5, 7}, {5, 1, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{9, 4, 2, 9, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 2, 7, 5, 2, 7}, {7, 4, 1, 8, 4, 1}, {7, 4, 7, 8, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 3, 1}, {4, 1, 1, 4, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvw : new int[][]{{4, 2, 7}, {9, 2, 3}, {9, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{5, 5, 0, 5, 5, 8, 0}, {6, 6, 0, 6, 6, 8, 0}, {7, 7, 0, 7, 7, 8, 0}, {8, 7, 0, 8, 7, 8, 1}, {9, 6, 0, 9, 6, 8, 1}, {10, 5, 0, 10, 5, 8, 1}, {6, 5, 0, 6, 5, 0, 5}, {9, 5, 0, 9, 5, 0, 4}, {7, 6, 0, 7, 6, 0, 5}, {8, 6, 0, 8, 6, 0, 4}, {6, 5, 8, 6, 5, 8, 5}, {9, 5, 8, 9, 5, 8, 4}, {7, 6, 8, 7, 6, 8, 5}, {8, 6, 8, 8, 6, 8, 4}, {7, 1, 6, 7, 1, 6, 3}, {8, 1, 5, 8, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150452_aw.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{7, 1, 5}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeWoodPressurePlateState, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{1, 0, 0, 3, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150446_ar.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), Blocks.field_150446_ar.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwo : new int[][]{{1, 1, 2, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwo[3], this.func_186165_e(), uvwo[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 2, 4, 2}, {3, 3, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 6;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_weaponsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 2, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 0, -1}, {2, 0, -1}, {3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                int w;
                int u;
                this.entitiesGenerated = true;
                int v = 1;
                if (random.nextInt(14) < 8) {
                    u = 2 + random.nextInt(4);
                    w = 2 + random.nextInt(2);
                } else {
                    u = 7 + random.nextInt(2);
                    w = 2 + random.nextInt(3);
                }
                if (u > 9) {
                    u -= 2;
                    w -= 2;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class PlainsToolSmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"            ", " FFFFFFFFFF ", " FFFFFFFFFF ", " FFFFFFFFFF ", " FFFFFFFFFF ", "       FFFF ", "       FFFF ", "        FF  ", "        FF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 6;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsToolSmith1() {
        }

        public PlainsToolSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsToolSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsToolSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsToolSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 6 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 6), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 4, 10, 0, 7}, {7, 0, 2, 10, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 4, 1, 3, 4}, {1, 0, 7, 1, 3, 7}, {7, 0, 2, 7, 3, 2}, {10, 0, 2, 10, 3, 2}, {7, 0, 4, 7, 3, 4}, {10, 0, 7, 10, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 5, 1, 4, 6}, {2, 1, 4, 6, 3, 4}, {10, 1, 3, 10, 4, 6}, {2, 1, 7, 9, 3, 7}, {7, 1, 3, 7, 3, 3}, {8, 3, 2, 9, 4, 2}, {2, 1, 5, 2, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{3, 2, 4, 5, 2, 4}, {3, 2, 7, 8, 2, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{0, 2, 4, 3}, {0, 2, 7, 3}, {7, 2, 1, 2}, {10, 2, 1, 2}, {4, 3, 6, 2}, {7, 3, 6, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 2, 4}, {4, 2, 7}, {7, 2, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 3, 3, 5, 3, 3, 3}, {0, 4, 4, 6, 4, 4, 3}, {11, 4, 4, 11, 4, 4, 3}, {0, 5, 5, 7, 5, 5, 3}, {10, 5, 5, 11, 5, 5, 3}, {0, 5, 6, 11, 5, 6, 2}, {0, 4, 7, 11, 4, 7, 2}, {0, 3, 8, 11, 3, 8, 2}, {6, 3, 1, 6, 3, 3, 0}, {7, 4, 1, 7, 4, 4, 0}, {8, 5, 1, 8, 5, 5, 0}, {9, 5, 1, 9, 5, 5, 1}, {10, 4, 1, 10, 4, 4, 1}, {11, 3, 1, 11, 3, 3, 1}, {0, 3, 4, 0, 3, 4, 6}, {0, 4, 5, 0, 4, 5, 6}, {0, 4, 6, 0, 4, 6, 7}, {0, 3, 7, 0, 3, 7, 7}, {11, 3, 4, 11, 3, 4, 6}, {11, 4, 5, 11, 4, 5, 6}, {11, 4, 6, 11, 4, 6, 7}, {11, 3, 7, 11, 3, 7, 7}, {7, 3, 1, 7, 3, 1, 5}, {8, 4, 1, 8, 4, 1, 5}, {9, 4, 1, 9, 4, 1, 4}, {10, 3, 1, 10, 3, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{8, 0, 1, 9, 0, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState smithingTableBlockState = ModObjects.chooseModSmithingTable(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{2, 1, 6}}) {
                this.func_175811_a(world, smithingTableBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{8, 1, 2, 2, 1, 1}, {9, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(9);
                int v = 1;
                int w = 5 + random.nextInt(2);
                if (u > 9) {
                    u -= 2;
                    w -= 2;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class PlainsTemple4
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"  FFF  ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "FFFFFFF", "FFFFFFF", "FFFFFFF", " FFFFF ", " FFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 12;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsTemple4() {
        }

        public PlainsTemple4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsTemple4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsTemple4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsTemple4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 0, 1, 0, 0}, {5, 0, 0, 5, 0, 0}, {2, 0, 1, 4, 4, 1}, {0, 0, 2, 0, 4, 4}, {1, 4, 2, 1, 10, 4}, {1, 0, 5, 1, 4, 8}, {6, 0, 2, 6, 4, 4}, {5, 4, 2, 5, 10, 4}, {5, 0, 5, 5, 4, 8}, {2, 0, 9, 4, 4, 9}, {2, 6, 5, 4, 10, 5}, {1, 0, 2, 2, 0, 4}, {4, 0, 2, 5, 0, 4}, {3, 0, 4, 3, 0, 4}, {2, 0, 5, 4, 0, 8}, {2, 1, 7, 2, 1, 8}, {3, 1, 8, 3, 1, 8}, {4, 1, 7, 4, 1, 8}, {2, 5, 1, 4, 5, 8}, {2, 9, 2, 4, 9, 4}, {1, 9, 1, 1, 9, 1}, {5, 9, 1, 5, 9, 1}, {1, 9, 5, 1, 9, 5}, {5, 9, 5, 5, 9, 5}, {3, 11, 5, 3, 11, 5}, {1, 11, 3, 1, 11, 3}, {5, 11, 3, 5, 11, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 1, 0}, {5, 1, 0}}) {
                this.func_175811_a(world, biomeCobblestoneWallState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeCobblestoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{0, 5, 3}, {6, 5, 3}}) {
                this.func_175811_a(world, biomeCobblestoneSlabBottomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 2, 0, -1}, {5, 2, 0, -1}, {3, 2, 2, 0}, {2, 4, 7, 1}, {3, 4, 8, 2}, {4, 4, 7, 3}, {2, 7, 2, 1}, {4, 7, 2, 3}, {3, 6, 7, -1}, {3, 10, 3, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 6, 1, 4, 10, 1}, {3, 11, 1, 3, 11, 1}, {1, 0, 1, 1, 3, 2}, {5, 0, 1, 5, 3, 2}, {1, 0, 3, 1, 3, 2}, {5, 0, 3, 5, 3, 2}, {1, 1, 4, 1, 3, 4}, {5, 1, 4, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{3, 3, 1}, {3, 7, 1}, {0, 2, 3}, {1, 2, 7}, {1, 7, 3}, {6, 2, 3}, {5, 2, 7}, {5, 7, 3}, {3, 7, 5}, {3, 2, 9}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(i == 0 ? (GeneralConfig.useVillageColors ? this.townColor : 4) : (GeneralConfig.useVillageColors ? this.townColor2 : 0)), uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{1, 4, 1, 1, 4, 1, 0}, {1, 8, 1, 1, 8, 1, 4}, {1, 8, 5, 1, 8, 5, 4}, {5, 4, 1, 5, 4, 1, 1}, {5, 8, 1, 5, 8, 1, 5}, {5, 8, 5, 5, 8, 5, 5}, {0, 4, 2, 0, 4, 2, 3}, {0, 4, 4, 0, 4, 4, 2}, {6, 4, 2, 6, 4, 2, 3}, {6, 4, 4, 6, 4, 4, 2}, {3, 0, 3, 3, 0, 3, 3}, {1, 1, 3, 1, 1, 3, 1}, {5, 1, 3, 5, 1, 3, 0}, {2, 2, 8, 2, 2, 8, 1}, {4, 2, 8, 4, 2, 8, 0}, {2, 1, 6, 2, 1, 6, 3}, {3, 1, 7, 3, 1, 7, 3}, {4, 1, 6, 4, 1, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{4, 1, 4, 4, 10, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            for (int[] uvw : new int[][]{{2, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 0, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 1;
                int w = 4;
                while (u == 2 && w == 4) {
                    u = 2 + random.nextInt(3);
                    w = 2 + random.nextInt(7);
                    if (u == 3 && w == 2) {
                        v = 0;
                        continue;
                    }
                    if ((u == 2 || u == 4) && (w == 6 || w == 7) || u == 3 && (w == 7 || w == 8)) {
                        v = 2;
                        continue;
                    }
                    if ((u == 2 || u == 4) && w == 8) {
                        v = 3;
                        continue;
                    }
                    v = 1;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class PlainsTemple3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsTemple3() {
        }

        public PlainsTemple3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsTemple3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsTemple3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsTemple3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 4, 1}, {2, 1, 9, 4, 4, 9}, {1, 1, 2, 1, 4, 4}, {1, 1, 6, 1, 4, 8}, {5, 1, 2, 5, 4, 4}, {5, 1, 6, 5, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{1, 0, 0}, {5, 0, 0}}) {
                this.func_175811_a(world, biomeCobblestoneWallState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 1, 0, -1}, {5, 1, 0, -1}, {3, 4, 2, 0}, {3, 4, 8, 2}, {3, 4, 10, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 0, 1, 1, 4, 1}, {5, 0, 1, 5, 4, 1}, {1, 0, 5, 1, 4, 5}, {5, 0, 5, 5, 4, 5}, {1, 0, 9, 1, 4, 9}, {5, 0, 9, 5, 4, 9}, {2, 4, 1, 2, 4, 1}, {4, 4, 1, 4, 4, 1}, {2, 4, 9, 2, 4, 9}, {4, 4, 9, 4, 4, 9}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 5, 1, 4, 5, 1}, {2, 5, 8, 4, 5, 8}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 0, 1}, {1, 0, 2, 1, 0, 4}, {1, 0, 6, 1, 0, 8}, {5, 0, 2, 5, 0, 4}, {5, 0, 6, 5, 0, 8}, {2, 0, 9, 4, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 8}, {1, 5, 2, 1, 5, 4}, {1, 5, 6, 1, 5, 8}, {5, 5, 2, 5, 5, 4}, {5, 5, 6, 5, 5, 8}, {3, 6, 0, 3, 6, 10}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {1, 2, 7}, {5, 2, 3}, {5, 2, 7}, {3, 2, 9}}) {
                this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 3, 3}, {1, 3, 7}, {5, 3, 3}, {5, 3, 7}}) {
                this.func_175811_a(world, Blocks.field_150397_co.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 4, 0, 0, 4, 1, 0}, {0, 4, 5, 0, 4, 5, 0}, {0, 4, 9, 0, 4, 10, 0}, {1, 5, 0, 1, 5, 1, 0}, {1, 5, 5, 1, 5, 5, 0}, {1, 5, 9, 1, 5, 10, 0}, {2, 6, 0, 2, 6, 10, 0}, {0, 5, 2, 0, 5, 2, 3}, {0, 5, 3, 0, 5, 3, 0}, {0, 5, 4, 0, 5, 4, 2}, {0, 5, 6, 0, 5, 6, 3}, {0, 5, 7, 0, 5, 7, 0}, {0, 5, 8, 0, 5, 8, 2}, {6, 5, 2, 6, 5, 2, 3}, {6, 5, 3, 6, 5, 3, 1}, {6, 5, 4, 6, 5, 4, 2}, {6, 5, 6, 6, 5, 6, 3}, {6, 5, 7, 6, 5, 7, 1}, {6, 5, 8, 6, 5, 8, 2}, {4, 6, 0, 4, 6, 10, 1}, {5, 5, 0, 5, 5, 1, 1}, {5, 5, 5, 5, 5, 5, 1}, {5, 5, 9, 5, 5, 10, 1}, {6, 4, 0, 6, 4, 1, 1}, {6, 4, 5, 6, 4, 5, 1}, {6, 4, 9, 6, 4, 10, 1}, {1, 4, 0, 1, 4, 0, 5}, {2, 5, 0, 2, 5, 0, 5}, {4, 5, 0, 4, 5, 0, 4}, {5, 4, 0, 5, 4, 0, 4}, {1, 4, 10, 1, 4, 10, 5}, {2, 5, 10, 2, 5, 10, 5}, {4, 5, 10, 4, 5, 10, 4}, {5, 4, 10, 5, 4, 10, 4}, {0, 4, 2, 0, 4, 2, 6}, {0, 4, 4, 0, 4, 4, 7}, {0, 4, 6, 0, 4, 6, 6}, {0, 4, 8, 0, 4, 8, 7}, {6, 4, 2, 6, 4, 2, 6}, {6, 4, 4, 6, 4, 4, 7}, {6, 4, 6, 6, 4, 6, 6}, {6, 4, 8, 6, 4, 8, 7}, {2, 1, 2, 2, 1, 5, 1}, {4, 1, 2, 4, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{2, 0, 0, 2, 0, 0, 0}, {3, 0, 0, 3, 0, 0, 3}, {4, 0, 0, 4, 0, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvw : new int[][]{{3, 1, 7}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3;
                int v = 1;
                int w = 7;
                while (u == 3 && w == 7) {
                    u = 2 + random.nextInt(3);
                    v = 1;
                    w = 6 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class PlainsTannery1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"          ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", "  FFF FFF ", "      FFF ", " F   F F  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 2;
        private int averageGroundLevel = -1;

        public PlainsTannery1() {
        }

        public PlainsTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 6, 3, 3}, {2, 0, 6, 7, 3, 6}, {1, 0, 4, 1, 4, 5}, {8, 0, 3, 8, 4, 5}, {7, 0, 2, 7, 0, 2}, {7, 3, 2, 7, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 5, 4, 9, 5, 4}, {5, 4, 3, 8, 4, 3}, {7, 4, 1, 7, 4, 2}, {2, 0, 4, 7, 0, 5}, {7, 0, 3, 7, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 3, 0, 5, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{8, 2, 4}, {6, 2, 6}, {3, 2, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 3, 2, 4, 3, 2, 3}, {0, 4, 3, 4, 4, 3, 3}, {0, 5, 4, 4, 5, 4, 3}, {9, 4, 2, 9, 4, 2, 3}, {5, 5, 3, 9, 5, 3, 3}, {5, 3, 1, 5, 3, 2, 0}, {6, 4, 1, 6, 4, 2, 0}, {8, 4, 1, 8, 4, 2, 1}, {9, 3, 1, 9, 3, 1, 1}, {0, 3, 7, 9, 3, 7, 2}, {0, 4, 6, 9, 4, 6, 2}, {0, 5, 5, 9, 5, 5, 2}, {6, 3, 1, 6, 3, 1, 5}, {8, 3, 1, 8, 3, 1, 4}, {0, 3, 6, 0, 3, 6, 7}, {0, 4, 5, 0, 4, 5, 7}, {0, 4, 4, 0, 4, 4, 6}, {0, 3, 3, 0, 3, 3, 6}, {9, 4, 5, 9, 4, 5, 7}, {9, 3, 6, 9, 3, 6, 7}, {9, 4, 3, 9, 4, 3, 6}, {9, 3, 2, 9, 3, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{7, 0, 1, 7, 0, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 0, 1, 2, 0}, {5, 0, 0, 5, 2, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{6, 0, 1}, {8, 0, 1}}) {
                this.func_175811_a(world, biomeCobblestoneWallState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{6, 1, 1, -1}, {8, 1, 1, -1}, {7, 3, 3, 0}, {2, 3, 4, 1}, {2, 3, 5, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 0, 3, 1, 3, 3}, {1, 0, 6, 1, 3, 6}, {8, 0, 2, 8, 3, 2}, {8, 0, 6, 8, 3, 6}, {6, 0, 2, 6, 3, 2}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState smoothStoneState = ModObjects.chooseModSmoothStoneBlockState();
            this.func_175811_a(world, smoothStoneState, 2, 1, 4, structureBB);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 2}, {2, 1, 5, 2, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150383_bp.func_176203_a(3), Blocks.field_150383_bp.func_176203_a(3), false);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{7, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 7;
            int chestV = 1;
            int chestW = 5;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_tannery");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvw : (ChestGenHooks)new int[][]{{7, 0, -1}}) {
                Object pathU = uvw[0];
                Object pathV = uvw[1];
                Object pathW = uvw[2];
                this.func_74871_b(world, (int)pathU, (int)pathV, (int)pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, (int)pathU, (int)(pathV - 2), (int)pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW)))) {
                    this.func_175811_a(world, biomeGrassState, (int)pathU, (int)(pathV - true), (int)pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a((int)pathU, (int)pathW), this.func_74862_a((int)(pathV - true)), this.func_74873_b((int)pathU, (int)pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(4);
                int v = 1;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class PlainsStable2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{" F               ", "FFFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFFF ", "   F     FP      "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 2;
        private int averageGroundLevel = -1;

        public PlainsStable2() {
        }

        public PlainsStable2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsStable2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsStable2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsStable2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{6, 1, 1, 14, 3, 1}, {5, 4, 2, 5, 4, 4}, {6, 1, 5, 14, 3, 5}, {15, 1, 2, 15, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{5, 1, 1, 5, 3, 1}, {8, 1, 1, 8, 3, 1}, {12, 1, 1, 12, 3, 1}, {15, 1, 1, 15, 3, 1}, {5, 1, 5, 5, 3, 5}, {8, 1, 5, 8, 3, 5}, {12, 1, 5, 12, 3, 5}, {15, 1, 5, 15, 3, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{5, 3, 2, 5, 3, 4}, {13, 1, 2, 13, 1, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 5, 3, 16, 5, 3}, {9, 4, 1, 11, 4, 1}, {9, 4, 5, 11, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodDoubleSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150373_bw.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 2, 4, 4, 2}, {2, 4, 4, 4, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodDoubleSlabState, biomeWoodDoubleSlabState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 3, 3, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 4, 3, 4, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{15, 2, 3}, {10, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 3, 0, 3}, {5, 3, 0, 3}, {6, 3, 0, 3}, {7, 3, 0, 3}, {8, 3, 0, 3}, {9, 4, 0, 3}, {10, 4, 0, 3}, {11, 4, 0, 3}, {12, 3, 0, 3}, {13, 3, 0, 3}, {14, 3, 0, 3}, {15, 3, 0, 3}, {16, 3, 0, 3}, {2, 4, 1, 3}, {3, 4, 1, 3}, {4, 4, 1, 3}, {5, 4, 1, 3}, {6, 4, 1, 3}, {7, 4, 1, 3}, {8, 4, 1, 3}, {12, 4, 1, 3}, {13, 4, 1, 3}, {14, 4, 1, 3}, {15, 4, 1, 3}, {16, 4, 1, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {6, 5, 2, 3}, {7, 5, 2, 3}, {8, 5, 2, 3}, {9, 5, 2, 3}, {10, 5, 2, 3}, {11, 5, 2, 3}, {12, 5, 2, 3}, {13, 5, 2, 3}, {14, 5, 2, 3}, {15, 5, 2, 3}, {16, 5, 2, 3}, {4, 5, 4, 2}, {5, 5, 4, 2}, {6, 5, 4, 2}, {7, 5, 4, 2}, {8, 5, 4, 2}, {9, 5, 4, 2}, {10, 5, 4, 2}, {11, 5, 4, 2}, {12, 5, 4, 2}, {13, 5, 4, 2}, {14, 5, 4, 2}, {15, 5, 4, 2}, {16, 5, 4, 2}, {2, 4, 5, 2}, {3, 4, 5, 2}, {4, 4, 5, 2}, {5, 4, 5, 2}, {6, 4, 5, 2}, {7, 4, 5, 2}, {8, 4, 5, 2}, {12, 4, 5, 2}, {13, 4, 5, 2}, {14, 4, 5, 2}, {15, 4, 5, 2}, {16, 4, 5, 2}, {4, 3, 6, 2}, {5, 3, 6, 2}, {6, 3, 6, 2}, {7, 3, 6, 2}, {8, 3, 6, 2}, {9, 4, 6, 2}, {10, 4, 6, 2}, {11, 4, 6, 2}, {12, 3, 6, 2}, {13, 3, 6, 2}, {14, 3, 6, 2}, {15, 3, 6, 2}, {16, 3, 6, 2}, {4, 3, 1, 6}, {4, 3, 5, 7}, {16, 3, 1, 6}, {16, 3, 5, 7}, {16, 4, 2, 6}, {16, 4, 4, 7}, {9, 3, 0, 5}, {11, 3, 0, 4}, {9, 3, 6, 5}, {11, 3, 6, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 1, 4, 1, 1}, {0, 1, 5, 4, 1, 5}, {0, 1, 2, 0, 1, 4}, {2, 2, 1, 2, 3, 1}, {2, 2, 5, 2, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 3, 3}, {6, 3, 3, 1}, {10, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{10, 1, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{6, 1, 2}, {7, 1, 4}, {8, 1, 4}, {8, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{9, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(4), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 4, 0, 5}, {5, 0, 2, 14, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            this.func_175804_a(world, structureBB, 14, 1, 2, 14, 1, 4, Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            for (int[] uvw : new int[][]{{10, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{2, 1, 3}, {4, 1, 3}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                        String[] petname_a = NameGenerator.newRandomName("pet", random);
                        animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                    }
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsStable1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFF          ", "FFFFFF F      F ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF ", "FFFFFF P        ", "FFFFFF P   F   F"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 4;
        private int averageGroundLevel = -1;

        public PlainsStable1() {
        }

        public PlainsStable1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsStable1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsStable1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsStable1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] decorUVW : new int[][]{{1, 1, 6}, {11, 1, 0}, {15, 1, 0}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 2, 14, 4, 2}, {5, 1, 6, 14, 4, 6}, {14, 1, 2, 14, 4, 6}, {14, 5, 3, 14, 5, 5}, {5, 4, 2, 5, 4, 6}, {5, 5, 3, 5, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{12, 1, 3, 12, 1, 5}, {14, 2, 3, 14, 2, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{9, 2, 2, 13, 2, 2}, {8, 2, 6, 12, 2, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 6, 4, 15, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{10, 2, 2}, {12, 2, 2}, {9, 2, 6}, {11, 2, 6}, {14, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 4, 1, 3}, {5, 4, 1, 3}, {6, 4, 1, 3}, {7, 4, 1, 3}, {8, 4, 1, 3}, {9, 4, 1, 3}, {10, 4, 1, 3}, {11, 4, 1, 3}, {12, 4, 1, 3}, {13, 4, 1, 3}, {14, 4, 1, 3}, {15, 4, 1, 3}, {4, 5, 2, 3}, {5, 5, 2, 3}, {6, 5, 2, 3}, {7, 5, 2, 3}, {8, 5, 2, 3}, {9, 5, 2, 3}, {10, 5, 2, 3}, {11, 5, 2, 3}, {12, 5, 2, 3}, {13, 5, 2, 3}, {14, 5, 2, 3}, {15, 5, 2, 3}, {4, 6, 3, 3}, {5, 6, 3, 3}, {6, 6, 3, 3}, {7, 6, 3, 3}, {8, 6, 3, 3}, {9, 6, 3, 3}, {10, 6, 3, 3}, {11, 6, 3, 3}, {12, 6, 3, 3}, {13, 6, 3, 3}, {14, 6, 3, 3}, {15, 6, 3, 3}, {4, 6, 5, 2}, {5, 6, 5, 2}, {6, 6, 5, 2}, {7, 6, 5, 2}, {8, 6, 5, 2}, {9, 6, 5, 2}, {10, 6, 5, 2}, {11, 6, 5, 2}, {12, 6, 5, 2}, {13, 6, 5, 2}, {14, 6, 5, 2}, {15, 6, 5, 2}, {4, 5, 6, 2}, {5, 5, 6, 2}, {6, 5, 6, 2}, {7, 5, 6, 2}, {8, 5, 6, 2}, {9, 5, 6, 2}, {10, 5, 6, 2}, {11, 5, 6, 2}, {12, 5, 6, 2}, {13, 5, 6, 2}, {14, 5, 6, 2}, {15, 5, 6, 2}, {4, 4, 7, 2}, {5, 4, 7, 2}, {6, 4, 7, 2}, {7, 4, 7, 2}, {8, 4, 7, 2}, {9, 4, 7, 2}, {10, 4, 7, 2}, {11, 4, 7, 2}, {12, 4, 7, 2}, {13, 4, 7, 2}, {14, 4, 7, 2}, {15, 4, 7, 2}, {4, 4, 2, 6}, {4, 5, 3, 6}, {4, 5, 5, 7}, {4, 4, 6, 7}, {15, 4, 2, 6}, {15, 5, 3, 6}, {15, 5, 5, 7}, {15, 4, 6, 7}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{5, 3, 3, 6}, {5, 3, 5, 7}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 8}, {5, 1, 0, 5, 1, 1}, {5, 1, 7, 5, 1, 8}, {1, 1, 0, 4, 1, 0}, {1, 1, 8, 4, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{4, 4, 4, 3}, {15, 4, 4, 1}, {6, 4, 4, 1}, {13, 4, 4, 3}, {10, 4, 3, 0}, {10, 4, 5, 2}, {0, 2, 0, -1}, {5, 2, 0, -1}, {0, 2, 8, -1}, {5, 2, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{7, 1, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, 3}, {5, 1, 5}, {8, 1, 3}, {9, 1, 3}, {8, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 0, 5, 0, 8}, {5, 0, 3, 13, 0, 5}, {7, 0, 2, 7, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            this.func_175804_a(world, structureBB, 13, 1, 3, 13, 1, 5, Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            for (int[] uvw : new int[][]{{7, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{2, 1, 2}, {10, 1, 4}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                        String[] petname_a = NameGenerator.newRandomName("pet", random);
                        animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                    }
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse8
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"    F    ", "   FFF   ", "  FFFFF  ", " FFFFFFF ", "FFFFFFFFF", " FFFFFFF ", "  FFFFF  ", "   FPF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse8() {
        }

        public PlainsSmallHouse8(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse8 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse8.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse8(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 2, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 2, 1, 2, 6, 1}, {6, 2, 1, 6, 6, 1}, {2, 2, 5, 2, 6, 5}, {6, 2, 5, 6, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 1, 5, 7, 1}, {3, 2, 5, 5, 7, 5}, {2, 2, 2, 2, 6, 4}, {6, 2, 2, 6, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{3, 6, 1, 5, 6, 1}, {3, 6, 5, 5, 6, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 2, 2, 5, 2, 4}, {2, 7, 2, 2, 7, 4}, {6, 7, 2, 6, 7, 4}, {3, 8, 2, 5, 8, 4}, {4, 8, 0, 4, 8, 1}, {4, 8, 5, 4, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{2, 4, 3}, {2, 7, 3}, {6, 4, 3}, {6, 7, 3}, {4, 4, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 6, 0, 0}, {1, 6, 1, 0}, {2, 7, 0, 0}, {2, 7, 1, 0}, {3, 8, 0, 0}, {3, 8, 1, 0}, {1, 6, 2, 0}, {1, 6, 3, 0}, {1, 6, 4, 0}, {1, 6, 5, 0}, {1, 6, 6, 0}, {2, 7, 5, 0}, {2, 7, 6, 0}, {3, 8, 5, 0}, {3, 8, 6, 0}, {2, 8, 2, 3}, {2, 8, 3, 0}, {2, 8, 4, 2}, {7, 6, 0, 1}, {7, 6, 1, 1}, {6, 7, 0, 1}, {6, 7, 1, 1}, {5, 8, 0, 1}, {5, 8, 1, 1}, {7, 6, 2, 1}, {7, 6, 3, 1}, {7, 6, 4, 1}, {7, 6, 5, 1}, {7, 6, 6, 1}, {6, 7, 5, 1}, {6, 7, 6, 1}, {5, 8, 5, 1}, {5, 8, 6, 1}, {6, 8, 2, 3}, {6, 8, 3, 1}, {6, 8, 4, 2}, {2, 6, 0, 5}, {3, 7, 0, 5}, {6, 6, 0, 4}, {5, 7, 0, 4}, {2, 6, 6, 5}, {3, 7, 6, 5}, {6, 6, 6, 4}, {5, 7, 6, 4}, {5, 3, 4, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 2, 0, 0}, {4, 2, 0, 3}, {5, 2, 0, 1}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 5, 0, 2}, {4, 6, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 3, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, 2}, {1, 1, 4}, {7, 1, 2}, {7, 1, 4}, {3, 1, 6}, {5, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(7), uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 3}, {7, 1, 3}, {4, 1, 6}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            for (int[] uvw : new int[][]{{4, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{4, 3, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse7
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"        ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", "  FFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse7() {
        }

        public PlainsSmallHouse7(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse7 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse7.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse7(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 1, 3, 1}, {6, 0, 1, 6, 3, 1}, {1, 0, 5, 1, 3, 5}, {6, 0, 5, 6, 3, 5}, {2, 0, 2, 2, 0, 2}, {5, 0, 2, 5, 0, 2}, {2, 0, 4, 2, 0, 4}, {5, 0, 4, 5, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 5, 1, 1}, {2, 3, 1, 5, 4, 1}, {3, 5, 1, 4, 5, 1}, {2, 0, 5, 5, 1, 5}, {2, 3, 5, 5, 4, 5}, {3, 5, 5, 4, 5, 5}, {1, 0, 2, 1, 3, 4}, {6, 0, 2, 6, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 2, 2, 1, 2, 4}, {6, 2, 2, 6, 2, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 2, 1, 5, 2, 1}, {2, 2, 5, 5, 2, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 2, 4, 0, 2}, {2, 0, 3, 5, 0, 3}, {3, 0, 4, 4, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {6, 2, 3}, {3, 2, 5}, {4, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 3, 0, 0}, {0, 3, 1, 0}, {0, 3, 2, 0}, {0, 3, 3, 0}, {0, 3, 4, 0}, {0, 3, 5, 0}, {0, 3, 6, 0}, {1, 4, 0, 0}, {1, 4, 1, 0}, {1, 4, 2, 0}, {1, 4, 3, 0}, {1, 4, 4, 0}, {1, 4, 5, 0}, {1, 4, 6, 0}, {2, 5, 0, 0}, {2, 5, 1, 0}, {2, 5, 2, 0}, {2, 5, 3, 0}, {2, 5, 4, 0}, {2, 5, 5, 0}, {2, 5, 6, 0}, {3, 6, 0, 0}, {3, 6, 1, 0}, {3, 6, 2, 0}, {3, 6, 3, 0}, {3, 6, 4, 0}, {3, 6, 5, 0}, {3, 6, 6, 0}, {4, 6, 0, 1}, {4, 6, 1, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 4, 1}, {4, 6, 5, 1}, {4, 6, 6, 1}, {5, 5, 0, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {5, 5, 6, 1}, {6, 4, 0, 1}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {6, 4, 6, 1}, {7, 3, 0, 1}, {7, 3, 1, 1}, {7, 3, 2, 1}, {7, 3, 3, 1}, {7, 3, 4, 1}, {7, 3, 5, 1}, {7, 3, 6, 1}, {1, 3, 0, 5}, {2, 4, 0, 5}, {3, 5, 0, 5}, {4, 5, 0, 4}, {5, 4, 0, 4}, {6, 3, 0, 4}, {1, 3, 6, 5}, {2, 4, 6, 5}, {3, 5, 6, 5}, {4, 5, 6, 4}, {5, 4, 6, 4}, {6, 3, 6, 4}, {2, 1, 4, 1}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 0, 0, 0}, {3, 0, 0, 3}, {4, 0, 0, 3}, {5, 0, 0, 1}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, 2}, {5, 2, 0, 2}, {3, 3, 2, 0}, {4, 3, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}, {4, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            int chestU = 5;
            int chestV = 1;
            int chestW = 4;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwo : new int[][]{{2, 1, 3, 0}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor : 4);
                }
            }
            for (int[] uvw : new int[][]{{2, 0, -1}, {3, 0, -1}, {4, 0, -1}, {5, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{4, 0, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse6
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "  FFF  ", "   F   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse6() {
        }

        public PlainsSmallHouse6(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse6 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse6.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse6(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var22_46;
            int[] uvwo;
            void var22_44;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 2}, {5, 2}, {1, 5}, {5, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 4, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 5}, {1, 0, 3, 1, 0, 4}, {5, 0, 3, 5, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 4, 3, 1, 4, 4}, {5, 4, 3, 5, 4, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 4, 2, 4, 4, 2}, {2, 4, 5, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomePlankState, 2, 1, 4, structureBB);
            this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(-1)), 2, 2, 4, structureBB);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 4, 3, 2}, {2, 5, 2, 4, 5, 2}, {2, 1, 5, 4, 3, 5}, {2, 5, 5, 4, 5, 5}, {1, 0, 3, 1, 3, 4}, {5, 0, 3, 5, 3, 4}, {3, 6, 1, 3, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{3, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 1, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {1, 5, 6, 0}, {2, 6, 1, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {2, 6, 6, 0}, {4, 6, 1, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 4, 1}, {4, 6, 5, 1}, {4, 6, 6, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {5, 5, 6, 1}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {6, 4, 6, 1}, {1, 4, 1, 5}, {2, 5, 1, 5}, {4, 5, 1, 4}, {5, 4, 1, 4}, {1, 4, 6, 5}, {2, 5, 6, 5}, {4, 5, 6, 4}, {5, 4, 6, 4}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(nArray[3] % 4 + nArray[3] / 4 * 4), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] uw = new int[][]{{3, 0, 1, 3}};
            int uvw = uw.length;
            boolean bl = false;
            while (var22_44 < uvw) {
                uvwo = uw[var22_44];
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
                ++var22_44;
            }
            uw = new int[][]{{3, 3, 1, 2}};
            uvw = uw.length;
            boolean bl2 = false;
            while (var22_46 < uvw) {
                uvwo = uw[var22_46];
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                ++var22_46;
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo2 : new int[][]{{3, 1, 4, 3}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo2[3];
                    int u = uvwo2[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo2[1];
                    int w = uvwo2[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int u : new int[]{2, 4}) {
                this.func_175811_a(world, biomeGrassState, u, 0, 1, structureBB);
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(5), u, 0, 0, structureBB);
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, u, 1, 1, structureBB);
            }
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 1, 0, 1, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(7), 5, 0, 1, structureBB);
            for (int[] uvw2 : new int[][]{{3, 0, -1}}) {
                int pathU = uvw2[0];
                int pathV = uvw2[1];
                int pathW = uvw2[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{4, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse5
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"   F     ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "  FFFFF  ", "   FFF F ", " F  P    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse5() {
        }

        public PlainsSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 1, 3, 1, 7, 3}, {7, 1, 3, 7, 7, 3}, {1, 1, 7, 1, 7, 7}, {7, 1, 7, 7, 7, 7}, {3, 3, 7, 3, 3, 7}, {5, 3, 7, 5, 3, 7}, {3, 6, 7, 3, 6, 7}, {5, 6, 7, 5, 6, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 4, 1, 1, 6}, {7, 1, 4, 7, 1, 6}, {2, 1, 7, 6, 1, 7}, {2, 1, 2, 2, 4, 2}, {6, 1, 2, 6, 4, 2}, {3, 1, 1, 5, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] decorUVW : new int[][]{{1, 1, 0}, {3, 1, 8}, {7, 1, 1}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 1, 2, 5, 1, 2}, {2, 1, 3, 6, 1, 6}, {1, 2, 4, 1, 4, 6}, {1, 6, 4, 1, 7, 6}, {7, 2, 4, 7, 4, 6}, {7, 6, 4, 7, 7, 6}, {2, 4, 3, 6, 7, 3}, {3, 9, 3, 5, 9, 3}, {2, 2, 7, 6, 7, 7}, {3, 9, 7, 5, 9, 7}, {3, 4, 2, 5, 4, 2}, {3, 4, 4, 6, 4, 4}, {2, 8, 4, 2, 8, 6}, {3, 9, 4, 3, 9, 6}, {5, 9, 4, 5, 9, 6}, {6, 8, 4, 6, 8, 6}, {4, 10, 2, 4, 10, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 5, 4, 1, 5, 6}, {7, 5, 4, 7, 5, 6}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 8, 3, 6, 8, 3}, {2, 8, 7, 6, 8, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{1, 3, 5}, {7, 3, 5}, {4, 3, 7}, {4, 6, 7}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 7, 2, 0}, {0, 7, 3, 0}, {0, 7, 4, 0}, {0, 7, 5, 0}, {0, 7, 6, 0}, {0, 7, 7, 0}, {0, 7, 8, 0}, {1, 8, 2, 0}, {1, 8, 3, 0}, {1, 8, 4, 0}, {1, 8, 5, 0}, {1, 8, 6, 0}, {1, 8, 7, 0}, {1, 8, 8, 0}, {2, 9, 2, 0}, {2, 9, 3, 0}, {2, 9, 4, 0}, {2, 9, 5, 0}, {2, 9, 6, 0}, {2, 9, 7, 0}, {2, 9, 8, 0}, {3, 10, 2, 0}, {3, 10, 3, 0}, {3, 10, 4, 0}, {3, 10, 5, 0}, {3, 10, 6, 0}, {3, 10, 7, 0}, {3, 10, 8, 0}, {5, 10, 2, 1}, {5, 10, 3, 1}, {5, 10, 4, 1}, {5, 10, 5, 1}, {5, 10, 6, 1}, {5, 10, 7, 1}, {5, 10, 8, 1}, {6, 9, 2, 1}, {6, 9, 3, 1}, {6, 9, 4, 1}, {6, 9, 5, 1}, {6, 9, 6, 1}, {6, 9, 7, 1}, {6, 9, 8, 1}, {7, 8, 2, 1}, {7, 8, 3, 1}, {7, 8, 4, 1}, {7, 8, 5, 1}, {7, 8, 6, 1}, {7, 8, 7, 1}, {7, 8, 8, 1}, {8, 7, 2, 1}, {8, 7, 3, 1}, {8, 7, 4, 1}, {8, 7, 5, 1}, {8, 7, 6, 1}, {8, 7, 7, 1}, {8, 7, 8, 1}, {1, 7, 2, 5}, {2, 8, 2, 5}, {3, 9, 2, 5}, {5, 9, 2, 4}, {6, 8, 2, 4}, {7, 7, 2, 4}, {1, 7, 8, 5}, {2, 8, 8, 5}, {3, 9, 8, 5}, {5, 9, 8, 4}, {6, 8, 8, 4}, {7, 7, 8, 4}, {5, 2, 6, 3}, {6, 2, 6, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 0, 3}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 4, 0, 2}, {5, 3, 8, 0}, {3, 6, 8, 0}, {5, 6, 8, 0}, {3, 3, 2, 0}, {5, 3, 2, 0}, {4, 7, 6, 2}, {4, 7, 4, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{4, 2, 1, 2, 1, 1}, {3, 5, 3, 2, 1, 1}, {5, 5, 3, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 5, 2, 2, 5, 2}, {3, 5, 1, 5, 5, 1}, {6, 5, 2, 6, 5, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            this.func_175804_a(world, structureBB, 4, 2, 4, 5, 2, 4, Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor3 : 13), Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor3 : 13), false);
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 2, 2, 4, 2, 4, 4, biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(1)), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(1)), false);
            for (int[] uvwo : new int[][]{{2, 2, 5, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{2, 2, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse4
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse4() {
        }

        public PlainsSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 1}, {5, 1}, {1, 5}, {5, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 4, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 3, 1}, {2, 5, 1, 4, 5, 1}, {2, 0, 5, 4, 3, 5}, {2, 5, 5, 4, 5, 5}, {1, 0, 2, 1, 3, 4}, {5, 0, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 2, 2, 1, 2, 4}, {5, 2, 2, 5, 2, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 4, 1, 4, 4, 1}, {2, 4, 5, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {1, 4, 2, 1, 4, 4}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 2, 5, 4}, {4, 5, 2, 4, 5, 4}, {3, 5, 2, 3, 5, 2}, {3, 5, 4, 3, 5, 4}, {3, 6, 0, 3, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {5, 2, 3}, {3, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 4, 0, 0}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 0, 0}, {1, 5, 1, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {1, 5, 6, 0}, {2, 6, 0, 0}, {2, 6, 1, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {2, 6, 5, 0}, {2, 6, 6, 0}, {4, 6, 0, 1}, {4, 6, 1, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 4, 1}, {4, 6, 5, 1}, {4, 6, 6, 1}, {5, 5, 0, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {5, 5, 6, 1}, {6, 4, 0, 1}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {6, 4, 6, 1}, {1, 4, 0, 5}, {2, 5, 0, 5}, {4, 5, 0, 4}, {5, 4, 0, 4}, {1, 4, 6, 5}, {2, 5, 6, 5}, {4, 5, 6, 4}, {5, 4, 6, 4}, {3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{4, 1, 2, 0}, {4, 1, 3, 0}, {4, 1, 4, 0}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{2, 1, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse3() {
        }

        public PlainsSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 1}, {5, 1}, {1, 5}, {5, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 3, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 3, 1}, {2, 0, 5, 4, 3, 5}, {1, 0, 2, 1, 3, 4}, {5, 0, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uw : new int[][]{{1, 2, 2, 1, 2, 4}, {5, 2, 2, 5, 2, 4}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uw : new int[][]{{2, 2, 5, 4, 2, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], uw[1], uw[2], uw[3], uw[4], uw[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {1, 4, 1, 5, 4, 1}, {1, 4, 5, 5, 4, 5}, {1, 4, 2, 1, 4, 4}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 2}, {2, 5, 4, 4, 5, 4}, {2, 5, 3, 2, 5, 3}, {4, 5, 3, 4, 5, 3}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {5, 2, 3}, {3, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {3, 6, 2, 3}, {3, 6, 4, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {0, 4, 0, 0}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 1, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {6, 4, 0, 1}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {6, 4, 6, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 4, 1}, {4, 1, 4, 3}, {3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{2, 1, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor : 4);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse2() {
        }

        public PlainsSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uw : new int[][]{{1, 1}, {5, 1}, {1, 5}, {5, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 3, uw[1], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 0, 1}, {2, 0, 5, 4, 0, 5}, {1, 0, 2, 1, 0, 4}, {5, 0, 2, 5, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {2, 1, 3, 2, 1, 3}, {0, 4, 0, 6, 4, 1}, {0, 4, 5, 6, 4, 6}, {0, 4, 2, 1, 4, 4}, {5, 4, 2, 6, 4, 4}, {1, 5, 1, 5, 5, 2}, {1, 5, 4, 5, 5, 5}, {1, 5, 3, 2, 5, 3}, {4, 5, 3, 5, 5, 3}, {2, 6, 2, 4, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 1, 4, 3, 1}, {2, 1, 5, 4, 3, 5}, {1, 1, 2, 1, 3, 4}, {5, 1, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {5, 2, 3}, {3, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{2, 1, 2, 2}, {2, 1, 4, 3}, {3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{4, 1, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor : 4);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallHouse1() {
        }

        public PlainsSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                }
            }
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uw : new int[][]{{1, 1}, {5, 1}, {1, 5}, {5, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 3, uw[1], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 3, 1}, {2, 0, 5, 4, 3, 5}, {1, 0, 2, 1, 3, 4}, {5, 0, 2, 5, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 4, 0, 4}, {1, 4, 1, 5, 4, 1}, {1, 4, 5, 5, 4, 5}, {1, 4, 2, 1, 4, 4}, {5, 4, 2, 5, 4, 4}, {2, 5, 2, 4, 5, 2}, {2, 5, 4, 4, 5, 4}, {2, 5, 3, 2, 5, 3}, {4, 5, 3, 4, 5, 3}, {3, 6, 3, 3, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 3}, {5, 2, 3}, {3, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{1, 4, 0, 3}, {2, 4, 0, 3}, {3, 4, 0, 3}, {4, 4, 0, 3}, {5, 4, 0, 3}, {2, 5, 1, 3}, {3, 5, 1, 3}, {4, 5, 1, 3}, {3, 6, 2, 3}, {3, 6, 4, 2}, {2, 5, 5, 2}, {3, 5, 5, 2}, {4, 5, 5, 2}, {1, 4, 6, 2}, {2, 4, 6, 2}, {3, 4, 6, 2}, {4, 4, 6, 2}, {5, 4, 6, 2}, {0, 4, 0, 0}, {0, 4, 1, 0}, {0, 4, 2, 0}, {0, 4, 3, 0}, {0, 4, 4, 0}, {0, 4, 5, 0}, {0, 4, 6, 0}, {1, 5, 1, 0}, {1, 5, 2, 0}, {1, 5, 3, 0}, {1, 5, 4, 0}, {1, 5, 5, 0}, {2, 6, 2, 0}, {2, 6, 3, 0}, {2, 6, 4, 0}, {6, 4, 0, 1}, {6, 4, 1, 1}, {6, 4, 2, 1}, {6, 4, 3, 1}, {6, 4, 4, 1}, {6, 4, 5, 1}, {6, 4, 6, 1}, {5, 5, 1, 1}, {5, 5, 2, 1}, {5, 5, 3, 1}, {5, 5, 4, 1}, {5, 5, 5, 1}, {4, 6, 2, 1}, {4, 6, 3, 1}, {4, 6, 4, 1}, {4, 1, 4, 3}, {3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, 2}, {4, 2, 0, 2}, {3, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwo : new int[][]{{2, 1, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    for (int[] ia : new int[][]{{3, 1, 3, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], 0);
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsSmallFarm1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int STRUCTURE_WIDTH = 9;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int STRUCTURE_DEPTH = 7;
        private static final int GROUND_LEVEL = 0;
        private int averageGroundLevel = -1;

        public PlainsSmallFarm1() {
        }

        public PlainsSmallFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsSmallFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)6, (int)7, (EnumFacing)coordBaseMode);
            return PlainsSmallFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsSmallFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeDirtState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeFillerState = biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < 9; ++u) {
                for (int w = 0; w < 7; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
                    if (u == 0 || u == 8 || w == 0 || w == 6) {
                        this.func_175811_a(world, biomeLogVertState, u, 0, w, structureBB);
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), u, 0, w, structureBB);
                }
            }
            this.func_175804_a(world, structureBB, 1, 0, 3, 7, 0, 3, Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            int[][][] uPairArray = new int[][][]{new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}, new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}};
            int[][][] vPairArray = new int[][][]{new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}};
            int[][][] wPairArray = new int[][][]{new int[][]{{5, 5, 5, 5, 5, 5, 5}, {4, 4, 4, 4, 4, 4, 4}}, new int[][]{{2, 2, 2, 2, 2, 2, 2}, {1, 1, 1, 1, 1, 1, 1}}};
            int[][][] cropPairAgeArray = new int[][][]{new int[][]{{0, 1, 0, 0, 0, 2, 0}, {1, 0, 1, 0, 0, 1, 1}}, new int[][]{{1, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}};
            for (int crop_pair = 0; crop_pair < cropPairAgeArray.length; ++crop_pair) {
                Block[] cropBlocks = StructureVillageVN.chooseCropPair(random);
                for (int crop_member = 0; crop_member < 2; ++crop_member) {
                    for (int i = 0; i < cropPairAgeArray[crop_pair][crop_member].length; ++i) {
                        IBlockState cropState;
                        int cropProgressMeta = cropPairAgeArray[crop_pair][crop_member][i];
                        while (true) {
                            try {
                                cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                            }
                            catch (IllegalArgumentException e) {
                                if (cropProgressMeta == 0) {
                                    cropState = Blocks.field_150464_aj.func_176203_a(cropPairAgeArray[crop_pair][crop_member][i]);
                                    break;
                                }
                                cropProgressMeta /= 2;
                                continue;
                            }
                            break;
                        }
                        this.func_175811_a(world, cropState, uPairArray[crop_pair][crop_member][i], vPairArray[crop_pair][crop_member][i], wPairArray[crop_pair][crop_member][i], structureBB);
                    }
                }
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), 7, 1, 5, structureBB);
                this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), 7, 0, 5, structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 0;
                int w = 3;
                int v = 1;
                while (w == 3) {
                    u = random.nextInt(9);
                    w = 1 + random.nextInt(5);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsShepherdsHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{" F FFFFFFF   ", "   FFFFFFF   ", "   FFFFFFF   ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "      P      ", "F   FFPF     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsShepherdsHouse1() {
        }

        public PlainsShepherdsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsShepherdsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsShepherdsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsShepherdsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 2}, {11, 2}, {1, 5}, {11, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 1, uw[1], uw[0], 3, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 2, 0, 4}, {6, 0, 2, 6, 0, 5}, {10, 0, 3, 10, 0, 4}, {2, 1, 2, 10, 3, 2}, {5, 4, 2, 7, 4, 2}, {2, 1, 5, 10, 3, 5}, {5, 4, 5, 7, 4, 5}, {1, 1, 3, 1, 3, 4}, {11, 1, 3, 11, 3, 4}, {0, 4, 3, 4, 4, 4}, {8, 4, 3, 12, 4, 4}, {6, 5, 2, 6, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 2, 2, 4, 2, 2}, {8, 2, 2, 10, 2, 2}, {2, 2, 5, 4, 2, 5}, {8, 2, 5, 10, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{3, 2, 2}, {9, 2, 2}, {3, 2, 5}, {9, 2, 5}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{0, 3, 1, 3}, {1, 3, 1, 3}, {2, 3, 1, 3}, {3, 3, 1, 3}, {0, 4, 2, 3}, {1, 4, 2, 3}, {2, 4, 2, 3}, {3, 4, 2, 3}, {0, 4, 5, 2}, {1, 4, 5, 2}, {2, 4, 5, 2}, {3, 4, 5, 2}, {0, 3, 6, 2}, {1, 3, 6, 2}, {2, 3, 6, 2}, {3, 3, 6, 2}, {9, 3, 1, 3}, {10, 3, 1, 3}, {11, 3, 1, 3}, {12, 3, 1, 3}, {9, 4, 2, 3}, {10, 4, 2, 3}, {11, 4, 2, 3}, {12, 4, 2, 3}, {9, 4, 5, 2}, {10, 4, 5, 2}, {11, 4, 5, 2}, {12, 4, 5, 2}, {9, 3, 6, 2}, {10, 3, 6, 2}, {11, 3, 6, 2}, {12, 3, 6, 2}, {5, 5, 2, 0}, {5, 5, 3, 0}, {5, 5, 4, 0}, {5, 5, 5, 0}, {5, 5, 6, 0}, {7, 5, 2, 1}, {7, 5, 3, 1}, {7, 5, 4, 1}, {7, 5, 5, 1}, {7, 5, 6, 1}, {4, 4, 6, 0}, {4, 4, 5, 0}, {8, 4, 6, 1}, {8, 4, 5, 1}, {4, 3, 1, 1}, {4, 4, 2, 0}, {8, 3, 1, 0}, {8, 4, 2, 1}, {4, 3, 6, 5}, {5, 4, 6, 5}, {7, 4, 6, 4}, {8, 3, 6, 4}, {0, 3, 2, 6}, {0, 3, 5, 7}, {12, 3, 2, 6}, {12, 3, 5, 7}, {10, 1, 3, 0}, {10, 1, 4, 0}}) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 2, 1, 2}, {7, 2, 1, 2}, {6, 3, 6, 0}, {2, 3, 3, 1}, {2, 3, 4, 1}, {10, 3, 3, 3}, {10, 3, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 2, 2, 1, 0}, {6, 1, 5, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            this.func_175804_a(world, structureBB, 3, 0, 6, 9, 0, 8, biomeGrassState, biomeGrassState, false);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 1, 0, 5, 3, 0}, {7, 1, 0, 7, 3, 0}, {3, 1, 6, 3, 1, 8}, {9, 1, 6, 9, 1, 8}, {4, 1, 8, 8, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{5, 4, 0, 5, 4, 1}, {7, 4, 0, 7, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{6, 4, 1}, {3, 0, 3}, {4, 0, 4}, {5, 0, 3}, {7, 0, 4}, {8, 0, 3}, {9, 0, 4}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 4, 0}, {3, 0, 4}, {4, 0, 3}, {5, 0, 4}, {7, 0, 3}, {8, 0, 4}, {9, 0, 3}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState loomState = ModObjects.chooseModLoom(1, this.func_186165_e());
            for (int i = 0; i < 2; ++i) {
                this.func_175811_a(world, loomState, 2, 1, 3 + i, structureBB);
            }
            for (int[] uvw : new int[][]{{6, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            for (int[] decorUVW : new int[][]{{0, 1, 0}, {1, 1, 8}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(7);
                int v = 1;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                for (int[] uvw : new int[][]{{5, 1, 7}}) {
                    BlockPos animalPos = new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]));
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(animalPos), null);
                    animal.func_70012_b((double)animalPos.func_177958_n() + 0.5, (double)animalPos.func_177956_o() + 0.5, (double)animalPos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMeetingPoint5
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFPFP", "FFPFFPFPPPF", "FFFPPPFPFPF", "FFFFPPPPFFF", "FFPPPFPPPFF", "FFFPPPPPFFF", "FFFFPPFPPFF", "FPFPFPPPFPF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsMeetingPoint5() {
        }

        public PlainsMeetingPoint5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsMeetingPoint5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsMeetingPoint5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsMeetingPoint5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuww : new int[][]{{1, 0, 2, 1, 0, 4}, {4, 0, 7, 6, 0, 7}, {9, 0, 2, 9, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuww[0], uuww[1], uuww[2], uuww[3], uuww[4], uuww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uw : new int[][]{{0, 0}, {0, 6}, {0, 9}, {1, 1}, {1, 5}, {1, 6}, {1, 7}, {1, 8}, {2, 0}, {2, 5}, {3, 8}, {3, 9}, {6, 9}, {7, 0}, {7, 5}, {8, 1}, {8, 7}, {8, 9}, {9, 1}}) {
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uw[0], 1, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{5, 8}, {7, 8}}) {
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uw[0], 1, uw[1], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uw[0], 2, uw[1], structureBB);
            }
            for (int[] decorUVW : new int[][]{{2, 1, 7}, {8, 1, 8}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 3, 2}, {2, 1, 2, 2, 3, 2}, {0, 1, 4, 0, 3, 4}, {2, 1, 4, 2, 3, 4}, {8, 1, 2, 8, 3, 2}, {10, 1, 2, 10, 3, 2}, {8, 1, 4, 8, 3, 4}, {10, 1, 4, 10, 3, 4}, {4, 1, 6, 4, 3, 6}, {6, 1, 6, 6, 3, 6}, {4, 1, 8, 4, 3, 8}, {6, 1, 8, 6, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 4}, {9, 1, 2, 9, 1, 4}, {4, 1, 7, 6, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{0, 4, 2, 2, 4, 2}, {0, 4, 4, 2, 4, 4}, {8, 4, 2, 10, 4, 2}, {8, 4, 4, 10, 4, 4}, {4, 4, 6, 4, 4, 8}, {6, 4, 6, 6, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            if (GeneralConfig.nameSign) {
                int signU = 5;
                int signV = 2;
                int signW = 7;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
                if (!(this.namePrefix.equals("") && this.nameRoot.equals("") && this.nameSuffix.equals(""))) {
                    TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                    world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)), 2);
                    world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                }
            }
            for (int[] uvw : new int[][]{{0, 4, 3}, {2, 4, 3}, {8, 4, 3}, {10, 4, 3}, {5, 4, 7}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 4, 3}, {9, 4, 3}, {5, 4, 6}, {5, 4, 8}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 4, 3, 1}, {7, 4, 3, 3}, {5, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMeetingPoint4
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFFFFFF", "FFFFFPFPFFPFFPFF", "FFPPPFFFFFFFPFFP", "FFFFFPFFPFPFFPPF", "FFFFPPPPFPFPFFFF", "FFFPFFPFFFFFFFFF", "FFFFPFPPPFFFPFPF", "FFFFPPPFFPFPFFFF", "FFPFFFPFPFPFPFFF", "FPFFFPFPFFPPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsMeetingPoint4() {
        }

        public PlainsMeetingPoint4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsMeetingPoint4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsMeetingPoint4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsMeetingPoint4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{3, 3}, {3, 6}, {4, 1}, {4, 4}, {5, 4}, {6, 6}, {7, 2}, {8, 0}, {8, 4}, {8, 5}, {10, 2}, {10, 4}, {10, 7}, {11, 3}, {12, 4}, {12, 6}, {13, 6}}) {
                this.func_175811_a(world, biomeCobblestoneState, uw[0], 0, uw[1], structureBB);
            }
            IBlockState biomeMossyCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150341_Y.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeMossyCobblestoneState, 13, 0, 1, structureBB);
            for (int[] uuww : new int[][]{{2, 0, 2, 2, 0, 5}, {13, 0, 2, 13, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuww[0], uuww[1], uuww[2], uuww[3], uuww[4], uuww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uw : new int[][]{{0, 0}, {0, 2}, {0, 5}, {0, 7}, {1, 3}, {1, 4}, {1, 9}, {3, 0}, {3, 9}, {4, 6}, {4, 8}, {4, 9}, {5, 7}, {6, 8}, {6, 9}, {7, 9}, {8, 7}, {8, 8}, {11, 8}, {12, 0}, {12, 9}, {13, 0}, {14, 1}, {14, 4}, {14, 9}, {15, 2}, {15, 3}, {15, 9}}) {
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uw[0], 1, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{0, 8}, {2, 6}, {5, 9}, {15, 0}, {15, 1}}) {
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uw[0], 1, uw[1], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uw[0], 2, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{7, 6}, {14, 0}}) {
                this.func_175811_a(world, Blocks.field_150327_N.func_176203_a(0), uw[0], 1, uw[1], structureBB);
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{9, 1, 7, -1, -1}}) {
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            for (int[] decorUVW : new int[][]{{1, 1, 1}, {2, 1, 8}, {13, 1, 7}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 3, 2}, {3, 1, 2, 3, 3, 2}, {1, 1, 5, 1, 3, 5}, {3, 1, 5, 3, 3, 5}, {12, 1, 2, 12, 3, 2}, {14, 1, 2, 14, 3, 2}, {12, 1, 5, 12, 3, 5}, {14, 1, 5, 14, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 2, 1, 5}, {13, 1, 2, 13, 1, 5}, {6, 1, 7, 6, 1, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 4, 2, 3, 4, 2}, {1, 4, 5, 3, 4, 5}, {12, 4, 2, 14, 4, 2}, {12, 4, 5, 14, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            if (GeneralConfig.nameSign) {
                TileEntitySign signContents;
                int signU = 6;
                int signV = 2;
                int signW = 7;
                int signX = this.func_74865_a(signU, signW);
                int signY = this.func_74862_a(signV);
                int signZ = this.func_74873_b(signU, signW);
                if (this.namePrefix.equals("") && this.nameRoot.equals("") && this.nameSuffix.equals("")) {
                    signContents = new TileEntitySign();
                    signContents.field_145915_a[1] = new TextComponentString("Market");
                } else {
                    signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                }
                IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            for (int[] uvwo : new int[][]{{2, 2, 2, -1}, {2, 2, 5, -1}, {13, 2, 2, -1}, {13, 2, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 4, 4}, {2, 4, 3}, {3, 4, 4}, {12, 4, 3}, {13, 4, 4}, {14, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 4, 3}, {2, 4, 4}, {3, 4, 3}, {12, 4, 4}, {13, 4, 3}, {14, 4, 4}}) {
                this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMediumHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"             ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", " FFFFFFFFFFF ", "             "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public PlainsMediumHouse2() {
        }

        public PlainsMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 1, 4, 3, 1}, {8, 0, 1, 10, 3, 1}, {6, 3, 1, 6, 3, 1}, {2, 0, 5, 4, 3, 5}, {6, 0, 5, 6, 3, 5}, {8, 0, 5, 10, 3, 5}, {1, 0, 2, 1, 3, 4}, {11, 0, 2, 11, 3, 4}, {6, 0, 1, 6, 0, 4}, {3, 0, 3, 4, 0, 3}, {8, 0, 3, 9, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 2, 2, 0, 4}, {3, 0, 2, 4, 0, 2}, {3, 0, 4, 4, 0, 4}, {5, 0, 2, 5, 0, 4}, {7, 0, 2, 7, 0, 4}, {8, 0, 2, 9, 0, 2}, {8, 0, 4, 9, 0, 4}, {10, 0, 2, 10, 0, 4}, {3, 5, 0, 3, 5, 6}, {9, 5, 0, 9, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeWoodDoubleSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150373_bw.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 6, 4, 0, 6, 4, 6, biomeWoodDoubleSlabState, biomeWoodDoubleSlabState, false);
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{6, 3, 0}, {6, 3, 6}}) {
                this.func_175811_a(world, biomeWoodSlabTopState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 1, 3, 1}, {5, 0, 1, 5, 3, 1}, {7, 0, 1, 7, 3, 1}, {11, 0, 1, 11, 3, 1}, {1, 0, 5, 1, 3, 5}, {5, 0, 5, 5, 3, 5}, {7, 0, 5, 7, 3, 5}, {11, 0, 5, 11, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 4, 1, 4, 4, 1}, {8, 4, 1, 10, 4, 1}, {2, 4, 5, 4, 4, 5}, {8, 4, 5, 10, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 3, 0, 0, 3, 6, 0}, {1, 4, 0, 1, 4, 6, 0}, {2, 5, 0, 2, 5, 6, 0}, {5, 4, 0, 5, 4, 6, 1}, {4, 5, 0, 4, 5, 6, 1}, {7, 4, 0, 7, 4, 6, 0}, {8, 5, 0, 8, 5, 6, 0}, {12, 3, 0, 12, 3, 6, 1}, {11, 4, 0, 11, 4, 6, 1}, {10, 5, 0, 10, 5, 6, 1}, {1, 3, 0, 1, 3, 0, 5}, {2, 4, 0, 2, 4, 0, 5}, {4, 4, 0, 4, 4, 0, 4}, {8, 4, 0, 8, 4, 0, 5}, {10, 4, 0, 10, 4, 0, 4}, {11, 3, 0, 11, 3, 0, 4}, {1, 3, 6, 1, 3, 6, 5}, {2, 4, 6, 2, 4, 6, 5}, {4, 4, 6, 4, 4, 6, 4}, {8, 4, 6, 8, 4, 6, 5}, {10, 4, 6, 10, 4, 6, 4}, {11, 3, 6, 11, 3, 6, 4}, {2, 1, 4, 2, 1, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvw : new int[][]{{3, 2, 1}, {9, 2, 1}, {3, 2, 5}, {9, 2, 5}, {1, 2, 3}, {11, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150452_aw.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{3, 1, 4}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeWoodPressurePlateState, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 2, 0, 2}, {7, 2, 0, 2}, {6, 2, 6, 0}, {5, 2, 4, 2}, {7, 2, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{3, 1, 2, 1}, {9, 1, 4, 3}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwm[3];
                    int u = uvwm[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwm[1];
                    int w = uvwm[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor : 4);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{6, 1, 1, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{6, 0, 0, 3}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[3] % 4 + uuvvwwo[3] / 4 * 4), uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], structureBB);
            }
            int chestU = 10;
            int chestV = 1;
            int chestW = 2;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{6, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{4, 1, 3, -1, 0}, {8, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMediumHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"           ", "   FFFFFFF ", "   FFFFFFF ", "   FFFFFFF ", "   FFFFFFF ", "   FFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "   FF      "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private int averageGroundLevel = -1;

        public PlainsMediumHouse1() {
        }

        public PlainsMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeStrippedLogVertState = biomeLogVertState;
            IBlockState biomeStrippedLogHorAlongState = biomeLogHorAlongState;
            IBlockState biomeStrippedLogHorAcrossState = biomeLogHorAcrossState;
            if (biomeStrippedLogVertState.func_177230_c() == Blocks.field_150364_r || biomeStrippedLogVertState.func_177230_c() == Blocks.field_150363_s) {
                if (biomeLogVertState.func_177230_c() == Blocks.field_150364_r) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 0);
                    biomeStrippedLogHorAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 1);
                    biomeStrippedLogHorAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState), 2);
                } else if (biomeLogVertState.func_177230_c() == Blocks.field_150363_s) {
                    biomeStrippedLogVertState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 0);
                    biomeStrippedLogHorAlongState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 1);
                    biomeStrippedLogHorAcrossState = ModObjects.chooseModStrippedLogState(biomeLogVertState.func_177230_c().func_176201_c(biomeLogVertState) + 4, 2);
                }
            }
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 1, 8, 2, 1}, {1, 1, 2, 1, 2, 5}, {1, 4, 2, 1, 4, 5}, {1, 5, 3, 1, 5, 4}, {1, 1, 6, 3, 2, 6}, {3, 1, 7, 3, 2, 10}, {3, 4, 7, 3, 4, 10}, {4, 1, 11, 8, 4, 11}, {6, 6, 11, 6, 6, 11}, {9, 1, 2, 9, 2, 10}, {9, 4, 2, 9, 4, 10}, {9, 5, 3, 9, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 1, 2, 8, 1, 5}, {4, 1, 6, 8, 1, 10}, {1, 3, 6, 3, 4, 6}, {0, 4, 1, 10, 4, 1}, {0, 5, 2, 10, 5, 2}, {0, 6, 3, 10, 6, 3}, {0, 6, 4, 10, 6, 4}, {0, 5, 5, 4, 5, 5}, {4, 5, 5, 4, 5, 12}, {5, 6, 5, 5, 6, 12}, {6, 7, 5, 6, 7, 12}, {7, 6, 5, 7, 6, 12}, {8, 5, 3, 8, 5, 12}, {3, 4, 12, 3, 4, 12}, {9, 4, 12, 9, 4, 12}, {5, 7, 4, 7, 7, 4}, {4, 6, 5, 4, 6, 5}, {3, 5, 6, 3, 5, 6}, {2, 4, 7, 2, 4, 7}, {8, 6, 5, 8, 6, 5}, {0, 4, 6, 0, 4, 6}, {10, 4, 6, 10, 4, 6}, {9, 5, 5, 10, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 4, 1}, {9, 1, 1, 9, 4, 1}, {1, 1, 6, 1, 4, 6}, {3, 1, 11, 3, 4, 11}, {9, 1, 11, 9, 4, 11}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeStrippedLogVertState, biomeStrippedLogVertState, false);
            }
            for (int[] uvw : new int[][]{{9, 3, 6}}) {
                this.func_175811_a(world, biomeStrippedLogHorAcrossState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 3, 1}, {4, 3, 1}, {8, 3, 1}}) {
                this.func_175811_a(world, biomeStrippedLogHorAlongState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 3, 2}, {1, 3, 5}, {9, 3, 2}, {9, 3, 5}, {9, 3, 7}, {9, 3, 10}, {3, 3, 7}, {3, 3, 10}, {5, 3, 1}, {7, 3, 1}, {5, 5, 11}, {7, 5, 11}}) {
                this.func_175811_a(world, biomeLogVertState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 3, 3}, {1, 3, 4}, {9, 3, 3}, {9, 3, 4}, {9, 3, 8}, {9, 3, 9}, {3, 3, 8}, {3, 3, 9}, {6, 3, 1}, {6, 5, 11}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 4, 0, 10, 4, 0, 3}, {0, 5, 1, 10, 5, 1, 3}, {0, 6, 2, 10, 6, 2, 3}, {0, 7, 3, 10, 7, 3, 3}, {0, 4, 7, 1, 4, 7, 2}, {0, 5, 6, 2, 5, 6, 2}, {0, 6, 5, 3, 6, 5, 2}, {0, 7, 4, 4, 7, 4, 2}, {10, 4, 7, 10, 4, 7, 2}, {9, 5, 6, 10, 5, 6, 2}, {9, 6, 5, 10, 6, 5, 2}, {8, 7, 4, 10, 7, 4, 2}, {2, 4, 8, 2, 4, 12, 0}, {3, 5, 7, 3, 5, 12, 0}, {4, 6, 6, 4, 6, 12, 0}, {5, 7, 5, 5, 7, 12, 0}, {10, 4, 8, 10, 4, 12, 1}, {9, 5, 7, 9, 5, 12, 1}, {8, 6, 6, 8, 6, 12, 1}, {7, 7, 5, 7, 7, 12, 1}, {5, 2, 2, 5, 2, 2, 1}, {7, 2, 2, 7, 2, 2, 0}, {3, 1, 0, 3, 1, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150452_aw.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{6, 2, 2}, {8, 2, 6}, {8, 2, 10}, {4, 2, 10}}) {
                this.func_175811_a(world, biomeFenceState, uvw[0], uvw[1], uvw[2], structureBB);
                this.func_175811_a(world, biomeWoodPressurePlateState, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 3, 0, 2}, {4, 3, 0, 2}, {6, 3, 12, 0}, {3, 4, 2, 0}, {8, 4, 6, 3}, {6, 3, 10, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{5, 2, 9, 2}, {7, 2, 9, 2}}) {
                boolean[] blArray = new boolean[]{false, true};
                int n = blArray.length;
                for (int i = 0; i < n; ++i) {
                    boolean isHead = blArray[i];
                    int orientation = uvwm[3];
                    int u = uvwm[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwm[1];
                    int w = uvwm[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 2, 1, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 0, 0}}) {
                this.func_175811_a(world, biomeGrassState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            for (int[] decorUVW : new int[][]{{0, 1, 10}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{7, 2, 4, -1, 0}, {6, 2, 6, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMasonsHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "  FFFFFF ", "   FFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 2;
        private int averageGroundLevel = -1;

        public PlainsMasonsHouse1() {
        }

        public PlainsMasonsHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsMasonsHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsMasonsHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsMasonsHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 2, 7, 0, 6}, {3, 0, 1, 7, 0, 1}, {4, 0, 0, 7, 0, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{3, 0, 4, 5, 0, 4}, {4, 6, 1, 4, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 2, 6, 3, 2}, {3, 5, 2, 5, 5, 2}, {2, 1, 6, 6, 3, 6}, {3, 5, 6, 5, 5, 6}, {1, 1, 3, 1, 3, 5}, {7, 1, 3, 7, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 3, 2}, {1, 1, 6, 1, 3, 6}, {7, 1, 2, 7, 3, 2}, {7, 1, 6, 7, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww : new int[][]{{2, 4, 2, 6, 4, 2}, {2, 4, 6, 6, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvw : new int[][]{{5, 2, 2}, {5, 2, 6}, {3, 2, 6}, {1, 2, 4}, {7, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{0, 3, 1, 0, 3, 7, 0}, {8, 3, 1, 8, 3, 7, 1}, {1, 4, 1, 1, 4, 7, 0}, {7, 4, 1, 7, 4, 7, 1}, {2, 5, 1, 2, 5, 7, 0}, {6, 5, 1, 6, 5, 7, 1}, {3, 6, 1, 3, 6, 7, 0}, {5, 6, 1, 5, 6, 7, 1}, {1, 3, 1, 1, 3, 1, 5}, {7, 3, 1, 7, 3, 1, 4}, {2, 4, 1, 2, 4, 1, 5}, {6, 4, 1, 6, 4, 1, 4}, {3, 5, 1, 3, 5, 1, 5}, {5, 5, 1, 5, 5, 1, 4}, {1, 3, 7, 1, 3, 7, 5}, {7, 3, 7, 7, 3, 7, 4}, {2, 4, 7, 2, 4, 7, 5}, {6, 4, 7, 6, 4, 7, 4}, {3, 5, 7, 3, 5, 7, 5}, {5, 5, 7, 5, 5, 7, 4}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeWoodStairsState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{4, 1, 0, 7, 1, 0}, {7, 1, 1, 7, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 0, -1}, {7, 2, 0, -1}, {4, 4, 3, 0}, {4, 4, 5, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{2, 1, 5}, {3, 1, 5}, {2, 2, 5}, {2, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150435_aG.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 1, 5}, {2, 3, 5}}) {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState stonecutterState = ModObjects.chooseModStonecutterState(3, this.func_186165_e());
            this.func_175811_a(world, stonecutterState, 6, 1, 4, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvwwo : new int[][]{{3, 0, 0, 3}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[3] % 4 + uuvvwwo[3] / 4 * 4), uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], structureBB);
            }
            this.func_175811_a(world, biomeGrassState, 2, 0, 1, structureBB);
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 1, 0, 1, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(5), 2, 0, 0, structureBB);
            IBlockState cornflowerState = ModObjects.chooseModCornflower();
            IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
            int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
            IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
            this.func_175811_a(world, flowerstate, 2, 1, 1, structureBB);
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 3 + random.nextInt(3);
                int v = 1;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class PlainsLibrary2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"         ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", " FFFFFFF ", "   P P   ", "  FPFPF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsLibrary2() {
        }

        public PlainsLibrary2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsLibrary2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsLibrary2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsLibrary2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var21_54;
            void var21_52;
            int[] uvwo;
            void var21_50;
            void var21_48;
            void var18_32;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int n = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, n)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, n, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, n)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{2, 0, 3, 6, 0, 4}, {2, 1, 2, 6, 3, 2}, {2, 1, 6, 6, 3, 6}, {1, 1, 3, 1, 3, 5}, {7, 1, 3, 7, 3, 5}, {2, 0, 5, 3, 0, 5}, {6, 0, 5, 6, 0, 5}, {3, 0, 2, 3, 0, 2}, {5, 0, 2, 5, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{2, 4, 3, 6, 4, 4}, {2, 5, 2, 6, 7, 2}, {2, 5, 6, 6, 7, 6}, {1, 5, 3, 1, 7, 5}, {7, 5, 3, 7, 7, 5}, {2, 4, 1, 6, 4, 1}, {6, 4, 5, 6, 4, 5}, {4, 1, 5, 4, 1, 5}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomePlankState, biomePlankState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] posX = new int[][]{{1, 1, 2, 1, 3, 2}, {1, 5, 2, 1, 6, 2}, {1, 1, 6, 1, 3, 6}, {1, 5, 6, 1, 6, 6}, {7, 1, 2, 7, 3, 2}, {7, 5, 2, 7, 6, 2}, {7, 1, 6, 7, 3, 6}, {7, 5, 6, 7, 6, 6}};
            int uuvvww = posX.length;
            boolean bl = false;
            while (var18_32 < uuvvww) {
                int[] uuvvww2 = posX[var18_32];
                this.func_175804_a(world, structureBB, uuvvww2[0], uuvvww2[1], uuvvww2[2], uuvvww2[3], uuvvww2[4], uuvvww2[5], biomeLogVertState, biomeLogVertState, false);
                ++var18_32;
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            for (int[] uuvvww3 : new int[][]{{2, 4, 0, 6, 4, 0}, {1, 4, 2, 7, 4, 2}, {3, 8, 2, 5, 8, 2}, {1, 4, 6, 7, 4, 6}, {3, 8, 6, 5, 8, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww3[0], uuvvww3[1], uuvvww3[2], uuvvww3[3], uuvvww3[4], uuvvww3[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] nArray : new int[][]{{1, 4, 3, 1, 4, 5}, {7, 4, 3, 7, 4, 5}, {4, 9, 1, 4, 9, 7}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int n : new int[]{1, 7}) {
                this.func_175811_a(world, biomeLogHorAlongState, n, 4, 1, structureBB);
            }
            for (int[] nArray : new int[][]{{1, 2, 4}, {1, 6, 4}, {7, 2, 4}, {7, 6, 4}, {3, 2, 6}, {5, 2, 6}, {3, 6, 6}, {5, 6, 6}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] uuvvww2 = new int[][]{{0, 6, 1, 0, 6, 2, 0}, {8, 6, 1, 8, 6, 2, 1}, {0, 6, 6, 0, 6, 7, 0}, {8, 6, 6, 8, 6, 7, 1}, {1, 7, 1, 1, 7, 2, 0}, {7, 7, 1, 7, 7, 2, 1}, {1, 7, 6, 1, 7, 7, 0}, {7, 7, 6, 7, 7, 7, 1}, {2, 8, 1, 2, 8, 7, 0}, {6, 8, 1, 6, 8, 7, 1}, {3, 9, 1, 3, 9, 7, 0}, {5, 9, 1, 5, 9, 7, 1}, {0, 7, 3, 0, 7, 5, 0}, {8, 7, 3, 8, 7, 5, 1}, {1, 6, 1, 1, 6, 1, 5}, {7, 6, 1, 7, 6, 1, 4}, {2, 7, 1, 2, 7, 1, 5}, {6, 7, 1, 6, 7, 1, 4}, {3, 8, 1, 3, 8, 1, 5}, {5, 8, 1, 5, 8, 1, 4}, {1, 6, 7, 1, 6, 7, 5}, {7, 6, 7, 7, 6, 7, 4}, {2, 7, 7, 2, 7, 7, 5}, {6, 7, 7, 6, 7, 7, 4}, {3, 8, 7, 3, 8, 7, 5}, {5, 8, 7, 5, 8, 7, 4}, {0, 6, 3, 0, 6, 3, 6}, {0, 6, 5, 0, 6, 5, 7}, {8, 6, 3, 8, 6, 3, 6}, {8, 6, 5, 8, 6, 5, 7}, {5, 1, 5, 5, 1, 5, 1}, {4, 2, 5, 4, 2, 5, 1}, {3, 3, 5, 3, 3, 5, 1}, {2, 4, 5, 2, 4, 5, 1}};
            int uuvvww3 = uuvvww2.length;
            boolean bl2 = false;
            while (var21_48 < uuvvww3) {
                int[] uuvvwwo = uuvvww2[var21_48];
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], iBlockState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), iBlockState.func_177230_c().func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
                ++var21_48;
            }
            uuvvww2 = new int[][]{{3, 3, 1, 2}, {5, 3, 1, 2}, {3, 7, 1, 2}, {5, 7, 1, 2}, {4, 2, 7, 0}, {4, 6, 7, 0}, {0, 4, 4, 3}, {8, 4, 4, 1}, {4, 2, 3, 0}, {4, 4, 5, 2}};
            uuvvww3 = uuvvww2.length;
            boolean bl3 = false;
            while (var21_50 < uuvvww3) {
                uvwo = uuvvww2[var21_50];
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
                ++var21_50;
            }
            uuvvww2 = new int[][]{{3, 1, 5, 3, 1, 5}, {2, 1, 5, 2, 3, 5}};
            uuvvww3 = uuvvww2.length;
            boolean bl4 = false;
            while (var21_52 < uuvvww3) {
                int[] uuvvww4 = uuvvww2[var21_52];
                this.func_175804_a(world, structureBB, uuvvww4[0], uuvvww4[1], uuvvww4[2], uuvvww4[3], uuvvww4[4], uuvvww4[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                ++var21_52;
            }
            uuvvww2 = new int[][]{{2, 1, 3, 1}};
            uuvvww3 = uuvvww2.length;
            boolean bl5 = false;
            while (var21_54 < uuvvww3) {
                uvwo = uuvvww2[var21_54];
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                ++var21_54;
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}, {5, 1, 2, 2, 1, 0}, {3, 5, 2, 2, 1, 1}, {5, 5, 2, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww5 : new int[][]{{2, 1, 0, 2, 2, 0}, {4, 1, 0, 4, 2, 0}, {6, 1, 0, 6, 2, 0}, {2, 3, 0, 6, 3, 0}, {2, 5, 0, 6, 5, 0}, {1, 5, 1, 1, 5, 1}, {7, 5, 1, 7, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww5[0], uuvvww5[1], uuvvww5[2], uuvvww5[3], uuvvww5[4], uuvvww5[5], biomeFenceState, biomeFenceState, false);
            }
            for (int u : new int[]{2, 4, 6}) {
                this.func_175811_a(world, biomeGrassState, u, 0, 0, structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {4, 1, -1}, {5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int n = 3 + random.nextInt(4);
                int v = random.nextBoolean() ? 5 : 1;
                int w = 3 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(n, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(n, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class PlainsLibrary1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"                 ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", " FFFFFFFFFFFFFFF ", "      FFFFF      ", "       FFF       ", "        F        "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 0;
        private int averageGroundLevel = -1;

        public PlainsLibrary1() {
        }

        public PlainsLibrary1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsLibrary1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsLibrary1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsLibrary1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var22_68;
            void var22_66;
            void var22_64;
            void var18_39;
            int[] uw;
            void var18_37;
            void var17_28;
            int posX22;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    posX22 = this.func_74865_a(u, w);
                    int n = this.func_74862_a(-1);
                    int n2 = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX22, n, n2)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX22, n, n2, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX22, n, n2)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{1, 0, 3, 5, 0, 9}, {11, 0, 3, 15, 0, 9}, {6, 0, 2, 10, 0, 9}, {7, 0, 1, 9, 0, 1}, {6, 1, 2, 6, 3, 2}, {10, 1, 2, 10, 3, 2}, {7, 1, 1, 7, 3, 1}, {9, 1, 1, 9, 3, 1}, {5, 1, 5, 5, 2, 5}, {11, 1, 5, 11, 2, 5}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            this.func_175811_a(world, biomeCobblestoneState, 8, 3, 1, structureBB);
            this.func_175811_a(world, biomeCobblestoneState, 4, 1, 5, structureBB);
            this.func_175811_a(world, biomeCobblestoneState, 12, 1, 5, structureBB);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] unitLetter = new int[][]{{1, 1, 4, 1, 6, 8}, {15, 1, 4, 15, 6, 8}, {2, 1, 3, 4, 5, 3}, {12, 1, 3, 14, 5, 3}, {6, 4, 3, 10, 6, 3}, {7, 8, 3, 9, 8, 3}, {2, 1, 9, 14, 5, 9}, {7, 3, 2, 9, 3, 2}, {6, 3, 3, 10, 3, 5}, {2, 6, 4, 5, 6, 4}, {11, 6, 4, 14, 6, 4}, {2, 6, 8, 14, 6, 8}, {2, 7, 4, 6, 7, 5}, {10, 7, 4, 14, 7, 5}, {2, 7, 7, 14, 7, 7}, {0, 8, 6, 16, 8, 6}, {8, 9, 2, 8, 9, 5}, {7, 8, 4, 7, 8, 5}, {9, 8, 4, 9, 8, 5}};
            posX22 = unitLetter.length;
            boolean bl = false;
            while (var17_28 < posX22) {
                int[] nArray = unitLetter[var17_28];
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], biomePlankState, biomePlankState, false);
                ++var17_28;
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] posX22 = new int[][]{{1, 3}, {1, 9}, {15, 3}, {15, 9}};
            int n = posX22.length;
            boolean bl2 = false;
            while (var18_37 < n) {
                uw = posX22[var18_37];
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 5, uw[1], biomeLogVertState, biomeLogVertState, false);
                ++var18_37;
            }
            posX22 = new int[][]{{5, 3}, {11, 3}};
            int n3 = posX22.length;
            boolean bl3 = false;
            while (var18_39 < n3) {
                uw = posX22[var18_39];
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 6, uw[1], biomeLogVertState, biomeLogVertState, false);
                ++var18_39;
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            int[][] nArrayArray = new int[][]{{2, 4, 3, 4, 4, 3}, {12, 4, 3, 14, 4, 3}, {6, 7, 3, 10, 7, 3}, {2, 4, 9, 14, 4, 9}};
            int n4 = nArrayArray.length;
            for (int uw2 = 0; uw2 < n4; ++uw2) {
                int[] uuvvww = nArrayArray[uw2];
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int u : new int[]{3, 5, 7, 9, 11, 13}) {
                this.func_175811_a(world, biomeLogHorAcrossState, u, 2, 9, structureBB);
            }
            IBlockState iBlockState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int[] uuvvww : new int[][]{{1, 4, 4, 1, 4, 8}, {1, 7, 5, 1, 7, 7}, {15, 4, 4, 15, 4, 8}, {15, 7, 5, 15, 7, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], iBlockState, iBlockState, false);
            }
            for (int u : new int[]{1, 15}) {
                for (int w : new int[]{5, 7}) {
                    this.func_175811_a(world, iBlockState, u, 2, w, structureBB);
                }
            }
            for (int[] uw3 : new int[][]{{3, 3}, {13, 3}, {1, 6}, {15, 6}, {4, 9}, {8, 9}, {12, 9}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw3[0], 2, uw3[1], structureBB);
            }
            IBlockState iBlockState2 = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{0, 5, 2, 4, 5, 2, 3}, {0, 6, 3, 4, 6, 3, 3}, {0, 7, 4, 4, 7, 4, 3}, {0, 8, 5, 5, 8, 5, 3}, {12, 5, 2, 16, 5, 2, 3}, {12, 6, 3, 16, 6, 3, 3}, {12, 7, 4, 16, 7, 4, 3}, {11, 8, 5, 16, 8, 5, 3}, {0, 5, 10, 16, 5, 10, 2}, {0, 6, 9, 16, 6, 9, 2}, {0, 7, 8, 16, 7, 8, 2}, {0, 8, 7, 16, 8, 7, 2}, {7, 9, 6, 9, 9, 6, 2}, {5, 7, 2, 5, 7, 4, 0}, {11, 7, 2, 11, 7, 4, 1}, {6, 8, 2, 6, 8, 5, 0}, {10, 8, 2, 10, 8, 5, 1}, {7, 9, 2, 7, 9, 5, 0}, {9, 9, 2, 9, 9, 5, 1}, {6, 7, 2, 6, 7, 2, 5}, {10, 7, 2, 10, 7, 2, 4}, {7, 8, 2, 7, 8, 2, 5}, {9, 8, 2, 9, 8, 2, 4}, {0, 5, 3, 0, 5, 3, 6}, {0, 5, 9, 0, 5, 9, 7}, {0, 6, 4, 0, 6, 4, 6}, {0, 6, 8, 0, 6, 8, 7}, {0, 7, 5, 0, 7, 5, 6}, {0, 7, 7, 0, 7, 7, 7}, {16, 5, 3, 16, 5, 3, 6}, {16, 5, 9, 16, 5, 9, 7}, {16, 6, 4, 16, 6, 4, 6}, {16, 6, 8, 16, 6, 8, 7}, {16, 7, 5, 16, 7, 5, 6}, {16, 7, 7, 16, 7, 7, 7}, {8, 4, 4, 8, 4, 4, 2}, {2, 1, 7, 2, 1, 8, 1}, {3, 1, 8, 4, 1, 8, 3}, {14, 1, 7, 14, 1, 8, 0}, {12, 1, 8, 13, 1, 8, 3}}) {
                this.func_175804_a(world, structureBB, nArray[0], nArray[1], nArray[2], nArray[3], nArray[4], nArray[5], iBlockState2.func_177230_c().func_176203_a(nArray[6] % 4 + nArray[6] / 4 * 4), iBlockState2.func_177230_c().func_176203_a(nArray[6] % 4 + nArray[6] / 4 * 4), false);
            }
            for (int[] nArray : new int[][]{{1, 2, 2, 2}, {15, 2, 2, 2}, {7, 2, 0, 2}, {9, 2, 0, 2}, {6, 2, 10, 0}, {10, 2, 10, 0}, {6, 3, 6, 0}, {10, 3, 6, 0}, {2, 5, 6, 1}, {14, 5, 6, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(nArray[3])), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] u = new int[][]{{3, 1, 5, 0}, {4, 2, 5, 0}, {5, 3, 5, 0}, {13, 1, 5, 1}, {12, 2, 5, 1}, {11, 3, 5, 1}, {8, 0, 0, 3}};
            int uw3 = u.length;
            boolean bl4 = false;
            while (var22_64 < uw3) {
                int[] uuvvwwo = u[var22_64];
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uuvvwwo[3] % 4 + uuvvwwo[3] / 4 * 4), uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], structureBB);
                ++var22_64;
            }
            u = new int[][]{{5, 1, 8, 7, 1, 8}, {6, 2, 8, 6, 2, 8}, {9, 1, 8, 11, 1, 8}, {10, 2, 8, 10, 2, 8}};
            uw3 = u.length;
            boolean bl5 = false;
            while (var22_66 < uw3) {
                int[] uuvvww = u[var22_66];
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                ++var22_66;
            }
            u = new int[][]{{6, 1, 5, 1}, {10, 1, 5, 3}};
            uw3 = u.length;
            boolean bl6 = false;
            while (var22_68 < uw3) {
                int[] uvwo = u[var22_68];
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState));
                ++var22_68;
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{8, 1, 1, 2, 1, 0}, {7, 4, 3, 2, 1, 0}, {9, 4, 3, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 7, 4, 1, 9, 4, 1, biomeFenceState, biomeFenceState, false);
            for (int u2 : new int[]{6, 10}) {
                this.func_175811_a(world, biomeFenceState, u2, 4, 2, structureBB);
            }
            for (int[] uvw : new int[][]{{8, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                void var22_74;
                int w;
                int v;
                this.entitiesGenerated = true;
                if (random.nextBoolean()) {
                    int n5 = 6 + random.nextInt(5);
                    v = 4;
                    w = 5;
                } else {
                    int n6 = 3 + random.nextInt(11);
                    v = 1;
                    w = 6 + random.nextInt(2);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a((int)var22_74, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b((int)var22_74, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class PlainsLargeFarm1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int STRUCTURE_WIDTH = 9;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int STRUCTURE_DEPTH = 13;
        private static final int GROUND_LEVEL = 0;
        private int averageGroundLevel = -1;

        public PlainsLargeFarm1() {
        }

        public PlainsLargeFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsLargeFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)6, (int)13, (EnumFacing)coordBaseMode);
            return PlainsLargeFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsLargeFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < 9; ++u) {
                for (int w = 0; w < 13; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    if (u == 0 || u == 8 || w == 0 || w == 12) {
                        this.func_175811_a(world, biomeLogVertState, u, 0, w, structureBB);
                        continue;
                    }
                    this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(7), u, 0, w, structureBB);
                }
            }
            this.func_175811_a(world, Blocks.field_150458_ak.func_176203_a(0), 7, 0, 2, structureBB);
            this.func_175804_a(world, structureBB, 1, 0, 6, 7, 0, 6, biomeLogVertState, biomeLogVertState, false);
            for (int w : new int[]{3, 9}) {
                this.func_175804_a(world, structureBB, 1, 0, w, 7, 0, w, Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            int[][][] uPairArray = new int[][][]{new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}, new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}, new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}, new int[][]{{1, 2, 3, 4, 5, 6, 7}, {1, 2, 3, 4, 5, 6, 7}}};
            int[][][] vPairArray = new int[][][]{new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}, new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1}}};
            int[][][] wPairArray = new int[][][]{new int[][]{{11, 11, 11, 11, 11, 11, 11}, {10, 10, 10, 10, 10, 10, 10}}, new int[][]{{8, 8, 8, 8, 8, 8, 8}, {7, 7, 7, 7, 7, 7, 7}}, new int[][]{{5, 5, 5, 5, 5, 5, 5}, {4, 4, 4, 4, 4, 4, 4}}, new int[][]{{2, 2, 2, 2, 2, 2, 2}, {1, 1, 1, 1, 1, 1, 1}}};
            int[][][] cropPairAgeArray = new int[][][]{new int[][]{{0, 7, 7, 7, 7, 7, 0}, {7, 7, 3, 1, 7, 1, 0}}, new int[][]{{1, 6, 2, 0, 0, 7, 7}, {0, 0, 1, 0, 0, 0, 0}}, new int[][]{{0, 0, 1, 1, 0, 1, 0}, {0, 1, 0, 0, 1, 0, 0}}, new int[][]{{0, 0, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0}}};
            for (int crop_pair = 0; crop_pair < cropPairAgeArray.length; ++crop_pair) {
                Block[] cropBlocks = StructureVillageVN.chooseCropPair(random);
                for (int crop_member = 0; crop_member < 2; ++crop_member) {
                    for (int i = 0; i < cropPairAgeArray[crop_pair][crop_member].length; ++i) {
                        IBlockState cropState;
                        int cropProgressMeta = cropPairAgeArray[crop_pair][crop_member][i];
                        while (true) {
                            try {
                                cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                            }
                            catch (IllegalArgumentException e) {
                                if (cropProgressMeta == 0) {
                                    cropState = Blocks.field_150464_aj.func_176203_a(cropPairAgeArray[crop_pair][crop_member][i]);
                                    break;
                                }
                                cropProgressMeta /= 2;
                                continue;
                            }
                            break;
                        }
                        this.func_175811_a(world, cropState, uPairArray[crop_pair][crop_member][i], vPairArray[crop_pair][crop_member][i], wPairArray[crop_pair][crop_member][i], structureBB);
                    }
                }
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), 1, 1, 1, structureBB);
                this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), 1, 0, 1, structureBB);
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), 1, 1, 11, structureBB);
                this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), 1, 0, 1, structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 0;
                int w = 3;
                int v = 1;
                while (w == 3 || w == 9) {
                    u = random.nextInt(9);
                    w = 1 + random.nextInt(11);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsFletcherHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"           ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "   FFFFF   ", "    FFF    ", " F   P  F F", "    FPF FFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsFletcherHouse1() {
        }

        public PlainsFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var20_44;
            void var20_42;
            int u;
            void var20_40;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u2 = 0; u2 < STRUCTURE_WIDTH; ++u2) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u2, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u3 = 0; u3 < foundationPattern[0].length(); ++u3) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u3, u3 + 1).toUpperCase();
                    int posX = this.func_74865_a(u3, w);
                    int posY = this.func_74862_a(0);
                    int n = this.func_74873_b(u3, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0 + (world.func_180495_p(new BlockPos(posX, posY, n)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, n, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, n)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u3, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u3, 0, w, structureBB);
                }
            }
            for (int[] uwg : new int[][]{{8, 0, 0}, {9, 0, 1}, {10, 0, 1}, {8, 1, 0}, {10, 1, 0}}) {
                if (uwg[2] == 0) {
                    this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), uwg[0], 1, uwg[1], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(2), uwg[0], 1, uwg[1], structureBB);
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), uwg[0], 2, uwg[1], structureBB);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 4}, {9, 4}, {1, 7}, {9, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], 1, uw[1], uw[0], 4, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int n : new int[]{1, 9}) {
                this.func_175804_a(world, structureBB, n, 4, 5, n, 4, 6, biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            this.func_175804_a(world, structureBB, 2, 4, 7, 8, 4, 7, biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 4, 0, 3, 6, 0, 3, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 3, 0, 4, 7, 0, 4, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 2, 0, 5, 8, 0, 6, biomePlankState, biomePlankState, false);
            this.func_175811_a(world, biomePlankState, 5, 0, 2, structureBB);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[] nArray = new int[]{2, 8};
            int n = nArray.length;
            boolean bl = false;
            while (var20_40 < n) {
                u = nArray[var20_40];
                this.func_175804_a(world, structureBB, u, 1, 4, u, 4, 4, biomeCobblestoneState, biomeCobblestoneState, false);
                ++var20_40;
            }
            int[] nArray2 = new int[]{1, 9};
            n = nArray2.length;
            boolean bl2 = false;
            while (var20_42 < n) {
                u = nArray2[var20_42];
                this.func_175804_a(world, structureBB, u, 1, 5, u, 3, 6, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, u, 5, 5, u, 5, 6, biomeCobblestoneState, biomeCobblestoneState, false);
                ++var20_42;
            }
            this.func_175804_a(world, structureBB, 2, 1, 7, 8, 3, 7, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 4, 5, 7, 6, 5, 7, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 4, 1, 2, 6, 4, 2, biomePlankState, biomePlankState, false);
            int[][] nArrayArray = new int[][]{{1, 2, 5}, {1, 2, 6}, {9, 2, 5}, {9, 2, 6}, {3, 2, 7}, {5, 2, 7}, {7, 2, 7}};
            n = nArrayArray.length;
            boolean bl3 = false;
            while (var20_44 < n) {
                int[] uvw = nArrayArray[var20_44];
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                ++var20_44;
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{3, 4, 2, 0}, {4, 5, 2, 0}, {6, 5, 2, 1}, {7, 4, 2, 1}, {2, 4, 3, 0}, {3, 5, 3, 0}, {4, 6, 3, 0}, {6, 6, 3, 1}, {7, 5, 3, 1}, {8, 4, 3, 1}, {3, 5, 4, 3}, {4, 6, 4, 0}, {6, 6, 4, 1}, {7, 5, 4, 3}, {4, 6, 5, 3}, {6, 6, 5, 3}, {4, 6, 6, 2}, {6, 6, 6, 2}, {3, 5, 7, 2}, {4, 6, 7, 0}, {6, 6, 7, 1}, {7, 5, 7, 2}, {3, 5, 8, 0}, {4, 6, 8, 0}, {6, 6, 8, 1}, {7, 5, 8, 1}, {0, 4, 3, 3}, {0, 5, 4, 3}, {0, 6, 5, 3}, {0, 6, 6, 2}, {0, 5, 7, 2}, {0, 4, 8, 2}, {1, 4, 3, 3}, {1, 5, 4, 3}, {1, 6, 5, 3}, {1, 6, 6, 2}, {1, 5, 7, 2}, {1, 4, 8, 2}, {2, 5, 4, 3}, {2, 6, 5, 3}, {2, 6, 6, 2}, {2, 5, 7, 2}, {2, 4, 8, 2}, {3, 6, 5, 3}, {3, 6, 6, 2}, {7, 6, 5, 3}, {7, 6, 6, 2}, {8, 5, 4, 3}, {8, 6, 5, 3}, {8, 6, 6, 2}, {8, 5, 7, 2}, {8, 4, 8, 2}, {9, 4, 3, 3}, {9, 5, 4, 3}, {9, 6, 5, 3}, {9, 6, 6, 2}, {9, 5, 7, 2}, {9, 4, 8, 2}, {10, 4, 3, 3}, {10, 5, 4, 3}, {10, 6, 5, 3}, {10, 6, 6, 2}, {10, 5, 7, 2}, {10, 4, 8, 2}, {0, 4, 4, 6}, {0, 5, 5, 6}, {0, 5, 6, 7}, {0, 4, 7, 7}, {10, 4, 4, 6}, {10, 5, 5, 6}, {10, 5, 6, 7}, {10, 4, 7, 7}, {3, 4, 8, 5}, {4, 5, 8, 5}, {6, 5, 8, 4}, {7, 4, 8, 4}, {3, 5, 5, 0}, {3, 5, 6, 0}, {7, 5, 5, 1}, {7, 5, 6, 1}}) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 5, 6, 3, 5, 6, 8, biomePlankState, biomePlankState, false);
            for (int[] uvwo : new int[][]{{5, 3, 1, 2}, {5, 3, 3, 0}, {4, 4, 6, 2}, {6, 4, 6, 2}, {4, 2, 8, 0}, {6, 2, 8, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int u4 : new int[]{3, 7}) {
                this.func_175804_a(world, structureBB, u4, 1, 3, u4, 4, 3, biomePlankState, biomePlankState, false);
            }
            for (int u5 : new int[]{4, 6}) {
                this.func_175811_a(world, biomePlankState, u5, 5, 3, structureBB);
            }
            this.func_175811_a(world, biomePlankState, 5, 5, 2, structureBB);
            this.func_175804_a(world, structureBB, 8, 1, 5, 8, 1, 6, biomePlankState, biomePlankState, false);
            int n2 = random.nextInt(2) + 1;
            int potU = 8;
            int potV = 2;
            int potW = 6;
            int potX = this.func_74865_a(potU, potW);
            int potY = this.func_74862_a(potV);
            int potZ = this.func_74873_b(potU, potW);
            TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, n2);
            BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
            world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
            world.func_175690_a(flowerPotPos, flowerPot);
            IBlockState fletchingTableState = ModObjects.chooseModFletchingTableState(1, this.func_186165_e());
            this.func_175811_a(world, fletchingTableState, 2, 1, 6, structureBB);
            this.func_175804_a(world, structureBB, 4, 1, 5, 6, 1, 5, Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), Blocks.field_150404_cg.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), false);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int u6 : new int[]{4, 6}) {
                this.func_175811_a(world, biomeGrassState, u6, 0, 0, structureBB);
                this.func_175804_a(world, structureBB, u6, 1, 0, u6, 3, 0, biomeFenceState, biomeFenceState, false);
                this.func_175804_a(world, structureBB, u6, 4, 0, u6, 4, 1, biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            }
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), 5, 4, 0, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 5, 4, 1, structureBB);
            for (int[] uvw : new int[][]{{5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            for (int[] decorUVW : new int[][]{{1, 1, 1}}) {
                this.func_175811_a(world, biomeDirtState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 2, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int decorHeightY = decorUVW[1];
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(decorHeightY), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(decorHeightY);
                    } else {
                        decorHeightY = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : decorBlueprint) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int n3 = random.nextInt(5) + 3;
                int v = 1;
                int w = random.nextInt(3) + 4;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(n3, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(n3, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsFisherCottage1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"    FFFF  ", "    FFFF  ", "  FFFFFFFF", " FFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", " FFFFFFFF ", "  FFFFFF  ", "   FFFFF  ", "    FFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public PlainsFisherCottage1() {
        }

        public PlainsFisherCottage1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsFisherCottage1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsFisherCottage1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsFisherCottage1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var18_32;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 2, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(1);
                    int n = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 1 + (world.func_180495_p(new BlockPos(posX, posY, n)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, n, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, n)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 1, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{3, 1}, {7, 1}, {3, 5}, {7, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 2, uw[1], uw[0], 6, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int n : new int[]{3, 7}) {
                this.func_175804_a(world, structureBB, n, 6, 2, n, 6, 4, biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            int[] posX = new int[]{1, 5};
            int uw = posX.length;
            boolean bl = false;
            while (var18_32 < uw) {
                int w = posX[var18_32];
                this.func_175804_a(world, structureBB, 4, 6, w, 6, 6, w, biomeLogHorAcrossState, biomeLogHorAcrossState, false);
                ++var18_32;
            }
            this.func_175804_a(world, structureBB, 3, 1, 1, 7, 1, 5, biomeDirtState, biomeDirtState, false);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeCobblestoneState, 3, 0, 2, structureBB);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 5, 2, 2, 6, 2, 4, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 4, 2, 2, 4, 2, 4, Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            this.func_175804_a(world, structureBB, 4, 1, 2, 4, 1, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            for (int u : new int[]{3, 7}) {
                this.func_175804_a(world, structureBB, u, 2, 2, u, 5, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int w : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, 4, 2, w, 6, 5, w, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, 4, 7, w, 6, 7, w, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{3, 4, 3}, {7, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int i = 0; i <= 2; ++i) {
                this.func_175804_a(world, structureBB, 4 - i, 8 - i, 0, 4 - i, 8 - i, 6, iBlockState.func_177230_c().func_176203_a(0), iBlockState.func_177230_c().func_176203_a(0), false);
                this.func_175804_a(world, structureBB, 6 + i, 8 - i, 0, 6 + i, 8 - i, 6, iBlockState.func_177230_c().func_176203_a(1), iBlockState.func_177230_c().func_176203_a(1), false);
            }
            this.func_175804_a(world, structureBB, 5, 8, 0, 5, 8, 6, biomePlankState, biomePlankState, false);
            for (int[] uvwo : new int[][]{{3, 6, 0, 5}, {4, 7, 0, 5}, {6, 7, 0, 4}, {7, 6, 0, 4}, {3, 6, 6, 5}, {4, 7, 6, 5}, {6, 7, 6, 4}, {7, 6, 6, 4}, {5, 2, 6, 2}}) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 5, 0, 2}, {5, 5, 6, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{5, 3, 1, 2, 1, 1}, {5, 3, 5, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 4, 3, 2, 4, 3, 4, biomeTrapdoorState.func_177230_c().func_176203_a(6), biomeTrapdoorState.func_177230_c().func_176203_a(6), false);
            int chestU = 6;
            int chestV = 3;
            int chestW = 4;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_fisher");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (Object uvwm : (ChestGenHooks)new int[][]{{1, 3}, {0, 4}, {0, 5}, {0, 6}, {1, 7}, {2, 8}, {3, 8}, {4, 9}, {4, 10}, {5, 10}, {6, 10}, {7, 10}, {8, 8}, {9, 8}, {9, 7}, {9, 6}, {9, 5}, {9, 4}, {8, 3}, {7, 0}}) {
                this.func_175811_a(world, biomeGrassState, (int)uvwm[0], 1, (int)uvwm[1], structureBB);
            }
            int[][] waterDepths = new int[][]{{4, 6}, {3, 7}, {6, 7}, {6, 8}, {6, 9}, {6, 9}, {6, 8}, {4, 7}};
            for (int u = 0; u <= 7; ++u) {
                this.func_175804_a(world, structureBB, u + 1, 1, waterDepths[u][0], u + 1, 1, waterDepths[u][1], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeWoodSlabBottomState, 5, 2, 7, structureBB);
            this.func_175804_a(world, structureBB, 5, 1, 6, 5, 1, 7, biomePlankState, biomePlankState, false);
            for (int[] uvwoo : new int[][]{{2, 2, 2, 3, -1}, {7, 2, 9, 1, -1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
                this.func_175811_a(world, biomeDirtState, uvwoo[0], uvwoo[1] - 1, uvwoo[2], structureBB);
            }
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwm : new int[][]{{4, 2, 0, 0}, {5, 2, 0, 3}, {6, 2, 0, 1}}) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            this.func_175811_a(world, biomeDirtState, 7, 1, 0, structureBB);
            for (int[] uvw : new int[][]{{4, 2, -1}, {5, 2, -1}, {6, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = random.nextInt(2) + 5;
                int v = 3;
                int w = random.nextInt(2) + 2;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsCartographer1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"       ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFPFF ", "   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsCartographer1() {
        }

        public PlainsCartographer1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsCartographer1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsCartographer1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsCartographer1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var16_33;
            void var16_31;
            void var16_29;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int i = 0; i < STRUCTURE_DEPTH; ++i) {
                    this.func_74871_b(world, u, 1, i, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int i = 0; i < foundationPattern[0].length(); ++i) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(i, i + 1).toUpperCase();
                    int n = this.func_74865_a(i, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(i, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, i, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, i, 0 + (world.func_180495_p(new BlockPos(n, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, n, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(n, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, i, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, i, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[][] nArrayArray = new int[][]{{1, 2}, {5, 2}, {1, 8}, {5, 8}};
            int unitLetter = nArrayArray.length;
            boolean bl = false;
            while (var16_29 < unitLetter) {
                int[] uw = nArrayArray[var16_29];
                this.func_175804_a(world, structureBB, uw[0], 1, uw[1], uw[0], 4, uw[1], biomeLogVertState, biomeLogVertState, false);
                ++var16_29;
            }
            int[] nArray = new int[]{1, 5};
            unitLetter = nArray.length;
            boolean bl2 = false;
            while (var16_31 < unitLetter) {
                int u = nArray[var16_31];
                this.func_175804_a(world, structureBB, u, 4, 3, u, 4, 7, biomeLogVertState, biomeLogVertState, false);
                ++var16_31;
            }
            int[] nArray2 = new int[]{2, 8};
            unitLetter = nArray2.length;
            boolean bl3 = false;
            while (var16_33 < unitLetter) {
                int w = nArray2[var16_33];
                this.func_175804_a(world, structureBB, 2, 4, w, 4, 4, w, biomeLogVertState, biomeLogVertState, false);
                ++var16_33;
            }
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 2, 0, 3, 4, 0, 7, iBlockState, iBlockState, false);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeCobblestoneState, 3, 0, 2, structureBB);
            for (int u : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, u, 1, 3, u, 3, 7, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int w : new int[]{2, 8}) {
                this.func_175804_a(world, structureBB, 2, 1, w, 4, 3, w, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, 2, 5, w, 4, 5, w, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 4}, {1, 2, 6}, {5, 2, 4}, {5, 2, 6}, {3, 2, 8}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            IBlockState iBlockState2 = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int i = 0; i <= 2; ++i) {
                this.func_175804_a(world, structureBB, 2 - i, 6 - i, 1, 2 - i, 6 - i, 9, iBlockState2.func_177230_c().func_176203_a(0), iBlockState2.func_177230_c().func_176203_a(0), false);
                this.func_175804_a(world, structureBB, 4 + i, 6 - i, 1, 4 + i, 6 - i, 9, iBlockState2.func_177230_c().func_176203_a(1), iBlockState2.func_177230_c().func_176203_a(1), false);
            }
            this.func_175804_a(world, structureBB, 3, 6, 1, 3, 6, 9, iBlockState, iBlockState, false);
            IBlockState biomeWoodSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 3, 7, 1, 3, 7, 9, biomeWoodSlabBottomState, biomeWoodSlabBottomState, false);
            for (int[] uvwo : new int[][]{{1, 4, 1, 5}, {5, 4, 1, 4}, {2, 5, 1, 5}, {4, 5, 1, 4}, {1, 4, 9, 5}, {5, 4, 9, 4}, {2, 5, 9, 5}, {4, 5, 9, 4}}) {
                this.func_175811_a(world, iBlockState2.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 4, 1, 2}, {3, 4, 3, 0}, {3, 4, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 2, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeFenceState, 2, 1, 3, structureBB);
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150452_aw.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeWoodPressurePlateState, 2, 2, 3, structureBB);
            IBlockState cartographyTableState = ModObjects.chooseModCartographyTableState(2, this.func_186165_e());
            this.func_175811_a(world, cartographyTableState, 3, 1, 6, structureBB);
            int[] carpetU = new int[]{2, 2, 2, 3, 4, 4, 4, 3};
            int[] carpetW = new int[]{5, 6, 7, 7, 7, 6, 5, 5};
            for (int i = 0; i <= 7; ++i) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(i % 2 == 0 ? (GeneralConfig.useVillageColors ? this.townColor : 4) : (GeneralConfig.useVillageColors ? this.townColor2 : 0)), carpetU[i], 1, carpetW[i], structureBB);
            }
            int chestU = 4;
            int chestV = 1;
            int chestW = 3;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_cartographer");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 0, 1, 1, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(7), 6, 1, 1, structureBB);
            for (int u : new int[]{1, 2, 4, 5}) {
                this.func_175811_a(world, biomeGrassState, u, 1, 1, structureBB);
                this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(5), u, 1, 0, structureBB);
            }
            for (int f : new int[]{1, 2, 4, 5}) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, f, 2, 1, structureBB);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int n = random.nextInt(3) + 2;
                int v = 1;
                int w = random.nextInt(2) + 4;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(n, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(n, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class PlainsButcherShop2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFFF", " FFFFF ", " FFFFF ", " FFFFF ", " FFFFF ", "   P   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 12;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsButcherShop2() {
        }

        public PlainsButcherShop2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsButcherShop2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsButcherShop2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsButcherShop2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var20_51;
            void var20_49;
            void var20_47;
            void var20_45;
            void var18_33;
            int u4;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u2 = 0; u2 < STRUCTURE_WIDTH; ++u2) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u2, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u3 = 0; u3 < foundationPattern[0].length(); ++u3) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u3, u3 + 1).toUpperCase();
                    int posX = this.func_74865_a(u3, w);
                    int posY = this.func_74862_a(0);
                    int n = this.func_74873_b(u3, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0 + (world.func_180495_p(new BlockPos(posX, posY, n)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, n, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, n)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u3, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u3, 0, w, structureBB);
                }
            }
            for (int[] decorUVW : new int[][]{{6, 0, 5, 0}, {0, 0, 14, 1}}) {
                this.func_175811_a(world, decorUVW[3] == 1 ? biomeGrassState : biomeDirtState, decorUVW[0], decorUVW[1], decorUVW[2], structureBB);
                this.func_175808_b(world, biomeFillerState, decorUVW[0], decorUVW[1] - 1, decorUVW[2], structureBB);
                for (int j = 0; j < decorUVW.length; ++j) {
                    int n = decorUVW[1] + 1;
                    Random randomFromXYZ = new Random();
                    randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(decorUVW[0], decorUVW[2]), this.func_74862_a(n), this.func_74873_b(decorUVW[0], decorUVW[2])));
                    if (this.decorHeightY.size() < j + 1) {
                        this.decorHeightY.add(n);
                    } else {
                        n = this.decorHeightY.get(j);
                    }
                    ArrayList<BlueprintData> arrayList = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                    for (BlueprintData b : arrayList) {
                        this.func_175811_a(world, b.getBlockState(), decorUVW[0] + b.getUPos(), n + b.getVPos(), decorUVW[2] + b.getWPos(), structureBB);
                        if ((b.getfillFlag() & 1) != 0) {
                            this.func_175808_b(world, b.getBlockState(), decorUVW[0] + b.getUPos(), n + b.getVPos() - 1, decorUVW[2] + b.getWPos(), structureBB);
                        }
                        if ((b.getfillFlag() & 2) == 0) continue;
                        this.func_74871_b(world, decorUVW[0] + b.getUPos(), n + b.getVPos() + 1, decorUVW[2] + b.getWPos(), structureBB);
                    }
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int u4 : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, u4, 1, 1, u4, 4, 1, biomeLogVertState, biomeLogVertState, false);
                this.func_175804_a(world, structureBB, u4, 1, 8, u4, 8, 8, biomeLogVertState, biomeLogVertState, false);
                this.func_175804_a(world, structureBB, u4, 5, 4, u4, 8, 4, biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int n : new int[]{1, 5}) {
                for (Object v : (Random)new int[]{0, 2}) {
                    this.func_175804_a(world, structureBB, n, (int)(v + 2), 2, n, (int)(v + 2), 7, biomeLogHorAlongState, biomeLogHorAlongState, false);
                    this.func_175804_a(world, structureBB, n, (int)(v + 6), 5, n, (int)(v + 6), 7, biomeLogHorAlongState, biomeLogHorAlongState, false);
                }
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            int[][] decorUVW = new int[][]{{4, 1}, {4, 8}, {6, 4}, {8, 4}, {6, 8}, {8, 8}};
            u4 = decorUVW.length;
            boolean bl = false;
            while (var18_33 < u4) {
                int[] vw = decorUVW[var18_33];
                this.func_175804_a(world, structureBB, 2, vw[0], vw[1], 4, vw[0], vw[1], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
                ++var18_33;
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 2, 0, 2, 4, 0, 8, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 2, 0, 4, 2, 0, 5, biomeDirtState, biomeDirtState, false);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 3, 4, 5, 4, 4, 7, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 2, 1, 1, 4, 3, 1, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 2, 1, 8, 4, 3, 8, biomeCobblestoneState, biomeCobblestoneState, false);
            int[] nArray = new int[]{1, 5};
            int vw = nArray.length;
            boolean bl2 = false;
            while (var20_45 < vw) {
                int u5 = nArray[var20_45];
                for (int v : new int[]{1, 3}) {
                    this.func_175804_a(world, structureBB, u5, v, 2, u5, v, 7, biomeCobblestoneState, biomeCobblestoneState, false);
                }
                ++var20_45;
            }
            int[] nArray2 = new int[]{1, 5};
            vw = nArray2.length;
            boolean bl3 = false;
            while (var20_47 < vw) {
                int u6 = nArray2[var20_47];
                for (int v : new int[]{5, 7}) {
                    this.func_175804_a(world, structureBB, u6, v, 5, u6, v, 7, biomeCobblestoneState, biomeCobblestoneState, false);
                }
                ++var20_47;
            }
            int[] nArray3 = new int[]{4, 8};
            vw = nArray3.length;
            boolean bl4 = false;
            while (var20_49 < vw) {
                int w = nArray3[var20_49];
                for (int v : new int[]{5, 7, 9}) {
                    this.func_175804_a(world, structureBB, 2, v, w, 4, v, w, biomeCobblestoneState, biomeCobblestoneState, false);
                }
                ++var20_49;
            }
            int[][] nArrayArray = new int[][]{{1, 2, 3}, {1, 2, 6}, {5, 2, 3}, {5, 2, 6}, {1, 6, 6}, {5, 6, 6}, {3, 6, 4}, {3, 6, 8}};
            vw = nArrayArray.length;
            boolean bl5 = false;
            while (var20_51 < vw) {
                int[] uvw = nArrayArray[var20_51];
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                ++var20_51;
            }
            this.func_175804_a(world, structureBB, 2, 5, 0, 4, 5, 3, biomePlankState, biomePlankState, false);
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 1, 5, 0, 1, 5, 3, iBlockState.func_177230_c().func_176203_a(0), iBlockState.func_177230_c().func_176203_a(0), false);
            this.func_175804_a(world, structureBB, 5, 5, 0, 5, 5, 3, iBlockState.func_177230_c().func_176203_a(1), iBlockState.func_177230_c().func_176203_a(1), false);
            this.func_175804_a(world, structureBB, 0, 4, 0, 0, 4, 9, iBlockState.func_177230_c().func_176203_a(0), iBlockState.func_177230_c().func_176203_a(0), false);
            this.func_175804_a(world, structureBB, 6, 4, 0, 6, 4, 9, iBlockState.func_177230_c().func_176203_a(1), iBlockState.func_177230_c().func_176203_a(1), false);
            this.func_175804_a(world, structureBB, 1, 4, 9, 5, 4, 9, iBlockState.func_177230_c().func_176203_a(2), iBlockState.func_177230_c().func_176203_a(2), false);
            this.func_175804_a(world, structureBB, 3, 10, 3, 3, 10, 9, biomePlankState, biomePlankState, false);
            for (int i = 0; i <= 2; ++i) {
                this.func_175804_a(world, structureBB, 2 - i, 10 - i, 3, 2 - i, 10 - i, 9, iBlockState.func_177230_c().func_176203_a(0), iBlockState.func_177230_c().func_176203_a(0), false);
                this.func_175804_a(world, structureBB, 4 + i, 10 - i, 3, 4 + i, 10 - i, 9, iBlockState.func_177230_c().func_176203_a(1), iBlockState.func_177230_c().func_176203_a(1), false);
            }
            for (int[] uvwo : new int[][]{{1, 4, 0, 5}, {5, 4, 0, 4}, {1, 8, 3, 5}, {5, 8, 3, 4}, {2, 9, 3, 5}, {4, 9, 3, 4}, {1, 8, 9, 5}, {5, 8, 9, 4}, {2, 9, 9, 5}, {4, 9, 9, 4}, {3, 4, 4, 7}, {4, 4, 4, 7}, {2, 1, 6, 1}, {2, 1, 7, 1}}) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{1, 0, 9, 5, 0, 14}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int u7 : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, u7, 1, 9, u7, 1, 13, biomeFenceState, biomeFenceState, false);
            }
            this.func_175804_a(world, structureBB, 1, 1, 14, 5, 1, 14, biomeFenceState, biomeFenceState, false);
            for (int u7 : new int[]{1, 5}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(0), u7, 2, 14, structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 3, 0, 2}, {3, 3, 9, 0}, {3, 8, 3, 2}, {3, 3, 2, 0}, {3, 3, 7, 2}, {3, 7, 7, 2}, {3, 7, 5, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 0, 3, 4, 0, 3, Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            this.func_175811_a(world, Blocks.field_150334_T.func_176203_a(0), 3, 0, 4, structureBB);
            this.func_175804_a(world, structureBB, 3, 0, 5, 4, 0, 5, Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            this.func_175811_a(world, Blocks.field_150334_T.func_176203_a(0), 4, 1, 4, structureBB);
            this.func_175804_a(world, structureBB, 4, 6, 5, 4, 11, 5, Blocks.field_150463_bK.func_176203_a(0), Blocks.field_150463_bK.func_176203_a(0), false);
            IBlockState iBlockState2 = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{4, 5, 5, 0}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), iBlockState2.func_177230_c().func_176203_a(iBlockState2.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            this.func_175811_a(world, Blocks.field_150347_e.func_176203_a(0), 4, 10, 5, structureBB);
            for (int[] vw2 : new int[][]{{1, 5}, {3, 7}}) {
                this.func_175811_a(world, biomePlankState, 2, vw2[0], vw2[1], structureBB);
            }
            for (int i = 0; i <= 3; ++i) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(3), 2, 1 + i, 4 + i, structureBB);
            }
            this.func_175811_a(world, biomeCobblestoneState, 3, 0, 1, structureBB);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 0}, {3, 1, 8, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{3, 1, 12}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
                boolean levelflag = random.nextBoolean();
                int u8 = levelflag ? random.nextInt(2) + 3 : 3;
                int v = levelflag ? 5 : 1;
                int w = levelflag ? random.nextInt(2) + 6 : random.nextInt(6) + 2;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u8, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u8, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class PlainsButcherShop1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"            ", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFFFFFFF", " FFFFFF     ", " FFFFFF     ", "   FF       "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 4;
        private int averageGroundLevel = -1;

        public PlainsButcherShop1() {
        }

        public PlainsButcherShop1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsButcherShop1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsButcherShop1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsButcherShop1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int j;
            int i;
            void var16_30;
            int w;
            int n;
            void var16_28;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int k = 0; k < STRUCTURE_DEPTH; ++k) {
                    this.func_74871_b(world, u, 0, k, structureBB);
                }
            }
            for (int w3 = 0; w3 < foundationPattern.length; ++w3) {
                for (int k = 0; k < foundationPattern[0].length(); ++k) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w3].substring(k, k + 1).toUpperCase();
                    int n2 = this.func_74865_a(k, w3);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(k, w3);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, k, -1, w3, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, k, -1 + (world.func_180495_p(new BlockPos(n2, posY, posZ)).func_185915_l() ? -1 : 0), w3, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, n2, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(n2, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, k, -1, w3, structureBB);
                    this.func_175811_a(world, biomeTopState, k, -1, w3, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            int[] nArray = new int[]{1, 6};
            int unitLetter = nArray.length;
            boolean bl = false;
            while (var16_28 < unitLetter) {
                int u = nArray[var16_28];
                int[] posZ = new int[]{1, 9};
                int n3 = posZ.length;
                for (n = 0; n < n3; ++n) {
                    w = posZ[n];
                    this.func_175804_a(world, structureBB, u, 0, w, u, 3, w, biomeLogVertState, biomeLogVertState, false);
                }
                ++var16_28;
            }
            this.func_175804_a(world, structureBB, 1, 0, 5, 1, 2, 5, biomeLogVertState, biomeLogVertState, false);
            int[][] nArrayArray = new int[][]{{2, 1}, {5, 1}, {2, 9}, {5, 9}, {1, 2}, {1, 4}, {1, 6}, {1, 8}};
            unitLetter = nArrayArray.length;
            boolean bl2 = false;
            while (var16_30 < unitLetter) {
                int[] uw = nArrayArray[var16_30];
                this.func_175811_a(world, biomeLogVertState, uw[0], 2, uw[1], structureBB);
                ++var16_30;
            }
            IBlockState iBlockState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            for (int w4 : new int[]{2, 5, 6}) {
                this.func_175811_a(world, iBlockState, 6, 2, w4, structureBB);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int w5 : new int[]{1, 9}) {
                this.func_175804_a(world, structureBB, 2, 0, w5, 5, 1, w5, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, 2, 3, w5, 5, 4, w5, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, 3, 5, w5, 4, 5, w5, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            this.func_175804_a(world, structureBB, 1, 0, 2, 1, 1, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 1, 0, 6, 1, 1, 8, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 6, 0, 2, 6, 1, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 6, 0, 8, 6, 2, 8, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 6, 0, 7, 7, 0, 7, biomeCobblestoneState, biomeCobblestoneState, false);
            for (int[] uw : new int[][]{{1, 3}, {1, 7}, {6, 3}, {6, 4}, {3, 9}, {4, 9}}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], 2, uw[1], structureBB);
            }
            IBlockState iBlockState2 = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.func_175804_a(world, structureBB, i2, 3 + i2, 0, i2, 3 + i2, STRUCTURE_DEPTH - 1, iBlockState2.func_177230_c().func_176203_a(0), iBlockState2.func_177230_c().func_176203_a(0), false);
                this.func_175804_a(world, structureBB, 7 - i2, 3 + i2, 0, 7 - i2, 3 + i2, STRUCTURE_DEPTH - 1, iBlockState2.func_177230_c().func_176203_a(1), iBlockState2.func_177230_c().func_176203_a(1), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (i = 0; i < 3; ++i) {
                this.func_175804_a(world, structureBB, 1 + i, 3 + i, 2, 1 + i, 3 + i, STRUCTURE_DEPTH - 3, biomePlankState, biomePlankState, false);
                this.func_175804_a(world, structureBB, 6 - i, 3 + i, 2, 6 - i, 3 + i, STRUCTURE_DEPTH - 3, biomePlankState, biomePlankState, false);
            }
            for (i = 0; i < 3; ++i) {
                int[] uw = new int[]{0, STRUCTURE_DEPTH - 1};
                n = uw.length;
                for (w = 0; w < n; ++w) {
                    j = uw[w];
                    this.func_175811_a(world, iBlockState2.func_177230_c().func_176203_a(5), 1 + i, 3 + i, j, structureBB);
                    this.func_175811_a(world, iBlockState2.func_177230_c().func_176203_a(4), 6 - i, 3 + i, j, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 2, 5, 0, 5}, {5, 0, 6, 5, 0, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomePlankState, biomePlankState, false);
            }
            for (int[] uuvvwwo : new int[][]{{7, 0, 4, 10, 0, 6}, {8, 0, 7, 10, 0, 7}, {7, 0, 8, 10, 0, 8}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeGrassState, biomeGrassState, false);
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState[] penrimState = new IBlockState[]{biomeLogVertState, biomeFenceState};
            for (int i3 = 0; i3 <= 1; ++i3) {
                int[] uuvvwwo = new int[]{3, 9};
                j = uuvvwwo.length;
                for (int k = 0; k < j; ++k) {
                    int w6 = uuvvwwo[k];
                    this.func_175804_a(world, structureBB, 7, i3, w6, 10, i3, w6, penrimState[i3], penrimState[i3], false);
                }
                this.func_175804_a(world, structureBB, 11, i3, 3, 11, i3, 9, penrimState[i3], penrimState[i3], false);
            }
            this.func_175804_a(world, structureBB, 7, 1, 5, 7, 1, 6, Blocks.field_150407_cf.func_176203_a(0), Blocks.field_150407_cf.func_176203_a(0), false);
            for (int[] uvwm : new int[][]{{2, 2, 0, 2}, {5, 2, 0, 2}, {0, 2, 5, 3}, {2, 3, 3, 1}, {5, 3, 7, 3}, {11, 2, 3, -1}, {11, 2, 9, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwm[3])), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 2, 0, 6, 4, 0, 8, Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            this.func_175804_a(world, structureBB, 2, 1, 7, 3, 1, 7, Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            for (int[] uvwo : new int[][]{{5, 1, 8, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            this.func_175811_a(world, Blocks.field_150347_e.func_176203_a(0), 5, 5, 8, structureBB);
            this.func_175804_a(world, structureBB, 5, 2, 8, 5, 4, 8, Blocks.field_150463_bK.func_176203_a(0), Blocks.field_150463_bK.func_176203_a(0), false);
            this.func_175804_a(world, structureBB, 5, 6, 8, 5, 7, 8, Blocks.field_150463_bK.func_176203_a(0), Blocks.field_150463_bK.func_176203_a(0), false);
            this.func_175811_a(world, biomeFenceState, 2, 1, 3, structureBB);
            IBlockState biomeWoodPressurePlateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150452_aw.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeWoodPressurePlateState, 2, 2, 3, structureBB);
            int flowernumber = random.nextInt(2) + 1;
            this.func_175811_a(world, biomePlankState, 5, 1, 2, structureBB);
            int potU = 5;
            int potV = 2;
            int potW = 2;
            int potX = this.func_74865_a(potU, potW);
            int potY = this.func_74862_a(potV);
            int potZ = this.func_74873_b(potU, potW);
            TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
            BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
            world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
            world.func_175690_a(flowerPotPos, flowerPot);
            for (int[] wo : new int[][]{{2, 2}, {4, 3}}) {
                this.func_175811_a(world, iBlockState2.func_177230_c().func_176203_a(wo[1]), 2, 1, wo[0], structureBB);
            }
            this.func_175804_a(world, structureBB, 3, 0, 0, 4, 0, 0, iBlockState2.func_177230_c().func_176203_a(3), iBlockState2.func_177230_c().func_176203_a(3), false);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 2, 1, 1}, {4, 1, 1, 2, 1, 0}, {6, 1, 7, 1, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 0, -1}, {4, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{9, 1, 6}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
                int u = random.nextInt(3) + 3;
                int v = 1;
                int w7 = random.nextInt(4) + 3;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w7) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w7) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class PlainsBigHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"           ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", " FFFFFFFFF ", "     P     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 11;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsBigHouse1() {
        }

        public PlainsBigHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsBigHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)11, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsBigHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsBigHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 1}, {1, 5}, {9, 1}, {9, 5}}) {
                this.func_175804_a(world, structureBB, uw[0], 1, uw[1], uw[0], 7, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            this.func_175804_a(world, structureBB, 2, 4, 1, 8, 4, 1, biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 2, 4, 5, 8, 4, 5, biomeLogVertState, biomeLogVertState, false);
            this.func_175804_a(world, structureBB, 5, 1, 5, 5, 3, 5, biomeLogVertState, biomeLogVertState, false);
            for (int i : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, 5, 5, i, 5, 7, i, biomeLogVertState, biomeLogVertState, false);
            }
            for (int i : new int[]{1, 9}) {
                this.func_175804_a(world, structureBB, i, 4, 2, i, 4, 4, biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 2, 1, 1, 8, 3, 1, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 2, 1, 5, 4, 3, 5, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 6, 1, 5, 8, 3, 5, biomeCobblestoneState, biomeCobblestoneState, false);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int i : new int[]{1, 5}) {
                this.func_175804_a(world, structureBB, 2, 5, i, 4, 7, i, biomePlankState, biomePlankState, false);
                this.func_175804_a(world, structureBB, 6, 5, i, 8, 7, i, biomePlankState, biomePlankState, false);
            }
            for (int i : new int[]{1, 9}) {
                this.func_175804_a(world, structureBB, i, 1, 2, i, 3, 4, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, i, 5, 2, i, 8, 4, biomePlankState, biomePlankState, false);
                this.func_175811_a(world, biomePlankState, i, 9, 3, structureBB);
            }
            for (int v : new int[]{2, 6}) {
                for (int[] uw : new int[][]{{1, 3}, {9, 3}, {3, 1}, {7, 1}, {3, 5}, {7, 5}}) {
                    this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), uw[0], v, uw[1], structureBB);
                }
            }
            for (int i = 0; i <= 3; ++i) {
                int[] nArray;
                if (i == 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = i;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = -i;
                    nArray = nArray3;
                    nArray3[1] = i;
                }
                for (int j : nArray) {
                    this.func_175804_a(world, structureBB, 0, 10 - i, 3 + j, 10, 10 - i, 3 + j, biomePlankState, biomePlankState, false);
                }
            }
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int height = 0; height <= 1; ++height) {
                this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(2, this.func_186165_e(), true, true)[height]), 5, 1 + height, 1, structureBB);
            }
            this.func_175811_a(world, biomeCobblestoneState, 5, 0, 1, structureBB);
            for (int[] uvw : new int[][]{{5, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            this.func_175804_a(world, structureBB, 2, 0, 2, 8, 0, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 5, 2, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 2, 3, 4, 3, 3, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            IBlockState biomeStoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int i = 0; i < 4; ++i) {
                this.func_175811_a(world, biomeStoneStairsBlock.func_177230_c().func_176203_a(1), 3 + i, 4 - i, 4, structureBB);
            }
            this.func_175804_a(world, structureBB, 2, 4, 2, 8, 4, 3, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 7, 4, 4, 8, 4, 4, biomePlankState, biomePlankState, false);
            this.func_175811_a(world, biomePlankState, 2, 4, 4, structureBB);
            for (int[] uvwm : new int[][]{{2, 3, 3, 1}, {8, 3, 3, 3}, {2, 7, 3, 1}, {8, 7, 3, 3}, {5, 6, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwm[3])), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{2, 1, 3, 2}, {7, 1, 2, 3}, {3, 5, 2, 1}, {7, 5, 2, 3}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwm[3];
                    int u = uvwm[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwm[1];
                    int w = uvwm[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor2 : 0);
                }
            }
            int chestU = 8;
            int chestV = 5;
            int chestW = 4;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 3, -1, 0}, {8, 1, 3, -1, 0}, {2, 5, 3, -1, 0}, {8, 5, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsArmorerHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"        ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", " FFFFFF ", "   FF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int GROUND_LEVEL = 0;
        private int averageGroundLevel = -1;

        public PlainsArmorerHouse1() {
        }

        public PlainsArmorerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsArmorerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)8, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsArmorerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsArmorerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var20_42;
            int i;
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uuvvww : new int[][]{{1, 0, 1, 6, 0, 7}, {2, 0, 1, 2, 4, 1}, {5, 0, 1, 5, 4, 1}, {3, 3, 1, 4, 5, 1}, {2, 1, 7, 5, 4, 7}, {3, 5, 7, 4, 5, 7}, {1, 1, 2, 1, 3, 6}, {6, 1, 2, 6, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCobblestoneState, biomeCobblestoneState, false);
            }
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uw : new int[][]{{1, 1}, {1, 7}, {6, 1}, {6, 7}}) {
                this.func_175804_a(world, structureBB, uw[0], 0, uw[1], uw[0], 3, uw[1], biomeLogVertState, biomeLogVertState, false);
            }
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            this.func_175804_a(world, structureBB, 1, 2, 2, 1, 2, 6, biomeLogHorAlongState, biomeLogHorAlongState, false);
            for (int i2 : new int[]{3, 5}) {
                this.func_175811_a(world, Blocks.field_150410_aZ.func_176203_a(0), 1, 2, i2, structureBB);
            }
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            this.func_175804_a(world, structureBB, 2, 2, 7, 5, 2, 7, biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            this.func_175804_a(world, structureBB, 3, 2, 7, 4, 2, 7, Blocks.field_150410_aZ.func_176203_a(0), Blocks.field_150410_aZ.func_176203_a(0), false);
            IBlockState biomeWoodStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150476_ad.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (i = 0; i < 4; ++i) {
                this.func_175804_a(world, structureBB, i, 3 + i, 0, i, 3 + i, 8, biomeWoodStairsState.func_177230_c().func_176203_a(0), biomeWoodStairsState.func_177230_c().func_176203_a(0), false);
                this.func_175804_a(world, structureBB, 7 - i, 3 + i, 0, 7 - i, 3 + i, 8, biomeWoodStairsState.func_177230_c().func_176203_a(1), biomeWoodStairsState.func_177230_c().func_176203_a(1), false);
            }
            for (i = 0; i < 3; ++i) {
                int[] i2 = new int[]{0, 8};
                int n = i2.length;
                for (int j = 0; j < n; ++j) {
                    int j2 = i2[j];
                    this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(5), 1 + i, 3 + i, j2, structureBB);
                    this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a(4), 6 - i, 3 + i, j2, structureBB);
                }
            }
            for (i = 0; i < 2; ++i) {
                this.func_175811_a(world, biomeWoodStairsState.func_177230_c().func_176203_a((new int[]{2, 3})[i] + 4), 7, 3, (new int[]{2, 6})[i], structureBB);
            }
            IBlockState biomeWoodSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(8), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 7, 3, 3, 7, 3, 5, biomeWoodSlabTopState, biomeWoodSlabTopState, false);
            for (int i3 : new int[]{2, 5}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(2)), i3, 2, 0, structureBB);
            }
            this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(1)), 2, 2, 4, structureBB);
            for (int i2 : new int[]{2, 6}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(3)), 5, 4, i2, structureBB);
            }
            IBlockState smoothStoneState = ModObjects.chooseModSmoothStoneBlockState();
            for (int[] uuww : new int[][]{{2, 2, 2, 5}, {2, 5, 6, 6}}) {
                this.func_175804_a(world, structureBB, uuww[0], 1, uuww[2], uuww[1], 1, uuww[3], smoothStoneState, smoothStoneState, false);
            }
            for (int i4 : new int[]{3, 5}) {
                this.func_175804_a(world, structureBB, 5, 1, i4, 5, 2, i4, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            int n = 3;
            while (var20_42 <= 5) {
                this.func_175804_a(world, structureBB, 7, 0, (int)var20_42, 7, 1, (int)var20_42, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeCobblestoneState, 7, -1, (int)var20_42, structureBB);
                ++var20_42;
            }
            this.func_175811_a(world, biomeCobblestoneState, 5, 3, 4, structureBB);
            IBlockState iBlockState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] nArray : new int[][]{{3, 0, 0, 3}, {4, 0, 0, 3}, {7, 2, 3, 3}, {7, 2, 4, 1}, {7, 2, 5, 2}, {5, 3, 3, 3}, {5, 3, 5, 2}, {5, 4, 4, 0}}) {
                this.func_175811_a(world, iBlockState.func_177230_c().func_176203_a(nArray[3]), nArray[0], nArray[1], nArray[2], structureBB);
            }
            IBlockState biomeCobblestoneWallState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150463_bK.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175804_a(world, structureBB, 6, 3, 4, 6, 6, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175811_a(world, biomeCobblestoneWallState, 6, 7, 4, structureBB);
            IBlockState biomeBrickState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150336_V.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeBrickState, 5, 0, 4, structureBB);
            this.func_175811_a(world, biomeBrickState, 6, 2, 4, structureBB);
            IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(3, this.func_186165_e());
            for (int[] uvw : new int[][]{{6, 1, 4}}) {
                this.func_175811_a(world, blastFurnaceState, uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            IBlockState iBlockState2 = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int height = 0; height < 2; ++height) {
                for (int leftright = 0; leftright < 2; ++leftright) {
                    this.func_175811_a(world, iBlockState2.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(2, this.func_186165_e(), true, leftright == 0)[height]), 3 + leftright, 1 + height, 1, structureBB);
                }
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = random.nextInt(2) + 3;
                int v = 1;
                int w = random.nextInt(4) + 2;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class PlainsAnimalPen3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"   FFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFF  ", "  FFFFFFF F", "F FFFFFFF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsAnimalPen3() {
        }

        public PlainsAnimalPen3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsAnimalPen3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return PlainsAnimalPen3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsAnimalPen3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            void var15_29;
            int posX;
            int w;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w2 = 0; w2 < foundationPattern.length; ++w2) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String string = foundationPattern[foundationPattern.length - 1 - w2].substring(u, u + 1).toUpperCase();
                    posX = this.func_74865_a(u, w2);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w2);
                    if (string.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w2, structureBB);
                        continue;
                    }
                    if (string.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w2, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w2, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w2, structureBB);
                }
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (w = 0; w < STRUCTURE_DEPTH; ++w) {
                void var15_22;
                int n = (new int[]{2, 2, 0, 0, 0, 0, 0, 3})[w];
                while (var15_22 <= (new int[]{8, 8, 8, 10, 10, 10, 10, 10})[w]) {
                    if (var15_22 == (new int[]{2, 2, 0, 0, 0, 0, 0, 3})[w] || var15_22 == (new int[]{8, 8, 8, 10, 10, 10, 10, 10})[w] || w == 0 || w == STRUCTURE_DEPTH - 1) {
                        this.func_175811_a(world, biomeFenceState, (int)var15_22, 1, w, structureBB);
                    }
                    ++var15_22;
                }
            }
            for (int[] uw : new int[][]{{1, 2}, {2, 2}, {9, 3}, {8, 3}, {1, 6}, {2, 6}, {3, 6}}) {
                this.func_175811_a(world, biomeFenceState, uw[0], 1, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{0, 0}, {10, 1}}) {
                this.func_175811_a(world, biomeDirtState, uw[0], 0, uw[1], structureBB);
                this.func_175808_b(world, biomeFillerState, uw[0], -1, uw[1], structureBB);
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{5, 1, 0, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int i : new int[]{0, 2}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(0), 4 + i, 2, 0, structureBB);
            }
            int[][] nArrayArray = new int[][]{{2, 0, 0, 8, 0, 1}, {0, 0, 2, 8, 0, 2}, {0, 0, 3, 10, 0, 6}, {3, 0, 7, 10, 0, 7}};
            posX = nArrayArray.length;
            for (int uw = 0; uw < posX; ++uw) {
                int[] uuvvwwo = nArrayArray[uw];
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeGrassState, biomeGrassState, false);
            }
            boolean bl = false;
            while (var15_29 < 3) {
                for (int w3 = 0; w3 < 3; ++w3) {
                    if (var15_29 != true && w3 != 1) continue;
                    this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), 6 + var15_29, 0, 4 + w3, structureBB);
                }
                ++var15_29;
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{1, 1, 4}, {5, 1, 2}, {5, 1, 5}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                        String[] petname_a = NameGenerator.newRandomName("pet", random);
                        animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                    }
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            int[][] nArrayArray2 = new int[][]{{0, 1, 0}, {3, 1, 4}, {7, 1, 3}, {10, 1, 1}};
            for (int j = 0; j < nArrayArray2.length; ++j) {
                int[] uvw = nArrayArray2[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = uvw[1];
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsAnimalPen2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int STRUCTURE_WIDTH = 11;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int STRUCTURE_DEPTH = 7;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsAnimalPen2() {
        }

        public PlainsAnimalPen2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsAnimalPen2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)11, (int)7, (int)7, (EnumFacing)coordBaseMode);
            return PlainsAnimalPen2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsAnimalPen2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeDirtState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + 0, this.field_74887_e.field_78896_c + 0, this.field_74887_e.field_78893_d - 0, this.field_74887_e.field_78892_f - 0), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int u = 0; u < 11; ++u) {
                for (int w = 0; w < 7; ++w) {
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeGrassState, u, 0, w, structureBB);
                    this.func_74871_b(world, u, 1, w, structureBB);
                    if (u != 0 && u != 10 && w != 0 && w != 6) continue;
                    this.func_175811_a(world, biomeFenceState, u, 1, w, structureBB);
                }
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{5, 1, 0, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(0), 7, 1, 3, structureBB);
            ArrayList<Integer> weedpositions = new ArrayList<Integer>();
            while (weedpositions.size() < 14) {
                int candidatevalue;
                while (weedpositions.contains(candidatevalue = random.nextInt(45))) {
                }
                weedpositions.add(candidatevalue);
            }
            for (int i = 0; i < weedpositions.size(); ++i) {
                if (i == 0) {
                    IBlockState cornflowerState = ModObjects.chooseModCornflower();
                    IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                    int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                    IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                    this.func_175811_a(world, flowerstate, (Integer)weedpositions.get(i) % 9 + 1, 1, (Integer)weedpositions.get(i) / 9 + 1, structureBB);
                    continue;
                }
                this.func_175811_a(world, i < 11 ? Blocks.field_150329_H.func_176203_a(1) : Blocks.field_150398_cm.func_176203_a(2), (Integer)weedpositions.get(i) % 9 + 1, 1, (Integer)weedpositions.get(i) / 9 + 1, structureBB);
                if (i < 11) continue;
                this.func_175811_a(world, Blocks.field_150398_cm.func_176203_a(11), (Integer)weedpositions.get(i) % 9 + 1, 2, (Integer)weedpositions.get(i) / 9 + 1, structureBB);
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{2, 1, 4, -1, 1}}) {
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{3, 1, 2}, {7, 1, 4}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                        String[] petname_a = NameGenerator.newRandomName("pet", random);
                        animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                    }
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsAnimalPen1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int STRUCTURE_WIDTH = 6;
        public static final int STRUCTURE_HEIGHT = 8;
        private static final int STRUCTURE_DEPTH = 5;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsAnimalPen1() {
        }

        public PlainsAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)6, (int)8, (int)5, (EnumFacing)coordBaseMode);
            return PlainsAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeDirtState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int u = 0; u < 6; ++u) {
                for (int w = 0; w < 5; ++w) {
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeGrassState, u, 0, w, structureBB);
                    this.func_74871_b(world, u, 1, w, structureBB);
                    if (u != 0 && u != 5 && w != 0 && w != 4) continue;
                    this.func_175811_a(world, biomeFenceState, u, 1, w, structureBB);
                }
            }
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwos : new int[][]{{2, 1, 0, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            ArrayList<Integer> weedpositions = new ArrayList<Integer>();
            while (weedpositions.size() < 3) {
                int candidatevalue;
                while (weedpositions.contains(candidatevalue = random.nextInt(12))) {
                }
                weedpositions.add(candidatevalue);
            }
            for (int i = 0; i < weedpositions.size(); ++i) {
                if (i == 0) {
                    IBlockState cornflowerState = ModObjects.chooseModCornflower();
                    IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                    int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                    IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                    this.func_175811_a(world, flowerstate, (Integer)weedpositions.get(i) % 4 + 1, 1, (Integer)weedpositions.get(i) / 4 + 1, structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), (Integer)weedpositions.get(i) % 4 + 1, 1, (Integer)weedpositions.get(i) / 4 + 1, structureBB);
            }
            IBlockState biomeSaplingState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150345_g.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwss : new int[][]{{4, 1, 3, -1, -1}}) {
                this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2], structureBB);
                if (!(biomeSaplingState.func_177230_c() instanceof BlockSapling)) continue;
                if (biomeSaplingState.func_177230_c().func_176201_c(biomeSaplingState) == 5) {
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                    this.func_175811_a(world, biomeSaplingState, uvwss[0] + uvwss[3], uvwss[1], uvwss[2] + uvwss[4], structureBB);
                }
                ((BlockSapling)biomeSaplingState.func_177230_c()).func_176476_e(world, new BlockPos(this.func_74865_a(uvwss[0], uvwss[2]), this.func_74862_a(uvwss[1]), this.func_74873_b(uvwss[0], uvwss[2])), biomeSaplingState, world.field_73012_v);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                BlockPos animalPos = new BlockPos((double)this.func_74865_a(1, 2) + 0.5, (double)this.func_74862_a(1) + 0.5, (double)this.func_74873_b(1, 2) + 0.5);
                EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, true, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                if (VillageGeneratorConfigHandler.nameVillageHorses && GeneralConfig.nameEntities && animal instanceof EntityHorse) {
                    String[] petname_a = NameGenerator.newRandomName("pet", random);
                    animal.func_96094_a((petname_a[1] + " " + petname_a[2] + " " + petname_a[3]).trim());
                }
                animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)animal);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsAccessory1
    extends StructureVillagePieces.Village {
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int STRUCTURE_WIDTH = 5;
        public static final int STRUCTURE_HEIGHT = 2;
        private static final int STRUCTURE_DEPTH = 3;
        private static final int GROUND_LEVEL = 1;
        private int averageGroundLevel = -1;

        public PlainsAccessory1() {
        }

        public PlainsAccessory1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static PlainsAccessory1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)5, (int)2, (int)3, (EnumFacing)coordBaseMode);
            return PlainsAccessory1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new PlainsAccessory1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeDirtState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < 5; ++u) {
                for (int w = 0; w < 3; ++w) {
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeGrassState, u, 0, w, structureBB);
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            this.func_175804_a(world, structureBB, 1, 1, 1, 3, 1, 1, Blocks.field_150349_c.func_176223_P(), Blocks.field_150349_c.func_176223_P(), false);
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 0, 1, 1, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(7), 4, 1, 1, structureBB);
            this.func_175804_a(world, structureBB, 1, 1, 0, 3, 1, 0, biomeTrapdoorState.func_177230_c().func_176203_a(5), biomeTrapdoorState.func_177230_c().func_176203_a(5), false);
            this.func_175804_a(world, structureBB, 1, 1, 2, 3, 1, 2, biomeTrapdoorState.func_177230_c().func_176203_a(4), biomeTrapdoorState.func_177230_c().func_176203_a(4), false);
            for (int f = 0; f < 3; ++f) {
                IBlockState cornflowerState = ModObjects.chooseModCornflower();
                IBlockState lilyOfTheValleyState = ModObjects.chooseModLilyOfTheValley();
                int flowerindex = random.nextInt(10 + (cornflowerState != null && lilyOfTheValleyState != null ? 2 : 0));
                IBlockState flowerstate = flowerindex == 10 && cornflowerState != null ? cornflowerState : (flowerindex == 11 && lilyOfTheValleyState != null ? lilyOfTheValleyState : (flowerindex == 9 ? Blocks.field_150327_N : Blocks.field_150328_O).func_176203_a((new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 0})[flowerindex % 10]));
                this.func_175811_a(world, flowerstate, 1 + f, 2, 1, structureBB);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class PlainsMeetingPoint3
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"FFFFPFFPFFF", "PFPFFPFFPFF", "PFPPFPFFFPF", "FPFFPPFPFFF", "FFPFFFFPPFF", "PFFPFFFFFPP", "FPFFFFFPFFP", "FPFFFPFFFPF", "PFPPFFFFFPF", "FPFFFFFFPFP", "FPPPFPPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        public static final int GROUND_LEVEL = 1;

        public PlainsMeetingPoint3() {
        }

        public PlainsMeetingPoint3(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 72, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 72, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 4, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 4, EnumFacing.WEST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState concreteBlockstate;
            int w;
            int v;
            int u;
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)14, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWallSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150444_as.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneStoneStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150446_ar.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u2 = 0; u2 < STRUCTURE_WIDTH; ++u2) {
                for (int w2 = 0; w2 < STRUCTURE_DEPTH; ++w2) {
                    this.func_74871_b(world, u2, 1, w2, structureBB);
                }
            }
            for (int w3 = 0; w3 < foundationPattern.length; ++w3) {
                for (int u3 = 0; u3 < foundationPattern[0].length(); ++u3) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w3].substring(u3, u3 + 1).toUpperCase();
                    int posX = this.func_74865_a(u3, w3);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u3, w3);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0, w3, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u3, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w3, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u3, 0, w3, structureBB);
                    this.func_175811_a(world, biomeTopState, u3, 0, w3, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(5, 5), this.func_74862_a(2), this.func_74873_b(5, 5));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            for (int[] offset_xy : new int[][]{{0, 1}, {0, 4}, {1, 5}, {1, 8}, {2, 1}, {2, 4}, {2, 5}, {2, 7}, {2, 10}, {3, 3}, {3, 6}, {3, 9}, {4, 3}, {4, 8}, {5, 1}, {5, 2}, {5, 10}, {6, 2}, {6, 3}, {6, 9}, {7, 1}, {7, 3}, {7, 5}, {7, 8}, {8, 2}, {8, 4}, {9, 6}, {9, 9}, {10, 7}}) {
                this.func_175811_a(world, biomeCobblestoneState, offset_xy[0], 0, offset_xy[1], structureBB);
            }
            for (int[] offset_xy : new int[][]{{0, 3}, {1, 2}, {1, 6}, {3, 4}, {3, 10}, {4, 2}, {6, 7}, {6, 8}, {7, 0}, {8, 0}, {8, 5}, {8, 8}, {10, 0}, {10, 3}}) {
                this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), offset_xy[0], 1, offset_xy[1], structureBB);
            }
            this.func_175811_a(world, Blocks.field_150327_N.func_176223_P(), 3, 1, 1, structureBB);
            for (int[] uvwm : new int[][]{{4, 1, 4, 3}, {5, 1, 4, 3}, {6, 1, 4, 1}, {6, 1, 5, 1}, {6, 1, 6, 2}, {5, 1, 6, 2}, {4, 1, 6, 0}, {4, 1, 5, 0}}) {
                this.func_175811_a(world, biomeCobblestoneStoneStairsState.func_177230_c().func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            world.func_180501_a(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(0), this.func_74873_b(5, 5)), Blocks.field_150346_d.func_176223_P(), 2);
            for (u = 3; u <= 7; ++u) {
                for (v = 5; v <= 6; ++v) {
                    for (w = 4; w <= 6; ++w) {
                        world.func_180501_a(new BlockPos(this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w)), Blocks.field_150362_t.func_176203_a(0), 2);
                    }
                }
            }
            for (u = 4; u <= 6; ++u) {
                for (v = 5; v <= 6; ++v) {
                    for (w = 3; w <= 7; ++w) {
                        world.func_180501_a(new BlockPos(this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w)), Blocks.field_150362_t.func_176203_a(0), 2);
                    }
                }
            }
            for (u = 4; u <= 6; ++u) {
                for (v = 7; v <= 8; ++v) {
                    for (w = 4; w <= 6; ++w) {
                        world.func_180501_a(new BlockPos(this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w)), Blocks.field_150362_t.func_176203_a(0), 2);
                    }
                }
            }
            for (int v2 = 1; v2 <= 7; ++v2) {
                world.func_180501_a(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(v2), this.func_74873_b(5, 5)), Blocks.field_150364_r.func_176203_a(0), 2);
            }
            for (int[] uvw : new int[][]{{4, 5, 3}, {4, 5, 7}, {6, 5, 7}, {5, 6, 7}, {4, 8, 4}, {6, 8, 4}, {6, 8, 6}, {4, 8, 6}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), Blocks.field_150350_a.func_176223_P(), 2);
            }
            for (int[] uvwo : new int[][]{{5, 3, 4, 2}, {4, 3, 5, 3}, {5, 3, 6, 0}, {6, 3, 5, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 4, 1, 1, 4, 4, 1, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 6, 1, 1, 6, 4, 1, biomeFenceState, biomeFenceState, false);
            if (GeneralConfig.useVillageColors) {
                concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175811_a(world, concreteBlockstate, 5, 4, 1, structureBB);
            } else {
                this.func_175811_a(world, biomeCobblestoneState, 5, 4, 1, structureBB);
            }
            this.func_175804_a(world, structureBB, 4, 1, 9, 4, 4, 9, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 6, 1, 9, 6, 4, 9, biomeFenceState, biomeFenceState, false);
            if (GeneralConfig.useVillageColors) {
                concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor2);
                this.func_175811_a(world, concreteBlockstate, 5, 4, 9, structureBB);
            } else {
                this.func_175811_a(world, biomeCobblestoneState, 5, 4, 9, structureBB);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 5;
                int signYBB = 4;
                int signZBB = 0;
                int signZBB2 = 10;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signX2 = this.func_74865_a(signXBB, signZBB2);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                int signZ2 = this.func_74873_b(signXBB, signZBB2);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(2, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
                TileEntitySign signContents2 = new TileEntitySign();
                for (int i = 0; i < 4; ++i) {
                    signContents2.field_145915_a[i] = signContents.field_145915_a[i];
                }
                world.func_180501_a(new BlockPos(signX2, signY, signZ2), biomeWallSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), true)), 2);
                world.func_175690_a(new BlockPos(signX2, signY, signZ2), (TileEntity)signContents2);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 7;
                int bannerZBB = 8;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{8, 1, 6, -1, 0}, {9, 1, 2, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class PlainsMeetingPoint2
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"FPPFFFFF", "FPPPFFFF", "FFPPFPPF", "FFFPFFPP", "FFFPFPFF", "FFFPPFFP", "FFFFFPPP", "FFFPPPPP", "FFFFPFFP", "FFFFPPPP", "FPFPPPFP", "PPPFPPPP", "PPPPFPPF", "FFPPFFFF", "FPPPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        public static final int GROUND_LEVEL = 1;

        public PlainsMeetingPoint2() {
        }

        public PlainsMeetingPoint2(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 68, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 68, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 0 ? 1 : (this.func_186165_e().func_176736_b() == 1 ? 10 : (this.func_186165_e().func_176736_b() == 2 ? 1 : 2))), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 0 ? 6 : (this.func_186165_e().func_176736_b() == 1 ? 1 : (this.func_186165_e().func_176736_b() == 2 ? 6 : 1))), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() == 0 ? 1 : (this.func_186165_e().func_176736_b() == 1 ? 6 : (this.func_186165_e().func_176736_b() == 2 ? 1 : 6))), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() == 0 ? 2 : (this.func_186165_e().func_176736_b() == 1 ? 1 : (this.func_186165_e().func_176736_b() == 2 ? 10 : 1))), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodenSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150376_bx.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(4, 4), this.func_74862_a(12), this.func_74873_b(4, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), 0, 1, 8, structureBB);
            this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), 1, 1, 7, structureBB);
            this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), 1, 1, 12, structureBB);
            this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), 4, 1, 10, structureBB);
            this.func_175811_a(world, Blocks.field_150329_H.func_176203_a(1), 4, 1, 11, structureBB);
            this.func_175804_a(world, structureBB, 4, 1, 1, 7, 1, 1, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 4, 0, 1, 7, 0, 1, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 4, 1, 0, 4, 3, 0, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 2, 4, 3, 2, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 2, 7, 3, 2, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 0, 7, 3, 0, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 4, 0, 7, 4, 2, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 5, 4, 0, 6, 4, 2, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), false);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 5, 4, 0, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 6, 4, 1, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 5, 4, 2, structureBB);
            for (int[] uvwo : new int[][]{{4, 2, 1, -1}, {7, 2, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 2, 1, 5, 2, 1, 8, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 2, 0, 5, 2, 0, 8, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 1, 1, 5, 1, 3, 5, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 1, 1, 8, 1, 3, 8, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 3, 1, 8, 3, 3, 8, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 3, 1, 5, 3, 3, 5, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 1, 4, 5, 3, 4, 8, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 1, 4, 6, 3, 4, 7, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), false);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 1, 4, 7, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 2, 4, 6, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 3, 4, 7, structureBB);
            for (int[] uvwo : new int[][]{{2, 2, 5, -1}, {2, 2, 8, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            this.func_175804_a(world, structureBB, 4, 1, 13, 7, 1, 13, biomePlankState, biomePlankState, false);
            this.func_175804_a(world, structureBB, 4, 0, 13, 7, 0, 13, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 4, 1, 12, 4, 3, 12, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 14, 4, 3, 14, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 14, 7, 3, 14, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 12, 7, 3, 12, biomeFenceState, biomeFenceState, false);
            this.func_175804_a(world, structureBB, 4, 4, 12, 7, 4, 14, biomeWoodenSlabState, biomeWoodenSlabState, false);
            this.func_175804_a(world, structureBB, 5, 4, 12, 6, 4, 14, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 4), false);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 5, 4, 12, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 6, 4, 13, structureBB);
            this.func_175811_a(world, Blocks.field_150325_L.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), 5, 4, 14, structureBB);
            for (int[] uvwo : new int[][]{{4, 2, 13, -1}, {7, 2, 13, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 2;
                int signYBB = 2;
                int signZBB = 10;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                this.func_175811_a(world, biomePlankState, signXBB, signYBB - 1, signZBB, structureBB);
                this.func_175811_a(world, biomeDirtState, signXBB, signYBB - 2, signZBB, structureBB);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(12, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 6;
                int bannerZBB = 4;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175811_a(world, biomeGrassState, bannerXBB, bannerYBB - 1, bannerZBB, structureBB);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 2, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 6, -1, 0}, {5, 1, 8, -1, 0}, {5, 1, 10, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class PlainsMeetingPoint1
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"    PP    ", " PPPPPPPP ", " PFFFFFFP ", " PFFFFFFP ", "PPFFFFFFPP", "PPFFFFFFPP", " PFFFFFFP ", " PFFFFFFP ", " PPPPPPPP ", "    PP    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        public static final int GROUND_LEVEL = 1;

        public PlainsMeetingPoint1() {
        }

        public PlainsMeetingPoint1(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 70, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 70, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() <= 1 ? 3 : 4), this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() <= 1 ? 3 : 4), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() <= 1 ? 4 : 3), this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() <= 1 ? 4 : 3), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCobblestoneSlabState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(3), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(4, 4), this.func_74862_a(12), this.func_74873_b(4, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175804_a(world, structureBB, 3, -3, 3, 6, 2, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            this.func_175804_a(world, structureBB, 4, -2, 4, 5, 1, 5, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_74878_a(world, structureBB, 4, 2, 4, 5, 2, 5);
            if (GeneralConfig.wellSlabs && GeneralConfig.wellDecorations) {
                this.func_175804_a(world, structureBB, 4, 2, 3, 5, 2, 3, biomeCobblestoneSlabState, biomeCobblestoneSlabState, false);
                this.func_175804_a(world, structureBB, 4, 2, 6, 5, 2, 6, biomeCobblestoneSlabState, biomeCobblestoneSlabState, false);
                this.func_175804_a(world, structureBB, 3, 2, 4, 3, 2, 5, biomeCobblestoneSlabState, biomeCobblestoneSlabState, false);
                this.func_175804_a(world, structureBB, 6, 2, 4, 6, 2, 5, biomeCobblestoneSlabState, biomeCobblestoneSlabState, false);
            }
            for (int i : new int[]{3, 6}) {
                for (int j : new int[]{3, 6}) {
                    this.func_175804_a(world, structureBB, i, 3, j, i, 4, j, biomeFenceState, biomeFenceState, false);
                }
            }
            this.func_175804_a(world, structureBB, 3, 5, 3, 6, 5, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            if (GeneralConfig.useVillageColors) {
                BlockPos uvw = new BlockPos(4, 5, 4);
                int metaBase = ((int)world.func_72905_C() % 4 + this.func_186165_e().func_176736_b()) % 4;
                int metaCycle = (metaBase + Math.abs(this.func_74865_a(uvw.func_177958_n(), uvw.func_177952_p()) % 2 - this.func_74873_b(uvw.func_177958_n(), uvw.func_177952_p()) % 2 * 3) + uvw.func_177956_o()) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177968_d();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177974_f();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177978_c();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
            }
            for (int i = 2; i <= 7; ++i) {
                for (int j = 2; j <= 7; ++j) {
                    if (j != 2 && j != 7 && i != 2 && i != 7) continue;
                    if (GeneralConfig.useVillageColors) {
                        IBlockState concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                        this.func_175804_a(world, structureBB, j, -3, i, j, 1, i, concreteBlockstate, concreteBlockstate, false);
                        continue;
                    }
                    this.func_175804_a(world, structureBB, j, -3, i, j, 1, i, biomeCobblestoneState, biomeCobblestoneState, false);
                }
            }
            for (int[] uvwo : new int[][]{{3, 6, 3, -1}, {3, 6, 6, -1}, {6, 6, 3, -1}, {6, 6, 6, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 6;
                int signYBB = 2;
                int signZBB = 7;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 8;
                int bannerZBB = 6;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{1, 1, 8, -1, 0}, {8, 1, 8, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class PlainsFountain01
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{" PPPPPPP ", "PPPPPPPPP", "PPFFFFFPP", "PPFFFFFPP", "PPFFFFFPP", "PPFFFFFPP", "PPFFFFFPP", "PPPPPPPPP", " PPPPPPP "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 4;
        public static final int GROUND_LEVEL = 1;

        public PlainsFountain01() {
        }

        public PlainsFountain01(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 67, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 67, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState concreteBlockstate;
            IBlockState biomeGrassState;
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeCobblestoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(4, 4), this.func_74862_a(2), this.func_74873_b(4, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            this.func_74878_a(world, structureBB, 2, 1, 2, 6, 4, 6);
            this.func_175804_a(world, structureBB, 2, -1, 2, 6, 0, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            int[][] e = new int[][]{{2, 1, 2, -1}, {2, 1, 6, -1}, {6, 1, 2, -1}, {6, 1, 6, -1}};
            int n = e.length;
            for (int i = 0; i < n; ++i) {
                int[] uvwo = e[i];
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (GeneralConfig.useVillageColors) {
                concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175804_a(world, structureBB, 2, 1, 3, 6, 1, 5, concreteBlockstate, concreteBlockstate, false);
                this.func_175804_a(world, structureBB, 3, 1, 2, 5, 1, 6, concreteBlockstate, concreteBlockstate, false);
                BlockPos uvw = new BlockPos(2, 0, 2);
                int metaBase = ((int)world.func_72905_C() % 4 + this.func_186165_e().func_176736_b()) % 4;
                int metaCycle = (metaBase + Math.abs(this.func_74865_a(uvw.func_177958_n(), uvw.func_177952_p()) % 2 - this.func_74873_b(uvw.func_177958_n(), uvw.func_177952_p()) % 2 * 3) + uvw.func_177956_o()) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177970_e(4);
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177965_g(4);
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
                uvw = uvw.func_177964_d(4);
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), uvw.func_177958_n(), uvw.func_177956_o(), uvw.func_177952_p(), structureBB);
            } else {
                this.func_175804_a(world, structureBB, 2, 1, 3, 6, 1, 5, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175804_a(world, structureBB, 3, 1, 2, 5, 1, 6, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            this.func_74878_a(world, structureBB, 3, 1, 3, 5, 1, 5);
            if (GeneralConfig.useVillageColors) {
                concreteBlockstate = Blocks.field_192443_dR.func_176203_a(this.townColor2);
                this.func_175804_a(world, structureBB, 4, 1, 4, 4, 2, 4, concreteBlockstate, concreteBlockstate, false);
            } else {
                this.func_175804_a(world, structureBB, 4, 1, 4, 4, 2, 4, biomeCobblestoneState, biomeCobblestoneState, false);
            }
            this.func_175811_a(world, Blocks.field_150358_i.func_176223_P(), 4, 3, 4, structureBB);
            if (GeneralConfig.nameSign) {
                int signXBB = 4;
                int signYBB = 2;
                int signZBB = 2;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 8;
                int bannerZBB = 6;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeCobblestoneState, biomeCobblestoneState, false);
                this.func_175808_b(world, biomeFillerState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 1, -1, 0}, {1, 1, 2, -1, 0}, {1, 1, 7, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

