/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village.biomestructures;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.handler.ChestLootHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.StructureVillageVN;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.chestloot.ChestGenHooks;
import astrotibs.villagenames.village.chestloot.WeightedRandomChestContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBanner;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class DesertStructures {
    public static ArrayList<BlueprintData> getRandomDesertDecorBlueprint(FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        int decorCount = 1;
        return DesertStructures.getDesertDecorBlueprint(random.nextInt(decorCount), materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static ArrayList<BlueprintData> getDesertDecorBlueprint(int decorType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random) {
        ArrayList<BlueprintData> blueprint = new ArrayList<BlueprintData>();
        IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), materialType, biome, disallowModSubs);
        switch (decorType) {
            case 0: {
                BlueprintData.addFillWithBlocks(blueprint, 0, 0, 0, 0, 1, 0, biomeLogVertState);
                BlueprintData.addPlaceBlock(blueprint, 0, 2, 0, Blocks.field_150405_ch.func_176223_P());
                BlueprintData.addPlaceBlock(blueprint, 0, 3, 0, Blocks.field_150478_aa.func_176203_a(0));
            }
        }
        return blueprint;
    }

    public static class DesertStreetSubstitute3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 9;
        public static final int STRUCTURE_DEPTH = 2;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertStreetSubstitute3() {
        }

        public DesertStreetSubstitute3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertStreetSubstitute3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)9, (int)5, (int)2, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)-6, (int)9, (int)21, (int)-4, (EnumFacing)coordBaseMode);
            return DesertStreetSubstitute3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new DesertStreetSubstitute3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int[] uw : new int[][]{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {1, -4}, {2, -4}, {3, -4}, {4, -4}, {5, -4}, {6, -4}, {7, -4}, {2, -5}, {3, -5}, {4, -5}, {5, -5}, {6, -5}}) {
                int groundY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o() - 1;
                int groundV = groundY - this.field_74887_e.field_78895_b;
                this.func_175808_b(world, biomeFillerState, uw[0], groundV - 1, uw[1], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uw[0], uw[1]), groundY, this.func_74873_b(uw[0], uw[1]), true);
                this.func_74871_b(world, uw[0], groundV + 1, uw[1], structureBB);
            }
            int[][] decorUVW = new int[][]{{4, 0, -2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = DesertStructures.getRandomDesertDecorBlueprint(this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), random);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l()) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertStreetSubstitute2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 13;
        public static final int STRUCTURE_DEPTH = 2;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertStreetSubstitute2() {
        }

        public DesertStreetSubstitute2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertStreetSubstitute2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)13, (int)5, (int)2, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)-6, (int)13, (int)21, (int)-4, (EnumFacing)coordBaseMode);
            return DesertStreetSubstitute2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new DesertStreetSubstitute2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int groundV;
            int groundY;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int[] uw : new int[][]{{1, 0}, {2, 0}, {3, 0}, {4, 0}, {5, 0}, {6, 0}, {7, 0}, {8, 0}, {9, 0}, {10, 0}, {11, 0}, {2, 1}, {3, 1}, {4, 1}, {5, 1}, {6, 1}, {7, 1}, {8, 1}, {9, 1}, {10, 1}, {1, -4}, {2, -4}, {3, -4}, {4, -4}, {5, -4}, {6, -4}, {7, -4}, {8, -4}, {9, -4}, {10, -4}, {11, -4}, {2, -5}, {3, -5}, {4, -5}, {5, -5}, {6, -5}, {7, -5}}) {
                groundY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o() - 1;
                groundV = groundY - this.field_74887_e.field_78895_b;
                this.func_175808_b(world, biomeFillerState, uw[0], groundV - 1, uw[1], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uw[0], uw[1]), groundY, this.func_74873_b(uw[0], uw[1]), true);
                this.func_74871_b(world, uw[0], groundV + 1, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{4, -1}, {6, -1}, {8, -1}, {5, -2}, {7, -2}, {4, -3}, {6, -3}, {8, -3}}) {
                groundY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o() - 1;
                groundV = groundY - this.field_74887_e.field_78895_b;
                this.func_175808_b(world, biomeFillerState, uw[0], groundV - 1, uw[1], structureBB);
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uw[0], groundV, uw[1], structureBB);
                this.func_74871_b(world, uw[0], groundV + 1, uw[1], structureBB);
            }
            Random randomFromXYZ = new Random();
            randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(0, 0), this.func_74862_a(0), this.func_74873_b(0, 0)));
            int[][] decorUVW = new int[][]{{1 + randomFromXYZ.nextInt(3), 0, 0 - randomFromXYZ.nextInt(5)}, {9 + randomFromXYZ.nextInt(3), 0, 0 - randomFromXYZ.nextInt(3)}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l()) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertStreetSubstitute1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 7;
        public static final int STRUCTURE_DEPTH = 2;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertStreetSubstitute1() {
        }

        public DesertStreetSubstitute1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertStreetSubstitute1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)7, (int)5, (int)2, (EnumFacing)coordBaseMode);
            StructureBoundingBox structureBBOtherSide = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)-16, (int)-6, (int)7, (int)21, (int)-4, (EnumFacing)coordBaseMode);
            return DesertStreetSubstitute1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureBBOtherSide) == null ? new DesertStreetSubstitute1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            int groundV;
            int groundY;
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int[] uw : new int[][]{{0, 0}, {1, 0}, {1, 1}, {5, 1}, {5, 0}, {6, 0}, {0, -4}, {1, -4}, {1, -5}, {5, -5}, {5, -4}, {6, -4}}) {
                groundY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o() - 1;
                groundV = groundY - this.field_74887_e.field_78895_b;
                this.func_175808_b(world, biomeFillerState, uw[0], groundV - 1, uw[1], structureBB);
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uw[0], groundV, uw[1], structureBB);
                this.func_74871_b(world, uw[0], groundV + 1, uw[1], structureBB);
            }
            for (int[] uw : new int[][]{{2, 0}, {3, 0}, {4, 0}, {2, 1}, {3, 1}, {4, 1}, {2, -4}, {3, -4}, {4, -4}, {2, -5}, {3, -5}, {4, -5}}) {
                groundY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uw[0], uw[1]), 64, this.func_74873_b(uw[0], uw[1]))).func_177956_o() - 1;
                groundV = groundY - this.field_74887_e.field_78895_b;
                this.func_175808_b(world, biomeFillerState, uw[0], groundV - 1, uw[1], structureBB);
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(uw[0], uw[1]), groundY, this.func_74873_b(uw[0], uw[1]), true);
                this.func_74871_b(world, uw[0], groundV + 1, uw[1], structureBB);
            }
            int[][] decorUVW = new int[][]{{3, 0, -2}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l()) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertStreetDecor1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        public static final int STRUCTURE_WIDTH = 3;
        public static final int STRUCTURE_DEPTH = 3;
        public static final int STRUCTURE_HEIGHT = 4;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertStreetDecor1() {
        }

        public DesertStreetDecor1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertStreetDecor1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)3, (EnumFacing)coordBaseMode);
            return DesertStreetDecor1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertStreetDecor1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int decorDepth;
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                uvw[2] = decorDepth = ((Integer)FunctionsVN.weightedRandom(new int[]{0, 1, 2}, new double[]{5.0, 6.0, 1.0}, randomFromXYZ)).intValue();
                int decorHeightY = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(this.func_74865_a(uvw[0], uvw[2]), 64, this.func_74873_b(uvw[0], uvw[2]))).func_177956_o() - this.func_74862_a(0);
                if (decorDepth < 0) {
                    int nonairSurrounding = 0;
                    int decorY = this.func_74862_a(decorHeightY);
                    for (int i = 0; i < 8; ++i) {
                        int z;
                        int[][] surroundpos = new int[][]{{0, 0}, {0, 1}, {0, 2}, {1, 2}, {2, 2}, {2, 1}, {2, 0}, {1, 0}};
                        int u = surroundpos[i][0];
                        int w = surroundpos[i][0];
                        int x = this.func_74865_a(u, w);
                        BlockPos pos = new BlockPos(x, decorY, z = this.func_74873_b(u, w));
                        if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a || ++nonairSurrounding < 4) continue;
                        ++decorHeightY;
                        break;
                    }
                }
                this.func_175808_b(world, biomeFillerState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
                this.func_74871_b(world, uvw[0], decorHeightY + 1, uvw[2], structureBB);
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
                if (world.func_180495_p(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(decorHeightY - 1), this.func_74873_b(uvw[0], uvw[2]))).func_185915_l()) continue;
                this.func_175811_a(world, biomeGrassState, uvw[0], decorHeightY - 1, uvw[2], structureBB);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertWeaponsmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFF    ", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "  FFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public DesertWeaponsmith1() {
        }

        public DesertWeaponsmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertWeaponsmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertWeaponsmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertWeaponsmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSandstoneWallIntoCobblestoneWallState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoCobblestoneWallState = biomeSandstoneWallIntoCobblestoneWallState == null ? Blocks.field_150463_bK.func_176203_a(0) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoCobblestoneWallState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 4, 0, 2}, {0, 0, 6, 4, 0, 6}, {5, 0, 0, 9, 0, 5}, {0, 1, 1, 1, 1, 1}, {0, 1, 2, 0, 1, 4}, {0, 1, 5, 0, 5, 6}, {5, 1, 3, 5, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 3, 4, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150322_A.func_176203_a(2), Blocks.field_150322_A.func_176203_a(2), false);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 0, 5, 5, 0}, {9, 1, 0, 9, 5, 0}, {5, 1, 6, 5, 5, 6}, {9, 1, 5, 9, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{6, 1, 0, 8, 4, 0}, {5, 4, 1, 5, 4, 2}, {5, 1, 4, 5, 4, 4}, {6, 1, 5, 8, 4, 5}, {9, 1, 1, 9, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{6, 3, 3, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{2, 0, 0, 4, 0, 0, 3}, {5, 3, 1, 5, 3, 1, 6}, {5, 3, 2, 5, 3, 2, 7}, {8, 1, 1, 8, 1, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{1, 5, 1, 1, 5, 6}, {4, 5, 1, 4, 5, 6}, {2, 5, 1, 3, 5, 2}, {2, 5, 5, 3, 5, 6}, {5, 5, 1, 5, 5, 5}, {6, 5, 0, 8, 5, 5}, {9, 5, 1, 9, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 2, 1, 1, 4}, {2, 1, 3, 4, 1, 3}, {4, 1, 4, 4, 1, 4}, {1, 1, 5, 4, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150347_e.func_176203_a(0), Blocks.field_150347_e.func_176203_a(0), false);
            }
            this.func_175804_a(world, structureBB, 2, 1, 4, 3, 1, 4, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 1, 2, 2, 1, 4, 4, Blocks.field_150411_aY.func_176223_P(), Blocks.field_150411_aY.func_176223_P(), false);
            for (int[] uuvvww : new int[][]{{1, 2, 1, 1, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoCobblestoneWallState, biomeSandstoneWallIntoCobblestoneWallState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 4, 2}, {4, 3, 4, 2}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), Blocks.field_150460_al.func_176203_a(StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uvw : new int[][]{{7, 2, 0}, {7, 2, 5}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, (new IBlockState[]{biomeSandstoneSlabBottomState, biomeSandstoneSlabTopState})[i], uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{0, 2, 2, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvwo : new int[][]{{7, 1, 4, 2, 0}}) {
                IBlockState biomeGrindstoneState = ModObjects.chooseModGrindstone(uvwo[3], this.func_186165_e(), uvwo[4] == 1);
                this.func_175811_a(world, biomeGrindstoneState, uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int chestU = 8;
            int chestV = 1;
            int chestW = 2;
            int chestO = 3;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_weaponsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{2, 0, -1}, {3, 0, -1}, {4, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 5;
                int v = 1;
                int w = 3;
                while (u == 7 && w == 4 || u == 8 && w == 2 || u == 8 && w == 1 || u <= 5 && w >= 3) {
                    u = 2 + random.nextInt(7);
                    w = 1 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class DesertToolSmith1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF    ", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFF P F", "FFFFF PF ", "FFFFFFP  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 3;
        private static final int INCREASE_MIN_U = 4;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertToolSmith1() {
        }

        public DesertToolSmith1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertToolSmith1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertToolSmith1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertToolSmith1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 4 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 4), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 3, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeWoodButtonState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150471_bO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 3, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(2);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 2, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 2 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 2, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 2, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{6, 2, 0, 6, 2, 3}, {1, 3, 1, 3, 3, 2}, {2, 4, 2, 2, 4, 2}, {0, 1, 3, 3, 7, 3}, {4, 3, 3, 4, 7, 3}, {5, 3, 3, 8, 5, 3}, {5, 2, 4, 7, 2, 4}, {7, 2, 5, 7, 2, 5}, {5, 2, 6, 7, 2, 6}, {8, 3, 3, 8, 5, 7}, {5, 3, 7, 7, 5, 7}, {4, 1, 4, 4, 7, 4}, {4, 4, 5, 4, 7, 5}, {4, 1, 6, 4, 7, 7}, {4, 3, 8, 4, 7, 8}, {0, 1, 8, 3, 7, 8}, {0, 0, 4, 0, 7, 7}, {1, 4, 4, 3, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 4, 3, 3, 7}, {4, 1, 5, 4, 3, 5}, {5, 2, 5, 5, 3, 5}}) {
                this.func_74878_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5]);
            }
            for (int[] uvwo : new int[][]{{1, 6, 2, 2}, {3, 6, 2, 2}, {5, 4, 2, 2}, {7, 4, 2, 2}, {2, 6, 7, 2}, {6, 4, 6, 2}, {2, 3, 4, 0}, {2, 3, 7, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{0, 3, 0, 4, 3, 0, 3}, {0, 3, 1, 0, 3, 2, 0}, {4, 3, 1, 4, 3, 2, 1}, {1, 4, 1, 3, 4, 1, 3}, {1, 4, 2, 1, 4, 2, 0}, {3, 4, 2, 3, 4, 2, 1}, {6, 2, 5, 6, 2, 5, 0}, {5, 1, 5, 5, 1, 5, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{0, 6, 4, 0, 6, 7}, {1, 6, 8, 3, 6, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150405_ch.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), false);
            }
            for (int[] uvwoc : new int[][]{{2, 0, 4, 0, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {2, 0, 6, 0, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {1, 0, 4, 1, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {1, 0, 6, 1, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {3, 0, 6, 1, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {3, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {1, 0, 5, 2, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {1, 0, 7, 2, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {3, 0, 7, 2, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {3, 0, 4, 3, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {2, 0, 5, 3, GeneralConfig.useVillageColors ? this.townColor5 : 3}, {2, 0, 7, 3, GeneralConfig.useVillageColors ? this.townColor5 : 3}}) {
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(uvwoc[4], (uvwoc[3] + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4);
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(uvwoc[4]), uvwoc[0], uvwoc[1], uvwoc[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{7, 3, 1, 9}, {8, 3, 2, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uuvvww : new int[][]{{0, 8, 3, 0, 8, 3}, {0, 8, 5, 0, 8, 6}, {0, 8, 8, 0, 8, 8}, {2, 8, 3, 2, 8, 3}, {2, 8, 8, 2, 8, 8}, {4, 8, 3, 4, 8, 3}, {4, 8, 5, 4, 8, 6}, {4, 8, 8, 4, 8, 8}, {6, 6, 3, 6, 6, 3}, {8, 6, 3, 8, 6, 3}, {8, 6, 5, 8, 6, 5}, {8, 6, 7, 8, 6, 7}, {6, 6, 7, 6, 6, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 7, 4, 3, 7, 7}, {5, 5, 4, 7, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uuvvwwo : new int[][]{{2, 2, 7, 3, 2, 7, 2}, {2, 2, 4, 3, 2, 4, 0}, {1, 2, 4, 1, 2, 7, 1}, {3, 2, 6, 3, 2, 6, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), false);
            }
            IBlockState smithingTableBlockState = ModObjects.chooseModSmithingTable(1, this.func_186165_e());
            for (int[] uvw : new int[][]{{1, 5, 6}}) {
                this.func_175811_a(world, smithingTableBlockState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 1;
            int chestV = 5;
            int chestW = 7;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_toolsmith");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwoor : new int[][]{{2, 5, 3, 0, 1, 0}, {6, 3, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{0, 3, -1}, {1, 3, -1}, {2, 3, -1}, {3, 3, -1}, {4, 3, -1}, {5, 3, -1}, {6, 3, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 1;
                int v = 5;
                int w = 7;
                while (u == 1 && v == 5 && (w == 6 || w == 7)) {
                    u = 1 + random.nextInt(3);
                    v = 1 + (random.nextBoolean() ? 4 : 0);
                    w = 4 + random.nextInt(4);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class DesertTemple2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertTemple2() {
        }

        public DesertTemple2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertTemple2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertTemple2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertTemple2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 4, 1}, {0, 1, 2, 0, 3, 5}, {11, 1, 1, 11, 4, 1}, {11, 1, 2, 11, 3, 5}, {2, 1, 1, 2, 3, 1}, {4, 1, 1, 4, 3, 1}, {7, 1, 1, 7, 3, 1}, {9, 1, 1, 9, 3, 1}, {0, 1, 5, 0, 3, 5}, {1, 1, 5, 1, 1, 5}, {2, 1, 5, 2, 3, 5}, {11, 1, 5, 11, 3, 5}, {10, 1, 5, 10, 1, 5}, {9, 1, 5, 9, 3, 5}, {3, 1, 5, 3, 4, 5}, {4, 3, 5, 4, 3, 5}, {7, 3, 5, 7, 3, 5}, {8, 1, 5, 8, 4, 5}, {3, 1, 6, 3, 1, 6}, {3, 4, 6, 3, 4, 6}, {3, 1, 7, 3, 4, 7}, {4, 1, 8, 4, 4, 8}, {8, 1, 6, 8, 1, 6}, {8, 4, 6, 8, 4, 6}, {8, 1, 7, 8, 4, 7}, {7, 1, 8, 7, 4, 8}, {1, 4, 1, 4, 4, 4}, {5, 4, 4, 6, 4, 4}, {7, 4, 1, 10, 4, 4}, {4, 4, 5, 4, 4, 5}, {7, 4, 5, 7, 4, 5}, {5, 5, 6, 6, 5, 7}, {1, 0, 2, 10, 0, 4}, {5, 0, 5, 6, 0, 5}, {5, 0, 8, 6, 0, 8}, {4, 0, 6, 4, 0, 7}, {7, 0, 6, 7, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{4, 3, 0, 2}, {7, 3, 0, 2}, {3, 3, 4, 2}, {8, 3, 4, 2}, {5, 3, 8, 1}, {6, 3, 8, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 9, 6, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{0, 1, 0, 3}, {4, 1, 0, 3}, {7, 1, 0, 3}, {11, 1, 0, 3}, {5, 3, 1, 5}, {6, 3, 1, 4}, {0, 5, 1, 0}, {1, 5, 1, 1}, {3, 5, 1, 0}, {4, 5, 1, 1}, {5, 4, 1, 1}, {6, 4, 1, 0}, {7, 5, 1, 0}, {8, 5, 1, 1}, {10, 5, 1, 0}, {11, 5, 1, 1}, {4, 2, 5, 5}, {5, 3, 5, 5}, {6, 3, 5, 4}, {7, 2, 5, 4}}) {
                this.func_175811_a(world, biomeSmoothSandstoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int gtColor = GeneralConfig.useVillageColors ? this.townColor : 5;
            IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (0 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4);
            if (tryGlazedTerracottaState != null) {
                this.func_175811_a(world, tryGlazedTerracottaState, 5, 0, 7, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (1 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 6, 0, 7, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (2 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 6, 0, 6, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (3 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 5, 0, 6, structureBB);
            } else {
                this.func_175804_a(world, structureBB, 5, 0, 6, 6, 0, 7, Blocks.field_150406_ce.func_176203_a(gtColor), Blocks.field_150406_ce.func_176203_a(gtColor), false);
            }
            for (int[] uvwm : new int[][]{{2, 1, 0, 9}, {9, 1, 0, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{0, 2, 3}, {1, 2, 5}, {3, 2, 6}, {11, 2, 3}, {10, 2, 5}, {8, 2, 6}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, (new IBlockState[]{biomeSandstoneSlabBottomState, biomeSandstoneSlabTopState})[i], uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 4, 4, 1, 4}, {7, 1, 4, 8, 1, 4}, {10, 1, 3, 10, 1, 4}, {0, 4, 2, 0, 4, 4}, {5, 4, 2, 6, 4, 3}, {11, 4, 2, 11, 4, 4}, {1, 4, 5, 2, 4, 5}, {9, 4, 5, 10, 4, 5}, {5, 5, 5, 6, 5, 5}, {5, 5, 8, 6, 5, 8}, {4, 5, 6, 4, 5, 7}, {7, 5, 6, 7, 5, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 1, 1, 3, 1}, {10, 3, 1, 10, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uvw : new int[][]{{1, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}, {6, 1, -1}, {7, 1, -1}, {8, 1, -1}, {9, 1, -1}, {10, 1, -1}, {11, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(6);
                int v = 1;
                int w = 3 + random.nextInt(6);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class DesertTemple1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFF    FFF", "FFFFFFFFFF", "FFFFFFFFFF", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", " FFFFFFFF ", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertTemple1() {
        }

        public DesertTemple1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertTemple1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertTemple1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertTemple1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{3, 1, 1, 3, 3, 1}, {4, 3, 1, 5, 3, 1}, {6, 1, 1, 6, 3, 1}, {1, 1, 3, 1, 3, 7}, {8, 1, 3, 8, 3, 7}, {3, 1, 9, 6, 3, 9}, {1, 0, 1, 2, 0, 2}, {7, 0, 1, 8, 0, 2}, {1, 0, 8, 2, 0, 9}, {7, 0, 8, 8, 0, 9}, {2, 0, 3, 2, 0, 7}, {3, 0, 2, 3, 0, 8}, {7, 0, 3, 7, 0, 7}, {6, 0, 2, 6, 0, 8}, {4, 0, 7, 5, 0, 8}, {4, 0, 4, 5, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 2, 0, 2}, {6, 2, 0, 2}, {2, 2, 4, 1}, {2, 2, 6, 1}, {7, 2, 4, 3}, {7, 2, 6, 3}, {4, 2, 8, 2}, {5, 2, 8, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 0, 2, 0, 0}, {3, 0, 1, 3, 0, 1}, {0, 0, 1, 0, 0, 2}, {7, 0, 0, 9, 0, 0}, {6, 0, 1, 6, 0, 1}, {9, 0, 1, 9, 0, 2}, {0, 0, 8, 0, 0, 10}, {1, 0, 10, 2, 0, 10}, {9, 0, 8, 9, 0, 10}, {7, 0, 10, 8, 0, 10}, {1, 0, 3, 1, 0, 7}, {8, 0, 3, 8, 0, 7}, {3, 0, 9, 6, 0, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 5, 0}, {2, 1, 0, 2, 5, 0}, {0, 1, 2, 0, 5, 2}, {2, 5, 2, 2, 5, 2}, {0, 1, 1, 0, 1, 1}, {0, 4, 1, 0, 4, 1}, {1, 1, 0, 1, 1, 0}, {1, 4, 0, 1, 4, 0}, {1, 4, 2, 1, 4, 2}, {2, 4, 1, 2, 4, 2}, {9, 1, 0, 9, 5, 0}, {7, 1, 0, 7, 5, 0}, {9, 1, 2, 9, 5, 2}, {7, 5, 2, 7, 5, 2}, {9, 1, 1, 9, 1, 1}, {9, 4, 1, 9, 4, 1}, {8, 1, 0, 8, 1, 0}, {8, 4, 0, 8, 4, 0}, {8, 4, 2, 8, 4, 2}, {7, 4, 1, 7, 4, 2}, {0, 1, 10, 0, 5, 10}, {2, 1, 10, 2, 5, 10}, {0, 1, 8, 0, 5, 8}, {2, 5, 8, 2, 5, 8}, {0, 1, 9, 0, 1, 9}, {0, 4, 9, 0, 4, 9}, {1, 1, 10, 1, 1, 10}, {1, 4, 10, 1, 4, 10}, {1, 4, 8, 1, 4, 8}, {2, 4, 8, 2, 4, 9}, {9, 1, 10, 9, 5, 10}, {7, 1, 10, 7, 5, 10}, {9, 1, 8, 9, 5, 8}, {7, 5, 8, 7, 5, 8}, {9, 1, 9, 9, 1, 9}, {9, 4, 9, 9, 4, 9}, {8, 1, 10, 8, 1, 10}, {8, 4, 10, 8, 4, 10}, {8, 4, 8, 8, 4, 8}, {7, 4, 8, 7, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 1, 5}, {5, 2, 1, 4}, {4, 0, 3, 3}, {5, 0, 3, 3}}) {
                this.func_175811_a(world, biomeSmoothSandstoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int gtColor = GeneralConfig.useVillageColors ? this.townColor2 : 0;
            IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (0 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4);
            if (tryGlazedTerracottaState != null) {
                this.func_175811_a(world, tryGlazedTerracottaState, 4, 0, 6, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (1 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 5, 0, 6, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (2 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 5, 0, 5, structureBB);
                tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(gtColor, (3 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4);
                this.func_175811_a(world, tryGlazedTerracottaState, 4, 0, 5, structureBB);
            } else {
                this.func_175804_a(world, structureBB, 4, 0, 5, 5, 0, 6, Blocks.field_150406_ce.func_176203_a(gtColor), Blocks.field_150406_ce.func_176203_a(gtColor), false);
            }
            for (int[] uvw : new int[][]{{1, 2, 0}, {8, 2, 0}, {9, 2, 1}, {9, 2, 9}, {8, 2, 10}, {1, 2, 10}, {0, 2, 9}, {0, 2, 1}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
                this.func_175811_a(world, biomeSandstoneSlabTopState, potU, potV + 1, potW, structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 6, 0, 0, 6, 0}, {2, 6, 0, 2, 6, 0}, {2, 6, 2, 2, 6, 2}, {0, 6, 2, 0, 6, 2}, {1, 5, 1, 1, 5, 1}, {7, 6, 0, 7, 6, 0}, {9, 6, 0, 9, 6, 0}, {9, 6, 2, 9, 6, 2}, {7, 6, 2, 7, 6, 2}, {8, 5, 1, 8, 5, 1}, {0, 6, 8, 0, 6, 8}, {2, 6, 8, 2, 6, 8}, {2, 6, 10, 2, 6, 10}, {0, 6, 10, 0, 6, 10}, {1, 5, 9, 1, 5, 9}, {7, 6, 8, 7, 6, 8}, {9, 6, 8, 9, 6, 8}, {9, 6, 10, 9, 6, 10}, {7, 6, 10, 7, 6, 10}, {8, 5, 9, 8, 5, 9}, {1, 4, 3, 2, 4, 7}, {7, 4, 3, 8, 4, 7}, {3, 4, 1, 6, 4, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneSlabBottomState, biomeSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 5, 1, 0, 5, 1}, {1, 5, 0, 1, 5, 0}, {2, 5, 1, 2, 5, 1}, {1, 5, 2, 1, 5, 2}, {7, 5, 1, 7, 5, 1}, {8, 5, 0, 8, 5, 0}, {9, 5, 1, 9, 5, 1}, {8, 5, 2, 8, 5, 2}, {0, 5, 9, 0, 5, 9}, {1, 5, 8, 1, 5, 8}, {2, 5, 9, 2, 5, 9}, {1, 5, 10, 1, 5, 10}, {7, 5, 9, 7, 5, 9}, {8, 5, 8, 8, 5, 8}, {9, 5, 9, 9, 5, 9}, {8, 5, 10, 8, 5, 10}, {3, 4, 4, 3, 4, 4}, {3, 4, 6, 3, 4, 6}, {4, 4, 5, 4, 4, 5}, {6, 4, 4, 6, 4, 4}, {6, 4, 6, 6, 4, 6}, {5, 4, 5, 5, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uvw : new int[][]{{1, 1, 1}}) {
                this.func_175811_a(world, Blocks.field_150382_bo.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int chestU = 8;
            int chestV = 1;
            int chestW = 1;
            int chestO = 0;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo("vn_temple");
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{0, 0, -1}, {1, 0, -1}, {2, 0, -1}, {3, 0, -1}, {4, 0, -1}, {5, 0, -1}, {6, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(6);
                int v = 1;
                int w = 3 + random.nextInt(6);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 2, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 2;
        }
    }

    public static class DesertTannery1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 10;
        private static final int GROUND_LEVEL = 2;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertTannery1() {
        }

        public DesertTannery1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertTannery1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)10, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertTannery1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertTannery1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 2, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 2, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 4, 0, 6, 4, 0}, {0, 4, 5, 6, 4, 5}, {0, 7, 2, 6, 7, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 4, 4}, {0, 7, 3, 0, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 6, 1, 0}, {1, 1, 1, 5, 1, 1}, {1, 1, 2, 1, 1, 2}, {3, 1, 2, 3, 1, 2}, {5, 1, 2, 5, 1, 2}, {0, 1, 3, 6, 1, 4}, {1, 2, 2, 5, 3, 2}, {0, 2, 0, 0, 3, 5}, {0, 5, 2, 0, 6, 5}, {6, 2, 0, 6, 3, 5}, {6, 4, 1, 6, 4, 4}, {6, 5, 2, 6, 6, 5}, {6, 7, 3, 6, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 1, 5}, {1, 1, 5, 5, 1, 5}, {6, 1, 1, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 1, 2}, {4, 3, 1, 2}, {1, 6, 3, 1}, {5, 6, 3, 3}, {5, 3, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 0, 2, 3, 0}, {4, 2, 0, 4, 3, 0}, {1, 4, 1, 5, 4, 3}, {5, 4, 3, 5, 4, 3}, {1, 5, 2, 5, 6, 2}, {1, 2, 5, 5, 3, 5}, {0, 5, 5, 6, 6, 5}, {1, 7, 5, 6, 7, 5}, {0, 8, 2, 6, 8, 5}, {2, 9, 2, 4, 9, 2}, {2, 9, 5, 4, 9, 5}, {1, 9, 3, 1, 9, 4}, {5, 9, 3, 5, 9, 4}, {1, 2, 4, 2, 2, 4}, {1, 3, 4, 1, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{1, 6, 1, 2}, {5, 6, 1, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{3, 2, 4, 1}, {2, 3, 4, 1}, {1, 4, 4, 1}}) {
                this.func_175811_a(world, biomeSmoothSandstoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 8, 2}, {1, 9, 2}, {2, 8, 2}, {3, 9, 2}, {4, 8, 2}, {5, 9, 2}, {6, 8, 2}, {0, 8, 5}, {1, 9, 5}, {2, 8, 5}, {3, 9, 5}, {4, 8, 5}, {5, 9, 5}, {6, 8, 5}}) {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 5, 5}, {3, 5, 5}, {5, 5, 5}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, (new IBlockState[]{biomeSmoothSandstoneSlabBottomState, biomeSandstoneSlabTopState})[i], uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{1, 5, 0, 9}, {5, 5, 1, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uuvvww : new int[][]{{5, 2, 4}}) {
                this.func_175811_a(world, Blocks.field_150383_bp.func_176203_a(3), uuvvww[0], uuvvww[1], uuvvww[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{1, 2, 2, 0, 1, 1}, {3, 2, 2, 0, 1, 1}, {5, 2, 2, 0, 1, 0}, {2, 5, 2, 0, 1, 0}, {4, 5, 2, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{0, 2, -1}, {1, 2, -1}, {2, 2, -1}, {3, 2, -1}, {4, 2, -1}, {5, 2, -1}, {6, 2, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 1 + random.nextInt(5);
                int v = 2 + (random.nextBoolean() ? 3 : 0);
                int w = 3;
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class DesertSmallHouse8
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse8() {
        }

        public DesertSmallHouse8(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse8 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse8.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse8(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneStairsState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150372_bz.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGreenCoralOrPottedCactusState = ModObjects.chooseGreenCoralOrPottedCactus();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 0}, {1, 0, 1, 3, 0, 3}, {1, 1, 0, 3, 3, 0}, {1, 1, 4, 3, 3, 4}, {0, 1, 1, 0, 3, 3}, {4, 1, 1, 4, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 4, 0}, {4, 1, 0, 4, 4, 0}, {0, 1, 4, 0, 4, 4}, {4, 1, 4, 4, 4, 4}, {3, 1, 2, 3, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150405_ch.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 1, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 4, 3}, {1, 4, 0, 3, 4, 4}, {4, 4, 1, 4, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneSlabBottomState, biomeSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 3, 2, 0, 3, 2}, {2, 3, 4, 2, 3, 4}, {4, 3, 2, 4, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uvwo : new int[][]{{3, 1, 1, 2}, {3, 1, 3, 3}}) {
                this.func_175811_a(world, biomeSandstoneStairsState.func_177230_c().func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 2}}) {
                if (biomeGreenCoralOrPottedCactusState.func_177230_c() == Blocks.field_150457_bL) {
                    int flowernumber = 9;
                    int potU = uvw[0];
                    int potV = uvw[1];
                    int potW = uvw[2];
                    int potX = this.func_74865_a(potU, potW);
                    int potY = this.func_74862_a(potV);
                    int potZ = this.func_74873_b(potU, potW);
                    TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                    BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                    world.func_175656_a(flowerPotPos, biomeGreenCoralOrPottedCactusState);
                    world.func_175690_a(flowerPotPos, flowerPot);
                    continue;
                }
                this.func_175811_a(world, biomeGreenCoralOrPottedCactusState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{1, 1, 3}}) {
                this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 0, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{1, 1, 2, 0, GeneralConfig.useVillageColors ? this.townColor : 5}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse7
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FPF   F", "FPF F F", "FPF   F", "FPFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public DesertSmallHouse7() {
        }

        public DesertSmallHouse7(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse7 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse7.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse7(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 1, 3}, {2, 1, 0, 2, 1, 3}, {6, 1, 0, 6, 1, 3}, {3, 1, 0, 5, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 6, 2, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{0, 2, 2, -1}, {2, 2, 2, -1}, {2, 2, 6, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 0, 1, 0, 4}, {4, 0, 4, 4, 0, 4}, {1, 0, 5, 5, 0, 6}, {0, 1, 4, 6, 3, 4}, {0, 1, 7, 6, 3, 7}, {0, 1, 5, 0, 1, 6}, {6, 1, 5, 6, 1, 6}, {0, 3, 5, 6, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 2, 5, 0, 2, 6}, {6, 2, 5, 6, 2, 6}, {2, 2, 7, 2, 2, 7}, {4, 2, 7, 4, 2, 7}, {0, 4, 4, 0, 4, 4}, {2, 4, 4, 2, 4, 4}, {4, 4, 4, 4, 4, 4}, {6, 4, 4, 6, 4, 4}, {0, 4, 7, 0, 4, 7}, {2, 4, 7, 2, 4, 7}, {4, 4, 7, 4, 4, 7}, {6, 4, 7, 6, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uvwo : new int[][]{{1, 1, 6, 1}, {3, 1, 6, 0}}) {
                this.func_175811_a(world, biomeSmoothSandstoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 0, 2}}) {
                this.func_175811_a(world, Blocks.field_150354_m.func_176203_a(this.materialType == FunctionsVN.MaterialType.MESA ? 1 : 0), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 2, 4, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150434_aF.func_176223_P(), Blocks.field_150434_aF.func_176223_P(), false);
            }
            for (int[] uvwm : new int[][]{{4, 2, 0, 10}, {6, 2, 2, 10}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvwoor : new int[][]{{1, 1, 4, 0, 1, 1}, {4, 1, 4, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{4, 1, 6, 3, GeneralConfig.useVillageColors ? this.townColor : 5}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{1, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 5, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse6
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFPFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 18;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse6() {
        }

        public DesertSmallHouse6(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse6 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)18, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse6.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse6(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 6, 1}, {4, 1, 1, 4, 6, 1}, {0, 1, 5, 0, 6, 5}, {4, 1, 5, 4, 6, 5}, {0, 8, 1, 0, 14, 1}, {4, 8, 1, 4, 14, 1}, {0, 8, 5, 0, 14, 5}, {4, 8, 5, 4, 14, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 1}, {1, 0, 2, 3, 0, 4}, {1, 1, 1, 1, 3, 1}, {3, 1, 1, 3, 3, 1}, {3, 3, 2, 3, 3, 2}, {1, 1, 5, 3, 3, 5}, {1, 1, 4, 3, 1, 4}, {3, 2, 4, 3, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{1, 2, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 3, 4}, {4, 1, 2, 4, 3, 4}, {1, 4, 5, 3, 6, 5}, {1, 4, 1, 1, 6, 1}, {3, 4, 1, 3, 6, 1}, {2, 4, 1, 2, 4, 1}, {2, 6, 1, 2, 6, 1}, {1, 4, 2, 1, 4, 2}, {2, 5, 3, 2, 5, 3}, {1, 5, 4, 1, 5, 4}, {3, 6, 4, 3, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 4, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 2, 0, 6, 4}, {4, 4, 2, 4, 6, 4}, {0, 7, 2, 0, 9, 4}, {4, 7, 2, 4, 9, 4}, {3, 7, 2, 3, 7, 2}, {1, 8, 2, 1, 8, 2}, {1, 9, 4, 1, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{1, 7, 4, 1}, {3, 9, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 7, 1, 3, 8, 1}, {1, 9, 1, 1, 9, 1}, {3, 9, 1, 3, 9, 1}, {1, 7, 5, 3, 9, 5}, {0, 10, 2, 0, 12, 4}, {4, 10, 2, 4, 12, 4}, {3, 10, 4, 3, 10, 4}, {3, 11, 2, 3, 11, 2}, {1, 12, 2, 1, 12, 2}, {2, 12, 3, 2, 12, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 12, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 10, 1, 3, 12, 1}, {1, 10, 5, 3, 12, 5}, {0, 13, 2, 0, 14, 4}, {4, 13, 2, 4, 14, 4}, {1, 13, 1, 1, 13, 1}, {3, 13, 1, 3, 13, 1}, {1, 14, 1, 3, 14, 1}, {1, 13, 5, 3, 14, 5}, {1, 13, 4, 1, 13, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 15, 1, 0, 15, 5}, {4, 15, 1, 4, 15, 5}, {1, 15, 1, 3, 15, 1}, {1, 15, 5, 3, 15, 5}, {2, 15, 2, 3, 15, 3}, {0, 16, 1, 0, 16, 1}, {2, 16, 1, 2, 16, 1}, {4, 16, 1, 4, 16, 1}, {0, 16, 3, 0, 16, 3}, {4, 16, 3, 4, 16, 3}, {0, 16, 5, 0, 16, 5}, {2, 16, 5, 2, 16, 5}, {4, 16, 5, 4, 16, 5}, {0, 7, 1, 0, 7, 1}, {4, 7, 1, 4, 7, 1}, {0, 7, 5, 0, 7, 5}, {4, 7, 5, 4, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 1, 2, 3, 1}, {2, 7, 1, 2, 7, 1}, {2, 11, 1, 2, 11, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwo : new int[][]{{0, 17, 1, -1}, {4, 17, 1, -1}, {0, 17, 5, -1}, {4, 17, 5, -1}, {2, 3, 0, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 1, 3, 3}, {2, 2, 4, 0}, {3, 3, 3, 2}, {2, 4, 2, 1}, {1, 5, 3, 3}, {2, 6, 4, 0}, {3, 7, 3, 2}, {2, 8, 2, 1}, {1, 9, 3, 3}, {2, 10, 4, 0}, {3, 11, 3, 2}, {2, 12, 2, 1}, {1, 13, 3, 3}, {2, 14, 4, 0}, {3, 15, 4, 0}}) {
                this.func_175811_a(world, biomeSmoothSandstoneStairsBlock.func_176203_a(uvwo[3] % 4 + uvwo[3] / 4 * 4), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 3, GeneralConfig.useVillageColors ? this.townColor3 : 13}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 2;
            int chestV = 13;
            int chestW = 3;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 2, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var26_58;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var26_58 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse5
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFPFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse5() {
        }

        public DesertSmallHouse5(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse5 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse5.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse5(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodButtonState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150471_bO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 3, 2}, {0, 1, 4, 0, 3, 4}, {4, 1, 2, 4, 3, 2}, {4, 1, 4, 4, 3, 4}, {1, 1, 5, 1, 2, 5}, {3, 1, 5, 3, 2, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 1}, {1, 0, 2, 3, 0, 4}, {0, 1, 1, 4, 3, 1}, {0, 1, 5, 0, 3, 5}, {2, 1, 5, 2, 3, 5}, {4, 1, 5, 4, 3, 5}, {0, 1, 3, 0, 3, 3}, {4, 1, 3, 4, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 1, 4, 4, 5}, {0, 5, 1, 0, 5, 1}, {2, 5, 1, 2, 5, 1}, {4, 5, 1, 4, 5, 1}, {0, 5, 3, 0, 5, 3}, {4, 5, 3, 4, 5, 3}, {0, 5, 5, 0, 5, 5}, {2, 5, 5, 2, 5, 5}, {4, 5, 5, 4, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 3, 0, 3, 3, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 0, 2}, {3, 0, 2}, {2, 0, 3}, {1, 0, 4}, {3, 0, 4}}) {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwm : new int[][]{{3, 1, 0, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvwm : new int[][]{{3, 1, 2}}) {
                this.func_175811_a(world, Blocks.field_150462_ai.func_176223_P(), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwoc : new int[][]{{3, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor : 5}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{1, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse4
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse4() {
        }

        public DesertSmallHouse4(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse4 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse4.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse4(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        /*
         * WARNING - void declaration
         */
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 3, 0}, {4, 1, 0, 4, 3, 0}, {0, 1, 4, 0, 3, 4}, {4, 1, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 0}, {1, 1, 0, 3, 3, 0}, {1, 1, 4, 1, 3, 4}, {2, 1, 4, 2, 1, 4}, {3, 1, 4, 3, 3, 4}, {1, 0, 1, 3, 0, 3}, {0, 1, 1, 0, 3, 3}, {4, 1, 1, 4, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 1, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 1, 3, 4, 3}, {2, 3, 4, 2, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 4, 0, 1, 4, 0, 3}, {3, 4, 0, 3, 4, 0, 3}, {1, 4, 4, 1, 4, 4, 2}, {3, 4, 4, 3, 4, 4, 2}, {0, 4, 1, 0, 4, 1, 0}, {0, 4, 3, 0, 4, 3, 0}, {4, 4, 1, 4, 4, 1, 1}, {4, 4, 3, 4, 4, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 0, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 0, 2}, {0, 4, 0}, {2, 4, 0}, {4, 4, 0}, {0, 4, 2}, {4, 4, 2}, {0, 4, 4}, {2, 4, 4}, {4, 4, 4}}) {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 3, 1, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                for (boolean bl : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (bl ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (bl ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), bl), uvwoc[4]);
                }
            }
            int chestU = 3;
            int chestV = 1;
            int chestW = 3;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 1, 2, -1, 0}};
                    int n = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        void var25_49;
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --var25_49 == false ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse3
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFPFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse3() {
        }

        public DesertSmallHouse3(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse3 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse3.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse3(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeWoodButtonState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150471_bO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 3, 1}, {4, 1, 1, 4, 3, 1}, {0, 1, 5, 0, 3, 5}, {4, 1, 5, 4, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 1}, {1, 1, 1, 3, 3, 1}, {1, 1, 5, 3, 3, 5}, {1, 0, 2, 3, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvw : new int[][]{{1, 1, 3}}) {
                this.func_175811_a(world, biomeCutSandstoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{1, 2, 2, 0}, {3, 2, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 3, 4}, {4, 1, 2, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 2, 3, 3, 2}, {0, 3, 3, 4, 3, 3}, {1, 3, 4, 3, 3, 4}, {2, 3, 5, 2, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 1, 2, 4, 1}, {2, 4, 5, 2, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{0, 4, 1, 0, 4, 1, 0}, {1, 4, 1, 1, 4, 1, 1}, {3, 4, 1, 3, 4, 1, 0}, {4, 4, 1, 4, 4, 1, 1}, {0, 4, 5, 0, 4, 5, 0}, {1, 4, 5, 1, 4, 5, 1}, {3, 4, 5, 3, 4, 5, 0}, {4, 4, 5, 4, 4, 5, 1}, {1, 1, 2, 1, 1, 2, 2}, {1, 1, 4, 1, 1, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 3, 0, 3, 3, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), false);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{1, 2, 3, 10}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor3 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 4, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", " FP  ", "F PFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse2() {
        }

        public DesertSmallHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeChiseledSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 2, 0, 2}, {1, 1, 2, 3, 4, 2}, {1, 0, 3, 3, 0, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvw : new int[][]{{1, 1, 5}}) {
                this.func_175811_a(world, biomeChiseledSandstoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 3, 1, 2}, {1, 2, 5, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 3, 0}, {4, 1, 0, 4, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 0, 4, 4, 0}, {1, 5, 2, 3, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 1, 3, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 6, 3, 3, 6}, {0, 1, 3, 0, 3, 5}, {4, 1, 3, 4, 3, 5}, {0, 4, 1, 0, 4, 1}, {4, 4, 1, 4, 4, 1}, {2, 5, 2, 2, 5, 2}, {2, 5, 6, 2, 5, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 4, 2}, {4, 1, 2, 4, 4, 2}, {0, 1, 6, 0, 4, 6}, {4, 1, 6, 4, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 3, 0, 4, 5}, {4, 4, 3, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 6, 3, 4, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 2, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvw : new int[][]{{2, 2, 6}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
                this.func_175811_a(world, biomeSandstoneSlabTopState, potU, potV + 1, potW, structureBB);
            }
            for (int[] uvwm : new int[][]{{1, 1, 3, GeneralConfig.useVillageColors ? this.townColor3 : 13}, {3, 1, 3, GeneralConfig.useVillageColors ? this.townColor3 : 13}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoc : new int[][]{{2, 1, 5, 3, GeneralConfig.useVillageColors ? this.townColor3 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{1, 1, 1, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertSmallHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFF", "FFFFF", "FFFFF", "FFFFF", "FFFFF", "  P  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertSmallHouse1() {
        }

        public DesertSmallHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertSmallHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertSmallHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertSmallHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 1, 2, 0, 1}, {1, 0, 2, 3, 0, 4}, {0, 1, 1, 4, 4, 1}, {0, 1, 2, 0, 4, 4}, {4, 1, 2, 4, 4, 4}, {0, 1, 5, 4, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvw : new int[][]{{0, 1, 1}, {4, 1, 1}, {0, 1, 5}, {4, 1, 5}, {2, 3, 1}, {2, 1, 5}}) {
                this.func_175811_a(world, biomeSandstoneState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{2, 3, 0, 2}, {2, 4, 2, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 1, 0, 4, 1}, {4, 4, 1, 4, 4, 1}, {0, 4, 5, 0, 4, 5}, {4, 4, 5, 4, 4, 5}, {0, 5, 2, 0, 5, 4}, {1, 5, 1, 3, 5, 5}, {4, 5, 2, 4, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneSlabBottomState, biomeSandstoneSlabBottomState, false);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 1, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 2, 5}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
                this.func_175811_a(world, biomeSandstoneSlabTopState, potU, potV + 1, potW, structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 4, 1, 1, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwoc : new int[][]{{3, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor4 : 9}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{2, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertShepherdHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 2;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertShepherdHouse1() {
        }

        public DesertShepherdHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertShepherdHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertShepherdHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertShepherdHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 2 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 2), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState loomState = ModObjects.chooseModLoom(3, this.func_186165_e());
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 4, 1}, {0, 1, 4, 0, 4, 4}, {4, 1, 1, 4, 5, 1}, {4, 1, 4, 4, 5, 4}, {10, 1, 1, 10, 5, 1}, {10, 1, 4, 10, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{6, 0, 1, 6, 0, 1}, {5, 0, 2, 5, 0, 3}, {4, 3, 2, 4, 4, 3}, {10, 1, 2, 10, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 3, 1, 3}, {3, 3, 4, 3}, {5, 3, 3, 1}, {9, 3, 3, 3}, {9, 3, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 1, 9, 4, 1}, {5, 1, 4, 9, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{6, 3, 0, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 0, 4, 1, 0}, {8, 1, 0, 8, 1, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 3, 1, 1}, {1, 1, 4, 3, 1, 4}, {0, 1, 2, 0, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uvw : new int[][]{{8, 2, 1}, {8, 2, 4}, {6, 2, 4}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, (new IBlockState[]{biomeSandstoneSlabBottomState, biomeSandstoneSlabTopState})[i], uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 4, 2, 0, 4, 3}, {1, 4, 1, 3, 4, 4}, {4, 5, 2, 4, 5, 3}, {5, 5, 1, 9, 5, 4}, {10, 5, 2, 10, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneSlabBottomState, biomeSandstoneSlabBottomState, false);
            }
            for (int[] uvwoor : new int[][]{{6, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 2, 0}, {8, 2, 0}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{1, 0, 3}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            int[] baleorientation = new int[]{0, 4, 8};
            for (int[] uvwo : new int[][]{{4, 1, 3, 0}, {5, 1, 3, 2}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(baleorientation[uvwo[3]]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{9, 1, 2}, {9, 1, 3}}) {
                this.func_175811_a(world, loomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{6, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 6 + random.nextInt(3);
                int v = 1;
                int w = 2 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 3, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
                for (int[] uvw : new int[][]{{3, 1, 2}}) {
                    BlockPos animalPos = new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2]));
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, false, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(animalPos), null);
                    animal.func_70012_b((double)animalPos.func_177958_n() + 0.5, (double)animalPos.func_177956_o() + 0.5, (double)animalPos.func_177952_p() + 0.5, random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertMediumHouse2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFFFFFF", "FFFFFFPFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 9;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 1;
        private static final int DECREASE_MAX_U = 1;
        private int averageGroundLevel = -1;

        public DesertMediumHouse2() {
        }

        public DesertMediumHouse2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertMediumHouse2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)9, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertMediumHouse2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertMediumHouse2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 1 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 1)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodButtonState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150471_bO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 0, 4, 1, 0}, {3, 2, 0, 3, 2, 0}, {1, 1, 1, 5, 5, 1}, {6, 1, 1, 9, 3, 1}, {9, 1, 1, 9, 3, 2}, {9, 1, 3, 9, 7, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{3, 5, 0, 2}, {8, 5, 4, 3}, {2, 4, 2, 0}, {4, 4, 2, 0}, {8, 2, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 1, 5, 6, 2}, {5, 1, 3, 5, 7, 5}, {1, 1, 1, 1, 5, 4}, {1, 1, 4, 4, 5, 4}, {6, 1, 5, 9, 7, 5}, {6, 4, 3, 9, 7, 3}, {6, 0, 2, 8, 0, 4}, {6, 0, 1, 6, 0, 1}, {6, 3, 2, 8, 3, 4}, {2, 1, 1, 4, 2, 3}, {2, 5, 2, 4, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 6, 1, 1, 6, 1}, {1, 6, 4, 1, 6, 4}, {5, 6, 1, 5, 6, 1}, {4, 6, 4, 4, 6, 4}, {5, 7, 4, 5, 7, 4}, {6, 7, 3, 8, 7, 5}, {9, 7, 4, 9, 7, 4}, {6, 4, 1, 8, 4, 1}, {9, 4, 1, 9, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 0, 1, 1, 0, 0}, {2, 2, 0, 2, 2, 0, 0}, {5, 1, 0, 5, 1, 0, 1}, {4, 2, 0, 4, 2, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwoor : new int[][]{{7, 4, 3, 0, 1, 0}, {3, 3, 1, 0, 1, 0}, {6, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvwwo : new int[][]{{6, 2, 4, 6, 3, 4, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            for (int[] uvw : new int[][]{{7, 1, 0}, {6, 4, 2}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uuvvwwo : new int[][]{{1, 3, 0, 2, 3, 0, 2}, {4, 3, 0, 9, 3, 0, 2}, {0, 3, 1, 0, 3, 4, 3}, {10, 3, 1, 10, 3, 5, 1}, {1, 3, 5, 4, 3, 5, 0}, {5, 3, 6, 9, 3, 6, 0}, {5, 6, 2, 9, 6, 2, 2}, {4, 6, 3, 4, 6, 3, 3}, {4, 6, 5, 4, 6, 5, 3}, {10, 6, 3, 10, 6, 5, 1}, {5, 6, 6, 9, 6, 6, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), biomeWoodButtonState.func_177230_c().func_176203_a(StructureVillageVN.chooseButtonMeta(uuvvwwo[6])), false);
            }
            int chestU = 2;
            int chestV = 3;
            int chestW = 3;
            int chestO = 2;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwoc : new int[][]{{3, 3, 3, 3, GeneralConfig.useVillageColors ? this.townColor : 5}, {8, 1, 3, 2, GeneralConfig.useVillageColors ? this.townColor3 : 13}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwoc[3];
                    int u = uvwoc[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwoc[1];
                    int w = uvwoc[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), uvwoc[4]);
                }
            }
            for (int[] uvw : new int[][]{{6, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{3, 3, 2, -1, 0}, {6, 1, 2, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertMediumHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertMediumHouse1() {
        }

        public DesertMediumHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertMediumHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertMediumHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertMediumHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 4, 2, 6, 4, 2}, {0, 4, 4, 6, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 1, 6, 4, 1}, {0, 4, 3, 6, 4, 3}, {0, 4, 5, 6, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 1, 3, 0, 1}, {1, 0, 2, 5, 0, 4}, {0, 1, 1, 6, 3, 1}, {0, 1, 5, 6, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, 2}, {4, 2, 0, 2}, {3, 3, 2, 0}, {1, 3, 4, 2}, {5, 3, 4, 2}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 3, 4}, {6, 1, 2, 6, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvw : new int[][]{{1, 2, 1}, {5, 2, 1}, {0, 2, 3}, {6, 2, 3}, {2, 2, 5}, {4, 2, 5}}) {
                for (int i = 0; i < 2; ++i) {
                    this.func_175811_a(world, (new IBlockState[]{biomeSandstoneSlabBottomState, biomeSandstoneSlabTopState})[i], uvw[0], uvw[1] + i, uvw[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{0, 5, 1}, {3, 5, 1}, {6, 5, 1}, {0, 5, 3}, {6, 5, 3}, {0, 5, 5}, {3, 5, 5}, {6, 5, 5}}) {
                this.func_175811_a(world, biomeSandstoneSlabBottomState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 0}, {3, 2, 4}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            int chestU = 1;
            int chestV = 1;
            int chestW = 2;
            int chestO = 1;
            BlockPos chestPos = new BlockPos(this.func_74865_a(chestU, chestW), this.func_74862_a(chestV), this.func_74873_b(chestU, chestW));
            world.func_180501_a(chestPos, Blocks.field_150486_ae.func_176203_a(StructureVillageVN.chooseFurnaceMeta(chestO, this.func_186165_e())), 2);
            TileEntity te = world.func_175625_s(chestPos);
            if (te instanceof IInventory) {
                ChestGenHooks chestGenHook = ChestGenHooks.getInfo(ChestLootHandler.getGenericLootForVillageType(this.villageType));
                WeightedRandomChestContent.generateChestContents(random, chestGenHook.getItems(random), (IInventory)((TileEntityChest)te), chestGenHook.getCount(random));
            }
            for (int[] uvwo : new int[][]{{1, 1, 3, 2}, {5, 1, 3, 2}}) {
                for (boolean isHead : new boolean[]{false, true}) {
                    int orientation = uvwo[3];
                    int u = uvwo[0] + (isHead ? (new int[]{0, -1, 0, 1})[orientation] : 0);
                    int v = uvwo[1];
                    int w = uvwo[2] + (isHead ? (new int[]{-1, 0, 1, 0})[orientation] : 0);
                    ModObjects.setModBedBlock(world, this.func_74865_a(u, w), this.func_74862_a(v), this.func_74873_b(u, w), StructureVillageVN.getBedOrientationMeta(orientation, this.func_186165_e(), isHead), GeneralConfig.useVillageColors ? this.townColor : 5);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInResidences) {
                    int[][] villagerPositions = new int[][]{{2, 1, 3, -1, 0}, {4, 1, 3, -1, 0}};
                    int countdownToAdult = 1 + random.nextInt(villagerPositions.length);
                    for (int[] ia : villagerPositions) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], --countdownToAdult == 0 ? 0 : Math.min(random.nextInt(24001) - 12000, 0));
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 1.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertMason1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "   PP   ", "  FPPF  "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertMason1() {
        }

        public DesertMason1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertMason1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertMason1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertMason1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 4, 2}, {0, 1, 6, 0, 4, 6}, {7, 1, 2, 7, 4, 2}, {7, 1, 6, 7, 4, 6}, {2, 1, 2, 2, 2, 2}, {5, 1, 2, 5, 2, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 3, 2, 5, 3, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 0, 4, 0, 2}, {1, 0, 3, 6, 0, 5}, {1, 1, 2, 1, 3, 2}, {6, 1, 2, 6, 3, 2}, {1, 1, 6, 6, 3, 6}, {0, 1, 3, 0, 3, 5}, {7, 1, 3, 7, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 1, 2}, {5, 2, 1, 2}, {1, 3, 4, 1}, {6, 3, 4, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{2, 1, 0, 2, 3, 0}, {5, 1, 0, 5, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvwwo : new int[][]{{2, 4, 0, 5, 4, 1}, {1, 4, 2, 6, 4, 2}, {0, 4, 3, 7, 4, 5}, {1, 4, 6, 6, 4, 6}, {0, 2, 4, 0, 2, 4}, {7, 2, 4, 7, 2, 4}, {2, 2, 6, 5, 2, 6}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            IBlockState stonecutterState = ModObjects.chooseModStonecutterState(3, this.func_186165_e());
            for (int[] uvw : new int[][]{{6, 1, 4}}) {
                this.func_175811_a(world, stonecutterState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{1, 1, 5}}) {
                this.func_175811_a(world, Blocks.field_150435_aG.func_176223_P(), uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 3, 1, 1, 4}, {1, 2, 3, 1, 2, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 5), Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor : 5), false);
            }
            int[][] u = new int[][]{{2, 1, 3, 1}};
            int unitLetter = u.length;
            for (int uuvvwwo = 0; uuvvwwo < unitLetter; ++uuvvwwo) {
                int[] uvwo;
                IBlockState tryGlazedTerracottaState = FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor2 : 0, StructureVillageVN.chooseGlazedTerracottaMeta((uvwo = u[uuvvwwo])[3], this.func_186165_e()));
                if (tryGlazedTerracottaState != null) {
                    this.func_175811_a(world, tryGlazedTerracottaState, uvwo[0], uvwo[1], uvwo[2], structureBB);
                    continue;
                }
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(GeneralConfig.useVillageColors ? this.townColor2 : 0), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{3, 1, 2, 0, 1, 0}, {4, 1, 2, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}, {4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u2 = 2 + random.nextInt(4);
                int v = 1;
                int w = 4 + random.nextInt(2);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u2, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u2, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class DesertLibrary1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF", "FFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertLibrary1() {
        }

        public DesertLibrary1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertLibrary1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertLibrary1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertLibrary1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(9), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 0, 6, 0}, {8, 1, 0, 8, 6, 0}, {0, 1, 4, 0, 6, 4}, {8, 1, 4, 8, 6, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 5, 1, 0, 5, 3}, {8, 5, 1, 8, 5, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 5, 0, 7, 5, 0}, {1, 5, 4, 7, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 0, 4, 0, 0}, {2, 0, 1, 6, 0, 3}, {7, 0, 2, 7, 0, 2}, {1, 1, 0, 7, 4, 0}, {1, 1, 4, 7, 4, 4}, {0, 1, 1, 0, 4, 3}, {8, 1, 1, 8, 4, 3}, {1, 4, 1, 7, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{4, 2, 3, 2}, {7, 2, 2, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 3, 0, 4, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneState, biomeSandstoneState, false);
            }
            for (int[] uvw : new int[][]{{2, 2, 0}, {6, 2, 0}, {2, 2, 4}, {6, 2, 4}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
                this.func_175811_a(world, biomeSandstoneSlabTopState, uvw[0], uvw[1] + 1, uvw[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{7, 1, 1, 7, 1, 1, 0}, {7, 1, 3, 7, 1, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            IBlockState biomePlankState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            for (int[] uvwo : new int[][]{{7, 1, 2, 3}}) {
                ModObjects.setModLecternState(world, this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2]), uvwo[3], this.func_186165_e(), biomePlankState.func_177230_c().func_176201_c(biomePlankState));
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 1, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (int[] uvwm : new int[][]{{3, 1, 2, GeneralConfig.useVillageColors ? this.townColor2 : 0}, {4, 1, 2, GeneralConfig.useVillageColors ? this.townColor : 5}, {5, 1, 2, GeneralConfig.useVillageColors ? this.townColor2 : 0}}) {
                this.func_175811_a(world, Blocks.field_150404_cg.func_176203_a(uvwm[3]), uvwm[0], uvwm[1], uvwm[2], structureBB);
            }
            for (int[] uvwoor : new int[][]{{4, 1, 0, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{4, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(5);
                int v = 1;
                int w = 1 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class DesertLargeFarm1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF", "FFFFFFFFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertLargeFarm1() {
        }

        public DesertLargeFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertLargeFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertLargeFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertLargeFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 1, 0, 2, 1, 2}, {3, 1, 1, 4, 1, 1}, {5, 1, 0, 7, 1, 0}, {8, 1, 1, 10, 1, 1}, {10, 1, 2, 12, 1, 5}, {9, 1, 5, 9, 1, 5}, {11, 1, 6, 12, 1, 6}, {12, 1, 7, 12, 1, 8}, {10, 1, 8, 11, 1, 8}, {10, 1, 9, 10, 1, 9}, {6, 1, 9, 9, 1, 10}, {6, 1, 7, 6, 1, 7}, {2, 1, 7, 5, 1, 10}, {1, 1, 7, 1, 1, 9}, {1, 1, 6, 2, 1, 6}, {1, 1, 3, 3, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeDirtState, biomeDirtState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 7, 4, 2, 7}, {1, 2, 8, 1, 2, 8}, {2, 1, 8, 4, 1, 8}, {5, 2, 8, 5, 2, 8}, {2, 2, 9, 4, 2, 9}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvwwo : new int[][]{{5, 1, 1, 7, 1, 1}, {3, 1, 2, 3, 1, 2}, {4, 1, 2, 8, 1, 3}, {9, 1, 2, 9, 1, 2}, {5, 1, 4, 9, 1, 4}, {4, 1, 5, 8, 1, 5}, {3, 1, 6, 10, 1, 6}, {7, 1, 7, 11, 1, 7}, {6, 1, 8, 9, 1, 8}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150458_ak.func_176203_a(7), Blocks.field_150458_ak.func_176203_a(7), false);
            }
            for (int[] uvwm : new int[][]{{5, 1, 2, 5}, {1, 1, 2, 6}, {3, 1, 2, 7}, {2, 2, 2, 3}, {6, 2, 2, 4}, {4, 2, 2, 5}, {1, 2, 2, 7}, {3, 2, 2, 8}, {7, 2, 2, 9}, {7, 3, 2, 4}, {5, 3, 2, 5}, {6, 3, 2, 6}, {2, 3, 2, 7}, {6, 3, 2, 8}, {7, 4, 2, 5}, {7, 4, 2, 6}, {7, 4, 2, 7}, {7, 4, 2, 8}, {7, 4, 2, 9}, {7, 5, 2, 4}, {7, 5, 2, 5}, {7, 5, 2, 6}, {7, 5, 2, 7}, {7, 5, 2, 8}, {7, 6, 2, 3}, {7, 6, 2, 4}, {7, 6, 2, 5}, {7, 6, 2, 6}, {7, 6, 2, 7}, {7, 6, 2, 8}, {7, 6, 2, 9}, {4, 6, 2, 10}, {7, 7, 2, 7}, {7, 7, 2, 9}, {7, 7, 2, 10}, {7, 7, 2, 11}, {7, 8, 2, 6}, {5, 8, 2, 7}, {7, 8, 2, 8}, {7, 8, 2, 9}}) {
                this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(uvwm[0]), uvwm[3], uvwm[2], uvwm[1], structureBB);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 8, 4, 2, 8}, {8, 1, 7, 8, 1, 7}, {6, 1, 2, 6, 1, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 2, 7, 1, 2, 7, 0}, {1, 2, 9, 1, 2, 9, 0}, {5, 2, 7, 5, 2, 7, 3}, {5, 2, 9, 5, 2, 9, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            int[] baleorientation = new int[]{0, 4, 8};
            for (int[] uvwo : new int[][]{{2, 2, 0, 2}, {1, 2, 3, 2}, {3, 2, 3, 1}, {2, 2, 4, 2}, {4, 2, 4, 2}, {2, 3, 4, 0}, {1, 2, 5, 0}, {9, 2, 3, 2}, {11, 2, 3, 0}, {12, 2, 2, 1}, {10, 2, 4, 1}, {10, 2, 5, 0}, {11, 2, 4, 0}, {11, 3, 4, 2}, {12, 2, 4, 2}, {12, 2, 5, 0}, {12, 2, 7, 2}, {9, 2, 9, 2}, {6, 2, 9, 1}, {7, 2, 10, 0}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(baleorientation[uvwo[3]]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{3, 2, 4}, {9, 2, 5}}) {
                IBlockState compostBinState = ModObjects.chooseModComposterState();
                this.func_175811_a(world, compostBinState != null ? compostBinState : Blocks.field_150407_cf.func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 5 + random.nextInt(4);
                int v = 2;
                int w = 3 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertFletcherHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFF   ", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFFFFF", "FFFFFFFFF   ", "   P        "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 12;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public DesertFletcherHouse1() {
        }

        public DesertFletcherHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertFletcherHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)12, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertFletcherHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertFletcherHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoCobblestoneState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoCobblestoneState = biomeSandstoneWallIntoCobblestoneState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoCobblestoneState, this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState fletchingTableState = ModObjects.chooseModFletchingTableState(1, this.func_186165_e());
            IBlockState biomeLadderState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150468_ap.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 4, 1}, {8, 1, 1, 8, 4, 1}, {0, 1, 5, 0, 4, 5}, {8, 1, 5, 8, 4, 5}, {9, 1, 2, 9, 9, 2}, {11, 1, 2, 11, 9, 2}, {9, 1, 4, 9, 9, 4}, {11, 1, 4, 11, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 0, 3, 0, 1}, {1, 1, 1, 7, 3, 1}, {1, 1, 5, 7, 3, 5}, {1, 0, 2, 8, 0, 4}, {9, 0, 3, 10, 0, 3}, {0, 1, 2, 0, 3, 4}, {11, 1, 3, 11, 8, 3}, {1, 1, 2, 1, 1, 2}, {1, 1, 4, 1, 1, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{10, 10, 3, 10, 10, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoCobblestoneState, biomeSandstoneWallIntoCobblestoneState, false);
            }
            for (int[] uvwo : new int[][]{{2, 2, 0, 2}, {2, 2, 4, 2}, {6, 2, 4, 2}, {10, 11, 3, -1}, {10, 7, 3, 3}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{10, 1, 2, 10, 8, 2}, {10, 1, 4, 10, 8, 4}, {9, 3, 3, 9, 8, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvwwo : new int[][]{{8, 1, 2, 8, 1, 2, 0}, {8, 1, 4, 8, 1, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{1, 3, 2, 8, 3, 4}, {10, 9, 3, 10, 9, 3}, {0, 3, 3, 0, 3, 3}, {6, 3, 1, 6, 3, 1}, {4, 3, 5, 4, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uuvvww : new int[][]{{2, 4, 1, 2, 4, 1}, {4, 4, 1, 4, 4, 1}, {6, 4, 1, 6, 4, 1}, {2, 4, 5, 2, 4, 5}, {4, 4, 5, 4, 4, 5}, {6, 4, 5, 6, 4, 5}, {0, 4, 3, 0, 4, 3}, {9, 9, 3, 9, 9, 3}, {11, 9, 3, 11, 9, 3}, {10, 9, 2, 10, 9, 2}, {10, 9, 4, 10, 9, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{10, 1, 3, 10, 6, 3, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), biomeLadderState.func_177230_c().func_176203_a(StructureVillageVN.chooseLadderMeta(uuvvwwo[6])), false);
            }
            this.func_175811_a(world, fletchingTableState, 1, 1, 3, structureBB);
            for (int[] uvwoor : new int[][]{{3, 1, 1, 0, 1, 0}, {9, 1, 3, 3, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{0, 2, 3, 9}, {6, 2, 1, 9}, {4, 2, 5, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(6);
                int v = 1;
                int w = 2 + random.nextInt(3);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 4, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertFisher1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFFFF ", "FFFFFFFPFF ", "FFFFF  PF  ", "FFFFFFFP FF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 3;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertFisher1() {
        }

        public DesertFisher1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertFisher1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertFisher1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertFisher1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabTopState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(true, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 1, 0, 4, 1, 0}, {0, 1, 4, 4, 1, 4}, {0, 1, 1, 0, 1, 3}, {4, 1, 1, 4, 1, 3}, {1, 0, 1, 3, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 3, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            for (int[] uuvvww : new int[][]{{0, 2, 4, 0, 5, 4}, {2, 2, 4, 2, 5, 4}, {4, 2, 4, 4, 5, 4}, {4, 2, 2, 4, 5, 2}, {4, 2, 0, 4, 5, 0}, {5, 1, 3, 5, 4, 3}, {9, 1, 3, 9, 4, 3}, {9, 1, 7, 9, 4, 7}, {3, 1, 5, 3, 4, 5}, {3, 1, 7, 3, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{7, 0, 0, 7, 0, 3}, {6, 1, 3, 8, 3, 3}, {5, 0, 4, 8, 0, 6}, {9, 1, 4, 9, 3, 6}, {3, 1, 6, 3, 3, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{7, 3, 2, 2}, {8, 2, 5, 3}, {4, 2, 6, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{4, 1, 7, 8, 3, 7}, {5, 1, 4, 5, 3, 4}, {4, 1, 5, 4, 3, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 4, 6, 3, 4, 6}, {4, 4, 5, 4, 4, 7}, {5, 4, 4, 8, 4, 7}, {6, 4, 3, 8, 4, 3}, {9, 4, 4, 9, 4, 6}, {9, 3, 5, 9, 3, 5}, {7, 3, 7, 7, 3, 7}, {5, 3, 7, 5, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 5, 4, 1, 5, 4}, {3, 5, 4, 3, 5, 4}, {4, 5, 3, 4, 5, 3}, {4, 5, 1, 4, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabTopState, biomeSmoothSandstoneSlabTopState, false);
            }
            for (int[] uvwo : new int[][]{{10, 1, 0, 8}, {8, 1, 1, 4}, {9, 1, 2, 0}, {9, 2, 2, 8}}) {
                this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(uvwo[3]), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvwoo : new int[][]{{5, 1, 2, 1, 1}, {5, 2, 2, 2, -1}, {4, 1, 6, 1, -1}, {8, 1, 6, 3, 2}, {8, 1, 5, 3, 0}, {8, 2, 6, 3, 3}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwoo[0], uvwoo[2]), this.func_74862_a(uvwoo[1]), this.func_74873_b(uvwoo[0], uvwoo[2])), ModObjects.chooseModBarrelBlockState(this.func_186165_e(), uvwoo[4], uvwoo[3]), 2);
            }
            for (int[] uvwoor : new int[][]{{7, 1, 3, 0, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvwm : new int[][]{{0, 2, 3, 10}, {2, 2, 0, 9}, {5, 1, 0, 10}, {6, 1, 2, 9}}) {
                int flowernumber = uvwm[3];
                int potU = uvwm[0];
                int potV = uvwm[1];
                int potW = uvwm[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{7, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 5;
                int v = 1;
                int w = 4;
                while (u == 5 && w == 4) {
                    u = 5 + random.nextInt(3);
                    w = 4 + random.nextInt(3);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertFarm2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF   ", "FFFFFFF   ", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFF   ", "FFFFFFF   "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public DesertFarm2() {
        }

        public DesertFarm2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertFarm2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertFarm2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertFarm2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTrapdoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150415_aT.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 0, 5, 1, 0, 3}, {7, 1, 2, 8, 1, 2, 3}, {0, 1, 0, 0, 1, 6, 0}, {6, 1, 0, 6, 1, 2, 1}, {9, 1, 2, 9, 1, 4, 1}, {6, 1, 4, 6, 1, 6, 1}, {1, 1, 6, 5, 1, 6, 2}, {7, 1, 4, 8, 1, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{6, 1, 3, 8, 1, 3}, {3, 0, 2, 3, 0, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 1, 5, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150458_ak.func_176203_a(7), Blocks.field_150458_ak.func_176203_a(7), false);
            }
            for (int[] uuvvwwo : new int[][]{{3, 1, 3, 3, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            int[][][] uPairArray = new int[][][]{new int[][]{{1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}}, new int[][]{{1, 2}, {4, 5}}, new int[][]{{1, 2, 3, 4, 5}, {1, 2, 3, 4, 5}}};
            int[][][] vPairArray = new int[][][]{new int[][]{{2, 2, 2, 2, 2}, {2, 2, 2, 2, 2}}, new int[][]{{2, 2}, {2, 2}}, new int[][]{{2, 2, 2, 2, 2}, {2, 2, 2, 2, 2}}};
            int[][][] wPairArray = new int[][][]{new int[][]{{5, 5, 5, 5, 5}, {4, 4, 4, 4, 4}}, new int[][]{{3, 3}, {3, 3}}, new int[][]{{2, 2, 2, 2, 2}, {1, 1, 1, 1, 1}}};
            int[][][] cropPairAgeArray = new int[][][]{new int[][]{{0, 1, 0, 1, 3}, {1, 0, 0, 1, 0}}, new int[][]{{1, 1}, {1, 0}}, new int[][]{{0, 0, 2, 2, 0}, {2, 0, 0, 1, 2}}};
            for (int crop_pair = 0; crop_pair < cropPairAgeArray.length; ++crop_pair) {
                Block[] cropBlocks = StructureVillageVN.chooseCropPair(random);
                for (int crop_member = 0; crop_member < 2; ++crop_member) {
                    for (int i = 0; i < cropPairAgeArray[crop_pair][crop_member].length; ++i) {
                        int cropProgressMeta = cropPairAgeArray[crop_pair][crop_member][i];
                        while (true) {
                            IBlockState cropState;
                            try {
                                cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                            }
                            catch (IllegalArgumentException e) {
                                if (cropProgressMeta == 0) {
                                    cropState = Blocks.field_150464_aj.func_176203_a(cropPairAgeArray[crop_pair][crop_member][i]);
                                    break;
                                }
                                cropProgressMeta /= 2;
                                continue;
                            }
                            break;
                        }
                        this.func_175811_a(world, Blocks.field_150464_aj.func_176203_a(cropPairAgeArray[crop_pair][crop_member][i]), uPairArray[crop_pair][crop_member][i], vPairArray[crop_pair][crop_member][i], wPairArray[crop_pair][crop_member][i], structureBB);
                    }
                }
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            this.func_175811_a(world, compostBinState != null ? compostBinState : Blocks.field_150407_cf.func_176203_a(0), 8, 2, 3, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(6), 7, 2, 3, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(7), 9, 2, 3, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(5), 8, 2, 2, structureBB);
            this.func_175811_a(world, biomeTrapdoorState.func_177230_c().func_176203_a(4), 8, 2, 4, structureBB);
            for (int[] uvw : new int[][]{{0, 1, -1}, {1, 1, -1}, {2, 1, -1}, {3, 1, -1}, {4, 1, -1}, {5, 1, -1}, {6, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 2;
                int w = 2;
                while (u > 0 && u < 6 && w > 0 && w < 6) {
                    u = random.nextInt(7);
                    w = random.nextInt(7);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertFarm1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertFarm1() {
        }

        public DesertFarm1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertFarm1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertFarm1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertFarm1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{2, 0, 0, 4, 0, 0}, {2, 0, 4, 4, 0, 4}, {0, 0, 2, 0, 0, 2}, {6, 0, 2, 6, 0, 2}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 0, 0, 1, 0, 0, 3}, {5, 0, 0, 5, 0, 0, 3}, {0, 0, 0, 0, 0, 1, 0}, {0, 0, 3, 0, 0, 4, 0}, {6, 0, 0, 6, 0, 1, 1}, {6, 0, 3, 6, 0, 4, 1}, {1, 0, 4, 1, 0, 4, 2}, {5, 0, 4, 5, 0, 4, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 0, 1, 1, 0, 3}, {3, 0, 1, 3, 0, 3}, {5, 0, 1, 5, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150458_ak.func_176203_a(7), Blocks.field_150458_ak.func_176203_a(7), false);
            }
            for (int[] uuvvwwo : new int[][]{{2, 0, 1, 2, 0, 3}, {4, 0, 1, 4, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            int[][] cropAgeArray = new int[][]{{7, 0, 7}, {7, 7, 0}, {7, 7, 0}};
            int[] ua = new int[]{1, 3, 5};
            for (int i = 0; i < 3; ++i) {
                Block[] cropBlocks = StructureVillageVN.chooseCropPair(random);
                for (int j = 0; j < 3; ++j) {
                    IBlockState cropState;
                    int cropProgressMeta = cropAgeArray[i][j];
                    while (true) {
                        try {
                            cropState = cropBlocks[0].func_176203_a(cropProgressMeta);
                        }
                        catch (IllegalArgumentException e) {
                            if (cropProgressMeta == 0) {
                                cropState = Blocks.field_150464_aj.func_176203_a(cropAgeArray[i][j]);
                                break;
                            }
                            cropProgressMeta /= 2;
                            continue;
                        }
                        break;
                    }
                    this.func_175811_a(world, cropState, ua[i], 1, j + 1, structureBB);
                }
            }
            IBlockState compostBinState = ModObjects.chooseModComposterState();
            if (compostBinState != null) {
                this.func_175811_a(world, compostBinState.func_177230_c().func_176223_P(), 5, 1, 2, structureBB);
                this.func_175811_a(world, Blocks.field_150346_d.func_176223_P(), 5, 0, 2, structureBB);
            }
            for (int[] uvw : new int[][]{{0, 0, -1}, {1, 0, -1}, {2, 0, -1}, {3, 0, -1}, {4, 0, -1}, {5, 0, -1}, {6, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2;
                int v = 1;
                int w = 2;
                while (u > 0 && u < STRUCTURE_WIDTH - 1 && w > 0 && w < STRUCTURE_DEPTH - 1) {
                    u = random.nextInt(STRUCTURE_WIDTH);
                    w = random.nextInt(STRUCTURE_DEPTH);
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 0, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertCartographerHouse1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertCartographerHouse1() {
        }

        public DesertCartographerHouse1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertCartographerHouse1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertCartographerHouse1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertCartographerHouse1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)5, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState cartographyTableState = ModObjects.chooseModCartographyTableState(2, this.func_186165_e());
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 0, 2, 1, 0}, {3, 0, 0, 3, 0, 0}, {1, 4, 1, 1, 4, 1}, {3, 0, 1, 5, 2, 1}, {1, 1, 1, 2, 1, 3}, {4, 2, 2, 4, 2, 2}, {1, 1, 1, 2, 1, 3}, {3, 2, 3, 5, 2, 5}, {0, 0, 2, 0, 4, 3}, {1, 0, 4, 1, 4, 4}, {2, 0, 4, 3, 2, 4}, {2, 0, 1, 2, 0, 3}, {3, 0, 2, 3, 1, 2}, {5, 3, 3, 5, 4, 3}, {4, 5, 3, 5, 5, 3}, {3, 5, 4, 3, 5, 5}, {0, 0, 5, 1, 0, 5}, {2, 0, 5, 3, 1, 5}, {4, 0, 6, 5, 5, 6}, {5, 0, 2, 6, 2, 2}, {6, 0, 4, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 6, 3, 6, 6}, {6, 0, 6, 6, 6, 6}, {3, 3, 3, 3, 6, 3}, {6, 0, 3, 6, 6, 3}, {6, 0, 1, 6, 3, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 3, 3}, {4, 1, 2, 1}, {4, 5, 5, 1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 0, 5, 1}, {2, 2, 1, 2, 5, 1}, {0, 0, 4, 0, 5, 4}, {2, 3, 4, 2, 5, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 5, 2, 0, 5, 3}, {1, 5, 1, 1, 5, 4}, {2, 5, 2, 2, 5, 3}, {3, 6, 4, 3, 6, 5}, {4, 6, 3, 4, 6, 6}, {5, 6, 3, 5, 6, 6}, {6, 6, 4, 6, 6, 5}, {3, 3, 1, 5, 3, 1}, {6, 3, 2, 6, 3, 2}, {1, 0, 6, 2, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{4, 0, 0, 4, 0, 0, 1}, {3, 1, 0, 3, 1, 0, 1}, {3, 2, 2, 3, 2, 2, 0}, {1, 1, 5, 1, 1, 5, 0}, {2, 2, 5, 2, 2, 5, 0}, {0, 0, 6, 0, 0, 6, 2}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwoor : new int[][]{{1, 2, 1, 0, 1, 0}, {4, 3, 3, 0, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{2, 2, 3}}) {
                this.func_175811_a(world, cartographyTableState, uvw[0], uvw[1], uvw[2], structureBB);
            }
            for (int[] uvw : new int[][]{{0, 0, 0}, {5, 3, 2}}) {
                int flowernumber = 9;
                int potU = uvw[0];
                int potV = uvw[1];
                int potW = uvw[2];
                int potX = this.func_74865_a(potU, potW);
                int potY = this.func_74862_a(potV);
                int potZ = this.func_74873_b(potU, potW);
                TileEntity flowerPot = new BlockFlowerPot().func_149915_a(world, flowernumber);
                BlockPos flowerPotPos = new BlockPos(potX, potY, potZ);
                world.func_175656_a(flowerPotPos, Blocks.field_150457_bL.func_176223_P());
                world.func_175690_a(flowerPotPos, flowerPot);
            }
            for (int[] uvw : new int[][]{{5, 0, -1}, {6, 0, -1}, {0, 0, 7}, {1, 0, 7}, {2, 0, 7}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 1;
                int v = 2;
                int w = 1 + random.nextInt(3);
                if (w < 2) {
                    ++w;
                    ++u;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 1, 2, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 1;
        }
    }

    public static class DesertButcherShop1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "FFFFFFFF", "  F     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 5;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 3;
        private int averageGroundLevel = -1;

        public DesertButcherShop1() {
        }

        public DesertButcherShop1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertButcherShop1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)5, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertButcherShop1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertButcherShop1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 3 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 3)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState smokerState = ModObjects.chooseModSmokerState(3, this.func_186165_e());
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogHorAlongState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), false);
            IBlockState biomeLogHorAcrossState = StructureVillageVN.getHorizontalPillarState(biomeLogVertState, this.func_186165_e().func_176736_b(), true);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 0, 0, 7}, {7, 0, 1, 7, 0, 7}, {1, 0, 1, 6, 0, 1}, {1, 0, 7, 6, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 0, 3, 1}, {4, 1, 1, 4, 3, 1}, {0, 1, 4, 0, 3, 4}, {4, 1, 4, 4, 3, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 2, 0, 4, 3}, {4, 4, 2, 4, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAlongState, biomeLogHorAlongState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 1, 3, 4, 1}, {1, 4, 4, 3, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogHorAcrossState, biomeLogHorAcrossState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 1, 1, 3, 3, 1}, {0, 1, 2, 0, 3, 3}, {4, 1, 2, 4, 3, 3}, {1, 1, 4, 3, 3, 4}, {1, 0, 2, 3, 0, 4}, {2, 0, 1, 2, 0, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 2, 2, 0, 2, 3}, {4, 2, 2, 4, 2, 3}, {1, 4, 2, 3, 4, 3}, {0, 4, 1, 0, 4, 1}, {0, 4, 4, 0, 4, 4}, {4, 4, 1, 4, 4, 1}, {4, 4, 4, 4, 4, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 5, 0, 1, 7}, {1, 1, 7, 6, 1, 7}, {7, 1, 1, 7, 1, 7}, {5, 1, 1, 6, 1, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 0, 5, 4, 0, 6}, {5, 0, 2, 6, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uvwo : new int[][]{{2, 3, 0, 2}, {2, 3, 3, 2}, {0, 2, 7, -1}, {7, 2, 7, -1}, {7, 2, 1, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvwwo : new int[][]{{2, 0, 0, 2, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwoor : new int[][]{{2, 1, 1, 2, 1, 1}, {2, 1, 4, 2, 1, 0}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uuvvwwo : new int[][]{{2, 0, 2, 2, 0, 3}, {3, 1, 2, 3, 1, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], Blocks.field_150334_T.func_176203_a(0), Blocks.field_150334_T.func_176203_a(0), false);
            }
            for (int[] uvwo : new int[][]{{1, 1, 3, 1}}) {
                world.func_180501_a(new BlockPos(this.func_74865_a(uvwo[0], uvwo[2]), this.func_74862_a(uvwo[1]), this.func_74873_b(uvwo[0], uvwo[2])), smokerState.func_177230_c().func_176203_a(smokerState.func_177230_c() == Block.func_149684_b((String)"futuremc:smoker") ? StructureVillageVN.chooseFurnaceMeta(uvwo[3], this.func_186165_e()) : StructureVillageVN.chooseBlastFurnaceMeta(uvwo[3], this.func_186165_e())), 2);
            }
            for (int[] uuvvww : new int[][]{{1, 2, 3, 1, 4, 3}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150405_ch.func_176223_P(), Blocks.field_150405_ch.func_176223_P(), false);
            }
            for (int[] uvw : new int[][]{{3, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{6, 1, 6}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
                int u = 2;
                int v = 1;
                int w = 1 + random.nextInt(3);
                if (w < 2) {
                    ++w;
                    --u;
                }
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 4, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 4;
        }
    }

    public static class DesertArmorer1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", "FFFFFFF", " FFFFF ", " FFFFF "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 7;
        private static final int GROUND_LEVEL = 1;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertArmorer1() {
        }

        public DesertArmorer1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertArmorer1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)7, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertArmorer1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertArmorer1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 1, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeWoodDoorState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180413_ao.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeFenceState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            IBlockState graniteState = Blocks.field_150348_b.func_176203_a(1);
            Block graniteStairsBlock = ModObjects.chooseModGraniteStairsBlock();
            IBlockState graniteWallState = ModObjects.chooseModGraniteWallState();
            if (graniteStairsBlock == null || graniteWallState == null) {
                graniteState = Blocks.field_150347_e.func_176203_a(0);
                graniteStairsBlock = Blocks.field_150446_ar;
                graniteWallState = Blocks.field_150463_bK.func_176223_P();
            }
            for (int[] uuvvww : new int[][]{{2, 1, 5, 4, 2, 5}, {3, 3, 5, 3, 4, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], graniteState, graniteState, false);
            }
            for (int[] uuvvwwo : new int[][]{{2, 3, 5, 2, 3, 5, 0}, {4, 3, 5, 4, 3, 5, 1}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], graniteStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), graniteStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{3, 5, 5, 3, 6, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], graniteWallState, graniteWallState, false);
            }
            IBlockState blastFurnaceState = ModObjects.chooseModBlastFurnaceState(2, this.func_186165_e());
            for (int[] uvw : new int[][]{{3, 1, 5}}) {
                this.func_175811_a(world, blastFurnaceState.func_177230_c().func_176203_a(0), uvw[0], uvw[1], uvw[2], structureBB);
                world.func_180501_a(new BlockPos(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])), blastFurnaceState, 2);
            }
            for (int[] uuvvww : new int[][]{{2, 2, 4, 4, 2, 4}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150430_aB.func_176203_a(StructureVillageVN.chooseButtonMeta(2)), Blocks.field_150430_aB.func_176203_a(StructureVillageVN.chooseButtonMeta(2)), false);
            }
            for (int[] uuvvww : new int[][]{{2, 1, 0, 4, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uvwo : new int[][]{{1, 2, 5, 3}, {5, 2, 5, 1}, {3, 3, 1, 0}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{3, 0, 0, 3, 0, 0}, {2, 0, 1, 4, 0, 2}, {1, 0, 3, 5, 0, 4}, {1, 0, 5, 1, 0, 5}, {5, 0, 5, 5, 0, 5}, {1, 1, 6, 5, 4, 6}, {0, 1, 3, 0, 4, 5}, {1, 1, 1, 1, 3, 2}, {6, 1, 3, 6, 4, 5}, {5, 1, 1, 5, 3, 2}, {1, 4, 2, 5, 4, 2}, {0, 5, 4, 0, 5, 4}, {6, 5, 4, 6, 5, 4}, {2, 5, 6, 2, 5, 6}, {4, 5, 6, 4, 5, 6}, {2, 5, 2, 2, 5, 2}, {4, 5, 2, 4, 5, 2}, {3, 4, 0, 3, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 2, 0, 5, 2}, {0, 1, 6, 0, 5, 6}, {6, 1, 2, 6, 5, 2}, {6, 1, 6, 6, 5, 6}, {1, 1, 0, 1, 4, 0}, {5, 1, 0, 5, 4, 0}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeLogVertState, biomeLogVertState, false);
            }
            for (int[] uuvvww : new int[][]{{1, 4, 1, 5, 4, 1}, {1, 5, 3, 5, 5, 4}, {1, 5, 5, 2, 5, 5}, {4, 5, 5, 5, 5, 5}, {2, 4, 0, 2, 4, 0}, {4, 4, 0, 4, 4, 0}, {1, 4, 1, 1, 4, 1}, {5, 4, 1, 5, 4, 1}, {1, 5, 2, 1, 5, 2}, {3, 5, 2, 3, 5, 2}, {5, 5, 2, 5, 5, 2}, {1, 5, 6, 1, 5, 6}, {3, 5, 6, 3, 5, 6}, {5, 5, 6, 5, 5, 6}, {0, 5, 3, 0, 5, 3}, {0, 5, 5, 0, 5, 5}, {6, 5, 3, 6, 5, 3}, {6, 5, 5, 6, 5, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{1, 1, 3, 1, 1, 3, 1}, {5, 1, 3, 5, 1, 3, 0}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uuvvww : new int[][]{{1, 2, 1, 1, 2, 1}, {5, 2, 1, 5, 2, 1}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeFenceState, biomeFenceState, false);
            }
            for (int[] uvwoor : new int[][]{{3, 1, 0, 2, 1, 1}}) {
                for (int height = 0; height <= 1; ++height) {
                    this.func_175811_a(world, biomeWoodDoorState.func_177230_c().func_176203_a(StructureVillageVN.getDoorMetas(uvwoor[3], this.func_186165_e(), uvwoor[4] == 1, uvwoor[5] == 1)[height]), uvwoor[0], uvwoor[1] + height, uvwoor[2], structureBB);
                }
            }
            for (int[] uvw : new int[][]{{3, 1, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                int u = 2 + random.nextInt(3);
                int v = 1;
                int w = 1 + random.nextInt(4);
                EntityVillager entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, 3, 1, 0);
                entityvillager.func_70012_b((double)this.func_74865_a(u, w) + 0.5, (double)this.func_74862_a(v) + 0.5, (double)this.func_74873_b(u, w) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)entityvillager);
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 3;
        }
    }

    public static class DesertAnimalPen2
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "    FF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertAnimalPen2() {
        }

        public DesertAnimalPen2(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertAnimalPen2 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertAnimalPen2.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertAnimalPen2(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 9, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 9, 0, 1}, {0, 0, 8, 9, 0, 8}, {0, 0, 2, 0, 0, 7}, {9, 0, 2, 9, 0, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 9, 1, 1}, {0, 1, 8, 9, 1, 8}, {0, 1, 2, 0, 1, 7}, {9, 1, 2, 9, 1, 7}, {0, 2, 4, 0, 3, 4}, {9, 2, 4, 9, 3, 4}, {0, 2, 8, 0, 3, 8}, {9, 2, 8, 9, 3, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 4, 7, 1, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 4, 9, 4, 8}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{4, 0, 0, 5, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwos : new int[][]{{4, 1, 1, 2, 0}, {5, 1, 1, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int[] uuvvww : new int[][]{{5, 1, 5, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], Blocks.field_150358_i.func_176203_a(0), Blocks.field_150358_i.func_176203_a(0), false);
            }
            for (int[] uvw : new int[][]{{4, 0, -1}, {5, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{3, 1, 3}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertAnimalPen1
    extends StructureVillagePieces.Village {
        public boolean entitiesGenerated = false;
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final String[] foundationPattern = new String[]{"FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "FFFFFFFFFF", "    FF    "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        private static final int GROUND_LEVEL = 0;
        private static final int INCREASE_MIN_U = 0;
        private static final int DECREASE_MAX_U = 0;
        private int averageGroundLevel = -1;

        public DesertAnimalPen1() {
        }

        public DesertAnimalPen1(StructureVillageVN.StartVN start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing coordBaseMode) {
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = boundingBox;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.disallowModSubs = start.disallowModSubs;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static DesertAnimalPen1 buildComponent(StructureVillageVN.StartVN villagePiece, List pieces, Random random, int x, int y, int z, EnumFacing coordBaseMode, int componentType) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)STRUCTURE_WIDTH, (int)6, (int)STRUCTURE_DEPTH, (EnumFacing)coordBaseMode);
            return DesertAnimalPen1.func_74895_a((StructureBoundingBox)structureboundingbox) && StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)structureboundingbox) == null ? new DesertAnimalPen1(villagePiece, componentType, random, structureboundingbox, coordBaseMode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.averageGroundLevel < 0 && this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78893_d - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0), this.field_74887_e.field_78892_f - (this.func_186165_e().func_176736_b() % 2 == 0 ? 0 : 0)), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int bbCenterX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int bbCenterZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(bbCenterX, 64, bbCenterZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (this.materialType == null) {
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, bbCenterX, bbCenterZ);
                }
            }
            if (!this.disallowModSubs) {
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeCutSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150322_A.func_176203_a(2), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            Block biomeSmoothSandstoneStairsBlock = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneStairsBlock(false).func_176223_P(), this.materialType, this.biome, this.disallowModSubs).func_177230_c();
            IBlockState biomeFenceGateState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180390_bo.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 0, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(-1);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, -1 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, -1, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, -1, w, structureBB);
                }
            }
            for (int[] uuvvww : new int[][]{{1, 0, 2, 8, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeGrassState, biomeGrassState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 0, 1, 9, 0, 1}, {0, 0, 7, 9, 0, 7}, {0, 0, 2, 0, 0, 6}, {9, 0, 2, 9, 0, 6}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeCutSandstoneState, biomeCutSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 1, 1, 9, 1, 1}, {0, 1, 7, 9, 1, 7}, {0, 1, 2, 0, 1, 6}, {9, 1, 2, 9, 1, 6}, {0, 2, 3, 0, 3, 3}, {2, 1, 3, 2, 3, 3}, {0, 2, 7, 0, 3, 7}, {2, 2, 7, 2, 3, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            }
            for (int[] uuvvww : new int[][]{{4, 0, 3, 6, 1, 5}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            for (int[] uuvvww : new int[][]{{0, 4, 3, 2, 4, 7}}) {
                this.func_175804_a(world, structureBB, uuvvww[0], uuvvww[1], uuvvww[2], uuvvww[3], uuvvww[4], uuvvww[5], biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            }
            for (int[] uuvvwwo : new int[][]{{4, 0, 0, 5, 0, 0, 3}}) {
                this.func_175804_a(world, structureBB, uuvvwwo[0], uuvvwwo[1], uuvvwwo[2], uuvvwwo[3], uuvvwwo[4], uuvvwwo[5], biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), biomeSmoothSandstoneStairsBlock.func_176203_a(uuvvwwo[6] % 4 + uuvvwwo[6] / 4 * 4), false);
            }
            for (int[] uvwos : new int[][]{{4, 1, 1, 2, 0}, {5, 1, 1, 2, 0}}) {
                this.func_175811_a(world, biomeFenceGateState.func_177230_c().func_176203_a(StructureVillageVN.chooseFenceGateMeta(uvwos[3], uvwos[4] == 1)), uvwos[0], uvwos[1], uvwos[2], structureBB);
            }
            for (int[] uvwo : new int[][]{{5, 1, 4}}) {
                this.func_175811_a(world, Blocks.field_150358_i.func_176203_a(0), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            for (int[] uvw : new int[][]{{4, 0, -1}, {5, 0, -1}}) {
                int pathU = uvw[0];
                int pathV = uvw[1];
                int pathW = uvw[2];
                this.func_74871_b(world, pathU, pathV, pathW, structureBB);
                this.func_175808_b(world, biomeFillerState, pathU, pathV - 2, pathW, structureBB);
                if (world.func_175623_d(new BlockPos(this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW)))) {
                    this.func_175811_a(world, biomeGrassState, pathU, pathV - 1, pathW, structureBB);
                }
                StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, this.func_74865_a(pathU, pathW), this.func_74862_a(pathV - 1), this.func_74873_b(pathU, pathW), false);
            }
            if (!this.entitiesGenerated) {
                this.entitiesGenerated = true;
                for (int[] uvw : new int[][]{{7, 1, 3}}) {
                    BlockPos animalPos = new BlockPos((double)this.func_74865_a(uvw[0], uvw[2]) + 0.5, (double)this.func_74862_a(uvw[1]) + 0.5, (double)this.func_74873_b(uvw[0], uvw[2]) + 0.5);
                    EntityLiving animal = StructureVillageVN.getVillageAnimal(world, animalPos, random, false, true, true, this.materialType == FunctionsVN.MaterialType.MUSHROOM);
                    animal.func_70012_b((double)animalPos.func_177958_n(), (double)animalPos.func_177956_o(), (double)animalPos.func_177952_p(), random.nextFloat() * 360.0f, 0.0f);
                    world.func_72838_d((Entity)animal);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }

        protected int func_180779_c(int villagersSpawnedIn, int currentVillagerProfession) {
            return 0;
        }
    }

    public static class DesertMeetingPoint3
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{" FF FFFFFF     ", "   FFFFFFFFFF  ", "FFFFFFFFFFFFFF ", "FFFFFFFFFFFFFFF", "FFFFFFFFFFFFFFF", "FFFFFFFFPPPPPPF", "FFFFFFFFPFFFFPP", "FFFFFFFFPFPPFPP", " FFFFFFFPFPPFPP", " FFFFFFFPFFFFPF", " FFFFFFPPPPPPPF", "   FFFFPPPPFFFF", "   FFFFPFFPFFF ", "   F FFPPPPFFF ", "     FFPFFPF F "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;

        public DesertMeetingPoint3() {
        }

        public DesertMeetingPoint3(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            if (this.func_186165_e().func_176736_b() != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{1, 5, 1, 7})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 1) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c + (new int[]{6, 4, 6, 1})[this.func_186165_e().func_176736_b()], EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 2) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (new int[]{1, 6, 4, 6})[this.func_186165_e().func_176736_b()], this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() != 3) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 5, this.field_74887_e.field_78896_c + (new int[]{7, 1, 5, 4})[this.func_186165_e().func_176736_b()], EnumFacing.WEST, this.func_74877_c());
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)14, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneWallIntoFenceState = ModObjects.chooseModSandstoneWall(this.materialType == FunctionsVN.MaterialType.MESA);
            if ((biomeSandstoneWallIntoFenceState = biomeSandstoneWallIntoFenceState == null ? StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs) : StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs)) == null) {
                StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_180407_aO.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            } else {
                biomeSandstoneWallIntoFenceState = StructureVillageVN.getBiomeSpecificBlockState(biomeSandstoneWallIntoFenceState, this.materialType, this.biome, this.disallowModSubs);
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150333_U.func_176203_a(1), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(8, 2), this.func_74862_a(3), this.func_74873_b(8, 2));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            int clearToHeight = 5;
            this.func_175804_a(world, structureBB, 7, 0, 0, 7, 0, 4, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 10, 0, 0, 10, 0, 3, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 8, 0, 1, 9, 0, 1, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 8, 0, 3, 9, 0, 3, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 8, 0, 4, 13, 0, 4, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 8, 0, 9, 13, 0, 9, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 8, 0, 5, 8, 0, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 13, 0, 5, 13, 0, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 10, 0, 6, 11, 0, 7, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 14, 0, 6, 14, 0, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            if (GeneralConfig.useVillageColors) {
                IBlockState iBlockState = Blocks.field_192443_dR.func_176203_a(this.townColor2);
                this.func_175804_a(world, structureBB, 9, 1, 5, 12, 1, 8, iBlockState, iBlockState, false);
            } else {
                this.func_175804_a(world, structureBB, 9, 1, 5, 12, 1, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            this.func_175811_a(world, biomeLogVertState, 9, 1, 5, structureBB);
            this.func_175811_a(world, biomeLogVertState, 9, 1, 8, structureBB);
            this.func_175811_a(world, biomeLogVertState, 12, 1, 8, structureBB);
            this.func_175811_a(world, biomeLogVertState, 12, 1, 5, structureBB);
            this.func_175811_a(world, biomeSandstoneSlabBottomState, 9, 2, 5, structureBB);
            this.func_175811_a(world, biomeSandstoneSlabBottomState, 9, 2, 8, structureBB);
            this.func_175811_a(world, biomeSandstoneSlabBottomState, 12, 2, 8, structureBB);
            this.func_175811_a(world, biomeSandstoneSlabBottomState, 12, 2, 5, structureBB);
            this.func_175804_a(world, structureBB, 10, 1, 6, 11, 1, 7, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 7, 1, 0, 7, 3, 0, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 10, 1, 0, 10, 3, 0, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 10, 1, 2, 10, 3, 2, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 2, 7, 3, 2, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 7, 4, 0, 10, 4, 2, biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            this.func_74878_a(world, structureBB, 8, 4, 1, 9, 4, 1);
            this.func_175804_a(world, structureBB, 1, 1, 5, 1, 4, 5, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 5, 1, 5, 5, 4, 5, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 5, 1, 7, 5, 4, 7, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 1, 1, 7, 1, 4, 7, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 1, 5, 5, 5, 5, 7, biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            this.func_74878_a(world, structureBB, 2, 5, 6, 4, 5, 6);
            this.func_175804_a(world, structureBB, 4, 1, 11, 4, 3, 11, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 11, 7, 3, 11, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 7, 1, 14, 7, 3, 14, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 4, 1, 14, 4, 3, 14, biomeSandstoneWallIntoFenceState, biomeSandstoneWallIntoFenceState, false);
            this.func_175804_a(world, structureBB, 4, 4, 11, 7, 4, 14, biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            this.func_74878_a(world, structureBB, 5, 4, 12, 6, 4, 13);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor : 0, (0 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4), 5, 1, 13, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor : 0, (1 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4), 6, 1, 13, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor : 0, (2 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4), 6, 1, 12, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor : 0, (3 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4), 5, 1, 12, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor2 : 0, (0 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4), 8, 1, 2, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor2 : 0, (1 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4), 9, 1, 2, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor2 : 0, (2 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 1 : 0)) % 4), 9, 1, 0, structureBB);
            this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(GeneralConfig.useVillageColors ? this.townColor2 : 0, (3 + this.func_186165_e().func_176736_b() + (this.func_186165_e().func_176736_b() < 2 ? 3 : 0)) % 4), 8, 1, 0, structureBB);
            this.func_175804_a(world, structureBB, 2, 1, 6, 4, 1, 6, biomeLogVertState, biomeLogVertState, false);
            this.func_175811_a(world, Blocks.field_150372_bz.func_176203_a(0), 1, 1, 6, structureBB);
            this.func_175811_a(world, Blocks.field_150372_bz.func_176203_a(1), 5, 1, 6, structureBB);
            this.func_175811_a(world, Blocks.field_150407_cf.func_176223_P(), 5, 1, 0, structureBB);
            this.func_175811_a(world, Blocks.field_150407_cf.func_176203_a(this.func_186165_e().func_176736_b() % 2 == 1 ? 8 : 4), 3, 1, 2, structureBB);
            for (int[] uvwm : new int[][]{{0, 1, 7, 9}, {3, 1, 7, 9}, {2, 2, 6, 9}, {4, 2, 6, 9}, {9, 2, 2, 9}, {1, 1, 4, 10}, {2, 1, 5, 10}, {2, 1, 7, 10}, {3, 2, 6, 10}, {4, 1, 5, 10}}) {
                BlockPos potPos = new BlockPos(this.func_74865_a(uvwm[0], uvwm[2]), this.func_74862_a(uvwm[1]), this.func_74873_b(uvwm[0], uvwm[2]));
                TileEntity flowerPotTE = new BlockFlowerPot().func_149915_a(world, uvwm[3]);
                world.func_180501_a(potPos, Blocks.field_150457_bL.func_176223_P(), 2);
                world.func_175690_a(potPos, flowerPotTE);
            }
            int[][] nArrayArray = new int[][]{{1, 1, 11}, {12, 1, 12}, {13, 1, 0}, {14, 1, 3}};
            for (int j = 0; j < nArrayArray.length; ++j) {
                int[] uvw = nArrayArray[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = uvw[1];
                ArrayList<BlueprintData> decorBlueprint = StructureVillageVN.getRandomDecorBlueprint(this.villageType, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ, VillageGeneratorConfigHandler.allowTaigaTroughs && !VillageGeneratorConfigHandler.restrictTaigaTroughs);
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
            }
            if (GeneralConfig.nameSign) {
                int signXBB = 8;
                int signYBB = 2;
                int signZBB = 2;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(0, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 10;
                int bannerZBB = 11;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
                this.func_175808_b(world, biomeSmoothSandstoneState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{6, 1, 5, -1, 0}, {8, 1, 10, -1, 0}, {11, 1, 10, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class DesertMeetingPoint2
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"     PPP    ", " PPPPPPPPPP ", " PPPPPPPPPP ", " PPFFFFFFPP ", "PPPFFFFFFPP ", "PPPFFFFFFPPP", "PPPFFFFFFPPP", " PPFFFFFFPPP", " PPFFFFFFPP ", " PPPPPPPPPP ", " PPPPPPPPPP ", "    PPP     "};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;

        public DesertMeetingPoint2() {
        }

        public DesertMeetingPoint2(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() >= 2 ? 5 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() >= 2 ? 5 : 4), EnumFacing.EAST, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + (this.func_186165_e().func_176736_b() <= 1 ? 5 : 4), this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + (this.func_186165_e().func_176736_b() <= 1 ? 5 : 4), EnumFacing.WEST, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)15, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneSlabBottomState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneSlab(false, false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(8, 1), this.func_74862_a(1), this.func_74873_b(8, 1));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String string = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = string.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(string, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception exception) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String string = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = string.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(string, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception exception) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String string = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = string.toLowerCase().trim().equals("nosub");
                }
                catch (Exception exception) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175804_a(world, structureBB, 1, 0, 1, 10, 0, 10, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 3, 0, 3, 8, 0, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            if (GeneralConfig.useVillageColors) {
                IBlockState iBlockState = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175804_a(world, structureBB, 3, 1, 3, 8, 1, 8, iBlockState, iBlockState, false);
            } else {
                this.func_175804_a(world, structureBB, 3, 1, 3, 8, 1, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            this.func_175804_a(world, structureBB, 4, 1, 4, 7, 1, 7, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 4, 4, 4, 7, 4, 7, biomeSmoothSandstoneSlabBottomState, biomeSmoothSandstoneSlabBottomState, false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 4, 4, 4, biomeLogVertState, biomeLogVertState, false);
            this.func_175804_a(world, structureBB, 4, 1, 7, 4, 4, 7, biomeLogVertState, biomeLogVertState, false);
            this.func_175804_a(world, structureBB, 7, 1, 7, 7, 4, 7, biomeLogVertState, biomeLogVertState, false);
            this.func_175804_a(world, structureBB, 7, 1, 4, 7, 4, 4, biomeLogVertState, biomeLogVertState, false);
            for (int[] uvwo : new int[][]{{4, 5, 4, -1}, {4, 5, 7, -1}, {7, 5, 7, -1}, {7, 5, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            if (GeneralConfig.useVillageColors) {
                BlockPos blockPos = new BlockPos(5, 4, 5);
                int metaBase = ((int)world.func_72905_C() % 4 + this.func_186165_e().func_176736_b()) % 4;
                int metaCycle = (metaBase + Math.abs(this.func_74865_a(blockPos.func_177958_n(), blockPos.func_177952_p()) % 2 - this.func_74873_b(blockPos.func_177958_n(), blockPos.func_177952_p()) % 2 * 3) + blockPos.func_177956_o()) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), structureBB);
                BlockPos blockPos2 = blockPos.func_177968_d();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p(), structureBB);
                BlockPos blockPos3 = blockPos2.func_177974_f();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), blockPos3.func_177958_n(), blockPos3.func_177956_o(), blockPos3.func_177952_p(), structureBB);
                BlockPos blockPos4 = blockPos3.func_177978_c();
                metaCycle = (metaCycle + 1) % 4;
                this.func_175811_a(world, FunctionsVN.getGlazedTerracotaFromMetas(this.townColor2, metaCycle), blockPos4.func_177958_n(), blockPos4.func_177956_o(), blockPos4.func_177952_p(), structureBB);
            } else {
                this.func_175804_a(world, structureBB, 5, 4, 5, 6, 4, 6, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            }
            if (GeneralConfig.nameSign) {
                int n = 8;
                int signYBB = 1;
                int signZBB = 1;
                int signX = this.func_74865_a(n, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(n, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(12, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int n = 10;
                int bannerZBB = 10;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(n, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(n, bannerZBB);
                this.func_175804_a(world, structureBB, n, bannerYBB - 2, bannerZBB, n, bannerYBB - 1, bannerZBB, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
                this.func_175808_b(world, biomeSmoothSandstoneState, n, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(12, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{10, 1, 8, -1, 0}, {1, 1, 10, -1, 0}, {7, 1, 10, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class DesertMeetingPoint1
    extends StructureVillageVN.StartVN {
        private static final String[] foundationPattern = new String[]{"   PPPPPPP", " PPPPPPPPP", " PPFFFPPPP", "PPFFFFFPPP", "PPFFFFFPPP", "PPFFFFFPPP", " PPFFFPPPP", " PPPPPPPPP", "   PPPPPPP"};
        public static final int STRUCTURE_WIDTH = foundationPattern[0].length();
        public static final int STRUCTURE_DEPTH = foundationPattern.length;
        public static final int STRUCTURE_HEIGHT = 6;
        public static final int GROUND_LEVEL = 1;

        public DesertMeetingPoint1() {
        }

        public DesertMeetingPoint1(BiomeProvider chunkManager, int componentType, Random random, int posX, int posZ, List components, float terrainType) {
            super(chunkManager, componentType, random, posX, posZ, components, terrainType);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            switch (this.func_186165_e()) {
                case NORTH: 
                case SOUTH: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_WIDTH - 1, 69, posZ + STRUCTURE_DEPTH - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(posX, 64, posZ, posX + STRUCTURE_DEPTH - 1, 69, posZ + STRUCTURE_WIDTH - 1);
                }
            }
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            if (GeneralConfig.debugMessages) {
                LogHelper.info((Object)((Object)this.materialType) + " " + (Object)((Object)this.villageType) + " village generated in " + ReflectionHelper.getPrivateValue(Biome.class, (Object)this.field_74929_a.func_180631_a(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2)), (String[])new String[]{"biomeName", "field_76791_y"}) + " at x=" + (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2 + ", y=" + (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2 + ", z=" + (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2 + " with town center: " + start.getClass().toString().substring(start.getClass().toString().indexOf("$") + 1) + " and coordBaseMode: " + this.func_186165_e() + ", horiz index: " + this.func_186165_e().func_176736_b());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            if (this.func_186165_e().func_176736_b() % 2 != 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.EAST, this.func_74877_c());
            }
            if (this.func_186165_e().func_176736_b() % 2 == 0) {
                StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a + 3, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 3, EnumFacing.WEST, this.func_74877_c());
            int strucX = 0;
            int strucZ = 0;
            EnumFacing coordBaseMode = EnumFacing.SOUTH;
            if (this.func_186165_e().func_176736_b() % 2 == 0) {
                strucX = this.field_74887_e.field_78893_d + 1;
                strucZ = this.field_74887_e.field_78896_c + random.nextInt(3) + 1;
                coordBaseMode = EnumFacing.EAST;
            } else {
                strucX = this.field_74887_e.field_78897_a + random.nextInt(3) + 1;
                strucZ = this.field_74887_e.field_78892_f + 1;
                coordBaseMode = EnumFacing.SOUTH;
            }
            StructureVillageVN.getNextVillageStructureComponent((StructureVillageVN.StartVN)start, components, random, strucX, this.field_74887_e.field_78895_b, strucZ, coordBaseMode, this.func_74877_c());
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            if (this.field_143015_k < 0 && this.field_143015_k < 0) {
                this.field_143015_k = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)7, this.func_186165_e().func_176736_b());
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78895_b - 1, 0);
            }
            IBlockState biomeStandingSignState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150472_an.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeSmoothSandstoneState = StructureVillageVN.getBiomeSpecificBlockState(ModObjects.chooseModSmoothSandstoneBlockState(false), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState;
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            for (int u = 0; u < STRUCTURE_WIDTH; ++u) {
                for (int w = 0; w < STRUCTURE_DEPTH; ++w) {
                    this.func_74871_b(world, u, 1, w, structureBB);
                }
            }
            for (int w = 0; w < foundationPattern.length; ++w) {
                for (int u = 0; u < foundationPattern[0].length(); ++u) {
                    String unitLetter = foundationPattern[foundationPattern.length - 1 - w].substring(u, u + 1).toUpperCase();
                    int posX = this.func_74865_a(u, w);
                    int posY = this.func_74862_a(0);
                    int posZ = this.func_74873_b(u, w);
                    if (unitLetter.equals("F")) {
                        this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                        continue;
                    }
                    if (unitLetter.equals("P")) {
                        this.func_175808_b(world, biomeFillerState, u, 0 + (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_185915_l() ? -1 : 0), w, structureBB);
                        StructureVillageVN.setPathSpecificBlock(world, this.materialType, this.biome, this.disallowModSubs, posX, posY, posZ, false);
                        continue;
                    }
                    if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() != biomeFillerState.func_177230_c()) continue;
                    this.func_175808_b(world, biomeFillerState, u, 0, w, structureBB);
                    this.func_175811_a(world, biomeTopState, u, 0, w, structureBB);
                }
            }
            NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, this.func_74865_a(6, 4), this.func_74862_a(2), this.func_74873_b(6, 4));
            if (this.townColor == -1) {
                this.townColor = villageNBTtag.func_74762_e("townColor");
            }
            if (this.townColor2 == -1) {
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
            }
            if (this.townColor3 == -1) {
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
            }
            if (this.townColor4 == -1) {
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
            }
            if (this.townColor5 == -1) {
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
            }
            if (this.townColor6 == -1) {
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
            }
            if (this.townColor7 == -1) {
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
            }
            if (this.namePrefix.equals("")) {
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
            }
            if (this.nameRoot.equals("")) {
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
            }
            if (this.nameSuffix.equals("")) {
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
            }
            BiomeProvider biomeProvider = world.func_72959_q();
            int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
            int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
            Biome biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            if (this.villageType == null || this.materialType == null) {
                try {
                    String string = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = string.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(string, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception exception) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
                }
                try {
                    String string = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = string.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(string, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception exception) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
                }
                try {
                    String string = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = string.toLowerCase().trim().equals("nosub");
                }
                catch (Exception exception) {
                    this.disallowModSubs = false;
                }
            }
            this.func_175804_a(world, structureBB, 3, 0, 0, 9, 0, 8, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 1, 0, 1, 2, 0, 7, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            this.func_175804_a(world, structureBB, 0, 0, 3, 0, 0, 5, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
            if (GeneralConfig.useVillageColors) {
                IBlockState iBlockState = Blocks.field_192443_dR.func_176203_a(this.townColor);
                this.func_175804_a(world, structureBB, 2, 1, 2, 6, 1, 6, iBlockState, iBlockState, false);
            } else {
                this.func_175804_a(world, structureBB, 2, 1, 2, 6, 1, 6, biomeLogVertState, biomeLogVertState, false);
            }
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 2, structureBB);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 2, 1, 6, structureBB);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 1, 6, structureBB);
            this.func_175811_a(world, Blocks.field_150350_a.func_176223_P(), 6, 1, 2, structureBB);
            this.func_175804_a(world, structureBB, 3, 0, 2, 5, 0, 2, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 0, 6, 5, 0, 6, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 2, 0, 3, 2, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 6, 0, 3, 6, 0, 5, biomeDirtState, biomeDirtState, false);
            this.func_175804_a(world, structureBB, 3, 1, 3, 5, 1, 5, Blocks.field_150358_i.func_176223_P(), Blocks.field_150358_i.func_176223_P(), false);
            this.func_175804_a(world, structureBB, 4, 1, 4, 4, 3, 4, biomeLogVertState, biomeLogVertState, false);
            if (GeneralConfig.useVillageColors) {
                this.func_175811_a(world, Blocks.field_150406_ce.func_176203_a(this.townColor2), 4, 4, 4, structureBB);
            } else {
                this.func_175811_a(world, Blocks.field_150405_ch.func_176223_P(), 4, 4, 4, structureBB);
            }
            for (int[] uvwo : new int[][]{{4, 5, 4, -1}}) {
                this.func_175811_a(world, Blocks.field_150478_aa.func_176203_a(StructureVillageVN.getTorchRotationMeta(uvwo[3])), uvwo[0], uvwo[1], uvwo[2], structureBB);
            }
            int n = 5;
            int tileV = 2;
            int tileW = 2;
            BlockPos potPos = new BlockPos(this.func_74865_a(n, tileW), this.func_74862_a(tileV), this.func_74873_b(n, tileW));
            TileEntity flowerPotWithCactus = new BlockFlowerPot().func_149915_a(world, 9);
            world.func_180501_a(potPos, Blocks.field_150457_bL.func_176223_P(), 2);
            world.func_175690_a(potPos, flowerPotWithCactus);
            if (GeneralConfig.nameSign) {
                int signXBB = 6;
                int signYBB = 2;
                int signZBB = 4;
                int signX = this.func_74865_a(signXBB, signZBB);
                int signY = this.func_74862_a(signYBB);
                int signZ = this.func_74873_b(signXBB, signZBB);
                TileEntitySign signContents = StructureVillageVN.generateSignContents(this.namePrefix, this.nameRoot, this.nameSuffix);
                world.func_180501_a(new BlockPos(signX, signY, signZ), biomeStandingSignState.func_177230_c().func_176203_a(StructureVillageVN.getSignRotationMeta(4, this.func_186165_e().func_176736_b(), false)), 2);
                world.func_175690_a(new BlockPos(signX, signY, signZ), (TileEntity)signContents);
            }
            if (GeneralConfig.villageBanners) {
                int bannerXBB = 7;
                int bannerZBB = 1;
                int bannerYBB = 1;
                int bannerX = this.func_74865_a(bannerXBB, bannerZBB);
                int bannerY = this.func_74862_a(bannerYBB);
                int bannerZ = this.func_74873_b(bannerXBB, bannerZBB);
                this.func_175804_a(world, structureBB, bannerXBB, bannerYBB - 2, bannerZBB, bannerXBB, bannerYBB - 1, bannerZBB, biomeSmoothSandstoneState, biomeSmoothSandstoneState, false);
                this.func_175808_b(world, biomeSmoothSandstoneState, bannerXBB, bannerYBB - 3, bannerZBB, structureBB);
                BlockPos bannerPos = new BlockPos(bannerX, bannerY, bannerZ);
                world.func_175656_a(bannerPos, Blocks.field_180393_cK.func_176203_a(StructureVillageVN.getSignRotationMeta(8, this.func_186165_e().func_176736_b(), false)));
                TileEntityBanner tilebanner = new TileEntityBanner();
                ItemStack villageBanner = BannerGenerator.makeBanner(villageNBTtag.func_74775_l("BlockEntityTag"), (this.namePrefix + " " + this.nameRoot + " " + this.nameSuffix).trim());
                tilebanner.func_175112_a(villageBanner, false);
                world.func_175690_a(bannerPos, (TileEntity)tilebanner);
            }
            if (!this.villagersGenerated) {
                this.villagersGenerated = true;
                if (VillageGeneratorConfigHandler.spawnVillagersInTownCenters) {
                    for (int[] ia : new int[][]{{1, 1, 1, -1, 0}, {5, 1, 0, -1, 0}, {1, 1, 7, -1, 0}}) {
                        EntityVillager entityvillager = new EntityVillager(world);
                        if (random.nextInt(3) == 0) {
                            entityvillager.func_70938_b(5);
                        } else {
                            entityvillager = StructureVillageVN.makeVillagerWithProfession(world, random, ia[3], ia[4], -12000 - random.nextInt(12001));
                        }
                        entityvillager.func_70012_b((double)this.func_74865_a(ia[0], ia[2]) + 0.5, (double)this.func_74862_a(ia[1]) + 0.5, (double)this.func_74873_b(ia[0], ia[2]) + 0.5, random.nextFloat() * 360.0f, 0.0f);
                        world.func_72838_d((Entity)entityvillager);
                    }
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }
}

