/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.village;

import astrotibs.villagenames.banner.BannerGenerator;
import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.config.village.VillageGeneratorConfigHandler;
import astrotibs.villagenames.integration.ModObjects;
import astrotibs.villagenames.name.NameGenerator;
import astrotibs.villagenames.nbt.VNWorldDataStructure;
import astrotibs.villagenames.utility.FunctionsVN;
import astrotibs.villagenames.utility.LogHelper;
import astrotibs.villagenames.village.biomestructures.BlueprintData;
import astrotibs.villagenames.village.biomestructures.DesertStructures;
import astrotibs.villagenames.village.biomestructures.PlainsStructures;
import astrotibs.villagenames.village.biomestructures.SavannaStructures;
import astrotibs.villagenames.village.biomestructures.SnowyStructures;
import astrotibs.villagenames.village.biomestructures.TaigaStructures;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockPackedIce;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.village.Village;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.MapGenStructureData;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;
import net.minecraft.world.gen.structure.template.TemplateManager;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class StructureVillageVN {
    public static final int VILLAGE_RADIUS_BUFFER = 112;
    public static final int[] LADDER_META_ARRAY = new int[]{2, 5, 3, 4};
    public static final int[][] FURNACE_META_ARRAY = new int[][]{{3, 4, 2, 5}, {5, 3, 5, 3}, {2, 5, 3, 4}, {4, 2, 4, 2}};
    public static final int[] BUTTON_META_ARRAY = new int[]{4, 1, 3, 2};
    public static final int[][] BLAST_FURNACE_META_ARRAY = new int[][]{{0, 1, 2, 3}, {3, 0, 3, 0}, {2, 3, 0, 1}, {1, 2, 1, 2}};
    public static final int[][] HANGING_GRINDSTONE_META_ARRAY = new int[][]{{6, 7, 4, 5}, {5, 6, 5, 6}, {4, 5, 6, 7}, {7, 4, 7, 4}};
    public static final int[][] CARTOGRAPHY_TABLE_META_ARRAY = new int[][]{{2, 5, 3, 4}, {4, 2, 4, 2}, {3, 4, 2, 5}, {5, 3, 5, 3}};
    public static final int[][] ANVIL_META_ARRAY = new int[][]{{3, 3, 1, 1}, {2, 2, 2, 2}, {1, 1, 3, 3}, {0, 0, 0, 0}};
    public static final int[][] GLAZED_TERRACOTTA_META_ARRAY = new int[][]{{1, 2, 2, 3}, {0, 1, 3, 0}, {3, 0, 0, 1}, {2, 3, 1, 2}};
    public static final int[] DOOR_META_ARRAY = new int[]{1, 2, 3, 0};
    public static final int[][] BIBLIOCRAFT_DESK_META_ARRAY = new int[][]{{3, 0, 1, 2}, {2, 3, 2, 3}, {1, 2, 3, 0}, {0, 1, 0, 1}};
    public static final int[] FENCE_GATE_META_ARRAY = new int[]{0, 1, 2, 3};

    public static List getStructureVillageWeightedPieceList(Random random, float villageSize, FunctionsVN.VillageType villageType) {
        int upperLimitStochastic;
        double upperLimitDouble;
        int lowerLimitStochastic;
        double lowerLimitDouble;
        int weightStochastic;
        double weightDouble;
        ArrayList<Double> ald;
        ArrayList<StructureVillagePieces.PieceWeight> arraylist = new ArrayList<StructureVillagePieces.PieceWeight>();
        if (VillageGeneratorConfigHandler.componentLegacyHouse4Garden_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyHouse4Garden_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House4Garden.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyChurch_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyChurch_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Church.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyHouse1_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyHouse1_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House1.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyWoodHut_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyWoodHut_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.WoodHut.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyHall_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyHall_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Hall.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyField1_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyField1_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field1.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyField2_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyField2_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.Field2.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyHouse2_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyHouse2_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House2.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        if (VillageGeneratorConfigHandler.componentLegacyHouse3_vals.get(0) > 0.0) {
            ald = VillageGeneratorConfigHandler.componentLegacyHouse3_vals;
            weightDouble = ald.get(0);
            weightStochastic = MathHelper.func_76128_c((double)weightDouble) + (random.nextDouble() < weightDouble % 1.0 ? 1 : 0);
            lowerLimitDouble = (double)villageSize * ald.get(1) + ald.get(2);
            lowerLimitStochastic = MathHelper.func_76128_c((double)lowerLimitDouble) + (random.nextDouble() < lowerLimitDouble % 1.0 ? 1 : 0);
            upperLimitDouble = (double)villageSize * ald.get(3) + ald.get(4);
            upperLimitStochastic = MathHelper.func_76128_c((double)upperLimitDouble) + (random.nextDouble() < upperLimitDouble % 1.0 ? 1 : 0);
            arraylist.add(new StructureVillagePieces.PieceWeight(StructureVillagePieces.House3.class, weightStochastic, MathHelper.func_76136_a((Random)random, (int)lowerLimitStochastic, (int)upperLimitStochastic)));
        }
        VillagerRegistry.addExtraVillageComponents(arraylist, (Random)random, (int)(Math.floor(villageSize) + (double)(villageSize % 1.0f) < (double)random.nextFloat() ? 1 : 0));
        ArrayList classPaths = new ArrayList();
        ArrayList villageTypes = new ArrayList();
        Map<String, ArrayList> mappedComponentVillageTypes = VillageGeneratorConfigHandler.unpackComponentVillageTypes(VillageGeneratorConfigHandler.componentVillageTypes);
        classPaths.addAll(mappedComponentVillageTypes.get("ClassPaths"));
        villageTypes.addAll(mappedComponentVillageTypes.get("VillageTypes"));
        Iterator iterator = arraylist.iterator();
        while (iterator.hasNext()) {
            int classPathListIndex;
            StructureVillagePieces.PieceWeight pw = (StructureVillagePieces.PieceWeight)iterator.next();
            if (pw.field_75087_d == 0 || pw.field_75088_b <= 0) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyHouse4Garden_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$House4Garden")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyChurch_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$Church")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyHouse1_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$House1")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyWoodHut_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$WoodHut")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyHall_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$Hall")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyField1_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$Field1")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyField2_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$Field2")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyHouse2_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$House2")) {
                iterator.remove();
                continue;
            }
            if (VillageGeneratorConfigHandler.componentLegacyHouse3_vals.get(0) <= 0.0 && pw.field_75090_a.toString().substring(6).equals("net.minecraft.world.gen.structure.StructureVillagePieces$House3")) {
                iterator.remove();
                continue;
            }
            String villageTypeToCompare = "";
            switch (villageType) {
                default: {
                    villageTypeToCompare = "plains";
                    break;
                }
                case DESERT: {
                    villageTypeToCompare = "desert";
                    break;
                }
                case TAIGA: {
                    villageTypeToCompare = "taiga";
                    break;
                }
                case SAVANNA: {
                    villageTypeToCompare = "savanna";
                    break;
                }
                case SNOWY: {
                    villageTypeToCompare = "snowy";
                }
            }
            if ((classPathListIndex = mappedComponentVillageTypes.get("ClassPaths").indexOf(pw.field_75090_a.toString().substring(6))) == -1 || ((String)mappedComponentVillageTypes.get("VillageTypes").get(classPathListIndex)).trim().toLowerCase().contains(villageTypeToCompare)) continue;
            iterator.remove();
        }
        return arraylist;
    }

    public static StructureComponent getNextVillageStructureComponent(StartVN start, List<StructureComponent> components, Random random, int x, int y, int z, EnumFacing facing, int componentType) {
        if (componentType > 50) {
            return null;
        }
        if (Math.abs(x - start.func_74874_b().field_78897_a) <= 112 && Math.abs(z - start.func_74874_b().field_78896_c) <= 112) {
            DecorTorch structurecomponent;
            block9: {
                Method generateComponent_reflected = ReflectionHelper.findMethod(StructureVillagePieces.class, (String)"generateComponent", (String)"func_176067_c", (Class[])new Class[]{StructureVillagePieces.Start.class, List.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class, Integer.TYPE});
                structurecomponent = null;
                try {
                    structurecomponent = (StructureVillagePieces.Village)generateComponent_reflected.invoke((Object)start, new Object[]{start, components, random, x, y, z, facing, componentType + 1});
                }
                catch (Exception e) {
                    if (!GeneralConfig.debugMessages) break block9;
                    LogHelper.warn("Could not invoke StructureVillagePieces.generateComponent method");
                }
            }
            if (structurecomponent != null) {
                if (structurecomponent instanceof StructureVillagePieces.Torch) {
                    StructureBoundingBox decorTorchBB = DecorTorch.findPieceBox(start, components, random, x, y, z, facing);
                    if (decorTorchBB == null) {
                        return null;
                    }
                    structurecomponent = new DecorTorch(start, componentType, random, decorTorchBB, facing);
                }
                int medianX = (structurecomponent.func_74874_b().field_78897_a + structurecomponent.func_74874_b().field_78893_d) / 2;
                int medianZ = (structurecomponent.func_74874_b().field_78896_c + structurecomponent.func_74874_b().field_78892_f) / 2;
                int rangeX = structurecomponent.func_74874_b().field_78893_d - structurecomponent.func_74874_b().field_78897_a;
                int rangeZ = structurecomponent.func_74874_b().field_78892_f - structurecomponent.func_74874_b().field_78896_c;
                int bboxWidth = rangeX > rangeZ ? rangeX : rangeZ;
                Biome biome = start.field_74929_a.func_180631_a(new BlockPos(medianX, 0, medianZ));
                if (VillageGeneratorConfigHandler.spawnBiomesNames != null) {
                    Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
                    for (int i = 0; i < mappedBiomes.get("BiomeNames").size(); ++i) {
                        if (!mappedBiomes.get("BiomeNames").get(i).equals((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"}))) continue;
                        BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
                        components.add((StructureComponent)structurecomponent);
                        start.field_74932_i.add(structurecomponent);
                        return structurecomponent;
                    }
                }
            }
            return null;
        }
        return null;
    }

    public static StructureBoundingBox findPieceBox(StructureVillagePieces.Start start, List<StructureComponent> components, Random random, int x, int y, int z, EnumFacing coordBaseMode) {
        for (int i = 7 * MathHelper.func_76136_a((Random)random, (int)3, (int)5); i >= 7; i -= 7) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)3, (int)i, (EnumFacing)coordBaseMode);
            if (StructureComponent.func_74883_a(components, (StructureBoundingBox)structureboundingbox) != null) continue;
            return structureboundingbox;
        }
        return null;
    }

    public static StructureComponent generateAndAddRoadPiece(StructureVillagePieces.Start start, List<StructureComponent> components, Random rand, int x, int y, int z, EnumFacing facing, int componentType) {
        if (componentType > 3 + start.field_74928_c) {
            return null;
        }
        if (Math.abs(x - start.func_74874_b().field_78897_a) <= 112 && Math.abs(z - start.func_74874_b().field_78896_c) <= 112) {
            StructureBoundingBox structureboundingbox = StructureVillagePieces.Path.func_175848_a((StructureVillagePieces.Start)start, components, (Random)rand, (int)x, (int)y, (int)z, (EnumFacing)facing);
            if (structureboundingbox != null && structureboundingbox.field_78895_b > 10) {
                PathVN path = new PathVN(start, componentType, rand, structureboundingbox, facing);
                int medianX = (path.func_74874_b().field_78897_a + path.func_74874_b().field_78893_d) / 2;
                int medianZ = (path.func_74874_b().field_78896_c + path.func_74874_b().field_78892_f) / 2;
                int rangeX = path.func_74874_b().field_78893_d - path.func_74874_b().field_78897_a;
                int rangeZ = path.func_74874_b().field_78892_f - path.func_74874_b().field_78896_c;
                int bboxWidth = rangeX > rangeZ ? rangeX : rangeZ;
                Biome biome = start.field_74929_a.func_180631_a(new BlockPos(medianX, 0, medianZ));
                if (VillageGeneratorConfigHandler.spawnBiomesNames != null) {
                    Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
                    for (int i = 0; i < mappedBiomes.get("BiomeNames").size(); ++i) {
                        if (!mappedBiomes.get("BiomeNames").get(i).equals((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"}))) continue;
                        BiomeManager.addVillageBiome((Biome)biome, (boolean)true);
                        components.add((StructureComponent)path);
                        start.field_74930_j.add(path);
                        return path;
                    }
                }
            }
            return null;
        }
        return null;
    }

    public static BlockPos getAboveTopmostSolidOrLiquidBlockVN(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), chunk.func_76625_h() + 16, pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0) {
            BlockPos blockpos1 = blockpos.func_177977_b();
            IBlockState blockstate = chunk.func_177435_g(blockpos1);
            Block block = blockstate.func_177230_c();
            Material material = blockstate.func_185904_a();
            if (material.func_76230_c() && !block.isLeaves(world.func_180495_p(blockpos1), (IBlockAccess)world, blockpos1) && material != Material.field_151584_j && material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151579_a && !block.isFoliage((IBlockAccess)world, blockpos1) && blockstate.func_185915_l() || material.func_76224_d()) break;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    public static int getMedianGroundLevel(World world, StructureBoundingBox boundingBox, boolean outlineOnly, byte sideFlag, int horizIndex) {
        ArrayList<Integer> i = new ArrayList<Integer>();
        for (int k = boundingBox.field_78896_c; k <= boundingBox.field_78892_f; ++k) {
            for (int l = boundingBox.field_78897_a; l <= boundingBox.field_78893_d; ++l) {
                int aboveTopLevel;
                if (!boundingBox.func_175898_b((Vec3i)new BlockPos(l, 64, k)) || outlineOnly && (!outlineOnly || !(k == boundingBox.field_78896_c && (sideFlag & (new int[]{1, 2, 4, 2})[horizIndex]) > 0 || k == boundingBox.field_78892_f && (sideFlag & (new int[]{4, 8, 1, 8})[horizIndex]) > 0 || l == boundingBox.field_78897_a && (sideFlag & (new int[]{2, 4, 2, 1})[horizIndex]) > 0) && (l != boundingBox.field_78893_d || (sideFlag & (new int[]{8, 1, 8, 4})[horizIndex]) <= 0)) || (aboveTopLevel = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(l, 64, k)).func_177956_o()) == -1) continue;
                i.add(aboveTopLevel);
            }
        }
        return FunctionsVN.medianIntArray(i, true);
    }

    public static IBlockState getBiomeSpecificBlockState(IBlockState blockstate, FunctionsVN.MaterialType materialType, Biome biome, boolean disallowModSubs) {
        if (materialType == null || biome == null) {
            return blockstate;
        }
        Block block = blockstate.func_177230_c();
        int meta = block.func_176201_c(blockstate);
        int woodMeta = 0;
        switch (materialType) {
            default: {
                woodMeta = BlockPlanks.EnumType.OAK.func_176839_a();
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180407_aO.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case SPRUCE: {
                woodMeta = BlockPlanks.EnumType.SPRUCE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180408_aP.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180391_bp.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150485_bF.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180414_ap.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:sprucewood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180408_aP.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case BIRCH: {
                woodMeta = BlockPlanks.EnumType.BIRCH.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180404_aQ.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180392_bq.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150487_bG.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180412_aq.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:birchwood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180404_aQ.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case JUNGLE: {
                woodMeta = BlockPlanks.EnumType.JUNGLE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150341_Y.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150463_bK) {
                    blockstate = Blocks.field_150463_bK.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180403_aR.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180386_br.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150481_bH.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180411_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:junglewood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180403_aR.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case ACACIA: {
                woodMeta = BlockPlanks.EnumType.ACACIA.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150363_s.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180405_aT.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180387_bt.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150400_ck.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180410_as.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:acaciawood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180405_aT.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case DARK_OAK: {
                woodMeta = BlockPlanks.EnumType.DARK_OAK.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150363_s.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180406_aS.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180385_bs.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150401_cl.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180409_at.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:darkoakwood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150347_e.func_176203_a(3);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_180406_aS.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150345_g.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150417_aV.func_176223_P();
                break;
            }
            case SAND: {
                IBlockState tryBlockstate;
                woodMeta = BlockPlanks.EnumType.JUNGLE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == Blocks.field_150417_aV && meta == 0) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == Blocks.field_150347_e && meta == 3) {
                    blockstate = Blocks.field_150347_e.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180403_aR.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180387_bt || block == Blocks.field_180392_bq || block == Blocks.field_180385_bs || block == Blocks.field_180386_br || block == Blocks.field_180390_bo || block == Blocks.field_180391_bp) {
                    blockstate = Blocks.field_180386_br.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150481_bH.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150446_ar) {
                    blockstate = Blocks.field_150372_bz.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150463_bK) {
                    tryBlockstate = ModObjects.chooseModSandstoneWall(false);
                    if (tryBlockstate == null) break;
                    blockstate = tryBlockstate;
                    break;
                }
                if (block == Blocks.field_150351_n) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150346_d) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150349_c) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180411_ar.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 3 ? 1 : (meta == 11 ? 9 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:junglewood"))) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150330_I.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150354_m.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150322_A.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150322_A.func_176203_a(2);
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150322_A.func_176203_a(2);
                break;
            }
            case MESA: {
                IBlockState tryBlockstate;
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150446_ar) {
                    blockstate = Blocks.field_150389_bf.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150351_n) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150354_m) {
                    blockstate = Blocks.field_150354_m.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150463_bK) {
                    tryBlockstate = ModObjects.chooseModSandstoneWall(true);
                    if (tryBlockstate == null) break;
                    blockstate = tryBlockstate;
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_180395_cM.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150333_U) {
                    blockstate = Blocks.field_180389_cP.func_176203_a(meta >= 8 ? 8 : 0);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_180396_cN.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    block = Block.func_149684_b((String)"quark:red_sandstone_smooth_slab");
                    if (block == null) {
                        blockstate = Blocks.field_180389_cP.func_176203_a(meta);
                        break;
                    }
                    return block.func_176203_a(meta);
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150329_H.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150354_m.func_176203_a(1);
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150405_ch.func_176223_P();
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150405_ch.func_176223_P();
                break;
            }
            case SNOW: {
                woodMeta = BlockPlanks.EnumType.SPRUCE.func_176839_a();
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150364_r.func_176203_a(woodMeta % 4);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180407_aO) {
                    blockstate = Blocks.field_180408_aP.func_176223_P();
                    break;
                }
                if (block == Blocks.field_180390_bo) {
                    blockstate = Blocks.field_180391_bp.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150476_ad) {
                    blockstate = Blocks.field_150485_bF.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150376_bx) {
                    blockstate = Blocks.field_150376_bx.func_176203_a(meta == 0 ? 0 + woodMeta : (meta == 8 ? 8 + woodMeta : meta));
                    break;
                }
                if (block == Blocks.field_150373_bw) {
                    blockstate = Blocks.field_150373_bw.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_180410_as || block == Blocks.field_180412_aq || block == Blocks.field_180409_at || block == Blocks.field_180411_ar || block == Blocks.field_180413_ao || block == Blocks.field_180414_ap) {
                    blockstate = Blocks.field_180414_ap.func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150471_bO) {
                    blockstate = ModObjects.chooseWoodenButton(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150452_aw) {
                    blockstate = ModObjects.chooseModPressurePlate(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150415_aT) {
                    blockstate = ModObjects.chooseModWoodenTrapdoor(woodMeta).func_176203_a(meta);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:bark") || block == Block.func_149684_b((String)"futureminecraf:sprucewood"))) {
                    blockstate = block.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150347_e.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"quark:sandstone_wall") && block != Block.func_149684_b((String)"futuremc:sandstone_wall")) break;
                blockstate = Blocks.field_180408_aP.func_176223_P();
                break;
            }
            case MUSHROOM: {
                if (block == Blocks.field_150364_r || block == Blocks.field_150363_s) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(15);
                    break;
                }
                if (block == Blocks.field_150347_e) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150341_Y) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150344_f) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150347_e && meta == 3) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150417_aV) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 2) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A && meta == 1) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150322_A) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == Blocks.field_150333_U || block != null && (block == Block.func_149684_b((String)"quark:sandstone_smooth_slab") || block == Block.func_149684_b((String)"quark:red_sandstone_smooth_slab"))) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 1 ? 3 : (meta == 9 ? 11 : meta));
                    break;
                }
                if (block == Blocks.field_150334_T && meta == 9 || block != null && (block == Block.func_149684_b((String)"futuremc:smooth_sandstone") || block == Block.func_149684_b((String)"futuremc:smooth_sandstone"))) {
                    blockstate = Blocks.field_150344_f.func_176203_a(woodMeta);
                    break;
                }
                if (block == Blocks.field_150334_T) {
                    blockstate = Blocks.field_150334_T.func_176203_a(meta == 1 ? 0 : meta);
                    break;
                }
                if (block == Blocks.field_150372_bz) {
                    blockstate = Blocks.field_150446_ar.func_176203_a(meta);
                    break;
                }
                if (block != null && block == Block.func_149684_b((String)"quark:sandstone_smooth_slab")) {
                    blockstate = Blocks.field_150333_U.func_176203_a(meta == 8 ? 11 : (meta == 0 ? 3 : meta));
                    break;
                }
                if (block != null && (block == Block.func_149684_b((String)"quark:sandstone_wall") || block == Block.func_149684_b((String)"futuremc:sandstone_wall"))) {
                    blockstate = Blocks.field_150463_bK.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150345_g) {
                    blockstate = Blocks.field_150338_P.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150349_c) {
                    blockstate = Blocks.field_150391_bh.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150433_aE) {
                    blockstate = Blocks.field_150346_d.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150431_aC) {
                    blockstate = Blocks.field_150350_a.func_176223_P();
                    break;
                }
                if (block == Blocks.field_150432_aD) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(0);
                    break;
                }
                if (block == Blocks.field_150403_cj) {
                    blockstate = Blocks.field_150420_aW.func_176203_a(14);
                    break;
                }
                if (block == null || block != Block.func_149684_b((String)"futuremc:blue_ice")) break;
                blockstate = Blocks.field_150420_aW.func_176203_a(14);
            }
        }
        if (!disallowModSubs) {
            BiomeEvent.GetVillageBlockID villageBlockEvent = new BiomeEvent.GetVillageBlockID(biome == null ? null : biome, block.func_176203_a(meta));
            MinecraftForge.TERRAIN_GEN_BUS.post((Event)villageBlockEvent);
            if (villageBlockEvent.getResult() == Event.Result.DENY) {
                return villageBlockEvent.getReplacement();
            }
        }
        return blockstate;
    }

    public static int getSignRotationMeta(int relativeOrientation, int coordBaseMode, boolean isHangingOnWall) {
        if (isHangingOnWall) {
            switch (relativeOrientation) {
                case 0: {
                    return (new int[]{3, 4, 2, 5})[coordBaseMode];
                }
                case 1: {
                    return (new int[]{5, 3, 5, 3})[coordBaseMode];
                }
                case 2: {
                    return (new int[]{2, 5, 3, 4})[coordBaseMode];
                }
                case 3: {
                    return (new int[]{4, 2, 4, 2})[coordBaseMode];
                }
            }
        } else {
            return coordBaseMode <= 1 ? ((coordBaseMode == 1 ? 24 : 16) - (relativeOrientation + coordBaseMode * 4)) % 16 : (relativeOrientation + coordBaseMode * 4) % 16;
        }
        return 0;
    }

    public static int getTorchRotationMeta(int relativeOrientation) {
        switch (relativeOrientation) {
            case 0: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    public static IBlockState getHorizontalPillarState(IBlockState blockstate, int coordBaseMode, boolean isAcross) {
        return blockstate.func_177230_c().func_176203_a(blockstate.func_177230_c().func_176201_c(blockstate) % 4 + 4 + (isAcross ? 0 : 4));
    }

    public static int setPathSpecificBlock(World world, FunctionsVN.MaterialType materialType, Biome biome, boolean disallowModSubs, int posX, int posY, int posZ, boolean searchDownward) {
        int surfaceY;
        if (materialType == null) {
            materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(world, posX, posZ);
        }
        if (biome == null) {
            biome = world.func_180494_b(new BlockPos(posX, 64, posZ));
        }
        int n = surfaceY = searchDownward ? StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, new BlockPos(posX, 64, posZ)).func_177977_b().func_177956_o() : posY;
        if (surfaceY < world.func_181545_F()) {
            surfaceY = world.func_181545_F() - 1;
        }
        do {
            BlockPos pos;
            Block surfaceBlock;
            if (((surfaceBlock = world.func_180495_p(pos = new BlockPos(posX, surfaceY, posZ)).func_177230_c()) instanceof BlockGrass || surfaceBlock instanceof BlockDirt) && world.func_175623_d(new BlockPos(posX, surfaceY, posZ).func_177984_a())) {
                IBlockState grassPath = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_185774_da.func_176223_P(), materialType, biome, disallowModSubs);
                world.func_180501_a(pos, grassPath, 2);
                return surfaceY;
            }
            if (surfaceBlock instanceof BlockSand) {
                IBlockState gravel = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150351_n.func_176223_P(), materialType, biome, disallowModSubs);
                IBlockState cobblestone = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), materialType, biome, disallowModSubs);
                world.func_180501_a(pos, gravel, 2);
                world.func_180501_a(pos.func_177977_b(), cobblestone, 2);
                return surfaceY;
            }
            if (surfaceBlock == Blocks.field_150353_l || surfaceBlock == Blocks.field_150356_k) {
                IBlockState cobblestone = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150347_e.func_176203_a(0), materialType, biome, disallowModSubs);
                world.func_180501_a(pos, cobblestone, 2);
                world.func_180501_a(pos.func_177977_b(), cobblestone, 2);
                return surfaceY;
            }
            if (!surfaceBlock.func_176223_P().func_185904_a().func_76224_d() && !(surfaceBlock instanceof BlockIce) && !(surfaceBlock instanceof BlockPackedIce) && !surfaceBlock.getClass().toString().substring(6).equals("biomesoplenty.common.block.BlockBOPMud")) continue;
            IBlockState planks = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150344_f.func_176203_a(0), materialType, biome, disallowModSubs);
            world.func_180501_a(pos, planks, 2);
            world.func_175698_g(pos.func_177984_a());
            int yDownScan = surfaceY;
            if (MathHelper.func_76130_a((int)posX) % 2 == 0 && MathHelper.func_76130_a((int)posZ) % 2 == 0) {
                IBlockState biomeLogVertState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150364_r.func_176203_a(0), materialType, biome, disallowModSubs);
                while (world.func_180495_p(new BlockPos(posX, --yDownScan, posZ)).func_185904_a().func_76224_d() && yDownScan > 0) {
                    world.func_180501_a(new BlockPos(posX, yDownScan, posZ), biomeLogVertState, 2);
                }
            }
            return surfaceY;
        } while (--surfaceY >= world.func_181545_F() - 1);
        return -1;
    }

    public static StructureBoundingBox contractBB(StructureBoundingBox structureBoundingBox, int xAmount, int yAmount, int zAmount) {
        return new StructureBoundingBox(structureBoundingBox.field_78897_a + MathHelper.func_76130_a((int)xAmount), structureBoundingBox.field_78895_b + MathHelper.func_76130_a((int)yAmount), structureBoundingBox.field_78896_c + MathHelper.func_76130_a((int)zAmount), structureBoundingBox.field_78893_d - MathHelper.func_76130_a((int)xAmount), structureBoundingBox.field_78894_e - MathHelper.func_76130_a((int)yAmount), structureBoundingBox.field_78892_f - MathHelper.func_76130_a((int)zAmount));
    }

    public static StructureBoundingBox contractBB(StructureBoundingBox structureBoundingBox, int xAmount, int zAmount) {
        return StructureVillageVN.contractBB(structureBoundingBox, xAmount, 0, zAmount);
    }

    public static StructureBoundingBox contractBB(StructureBoundingBox structureBoundingBox, int amount) {
        return StructureVillageVN.contractBB(structureBoundingBox, amount, amount, amount);
    }

    public static NBTTagCompound getOrMakeVNInfo(World world, int posX, int posY, int posZ) {
        return StructureVillageVN.getOrMakeVNInfo(world, new BlockPos(posX, posY, posZ));
    }

    public static NBTTagCompound getOrMakeVNInfo(World world, BlockPos pos) {
        int i;
        MapGenStructureData structureData;
        NBTTagCompound bannerNBT;
        String nameSuffix;
        String nameRoot;
        String namePrefix;
        int townZ;
        int townY;
        int townX;
        int townColorMeta;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        String townSignEntry = "";
        NBTTagCompound villagetagcompound = new NBTTagCompound();
        Random randomFromXYZ = new Random();
        randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        try {
            Village villageNearTarget = world.field_72982_D.func_176056_a(pos, 112);
            if (villageNearTarget != null) {
                int villageRadius = villageNearTarget.func_75568_b();
                int popSize = villageNearTarget.func_75562_e();
                int centerX = villageNearTarget.func_180608_a().func_177958_n();
                int centerY = villageNearTarget.func_180608_a().func_177956_o();
                int centerZ = villageNearTarget.func_180608_a().func_177952_p();
                VNWorldDataStructure data = VNWorldDataStructure.forWorld(world, "villagenames3_Village", "NamedStructures");
                NBTTagCompound tagCompound = data.getData();
                Set tagmapKeyset = tagCompound.func_150296_c();
                Iterator itr = tagmapKeyset.iterator();
                boolean signLocated = false;
                boolean isColony = false;
                while (itr.hasNext()) {
                    int i2;
                    Object element = itr.next();
                    townSignEntry = element.toString();
                    NBTTagList nbttaglist = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a());
                    villagetagcompound = nbttaglist.func_150305_b(0);
                    townColorMeta = villagetagcompound.func_74762_e("townColor");
                    townX = villagetagcompound.func_74762_e("signX");
                    townY = villagetagcompound.func_74762_e("signY");
                    townZ = villagetagcompound.func_74762_e("signZ");
                    namePrefix = villagetagcompound.func_74779_i("namePrefix");
                    nameRoot = villagetagcompound.func_74779_i("nameRoot");
                    nameSuffix = villagetagcompound.func_74779_i("nameSuffix");
                    boolean updateTownNBT = false;
                    int[] townColorArray = new int[]{townColorMeta, -1, -1, -1, -1, -1, -1};
                    if (villagetagcompound.func_150297_b("BlockEntityTag", 10) && (bannerNBT = villagetagcompound.func_74775_l("BlockEntityTag")).func_150297_b("Patterns", 9)) {
                        NBTTagList nbttaglistPattern = bannerNBT.func_150295_c("Patterns", 9);
                        ArrayList<Integer> colorSet = new ArrayList<Integer>();
                        colorSet.add(townColorMeta);
                        for (i2 = 0; i2 < nbttaglistPattern.func_74745_c(); ++i2) {
                            NBTTagCompound patterntag = nbttaglistPattern.func_150305_b(i2);
                            if (!patterntag.func_74764_b("Color")) continue;
                            int candidateColor = patterntag.func_74762_e("Color");
                            boolean matchFound = false;
                            for (int j = 0; j < colorSet.size(); ++j) {
                                if (candidateColor != (Integer)colorSet.get(j)) continue;
                                matchFound = true;
                                break;
                            }
                            if (matchFound) continue;
                            colorSet.add(candidateColor);
                        }
                        for (i2 = 1; i2 < colorSet.size(); ++i2) {
                            townColorArray[i2] = 15 - (Integer)colorSet.get(i2);
                        }
                    }
                    for (int c = 1; c < townColorArray.length; ++c) {
                        if (villagetagcompound.func_74764_b("townColor" + (c + 1))) {
                            townColorArray[c] = villagetagcompound.func_74762_e("townColor" + (c + 1));
                        } else if (townColorArray[c] == -1) {
                            boolean isRedundant;
                            block11: do {
                                townColorArray[c] = (Integer)FunctionsVN.weightedRandom(BannerGenerator.colorMeta, BannerGenerator.colorWeights, randomFromXYZ);
                                isRedundant = false;
                                for (i2 = 0; i2 < c; ++i2) {
                                    if (townColorArray[c] != townColorArray[i2]) continue;
                                    isRedundant = true;
                                    continue block11;
                                }
                            } while (isRedundant);
                        }
                        if (villagetagcompound.func_74764_b("townColor" + (c + 1))) continue;
                        updateTownNBT = true;
                        villagetagcompound.func_74768_a("townColor" + (c + 1), townColorArray[c]);
                    }
                    if (!villagetagcompound.func_74764_b("villageType")) {
                        villagetagcompound.func_74778_a("villageType", FunctionsVN.VillageType.getVillageTypeFromBiome(world, posX, posZ).toString());
                    }
                    if (!villagetagcompound.func_74764_b("materialType")) {
                        villagetagcompound.func_74778_a("materialType", FunctionsVN.MaterialType.getMaterialTemplateForBiome(world, posX, posZ).toString());
                    }
                    if (updateTownNBT) {
                        nbttaglist.func_150304_a(0, (NBTBase)villagetagcompound);
                        tagCompound.func_74782_a(townSignEntry, (NBTBase)nbttaglist);
                        data.func_76185_a();
                    }
                    Village villageNearSign = world.field_72982_D.func_176056_a(new BlockPos(townX, townY, townZ), 112);
                    isColony = villagetagcompound.func_74767_n("isColony");
                    if (villageNearSign != villageNearTarget) continue;
                    signLocated = true;
                    return villagetagcompound;
                }
            }
        }
        catch (Exception villageNearTarget) {
            // empty catch block
        }
        VNWorldDataStructure data = VNWorldDataStructure.forWorld(world, "villagenames3_Village", "NamedStructures");
        NBTTagCompound tagCompound = data.getData();
        Set tagmapKeyset = tagCompound.func_150296_c();
        NBTTagList nbttaglist = null;
        villagetagcompound = null;
        NBTTagCompound villageToCompare = null;
        float bestSquareDistance = Float.MAX_VALUE;
        for (Object element : tagmapKeyset) {
            townSignEntry = element.toString();
            nbttaglist = tagCompound.func_150295_c(townSignEntry, (int)tagCompound.func_74732_a());
            villageToCompare = nbttaglist.func_150305_b(0);
            townX = villageToCompare.func_74764_b("signX") ? villageToCompare.func_74762_e("signX") : 0;
            townY = villageToCompare.func_74764_b("signY") ? villageToCompare.func_74762_e("signY") : 0;
            int n = villageToCompare.func_74764_b("signZ") ? villageToCompare.func_74762_e("signZ") : 0;
            townZ = n;
            float squareDistanceToVNVillage = (posX - townX) * (posX - townX) + (posY - townY) * (posY - townY) + (posZ - townZ) * (posZ - townZ);
            if (!(squareDistanceToVNVillage < bestSquareDistance) || !(squareDistanceToVNVillage <= 12544.0f)) continue;
            villagetagcompound = villageToCompare;
            bestSquareDistance = squareDistanceToVNVillage;
        }
        if (villagetagcompound != null) {
            int i3;
            townColorMeta = villagetagcompound.func_74762_e("townColor");
            namePrefix = villagetagcompound.func_74779_i("namePrefix");
            nameRoot = villagetagcompound.func_74779_i("nameRoot");
            nameSuffix = villagetagcompound.func_74779_i("nameSuffix");
            boolean updateTownNBT = false;
            int[] townColorArray = new int[]{townColorMeta, -1, -1, -1, -1, -1, -1};
            if (villagetagcompound.func_150297_b("BlockEntityTag", 10) && (bannerNBT = villagetagcompound.func_74775_l("BlockEntityTag")).func_150297_b("Patterns", 9)) {
                NBTTagList nbttaglistPattern = bannerNBT.func_150295_c("Patterns", 9);
                ArrayList<Integer> colorSet = new ArrayList<Integer>();
                colorSet.add(townColorMeta);
                for (i3 = 0; i3 < nbttaglistPattern.func_74745_c(); ++i3) {
                    NBTTagCompound patterntag = nbttaglistPattern.func_150305_b(i3);
                    if (!patterntag.func_74764_b("Color")) continue;
                    int candidateColor = patterntag.func_74762_e("Color");
                    boolean matchFound = false;
                    for (int j = 0; j < colorSet.size(); ++j) {
                        if (candidateColor != (Integer)colorSet.get(j)) continue;
                        matchFound = true;
                        break;
                    }
                    if (matchFound) continue;
                    colorSet.add(candidateColor);
                }
                for (i3 = 1; i3 < colorSet.size(); ++i3) {
                    townColorArray[i3] = 15 - (Integer)colorSet.get(i3);
                }
            }
            for (int c = 1; c < townColorArray.length; ++c) {
                if (villagetagcompound.func_74764_b("townColor" + (c + 1))) {
                    townColorArray[c] = villagetagcompound.func_74762_e("townColor" + (c + 1));
                } else if (townColorArray[c] == -1) {
                    boolean isRedundant;
                    block18: do {
                        townColorArray[c] = (Integer)FunctionsVN.weightedRandom(BannerGenerator.colorMeta, BannerGenerator.colorWeights, randomFromXYZ);
                        isRedundant = false;
                        for (i3 = 0; i3 < c; ++i3) {
                            if (townColorArray[c] != townColorArray[i3]) continue;
                            isRedundant = true;
                            continue block18;
                        }
                    } while (isRedundant);
                }
                if (villagetagcompound.func_74764_b("townColor" + (c + 1))) continue;
                updateTownNBT = true;
                villagetagcompound.func_74768_a("townColor" + (c + 1), townColorArray[c]);
            }
            if (!villagetagcompound.func_74764_b("villageType")) {
                villagetagcompound.func_74778_a("villageType", FunctionsVN.VillageType.getVillageTypeFromBiome(world, posX, posZ).toString());
            }
            if (!villagetagcompound.func_74764_b("materialType")) {
                villagetagcompound.func_74778_a("materialType", FunctionsVN.MaterialType.getMaterialTemplateForBiome(world, posX, posZ).toString());
            }
            if (updateTownNBT) {
                nbttaglist.func_150304_a(0, (NBTBase)villagetagcompound);
                tagCompound.func_74782_a(townSignEntry, (NBTBase)nbttaglist);
                data.func_76185_a();
            }
            return villagetagcompound;
        }
        villagetagcompound = new NBTTagCompound();
        NBTTagCompound nbttagcompound = null;
        int villageArea = -1;
        try {
            structureData = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "Village");
            nbttagcompound = structureData.func_143041_a();
        }
        catch (Exception e) {
            try {
                structureData = (MapGenStructureData)world.getPerWorldStorage().func_75742_a(MapGenStructureData.class, "OTGVillage");
                nbttagcompound = structureData.func_143041_a();
            }
            catch (Exception i4) {
                // empty catch block
            }
        }
        int topLineRand = randomFromXYZ.nextInt(4);
        String[] newVillageName = NameGenerator.newRandomName("Village", randomFromXYZ);
        String headerTags = newVillageName[0];
        namePrefix = newVillageName[1];
        nameRoot = newVillageName[2];
        nameSuffix = newVillageName[3];
        villagetagcompound.func_74778_a("namePrefix", namePrefix);
        villagetagcompound.func_74778_a("nameRoot", nameRoot);
        villagetagcompound.func_74778_a("nameSuffix", nameSuffix);
        Object[] newRandomBanner = BannerGenerator.randomBannerArrays(randomFromXYZ, -1, -1);
        ArrayList patternArray = (ArrayList)newRandomBanner[0];
        ArrayList colorArray = (ArrayList)newRandomBanner[1];
        ItemStack villageBanner = BannerGenerator.makeBanner(patternArray, colorArray);
        townColorMeta = 15 - (Integer)colorArray.get(0);
        villagetagcompound.func_74768_a("signX", posX);
        villagetagcompound.func_74768_a("signY", posY);
        villagetagcompound.func_74768_a("signZ", posZ);
        villagetagcompound.func_74768_a("townColor", townColorMeta);
        boolean updateTownNBT = false;
        int[] townColorArray = new int[]{townColorMeta, -1, -1, -1, -1, -1, -1};
        ArrayList colorSet = new ArrayList();
        colorSet.add(colorArray.get(0));
        for (i = 1; i < colorArray.size(); ++i) {
            int candidateColor = (Integer)colorArray.get(i);
            boolean matchFound = false;
            for (int j = 0; j < colorSet.size(); ++j) {
                if (candidateColor != (Integer)colorSet.get(j)) continue;
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            colorSet.add(candidateColor);
        }
        for (i = 1; i < colorSet.size(); ++i) {
            townColorArray[i] = 15 - (Integer)colorSet.get(i);
        }
        for (int c = 1; c < townColorArray.length; ++c) {
            if (villagetagcompound.func_74764_b("townColor" + (c + 1))) {
                townColorArray[c] = villagetagcompound.func_74762_e("townColor" + (c + 1));
            } else if (townColorArray[c] == -1) {
                boolean isRedundant;
                block24: do {
                    townColorArray[c] = (Integer)FunctionsVN.weightedRandom(BannerGenerator.colorMeta, BannerGenerator.colorWeights, randomFromXYZ);
                    isRedundant = false;
                    for (int i5 = 0; i5 < c; ++i5) {
                        if (townColorArray[c] != townColorArray[i5]) continue;
                        isRedundant = true;
                        continue block24;
                    }
                } while (isRedundant);
            }
            if (villagetagcompound.func_74764_b("townColor" + (c + 1))) continue;
            updateTownNBT = true;
            villagetagcompound.func_74768_a("townColor" + (c + 1), townColorArray[c]);
        }
        villagetagcompound.func_74778_a("villageType", FunctionsVN.VillageType.getVillageTypeFromBiome(world, posX, posZ).toString());
        villagetagcompound.func_74778_a("materialType", FunctionsVN.MaterialType.getMaterialTemplateForBiome(world, posX, posZ).toString());
        nbttaglist = new NBTTagList();
        if (villageBanner != null) {
            villagetagcompound.func_74782_a("BlockEntityTag", (NBTBase)BannerGenerator.getNBTFromBanner(villageBanner));
        }
        nbttaglist.func_74742_a((NBTBase)villagetagcompound);
        data.getData().func_74782_a((namePrefix + " " + nameRoot + " " + nameSuffix).trim() + ", x" + posX + " y" + posY + " z" + posZ, (NBTBase)nbttaglist);
        data.func_76185_a();
        return villagetagcompound;
    }

    public static TileEntitySign generateSignContents(String namePrefix, String nameRoot, String nameSuffix) {
        Random random = new Random();
        TileEntitySign signContents = new TileEntitySign();
        String[] villageOrTown = new String[]{"Village" + (random.nextBoolean() ? " of" : ":"), "Town" + (random.nextBoolean() ? " of" : ":")};
        if (namePrefix.toLowerCase().trim().contains("village") || nameSuffix.toLowerCase().trim().contains("village")) {
            villageOrTown[0] = "Town" + (random.nextBoolean() ? " of" : ":");
        }
        if (namePrefix.toLowerCase().trim().contains("town") || nameSuffix.toLowerCase().trim().contains("town")) {
            villageOrTown[0] = "Village" + (random.nextBoolean() ? " of" : ":");
        }
        if (villageOrTown[0].toLowerCase().trim().contains("town") && villageOrTown[1].toLowerCase().trim().contains("village")) {
            villageOrTown[0] = "";
            villageOrTown[1] = "";
        }
        String topLine = random.nextBoolean() ? "Welcome to" : villageOrTown[random.nextInt(2)];
        topLine = topLine.trim();
        if (namePrefix.length() + 1 + nameRoot.length() > 15) {
            signContents.field_145915_a[0] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
            signContents.field_145915_a[1] = new TextComponentString(namePrefix.trim());
            if (nameRoot.length() + 1 + nameSuffix.length() > 15) {
                signContents.field_145915_a[2] = new TextComponentString(nameRoot.trim());
                signContents.field_145915_a[3] = new TextComponentString(nameSuffix.trim());
            } else {
                signContents.field_145915_a[2] = new TextComponentString((nameRoot + " " + nameSuffix).trim());
            }
        } else if (namePrefix.length() + 1 + nameRoot.length() + 1 + nameSuffix.length() <= 15) {
            signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine);
            signContents.field_145915_a[2] = new TextComponentString((namePrefix + " " + nameRoot + " " + nameSuffix).trim());
        } else {
            signContents.field_145915_a[1] = new TextComponentString(GeneralConfig.headerTags.trim() + topLine.trim());
            signContents.field_145915_a[2] = new TextComponentString((namePrefix + " " + nameRoot).trim());
            signContents.field_145915_a[3] = new TextComponentString(nameSuffix.trim());
        }
        if (topLine.equals("")) {
            for (int isign = 0; isign < 3; ++isign) {
                signContents.field_145915_a[isign] = signContents.field_145915_a[isign + 1];
            }
            signContents.field_145915_a[3] = new TextComponentString("");
        }
        return signContents;
    }

    public static EntityVillager makeVillagerWithProfession(World world, Random random, int profession, int career, int age) {
        EntityVillager entityvillager = new EntityVillager(world);
        int tries = 100;
        while (true) {
            entityvillager = new EntityVillager(world);
            Method populateBuyingList_m = ReflectionHelper.findMethod(EntityVillager.class, (String)"populateBuyingList", (String)"func_175554_cu", (Class[])new Class[0]);
            IModularSkin ims = (IModularSkin)entityvillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            if (profession == -1) {
                if (VillageGeneratorConfigHandler.spawnModdedVillagers) {
                    VillagerRegistry.setRandomProfession((EntityVillager)entityvillager, (Random)random);
                } else {
                    entityvillager.func_70938_b(random.nextInt(6));
                }
                VillagerRegistry.setRandomProfession((EntityVillager)entityvillager, (Random)entityvillager.field_70170_p.field_73012_v);
                if (entityvillager.func_70946_n() < 0 || entityvillager.func_70946_n() > 4) break;
                switch (random.nextInt(GeneralConfig.modernVillagerTrades ? 13 : 12)) {
                    default: {
                        profession = 0;
                        career = 1;
                        break;
                    }
                    case 1: {
                        profession = 0;
                        career = 2;
                        break;
                    }
                    case 2: {
                        profession = 0;
                        career = 3;
                        break;
                    }
                    case 3: {
                        profession = 0;
                        career = 4;
                        break;
                    }
                    case 4: {
                        profession = 1;
                        career = 1;
                        break;
                    }
                    case 5: {
                        profession = 1;
                        career = 2;
                        break;
                    }
                    case 6: {
                        profession = 2;
                        career = 1;
                        break;
                    }
                    case 7: {
                        profession = 3;
                        career = 1;
                        break;
                    }
                    case 8: {
                        profession = 3;
                        career = 2;
                        break;
                    }
                    case 9: {
                        profession = 3;
                        career = 3;
                        break;
                    }
                    case 10: {
                        profession = 4;
                        career = 1;
                        break;
                    }
                    case 11: {
                        profession = 4;
                        career = 2;
                        break;
                    }
                    case 12: {
                        profession = 3;
                        career = 4;
                    }
                }
                entityvillager.func_70938_b(profession);
            } else {
                entityvillager.func_70938_b(profession);
            }
            ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)entityvillager, (Object)career, (String[])new String[]{"careerId", "field_175563_bv"});
            ims.setCareer(career);
            try {
                populateBuyingList_m.invoke((Object)entityvillager, new Object[0]);
            }
            catch (Exception e) {
                if (!GeneralConfig.debugMessages) break;
                LogHelper.warn("Could not invoke EntityVillager.populateBuyingList method");
                break;
            }
            if (entityvillager.func_70946_n() == profession && (Integer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)entityvillager, (String[])new String[]{"careerId", "field_175563_bv"}) == career && ims.getCareer() == career || tries-- <= 0) break;
            entityvillager.func_70106_y();
        }
        entityvillager.func_70873_a(age);
        return entityvillager;
    }

    protected static StructureComponent getNextComponentNN(StartVN start, List components, Random random, int yOffset, int lateralOffset, EnumFacing coordBaseMode, int componentType, StructureBoundingBox boundingBox) {
        switch (coordBaseMode) {
            case SOUTH: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a - 1, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c + lateralOffset, EnumFacing.WEST, componentType);
            }
            case WEST: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a + lateralOffset, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c - 1, EnumFacing.NORTH, componentType);
            }
            case NORTH: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a - 1, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c + lateralOffset, EnumFacing.WEST, componentType);
            }
            case EAST: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a + lateralOffset, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c - 1, EnumFacing.NORTH, componentType);
            }
        }
        return null;
    }

    protected static StructureComponent getNextComponentPP(StartVN start, List components, Random random, int yOffset, int lateralOffset, EnumFacing coordBaseMode, int componentType, StructureBoundingBox boundingBox) {
        switch (coordBaseMode) {
            case SOUTH: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78893_d + 1, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c + lateralOffset, EnumFacing.EAST, componentType);
            }
            case WEST: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a + lateralOffset, boundingBox.field_78895_b + yOffset, boundingBox.field_78892_f + 1, EnumFacing.SOUTH, componentType);
            }
            case NORTH: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78893_d + 1, boundingBox.field_78895_b + yOffset, boundingBox.field_78896_c + lateralOffset, EnumFacing.EAST, componentType);
            }
            case EAST: {
                return StructureVillageVN.getNextVillageStructureComponent(start, components, random, boundingBox.field_78897_a + lateralOffset, boundingBox.field_78895_b + yOffset, boundingBox.field_78892_f + 1, EnumFacing.SOUTH, componentType);
            }
        }
        return null;
    }

    public static int chooseLadderMeta(int orientation) {
        if (orientation < 0) {
            return -orientation;
        }
        return LADDER_META_ARRAY[orientation];
    }

    public static int chooseFurnaceMeta(int orientation, EnumFacing coordBaseMode) {
        if (orientation < 0) {
            return -orientation;
        }
        return FURNACE_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseButtonMeta(int orientation) {
        return BUTTON_META_ARRAY[orientation];
    }

    public static int chooseGlazedTerracottaMeta(int orientation, EnumFacing coordBaseMode) {
        return GLAZED_TERRACOTTA_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseBlastFurnaceMeta(int orientation, EnumFacing coordBaseMode) {
        if (orientation < 0) {
            return -orientation;
        }
        return BLAST_FURNACE_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseCartographyTableMeta(int orientation, EnumFacing coordBaseMode) {
        if (orientation < 0) {
            return -orientation;
        }
        return CARTOGRAPHY_TABLE_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseAnvilMeta(int orientation, EnumFacing coordBaseMode) {
        return ANVIL_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseFMCGrindstoneHangingMeta(int orientation, EnumFacing coordBaseMode) {
        if (orientation < 0) {
            return -orientation;
        }
        return HANGING_GRINDSTONE_META_ARRAY[orientation][coordBaseMode.func_176736_b()];
    }

    public static int chooseFenceGateMeta(int orientation, boolean isOpen) {
        return FENCE_GATE_META_ARRAY[orientation] + (isOpen ? 4 : 0);
    }

    public static int chooseBibliocraftDeskMeta(int orientation, EnumFacing coordBaseMode) {
        return BIBLIOCRAFT_DESK_META_ARRAY[orientation][coordBaseMode.func_176736_b()] % 4;
    }

    public static int[] getDoorMetas(int orientation, EnumFacing coordBaseMode, boolean isShut, boolean isRightHanded) {
        int horizIndex = coordBaseMode.func_176736_b();
        return new int[]{DOOR_META_ARRAY[orientation] + (isShut ? 0 : 4), isRightHanded ? 8 : 9};
    }

    public static EntityLiving getVillageAnimal(World world, BlockPos pos, Random random, boolean includeHorses, boolean includeSheep, boolean includeOtherAnimals, boolean mooshroomsInsteadOfCows) {
        EntityLiving testEntity;
        int n;
        EntityLiving animal = null;
        int chickenWeight = 0;
        int sheepWeight = 2;
        int horseWeight = 5;
        ArrayList<Object> arraylist_animal = new ArrayList<Object>();
        ArrayList<Object> arraylist_temp_animal = new ArrayList<Object>();
        arraylist_temp_animal.clear();
        if (includeHorses) {
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                String[] stringArray = ModObjects.animania_horse;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String string = stringArray[n];
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(string), (World)world);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i2 = 0; i2 < horseWeight; ++i2) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            for (int i = 0; i < horseWeight; ++i) {
                arraylist_temp_animal.add(new EntityHorse(world));
            }
        }
        for (EntityLiving entityLiving : arraylist_temp_animal) {
            arraylist_animal.add(entityLiving);
        }
        arraylist_temp_animal.clear();
        if (includeSheep) {
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                String[] i = ModObjects.animania_sheep;
                int n3 = i.length;
                for (n = 0; n < n3; ++n) {
                    String string = i[n];
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(string), (World)world);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i2 = 0; i2 < sheepWeight; ++i2) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            if (arraylist_temp_animal.isEmpty()) {
                for (int i = 0; i < sheepWeight; ++i) {
                    arraylist_temp_animal.add(new EntitySheep(world));
                }
            }
        }
        for (EntityLiving entityLiving : arraylist_temp_animal) {
            arraylist_animal.add(entityLiving);
        }
        if (includeOtherAnimals) {
            arraylist_temp_animal.clear();
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                for (String string : ModObjects.animania_chicken) {
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(string), (World)world);
                    }
                    catch (Exception i2) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i = 0; i < chickenWeight; ++i) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            for (EntityLiving entityLiving : arraylist_temp_animal) {
                arraylist_animal.add(entityLiving);
            }
            arraylist_temp_animal.clear();
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                for (String string : ModObjects.animania_goat) {
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(string), (World)world);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i3 = 0; i3 < 1; ++i3) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            for (EntityLiving entityLiving : arraylist_temp_animal) {
                arraylist_animal.add(entityLiving);
            }
            arraylist_temp_animal.clear();
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                String[] i = ModObjects.animania_pig;
                int n4 = i.length;
                for (n = 0; n < n4; ++n) {
                    Object object = i[n];
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation((String)object), (World)world);
                    }
                    catch (Exception i3) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i4 = 0; i4 < 1; ++i4) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            if (arraylist_temp_animal.isEmpty()) {
                for (int i = 0; i < 1; ++i) {
                    arraylist_animal.add(new EntityPig(world));
                }
            }
            for (EntityLiving entityLiving : arraylist_temp_animal) {
                arraylist_animal.add(entityLiving);
            }
            arraylist_temp_animal.clear();
            if (VillageGeneratorConfigHandler.animaniaLivestock) {
                for (String string : mooshroomsInsteadOfCows ? ModObjects.animania_mooshroom : ModObjects.animania_cow) {
                    testEntity = null;
                    try {
                        testEntity = (EntityLiving)EntityList.func_188429_b((ResourceLocation)new ResourceLocation(string), (World)world);
                    }
                    catch (Exception i4) {
                        // empty catch block
                    }
                    if (testEntity == null) continue;
                    for (int i = 0; i < 1; ++i) {
                        arraylist_temp_animal.add(testEntity);
                    }
                }
            }
            if (arraylist_temp_animal.isEmpty()) {
                for (int i = 0; i < 1; ++i) {
                    arraylist_temp_animal.add(mooshroomsInsteadOfCows ? new EntityMooshroom(world) : new EntityCow(world));
                }
            }
            for (EntityLiving entityLiving : arraylist_temp_animal) {
                arraylist_animal.add(entityLiving);
            }
        }
        animal = (EntityLiving)arraylist_animal.get(random.nextInt(arraylist_animal.size()));
        IEntityLivingData ientitylivingdata = animal.func_180482_a(world.func_175649_E(pos), null);
        return animal;
    }

    public static int getBedOrientationMeta(int relativeOrientation, EnumFacing coordBaseMode, boolean isHead) {
        int horizIndex = coordBaseMode.func_176736_b();
        switch (relativeOrientation) {
            case 0: {
                return (new int[]{2, 3, 0, 1})[horizIndex] + (isHead ? 8 : 0);
            }
            case 1: {
                return (new int[]{1, 2, 1, 2})[horizIndex] + (isHead ? 8 : 0);
            }
            case 2: {
                return (new int[]{0, 1, 2, 3})[horizIndex] + (isHead ? 8 : 0);
            }
            case 3: {
                return (new int[]{3, 0, 3, 0})[horizIndex] + (isHead ? 8 : 0);
            }
        }
        return 0 + (isHead ? 8 : 0);
    }

    public static int getTrapdoorMeta(int relativeOrientation, boolean isTop, boolean isVertical) {
        int meta = 0;
        switch (relativeOrientation) {
            case 0: {
                meta = 0;
                break;
            }
            case 1: {
                meta = 3;
                break;
            }
            default: {
                meta = 1;
                break;
            }
            case 3: {
                meta = 2;
            }
        }
        meta += isVertical ? 4 : 0;
        return meta += isTop ? 8 : 0;
    }

    public static Block[] chooseCropPair(Random random) {
        Block cropblock;
        Block[] cropblocks = new Block[]{Blocks.field_150464_aj, Blocks.field_150464_aj};
        ArrayList<Block> cropArray = new ArrayList<Block>();
        if (random.nextDouble() < (double)GeneralConfig.harvestcraftCropFarmRate) {
            Block tryModCrop = Block.func_149684_b((String)"harvestcraft:pambambooshootcrop");
            if (tryModCrop != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamsesameseedscrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamblackberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamonioncrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamtealeafcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcucumbercrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamscallioncrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcorncrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamrhubarbcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamtomatocrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcottoncrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pampeanutcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamsweetpotatocrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambeetcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pampineapplecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamstrawberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamartichokecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamokracrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamrutabagacrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamparsnipcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcandleberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcantaloupecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamwintersquashcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamraspberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcoffeebeancrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamsoybeancrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamspiceleafcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcelerycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambellpeppercrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambeancrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcabbagecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamzucchinicrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamleekcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamlettucecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambrusselsproutcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcauliflowercrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pampeascrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamkiwicrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamryecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamchilipeppercrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamradishcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcurryleafcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamgrapecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pammustardseedscrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pameggplantcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamgarliccrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambarleycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pambroccolicrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamspinachcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamasparaguscrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamgingercrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamoatscrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamblueberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamturnipcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamagavecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamamaranthcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamarrowrootcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamcassavacrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamchickpeacrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamelderberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamflaxcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamgigapicklecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamgreengrapecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamhuckleberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamjicamacrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamjuniperberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamjutecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamkalecrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamkenafcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamkohlrabicrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamlentilcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pammilletcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pammulberrycrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamquinoacrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamsisalcrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamtarocrop")) != null) {
                cropArray.add(tryModCrop);
            }
            if ((tryModCrop = Block.func_149684_b((String)"harvestcraft:pamtomatillocrop")) != null) {
                cropArray.add(tryModCrop);
            }
        }
        if (cropArray.size() > 0) {
            for (int i = 0; i < 2; ++i) {
                cropblocks[i] = (Block)cropArray.get(random.nextInt(cropArray.size()));
            }
            return cropblocks;
        }
        cropArray.add(Blocks.field_150464_aj);
        cropArray.add(Blocks.field_150464_aj);
        cropArray.add(Blocks.field_150464_aj);
        cropArray.add(Blocks.field_150464_aj);
        cropArray.add(Blocks.field_150464_aj);
        cropArray.add(Blocks.field_150459_bM);
        cropArray.add(Blocks.field_150459_bM);
        cropArray.add(Blocks.field_150469_bN);
        cropArray.add(Blocks.field_150469_bN);
        cropArray.add(Blocks.field_185773_cZ);
        cropblocks[0] = cropblock = (Block)cropArray.get(random.nextInt(cropArray.size()));
        cropblocks[1] = cropblock;
        return cropblocks;
    }

    public static int generateUnusedColor(int[] colorArray, Random random, boolean useWeighted) {
        int candidateColor;
        int n = candidateColor = useWeighted ? ((Integer)FunctionsVN.weightedRandom(BannerGenerator.colorMeta, BannerGenerator.colorWeights, random)).intValue() : random.nextInt(16);
        if (colorArray.length >= 16) {
            return candidateColor;
        }
        boolean matchFound = false;
        while (true) {
            candidateColor = useWeighted ? ((Integer)FunctionsVN.weightedRandom(BannerGenerator.colorMeta, BannerGenerator.colorWeights, random)).intValue() : random.nextInt(16);
            for (int color : colorArray) {
                if (color != candidateColor) continue;
                matchFound = true;
            }
            if (!matchFound) break;
            matchFound = false;
        }
        return candidateColor;
    }

    public static ArrayList<BlueprintData> getRandomDecorBlueprint(FunctionsVN.VillageType villageType, FunctionsVN.MaterialType materialType, boolean disallowModSubs, Biome biome, EnumFacing coordBaseMode, Random random, boolean allowTaigaTroughs) {
        switch (villageType) {
            default: {
                return PlainsStructures.getRandomPlainsDecorBlueprint(materialType, disallowModSubs, biome, coordBaseMode, random);
            }
            case DESERT: {
                return DesertStructures.getRandomDesertDecorBlueprint(materialType, disallowModSubs, biome, coordBaseMode, random);
            }
            case TAIGA: {
                return allowTaigaTroughs ? TaigaStructures.getRandomTaigaDecorBlueprint(materialType, disallowModSubs, biome, coordBaseMode, random) : TaigaStructures.getTaigaDecorBlueprint(1 + random.nextInt(6), materialType, disallowModSubs, biome, coordBaseMode, random);
            }
            case SAVANNA: {
                return SavannaStructures.getRandomSavannaDecorBlueprint(materialType, disallowModSubs, biome, coordBaseMode, random);
            }
            case SNOWY: 
        }
        return SnowyStructures.getRandomSnowyDecorBlueprint(materialType, disallowModSubs, biome, coordBaseMode, random);
    }

    public static void cleanEntityItems(World world, StructureBoundingBox boundingBox) {
        AxisAlignedBB aabb = new AxisAlignedBB((double)boundingBox.field_78897_a, (double)boundingBox.field_78895_b, (double)boundingBox.field_78896_c, (double)boundingBox.field_78893_d, (double)boundingBox.field_78894_e, (double)boundingBox.field_78892_f).func_72321_a(3.0, 8.0, 3.0);
        List list = world.func_175647_a(EntityItem.class, aabb, null);
        if (!list.isEmpty()) {
            for (EntityItem entityitem : list) {
                entityitem.func_70106_y();
            }
            if (GeneralConfig.debugMessages) {
                LogHelper.info("Cleaned " + list.size() + " Entity items within " + aabb.toString());
            }
        }
    }

    public static class PathVN
    extends StructureVillagePieces.Road {
        private int length;

        public PathVN() {
        }

        public PathVN(StructureVillagePieces.Start start, int componentType, Random random, StructureBoundingBox boundingBox, EnumFacing facing) {
            super(start, componentType);
            this.func_186164_a(facing);
            this.field_74887_e = boundingBox;
            this.length = Math.max(boundingBox.func_78883_b(), boundingBox.func_78880_d());
        }

        protected void func_143012_a(NBTTagCompound tagCompound) {
            super.func_143012_a(tagCompound);
            tagCompound.func_74768_a("Length", this.length);
        }

        protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
            super.func_143011_b(tagCompound, templateManager);
            this.length = tagCompound.func_74762_e("Length");
        }

        public void func_74861_a(StructureComponent start, List components, Random random) {
            StructureComponent structurecomponent1;
            int i;
            boolean flag = false;
            for (i = random.nextInt(5); i < this.length - 8; i += 2 + random.nextInt(5)) {
                structurecomponent1 = StructureVillageVN.getNextComponentNN((StartVN)start, components, random, 0, i, this.func_186165_e(), this.func_74877_c(), this.func_74874_b());
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            for (i = random.nextInt(5); i < this.length - 8; i += 2 + random.nextInt(5)) {
                structurecomponent1 = StructureVillageVN.getNextComponentPP((StartVN)start, components, random, 0, i, this.func_186165_e(), this.func_74877_c(), this.func_74874_b());
                if (structurecomponent1 == null) continue;
                i += Math.max(structurecomponent1.func_74874_b().func_78883_b(), structurecomponent1.func_74874_b().func_78880_d());
                flag = true;
            }
            if (flag && random.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (flag && random.nextInt(3) > 0 && this.func_186165_e() != null) {
                switch (this.func_186165_e()) {
                    case NORTH: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case SOUTH: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case WEST: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case EAST: {
                        StructureVillageVN.generateAndAddRoadPiece((StructureVillagePieces.Start)start, components, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            StructureVillagePieces.Start startPiece_reflected = (StructureVillagePieces.Start)ReflectionHelper.getPrivateValue(StructureVillagePieces.Village.class, (Object)((Object)this), (String[])new String[]{"startPiece", "startPiece"});
            for (int u = 0; u <= this.field_74887_e.field_78893_d - this.field_74887_e.field_78897_a; ++u) {
                for (int w = 0; w <= this.field_74887_e.field_78892_f - this.field_74887_e.field_78896_c; ++w) {
                    int x = this.field_74887_e.field_78897_a + u;
                    int z = this.field_74887_e.field_78896_c + w;
                    BlockPos blockpos = new BlockPos(x, 64, z);
                    if (!structureBB.func_175898_b((Vec3i)blockpos)) continue;
                    int y = StructureVillageVN.getAboveTopmostSolidOrLiquidBlockVN(world, blockpos).func_177956_o() - 1;
                    if (startPiece_reflected == null) {
                        StructureVillageVN.setPathSpecificBlock(world, FunctionsVN.MaterialType.getMaterialTemplateForBiome(world, x, z), world.func_180494_b(new BlockPos(x, y, z)), false, x, y, z, true);
                        continue;
                    }
                    StructureVillageVN.setPathSpecificBlock(world, ((StartVN)startPiece_reflected).materialType, ((StartVN)startPiece_reflected).biome, ((StartVN)startPiece_reflected).disallowModSubs, x, y, z, true);
                }
            }
            return true;
        }
    }

    public static class DecorTorch
    extends StructureVillagePieces.Village {
        public ArrayList<Integer> decorHeightY = new ArrayList();
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public Biome biome = null;
        private static final int GROUND_LEVEL = 0;
        private int averageGroundLevel = -1;

        public DecorTorch() {
        }

        public DecorTorch(StartVN start, int componentType, Random random, StructureBoundingBox structureBB, EnumFacing coordBaseMode) {
            super((StructureVillagePieces.Start)start, componentType);
            this.func_186164_a(coordBaseMode);
            this.field_74887_e = structureBB;
            if (start != null) {
                this.villageType = start.villageType;
                this.materialType = start.materialType;
                this.townColor = start.townColor;
                this.townColor2 = start.townColor2;
                this.townColor3 = start.townColor3;
                this.townColor4 = start.townColor4;
                this.townColor5 = start.townColor5;
                this.townColor6 = start.townColor6;
                this.townColor7 = start.townColor7;
                this.namePrefix = start.namePrefix;
                this.nameRoot = start.nameRoot;
                this.nameSuffix = start.nameSuffix;
                this.biome = start.biome;
            }
        }

        public static StructureBoundingBox findPieceBox(StartVN start, List components, Random random, int x, int y, int z, EnumFacing coordBaseMode) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_175897_a((int)x, (int)y, (int)z, (int)0, (int)0, (int)0, (int)3, (int)4, (int)3, (EnumFacing)coordBaseMode);
            return StructureComponent.func_74883_a((List)components, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBB) {
            IBlockState biomeGrassState;
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = StructureVillageVN.getMedianGroundLevel(world, new StructureBoundingBox(this.field_74887_e.field_78897_a, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78892_f), true, (byte)1, this.func_186165_e().func_176736_b());
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78895_b - 0, 0);
            }
            if (this.villageType == null || this.materialType == null || this.townColor == -1 || this.townColor2 == -1 || this.townColor3 == -1 || this.townColor4 == -1 || this.townColor5 == -1 || this.townColor6 == -1 || this.townColor7 == -1 || this.nameRoot.equals("")) {
                NBTTagCompound villageNBTtag = StructureVillageVN.getOrMakeVNInfo(world, (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, (this.field_74887_e.field_78895_b + this.field_74887_e.field_78894_e) / 2, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2);
                this.townColor = villageNBTtag.func_74762_e("townColor");
                this.townColor2 = villageNBTtag.func_74762_e("townColor2");
                this.townColor3 = villageNBTtag.func_74762_e("townColor3");
                this.townColor4 = villageNBTtag.func_74762_e("townColor4");
                this.townColor5 = villageNBTtag.func_74762_e("townColor5");
                this.townColor6 = villageNBTtag.func_74762_e("townColor6");
                this.townColor7 = villageNBTtag.func_74762_e("townColor7");
                this.namePrefix = villageNBTtag.func_74779_i("namePrefix");
                this.nameRoot = villageNBTtag.func_74779_i("nameRoot");
                this.nameSuffix = villageNBTtag.func_74779_i("nameSuffix");
                BiomeProvider chunkManager = world.func_72959_q();
                int posX = (this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2;
                int posZ = (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2;
                Biome biome = chunkManager.func_180631_a(new BlockPos(posX, 64, posZ));
                Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
                try {
                    String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(chunkManager, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
                }
                catch (Exception e) {
                    this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(chunkManager, posX, posZ);
                }
                try {
                    String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(chunkManager, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
                }
                catch (Exception e) {
                    this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(chunkManager, posX, posZ);
                }
                try {
                    String mappedBlockModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                    this.disallowModSubs = mappedBlockModSubs.toLowerCase().trim().equals("nosub");
                }
                catch (Exception e) {
                    this.disallowModSubs = false;
                }
            }
            if (this.biome == null) {
                this.biome = world.func_180494_b(new BlockPos((this.field_74887_e.field_78897_a + this.field_74887_e.field_78893_d) / 2, 0, (this.field_74887_e.field_78896_c + this.field_74887_e.field_78892_f) / 2));
            }
            IBlockState biomeDirtState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150346_d.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            IBlockState biomeTopState = biomeGrassState = StructureVillageVN.getBiomeSpecificBlockState(Blocks.field_150349_c.func_176223_P(), this.materialType, this.biome, this.disallowModSubs);
            if (this.biome != null && this.biome.field_76752_A != null) {
                biomeTopState = this.biome.field_76752_A;
            }
            IBlockState biomeFillerState = biomeDirtState;
            if (this.biome != null && this.biome.field_76753_B != null) {
                biomeFillerState = this.biome.field_76753_B;
            }
            this.func_175808_b(world, biomeFillerState, 1, -2, 1, structureBB);
            this.func_175811_a(world, biomeTopState, 1, -1, 1, structureBB);
            int[][] decorUVW = new int[][]{{1, 0, 1}};
            for (int j = 0; j < decorUVW.length; ++j) {
                int[] uvw = decorUVW[j];
                Random randomFromXYZ = new Random();
                randomFromXYZ.setSeed(world.func_72905_C() + FunctionsVN.getUniqueLongForXYZ(this.func_74865_a(uvw[0], uvw[2]), this.func_74862_a(uvw[1]), this.func_74873_b(uvw[0], uvw[2])));
                int decorHeightY = uvw[1];
                if (this.decorHeightY.size() < j + 1) {
                    this.decorHeightY.add(decorHeightY);
                } else {
                    decorHeightY = this.decorHeightY.get(j);
                }
                ArrayList<BlueprintData> decorBlueprint = null;
                decorBlueprint = this.villageType == FunctionsVN.VillageType.DESERT ? DesertStructures.getDesertDecorBlueprint(0, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ) : (this.villageType == FunctionsVN.VillageType.TAIGA ? TaigaStructures.getTaigaDecorBlueprint(6, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ) : (this.villageType == FunctionsVN.VillageType.SAVANNA ? SavannaStructures.getSavannaDecorBlueprint(0, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ) : (this.villageType == FunctionsVN.VillageType.SNOWY ? SnowyStructures.getSnowyDecorBlueprint(randomFromXYZ.nextInt(3), this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ) : PlainsStructures.getPlainsDecorBlueprint(0, this.materialType, this.disallowModSubs, this.biome, this.func_186165_e(), randomFromXYZ))));
                for (BlueprintData b : decorBlueprint) {
                    this.func_175811_a(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos(), uvw[2] + b.getWPos(), structureBB);
                    if ((b.getfillFlag() & 1) != 0) {
                        this.func_175808_b(world, b.getBlockState(), uvw[0] + b.getUPos(), decorHeightY + b.getVPos() - 1, uvw[2] + b.getWPos(), structureBB);
                    }
                    if ((b.getfillFlag() & 2) == 0) continue;
                    this.func_74871_b(world, uvw[0] + b.getUPos(), decorHeightY + b.getVPos() + 1, uvw[2] + b.getWPos(), structureBB);
                }
            }
            if (VillageGeneratorConfigHandler.cleanDroppedItems) {
                StructureVillageVN.cleanEntityItems(world, this.field_74887_e);
            }
            return true;
        }
    }

    public static class StartVN
    extends StructureVillagePieces.Start {
        public FunctionsVN.VillageType villageType = null;
        public FunctionsVN.MaterialType materialType = null;
        public boolean disallowModSubs = false;
        public int townColor = -1;
        public int townColor2 = -1;
        public int townColor3 = -1;
        public int townColor4 = -1;
        public int townColor5 = -1;
        public int townColor6 = -1;
        public int townColor7 = -1;
        public String namePrefix = "";
        public String nameRoot = "";
        public String nameSuffix = "";
        public boolean villagersGenerated = false;
        public int bannerY = 0;
        public ArrayList<Integer> decorHeightY = new ArrayList();

        public StartVN() {
        }

        public StartVN(BiomeProvider biomeProvider, int componentType, Random random, int posX, int posZ, List components, float villageSize) {
            super(biomeProvider, componentType, random, posX, posZ, components, villageSize % 1.0f < random.nextFloat() ? 1 : 0);
            this.biome = biomeProvider.func_180631_a(new BlockPos(posX, 64, posZ));
            Map<String, ArrayList<String>> mappedBiomes = VillageGeneratorConfigHandler.unpackBiomes(VillageGeneratorConfigHandler.spawnBiomesNames);
            try {
                String mappedVillageType = mappedBiomes.get("VillageTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)this.biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                this.villageType = mappedVillageType.equals("") ? FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ) : FunctionsVN.VillageType.getVillageTypeFromName(mappedVillageType, FunctionsVN.VillageType.PLAINS);
            }
            catch (Exception e) {
                this.villageType = FunctionsVN.VillageType.getVillageTypeFromBiome(biomeProvider, posX, posZ);
            }
            try {
                String mappedMaterialType = mappedBiomes.get("MaterialTypes").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)this.biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                this.materialType = mappedMaterialType.equals("") ? FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ) : FunctionsVN.MaterialType.getMaterialTypeFromName(mappedMaterialType, FunctionsVN.MaterialType.OAK);
            }
            catch (Exception e) {
                this.materialType = FunctionsVN.MaterialType.getMaterialTemplateForBiome(biomeProvider, posX, posZ);
            }
            try {
                String mappeddisallowModSubs = mappedBiomes.get("DisallowModSubs").get(mappedBiomes.get("BiomeNames").indexOf((String)ReflectionHelper.getPrivateValue(Biome.class, (Object)this.biome, (String[])new String[]{"biomeName", "field_76791_y"})));
                this.disallowModSubs = mappeddisallowModSubs.toLowerCase().trim().equals("nosub");
            }
            catch (Exception e) {
                this.disallowModSubs = false;
            }
        }
    }
}

