/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.tracker;

import astrotibs.villagenames.capabilities.IModularSkin;
import astrotibs.villagenames.capabilities.ModularSkinProvider;
import astrotibs.villagenames.network.MessageModernVillagerSkin;
import astrotibs.villagenames.network.MessageVillageGuard;
import astrotibs.villagenames.network.MessageZombieVillagerProfession;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientInfoTracker {
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Integer, MessageZombieVillagerProfession> LoadedZombies = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Integer, MessageVillageGuard> LoadedGuards = new HashMap();
    @SideOnly(value=Side.CLIENT)
    private static HashMap<Integer, MessageModernVillagerSkin> loadedVillagers = new HashMap();

    @SideOnly(value=Side.CLIENT)
    public static void addZombieMessage(MessageZombieVillagerProfession message) {
        LoadedZombies.put(message.getEntityID(), message);
    }

    @SideOnly(value=Side.CLIENT)
    public static MessageZombieVillagerProfession getZombieMessage(int entityID) {
        MessageZombieVillagerProfession msg = LoadedZombies.get(entityID);
        LoadedZombies.remove(entityID);
        return msg;
    }

    @SideOnly(value=Side.CLIENT)
    public static void addGuardMessage(MessageVillageGuard message) {
        LoadedGuards.put(message.getEntityID(), message);
    }

    @SideOnly(value=Side.CLIENT)
    public static MessageVillageGuard getGuardMessage(int entityID) {
        MessageVillageGuard msg = LoadedGuards.get(entityID);
        LoadedGuards.remove(entityID);
        return msg;
    }

    @SideOnly(value=Side.CLIENT)
    public static void SyncZombieMessage(int entityID) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityID);
        if (entity instanceof EntityZombieVillager) {
            ClientInfoTracker.SyncZombieMessage((EntityZombieVillager)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void SyncZombieMessage(EntityZombieVillager zombievillager) {
        MessageZombieVillagerProfession msg = ClientInfoTracker.getZombieMessage(zombievillager.func_145782_y());
        if (msg != null) {
            IModularSkin ims = (IModularSkin)zombievillager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            ims.setProfession(msg.getProfession());
            ims.setCareer(msg.getCareer());
            ims.setBiomeType(msg.getBiomeType());
            ims.setProfessionLevel(msg.getProfessionLevel());
            ims.setSkinTone(msg.getSkinTone());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void SyncGuardMessage(int entityID) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityID);
        if (entity.getClass().toString().substring(6).equals("com.emoniph.witchery.entity.EntityVillageGuard")) {
            ClientInfoTracker.SyncGuardMessage((EntityLiving)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void SyncGuardMessage(EntityLiving guard) {
        MessageVillageGuard msg = ClientInfoTracker.getGuardMessage(guard.func_145782_y());
        if (msg != null) {
            IModularSkin iModularSkin = (IModularSkin)guard.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addModernVillagerMessage(MessageModernVillagerSkin message) {
        loadedVillagers.put(message.getEntityID(), message);
    }

    @SideOnly(value=Side.CLIENT)
    public static MessageModernVillagerSkin getModernVillagerMessage(int entityID) {
        MessageModernVillagerSkin msg = loadedVillagers.get(entityID);
        loadedVillagers.remove(entityID);
        return msg;
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncModernVillagerMessage(int entityID) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityID);
        if (entity instanceof EntityVillager && ((EntityVillager)entity).func_70946_n() >= 0) {
            ClientInfoTracker.syncModernVillagerMessage((EntityVillager)entity);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void syncModernVillagerMessage(EntityVillager villager) {
        MessageModernVillagerSkin msg = ClientInfoTracker.getModernVillagerMessage(villager.func_145782_y());
        if (msg != null) {
            IModularSkin ims = (IModularSkin)villager.getCapability(ModularSkinProvider.MODULAR_SKIN, null);
            ims.setProfession(msg.getProfession());
            ims.setCareer(msg.getCareer());
            ims.setBiomeType(msg.getBiomeType());
            ims.setProfessionLevel(msg.getProfessionLevel());
            ims.setSkinTone(msg.getSkinTone());
        }
    }
}

