/*
 * Decompiled with CFR 0.152.
 */
package astrotibs.villagenames.handler;

import astrotibs.villagenames.VillageNames;
import astrotibs.villagenames.config.GeneralConfig;
import astrotibs.villagenames.utility.LogHelper;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.io.IOUtils;

public class VersionChecker
implements Runnable {
    private static boolean isLatestVersion = false;
    private static boolean warnaboutfailure = false;
    private static String latestVersion = "";

    @Override
    public void run() {
        InputStream in = null;
        try {
            in = new URL("https://gitgud.io/AstroTibs/VillageNames/raw/1.12.2/CURRENT_VERSION").openStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            latestVersion = (String)IOUtils.readLines((InputStream)in, (Charset)Charset.defaultCharset()).get(0);
        }
        catch (Exception e) {
            if (!warnaboutfailure) {
                LogHelper.error("Could not connect with server to compare Village Names version");
                LogHelper.error("You can check for new versions at https://www.curseforge.com/minecraft/mc-mods/village-names");
                warnaboutfailure = true;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        isLatestVersion = "4.1.5".equals(latestVersion);
        if (!(this.isLatestVersion() || latestVersion.equals("") || latestVersion.equals(null))) {
            LogHelper.info("This version of Village Names (4.1.5) differs from the latest version: " + latestVersion);
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getLatestVersion() {
        return latestVersion;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END && event.player.field_70173_aa == 30) {
            if ((latestVersion.equals(null) || latestVersion.equals("")) && !warnaboutfailure) {
                this.run();
            }
            if (!(VillageNames.haveWarnedVersionOutOfDate || !GeneralConfig.versionChecker || VillageNames.versionChecker.isLatestVersion() || latestVersion.equals(null) || latestVersion.equals("") || "4.1.5".contains("DEV"))) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Village Names" + TextFormatting.RESET + " version " + TextFormatting.YELLOW + this.getLatestVersion() + TextFormatting.RESET + " is available! Get it at:"));
                event.player.func_145747_a(ForgeHooks.newChatWithLinks((String)"https://www.curseforge.com/minecraft/mc-mods/village-names"));
                VillageNames.haveWarnedVersionOutOfDate = true;
            }
        }
    }
}

